/*
 * Decompiled with CFR 0.152.
 */
package com.android.gmacs.album;

import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.android.gmacs.R;
import com.android.gmacs.activity.BaseActivity;
import com.android.gmacs.album.AlbumViewPager;
import com.android.gmacs.album.GmacsImageDao;
import com.android.gmacs.album.GmacsPhotoBrowseActivity;
import com.android.gmacs.album.ImageUrlArrayListWrapper;
import com.android.gmacs.view.photoview.PhotoView;
import com.android.gmacs.view.photoview.PhotoViewAttacher;
import com.common.gmacs.downloader.RequestManager;
import com.common.gmacs.downloader.image.ImageLoader;
import com.common.gmacs.utils.GmacsEnvi;
import com.common.gmacs.utils.ToastUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GmacsPhotoBrowseActivity
extends BaseActivity {
    private int currentIndex;
    private boolean fromCamera;
    private String func = "update";
    private boolean isCameraJobCanceled = true;
    private boolean isPreviewMode;
    private RelativeLayout mBottomContainer;
    private ArrayList<String> mDataList;
    private int mMaxCount;
    private ImageView mRawCheck;
    private TextView mRawSizeText;
    private ImageView mSelectCheck;
    private TextView mSelectText;
    private ArrayList<String> mSelectedDataList = new ArrayList();
    private ViewPager mViewPager;

    public GmacsPhotoBrowseActivity() {
        this.mDataList = new ArrayList();
    }

    static /* synthetic */ int access$002(GmacsPhotoBrowseActivity gmacsPhotoBrowseActivity, int n2) {
        gmacsPhotoBrowseActivity.currentIndex = n2;
        return n2;
    }

    static /* synthetic */ String access$602(GmacsPhotoBrowseActivity gmacsPhotoBrowseActivity, String string2) {
        gmacsPhotoBrowseActivity.func = string2;
        return string2;
    }

    static /* synthetic */ boolean access$702(GmacsPhotoBrowseActivity gmacsPhotoBrowseActivity, boolean bl2) {
        gmacsPhotoBrowseActivity.isCameraJobCanceled = bl2;
        return bl2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void notifyCountInfo() {
        int n2 = this.mSelectedDataList.size();
        if (n2 == 0) {
            this.mTitleBar.mRightTextView.setText(R.string.send);
            return;
        }
        this.mTitleBar.mRightTextView.setText((CharSequence)String.format(this.getString(R.string.send_count), n2, 10));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void switchPreviewMode() {
        if (!this.isPreviewMode) {
            if (Build.VERSION.SDK_INT >= 21) {
                this.getWindow().getDecorView().setSystemUiVisibility(5380);
            }
            this.hideTitleBar();
            this.mBottomContainer.setVisibility(8);
            this.isPreviewMode = true;
            return;
        }
        if (Build.VERSION.SDK_INT >= 21) {
            this.getWindow().getDecorView().setSystemUiVisibility(1280);
        }
        this.showTitleBar();
        this.mBottomContainer.setVisibility(0);
        this.isPreviewMode = false;
    }

    public void finish() {
        if (Build.VERSION.SDK_INT >= 21) {
            this.getWindow().getDecorView().setSystemUiVisibility(1280);
        }
        this.myOnBack(this.func);
        super.finish();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void initData() {
        Intent intent = this.getIntent();
        this.mMaxCount = intent.getIntExtra("photoMaxCount", 10);
        boolean bl2 = intent.getBooleanExtra("isPreview", false);
        Object object = ((ImageUrlArrayListWrapper)intent.getParcelableExtra((String)"selected_img_data")).mList;
        if (object == null) {
            this.finish();
            return;
        }
        this.mSelectedDataList.addAll((Collection<String>)object);
        if (bl2) {
            this.mDataList.addAll(this.mSelectedDataList);
            this.fromCamera = intent.getBooleanExtra("fromCamera", false);
            if (this.fromCamera) {
                this.mSelectCheck.setVisibility(8);
                this.mSelectText.setVisibility(8);
                this.mTitleBar.mTitleView.setVisibility(8);
            }
        } else {
            object = intent.getStringExtra("dirPath");
            if (TextUtils.isEmpty((CharSequence)object)) {
                this.finish();
                return;
            }
            object = GmacsImageDao.instance((Context)this).getImgListByDir((String)object);
            if (object == null) {
                this.finish();
                return;
            }
            this.mDataList.addAll(((GmacsImageDao.ImgDir)object).dataList);
            this.currentIndex = intent.getIntExtra("img_position", 0);
        }
        this.mViewPager.setAdapter(new AlbumPagerAdapter(this.mDataList));
        if (this.currentIndex != 0) {
            this.mViewPager.setCurrentItem(this.currentIndex);
            return;
        }
        if (this.fromCamera) {
            this.mTitleBar.mRightTextView.setText(this.getText(R.string.send));
            return;
        }
        this.mTitleBar.setTitle("1/" + this.mDataList.size());
        if (this.mSelectedDataList.contains(this.mDataList.get(0))) {
            this.mSelectCheck.setTag((Object)true);
            this.mSelectCheck.setImageResource(R.drawable.gmacs_btn_checkbox_checked);
        } else {
            this.mSelectCheck.setTag((Object)false);
            this.mSelectCheck.setImageResource(R.drawable.gmacs_btn_checkbox_unchecked);
        }
        this.notifyCountInfo();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void initView() {
        this.requestNotFitSystemWindow();
        this.resetContentContainerMargin();
        this.mTitleBar.mTitleView.setTextColor(-1);
        this.mTitleBar.setBackListener(new View.OnClickListener(){

            public void onClick(View view) {
                GmacsPhotoBrowseActivity.this.onBackPressed();
            }
        });
        this.mTitleBar.setBackgroundColor(this.getResources().getColor(R.color.dark_212121));
        if (this.mStatusBar != null) {
            this.mStatusBar.setBackgroundColor(this.getResources().getColor(R.color.dark_212121));
        }
        this.mViewPager = (AlbumViewPager)this.findViewById(R.id.view_pager);
        this.mViewPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            @Override
            public void onPageScrollStateChanged(int n2) {
            }

            @Override
            public void onPageScrolled(int n2, float f2, int n3) {
            }

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void onPageSelected(int n2) {
                GmacsPhotoBrowseActivity.access$002(GmacsPhotoBrowseActivity.this, n2);
                GmacsPhotoBrowseActivity.this.mTitleBar.setTitle(n2 + 1 + "/" + GmacsPhotoBrowseActivity.this.mDataList.size());
                if (GmacsPhotoBrowseActivity.this.mSelectedDataList.contains(GmacsPhotoBrowseActivity.this.mDataList.get(n2))) {
                    GmacsPhotoBrowseActivity.this.mSelectCheck.setTag((Object)true);
                    GmacsPhotoBrowseActivity.this.mSelectCheck.setImageResource(R.drawable.gmacs_btn_checkbox_checked);
                } else {
                    GmacsPhotoBrowseActivity.this.mSelectCheck.setTag((Object)false);
                    GmacsPhotoBrowseActivity.this.mSelectCheck.setImageResource(R.drawable.gmacs_btn_checkbox_unchecked);
                }
                GmacsPhotoBrowseActivity.this.notifyCountInfo();
            }
        });
        this.mTitleBar.mRightTextView.setVisibility(0);
        this.mTitleBar.mRightTextView.setText(R.string.send);
        if (Build.VERSION.SDK_INT > 16) {
            this.mTitleBar.mRightTextView.setBackground(null);
        } else {
            this.mTitleBar.mRightTextView.setBackgroundDrawable(null);
        }
        this.mTitleBar.mRightTextView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (GmacsPhotoBrowseActivity.this.mSelectedDataList.size() == 0) {
                    GmacsPhotoBrowseActivity.this.mSelectedDataList.add(GmacsPhotoBrowseActivity.this.mDataList.get(GmacsPhotoBrowseActivity.this.currentIndex));
                }
                GmacsPhotoBrowseActivity.access$602(GmacsPhotoBrowseActivity.this, "ok");
                GmacsPhotoBrowseActivity.access$702(GmacsPhotoBrowseActivity.this, false);
                GmacsPhotoBrowseActivity.this.finish();
            }
        });
        this.mBottomContainer = (RelativeLayout)this.findViewById(R.id.bottom_layout);
        this.mSelectCheck = (ImageView)this.mBottomContainer.findViewById(R.id.select);
        this.mSelectCheck.setTag((Object)false);
        this.mSelectCheck.setOnClickListener(new View.OnClickListener(){

            /*
             * Enabled aggressive block sorting
             */
            public void onClick(View object) {
                String string2 = (String)GmacsPhotoBrowseActivity.this.mDataList.get(GmacsPhotoBrowseActivity.this.currentIndex);
                if (((Boolean)GmacsPhotoBrowseActivity.this.mSelectCheck.getTag()).booleanValue()) {
                    GmacsPhotoBrowseActivity.this.mSelectCheck.setTag((Object)false);
                    GmacsPhotoBrowseActivity.this.mSelectCheck.setImageResource(R.drawable.gmacs_btn_checkbox_unchecked);
                    GmacsPhotoBrowseActivity.this.mSelectedDataList.remove(string2);
                } else {
                    if (GmacsPhotoBrowseActivity.this.mSelectedDataList.size() >= GmacsPhotoBrowseActivity.this.mMaxCount) {
                        ToastUtil.showToast(String.format(GmacsPhotoBrowseActivity.this.getString(R.string.reach_upload_max), GmacsPhotoBrowseActivity.this.mMaxCount));
                        return;
                    }
                    GmacsPhotoBrowseActivity.this.mSelectCheck.setTag((Object)true);
                    GmacsPhotoBrowseActivity.this.mSelectCheck.setImageResource(R.drawable.gmacs_btn_checkbox_checked);
                    GmacsPhotoBrowseActivity.this.mSelectedDataList.add(string2);
                }
                GmacsPhotoBrowseActivity.this.notifyCountInfo();
            }
        });
        this.mSelectText = (TextView)this.findViewById(R.id.select_text);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void myOnBack(String string2) {
        ToastUtil.cancelToast();
        Intent intent = new Intent();
        intent.putExtra("img_position", this.currentIndex);
        intent.putExtra("func", string2);
        intent.putExtra("raw", false);
        intent.putExtra("selected_img_data", (Parcelable)new ImageUrlArrayListWrapper(this.mSelectedDataList));
        if (this.fromCamera && this.isCameraJobCanceled) {
            this.setResult(0);
            return;
        }
        this.setResult(-1, intent);
    }

    @Override
    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.setContentView(R.layout.gmacs_activity_photo_browse);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean onKeyDown(int n2, KeyEvent keyEvent) {
        if (n2 != 4) return false;
        this.onBackPressed();
        return true;
    }

    private class AlbumPagerAdapter
    extends PagerAdapter
    implements PhotoViewAttacher.OnPhotoTapListener {
        private List<String> dataList = new ArrayList<String>();

        AlbumPagerAdapter(List<String> list) {
            this.dataList = list;
        }

        @Override
        public void destroyItem(ViewGroup viewGroup, int n2, Object object) {
            viewGroup.removeView((View)object);
        }

        @Override
        public int getCount() {
            return this.dataList.size();
        }

        public View instantiateItem(ViewGroup viewGroup, int n2) {
            PhotoView photoView = new PhotoView(viewGroup.getContext());
            photoView.setPadding(2, 0, 2, 0);
            RequestManager.getInstance().getNoL1CacheImageLoader().get(this.dataList.get(n2), (ImageLoader.ImageListener)new 1(this, photoView), GmacsEnvi.getGLMaxTextureSize(), GmacsEnvi.getGLMaxTextureSize(), ImageView.ScaleType.CENTER_INSIDE, 0, 0);
            viewGroup.addView((View)photoView, -1, -1);
            photoView.setOnPhotoTapListener(this);
            return photoView;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean isViewFromObject(View view, Object object) {
            if (view != object) return false;
            return true;
        }

        @Override
        public void onPhotoTap(View view, float f2, float f3) {
            GmacsPhotoBrowseActivity.this.switchPreviewMode();
        }
    }
}

