/*
 * Decompiled with CFR 0.152.
 */
package com.android.gmacs.sound;

import android.content.Context;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.text.TextUtils;
import com.android.gmacs.sound.SoundPlayer;
import com.common.gmacs.utils.GmacsConfig;
import com.common.gmacs.utils.GmacsEnvi;

public class SoundPlayer
implements MediaPlayer.OnCompletionListener,
MediaPlayer.OnErrorListener,
MediaPlayer.OnPreparedListener {
    private static SoundPlayer mSoundPlayer;
    private boolean isSoundPlaying;
    private boolean isSpeakerphoneOn = (Boolean)GmacsConfig.ClientConfig.getParam("isSpeakerphoneOn", true);
    private AudioManager mAudioManager;
    private VoiceCompletion mCurrentListener;
    private long mCurrentPlayId = -2L;
    private MediaPlayer mPlayer;

    private SoundPlayer() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SoundPlayer getInstance() {
        if (mSoundPlayer == null) {
            synchronized (SoundPlayer.class) {
                if (mSoundPlayer == null) {
                    SoundPlayer soundPlayer;
                    mSoundPlayer = soundPlayer = new SoundPlayer();
                }
            }
        }
        return mSoundPlayer;
    }

    private void notifyFinalState(boolean bl2) {
        this.mCurrentPlayId = -2L;
        this.isSoundPlaying = false;
        if (this.mCurrentListener != null) {
            this.mCurrentListener.onCompletion(this.mPlayer, bl2);
        }
        if (this.mAudioManager == null) {
            this.mAudioManager = (AudioManager)GmacsEnvi.appContext.getSystemService("audio");
        }
        this.mAudioManager.abandonAudioFocus(null);
        this.mAudioManager.setMode(0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void startPlaying(String string2) {
        try {
            if (this.mPlayer == null) {
                MediaPlayer mediaPlayer;
                this.mPlayer = mediaPlayer = new MediaPlayer();
                this.mPlayer.setWakeMode((Context)GmacsEnvi.appContext, 1);
                this.mPlayer.setAudioStreamType(0);
                this.mPlayer.setOnErrorListener((MediaPlayer.OnErrorListener)this);
                this.mPlayer.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
            }
            this.mPlayer.reset();
            this.mPlayer.setDataSource(string2);
            this.mPlayer.setOnPreparedListener((MediaPlayer.OnPreparedListener)this);
            this.mPlayer.prepareAsync();
            this.isSoundPlaying = true;
            return;
        }
        catch (Exception exception) {
            this.notifyFinalState(false);
            return;
        }
    }

    private void stopPlay() {
        if (this.mPlayer != null && this.mPlayer.isPlaying()) {
            this.mPlayer.stop();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void autoStartPlaying(String string2, VoiceCompletion voiceCompletion, long l2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            this.mCurrentPlayId = -2L;
            voiceCompletion.onCompletion(this.mPlayer, false);
            return;
        }
        this.mCurrentListener = voiceCompletion;
        this.mCurrentPlayId = l2;
        this.startPlaying(string2);
    }

    public long currentPlayId() {
        return this.mCurrentPlayId;
    }

    public void destroy() {
        if (this.mPlayer != null) {
            if (this.mPlayer.isPlaying()) {
                this.mPlayer.stop();
            }
            this.mPlayer.release();
            this.mPlayer = null;
        }
        this.mAudioManager = null;
        this.mCurrentPlayId = -2L;
        this.mCurrentListener = null;
        this.isSoundPlaying = false;
    }

    public boolean isSoundPlaying() {
        return this.isSoundPlaying;
    }

    public boolean isSpeakerphoneOn() {
        return this.isSpeakerphoneOn;
    }

    public boolean isWiredHeadsetOn() {
        if (this.mAudioManager == null) {
            this.mAudioManager = (AudioManager)GmacsEnvi.appContext.getSystemService("audio");
        }
        return this.mAudioManager.isWiredHeadsetOn();
    }

    public void onCompletion(MediaPlayer mediaPlayer) {
        this.notifyFinalState(true);
    }

    public boolean onError(MediaPlayer mediaPlayer, int n2, int n3) {
        if (mediaPlayer.isPlaying()) {
            mediaPlayer.stop();
        }
        this.notifyFinalState(false);
        return false;
    }

    public void onPrepared(MediaPlayer mediaPlayer) {
        if (this.mAudioManager == null) {
            this.mAudioManager = (AudioManager)GmacsEnvi.appContext.getSystemService("audio");
        }
        this.mAudioManager.requestAudioFocus(null, 3, 1);
        this.mAudioManager.setMode(3);
        this.mAudioManager.setSpeakerphoneOn(this.isSpeakerphoneOn);
        mediaPlayer.start();
    }

    public void saveAudioMessageRoute(boolean bl2) {
        this.isSpeakerphoneOn = bl2;
        GmacsConfig.ClientConfig.setParam("isSpeakerphoneOn", bl2);
    }

    public void setSpeakerphoneOn(boolean bl2) {
        if (this.mAudioManager == null) {
            this.mAudioManager = (AudioManager)GmacsEnvi.appContext.getSystemService("audio");
        }
        this.mAudioManager.setSpeakerphoneOn(bl2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void startPlaying(String string2, VoiceCompletion voiceCompletion, long l2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            this.mCurrentPlayId = -2L;
            voiceCompletion.onCompletion(this.mPlayer, false);
            return;
        }
        if (l2 == this.mCurrentPlayId) {
            this.stopPlay();
            this.notifyFinalState(false);
            return;
        }
        if (this.isSoundPlaying) {
            this.stopPlay();
            this.notifyFinalState(false);
        }
        this.mCurrentListener = voiceCompletion;
        this.mCurrentPlayId = l2;
        this.startPlaying(string2);
    }

    public void stopPlayAndAnimation() {
        if (this.mPlayer != null && this.mPlayer.isPlaying()) {
            this.mPlayer.stop();
        }
        this.notifyFinalState(false);
    }
}

