/*
 * Decompiled with CFR 0.152.
 */
package com.android.gmacs.view.photoview;

import android.graphics.RectF;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.widget.ImageView;
import com.android.gmacs.view.photoview.PhotoViewAttacher;

public class DefaultOnDoubleTapListener
implements GestureDetector.OnDoubleTapListener {
    private PhotoViewAttacher photoViewAttacher;

    public DefaultOnDoubleTapListener(PhotoViewAttacher photoViewAttacher) {
        this.setPhotoViewAttacher(photoViewAttacher);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean onDoubleTap(MotionEvent motionEvent) {
        float f2;
        float f3;
        float f4;
        boolean bl2 = true;
        if (this.photoViewAttacher == null) {
            return false;
        }
        try {
            f4 = this.photoViewAttacher.getScale();
            f3 = motionEvent.getX();
            f2 = motionEvent.getY();
            if (f4 < this.photoViewAttacher.getMediumScale()) {
                this.photoViewAttacher.setScale(this.photoViewAttacher.getMediumScale(), f3, f2, true);
                return bl2;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return bl2;
        }
        if (f4 >= this.photoViewAttacher.getMediumScale() && f4 < this.photoViewAttacher.getMaximumScale()) {
            this.photoViewAttacher.setScale(this.photoViewAttacher.getMaximumScale(), f3, f2, true);
            return bl2;
        }
        this.photoViewAttacher.setScale(this.photoViewAttacher.getMinimumScale(), f3, f2, true);
        return bl2;
    }

    public boolean onDoubleTapEvent(MotionEvent motionEvent) {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean onSingleTapConfirmed(MotionEvent motionEvent) {
        float f2;
        float f3;
        RectF rectF;
        boolean bl2 = false;
        if (this.photoViewAttacher == null) {
            return bl2;
        }
        ImageView imageView = this.photoViewAttacher.getImageView();
        if (this.photoViewAttacher.getOnPhotoTapListener() != null && (rectF = this.photoViewAttacher.getDisplayRect()) != null && rectF.contains(f3 = motionEvent.getX(), f2 = motionEvent.getY())) {
            f3 = (f3 - rectF.left) / rectF.width();
            f2 = (f2 - rectF.top) / rectF.height();
            this.photoViewAttacher.getOnPhotoTapListener().onPhotoTap((View)imageView, f3, f2);
            return true;
        }
        boolean bl3 = bl2;
        if (this.photoViewAttacher.getOnViewTapListener() == null) return bl3;
        this.photoViewAttacher.getOnViewTapListener().onViewTap((View)imageView, motionEvent.getX(), motionEvent.getY());
        return bl2;
    }

    public void setPhotoViewAttacher(PhotoViewAttacher photoViewAttacher) {
        this.photoViewAttacher = photoViewAttacher;
    }
}

