/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.support.v4.app.FragmentActivity;
import android.util.Log;
import android.view.View;
import android.widget.ImageView;
import com.bumptech.glide.GlideBuilder;
import com.bumptech.glide.MemoryCategory;
import com.bumptech.glide.RequestManager;
import com.bumptech.glide.load.DecodeFormat;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.engine.Engine;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.bumptech.glide.load.engine.cache.MemoryCache;
import com.bumptech.glide.load.engine.prefill.BitmapPreFiller;
import com.bumptech.glide.load.engine.prefill.PreFillType;
import com.bumptech.glide.load.model.GenericLoaderFactory;
import com.bumptech.glide.load.model.GlideUrl;
import com.bumptech.glide.load.model.ImageVideoWrapper;
import com.bumptech.glide.load.model.ModelLoader;
import com.bumptech.glide.load.model.ModelLoaderFactory;
import com.bumptech.glide.load.model.file_descriptor.FileDescriptorFileLoader;
import com.bumptech.glide.load.model.file_descriptor.FileDescriptorResourceLoader;
import com.bumptech.glide.load.model.file_descriptor.FileDescriptorStringLoader;
import com.bumptech.glide.load.model.file_descriptor.FileDescriptorUriLoader;
import com.bumptech.glide.load.model.stream.HttpUrlGlideUrlLoader;
import com.bumptech.glide.load.model.stream.StreamByteArrayLoader;
import com.bumptech.glide.load.model.stream.StreamFileLoader;
import com.bumptech.glide.load.model.stream.StreamResourceLoader;
import com.bumptech.glide.load.model.stream.StreamStringLoader;
import com.bumptech.glide.load.model.stream.StreamUriLoader;
import com.bumptech.glide.load.model.stream.StreamUrlLoader;
import com.bumptech.glide.load.resource.bitmap.CenterCrop;
import com.bumptech.glide.load.resource.bitmap.FileDescriptorBitmapDataLoadProvider;
import com.bumptech.glide.load.resource.bitmap.FitCenter;
import com.bumptech.glide.load.resource.bitmap.GlideBitmapDrawable;
import com.bumptech.glide.load.resource.bitmap.ImageVideoDataLoadProvider;
import com.bumptech.glide.load.resource.bitmap.StreamBitmapDataLoadProvider;
import com.bumptech.glide.load.resource.drawable.GlideDrawable;
import com.bumptech.glide.load.resource.file.StreamFileDataLoadProvider;
import com.bumptech.glide.load.resource.gif.GifDrawable;
import com.bumptech.glide.load.resource.gif.GifDrawableLoadProvider;
import com.bumptech.glide.load.resource.gifbitmap.GifBitmapWrapper;
import com.bumptech.glide.load.resource.gifbitmap.GifBitmapWrapperTransformation;
import com.bumptech.glide.load.resource.gifbitmap.ImageVideoGifDrawableLoadProvider;
import com.bumptech.glide.load.resource.transcode.GifBitmapWrapperDrawableTranscoder;
import com.bumptech.glide.load.resource.transcode.GlideBitmapDrawableTranscoder;
import com.bumptech.glide.load.resource.transcode.ResourceTranscoder;
import com.bumptech.glide.load.resource.transcode.TranscoderRegistry;
import com.bumptech.glide.manager.RequestManagerRetriever;
import com.bumptech.glide.module.GlideModule;
import com.bumptech.glide.module.ManifestParser;
import com.bumptech.glide.provider.DataLoadProvider;
import com.bumptech.glide.provider.DataLoadProviderRegistry;
import com.bumptech.glide.request.FutureTarget;
import com.bumptech.glide.request.Request;
import com.bumptech.glide.request.target.ImageViewTargetFactory;
import com.bumptech.glide.request.target.Target;
import com.bumptech.glide.util.Util;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;

public class Glide {
    private static final String TAG = "Glide";
    private static volatile Glide glide;
    private final CenterCrop bitmapCenterCrop;
    private final FitCenter bitmapFitCenter;
    private final BitmapPool bitmapPool;
    private final BitmapPreFiller bitmapPreFiller;
    private final DataLoadProviderRegistry dataLoadProviderRegistry;
    private final DecodeFormat decodeFormat;
    private final GifBitmapWrapperTransformation drawableCenterCrop;
    private final GifBitmapWrapperTransformation drawableFitCenter;
    private final Engine engine;
    private final ImageViewTargetFactory imageViewTargetFactory = new ImageViewTargetFactory();
    private final GenericLoaderFactory loaderFactory;
    private final Handler mainHandler;
    private final MemoryCache memoryCache;
    private final TranscoderRegistry transcoderRegistry = new TranscoderRegistry();

    Glide(Engine engine, MemoryCache memoryCache, BitmapPool bitmapPool, Context context, DecodeFormat decodeFormat) {
        this.engine = engine;
        this.bitmapPool = bitmapPool;
        this.memoryCache = memoryCache;
        this.decodeFormat = decodeFormat;
        this.loaderFactory = new GenericLoaderFactory(context);
        this.mainHandler = new Handler(Looper.getMainLooper());
        this.bitmapPreFiller = new BitmapPreFiller(memoryCache, bitmapPool, decodeFormat);
        this.dataLoadProviderRegistry = new DataLoadProviderRegistry();
        engine = new StreamBitmapDataLoadProvider(bitmapPool, decodeFormat);
        this.dataLoadProviderRegistry.register(InputStream.class, Bitmap.class, (DataLoadProvider)engine);
        memoryCache = new FileDescriptorBitmapDataLoadProvider(bitmapPool, decodeFormat);
        this.dataLoadProviderRegistry.register(ParcelFileDescriptor.class, Bitmap.class, (DataLoadProvider)memoryCache);
        engine = new ImageVideoDataLoadProvider((DataLoadProvider)engine, (DataLoadProvider)memoryCache);
        this.dataLoadProviderRegistry.register(ImageVideoWrapper.class, Bitmap.class, (DataLoadProvider)engine);
        memoryCache = new GifDrawableLoadProvider(context, bitmapPool);
        this.dataLoadProviderRegistry.register(InputStream.class, GifDrawable.class, (DataLoadProvider)memoryCache);
        this.dataLoadProviderRegistry.register(ImageVideoWrapper.class, GifBitmapWrapper.class, (DataLoadProvider)new ImageVideoGifDrawableLoadProvider((DataLoadProvider)engine, (DataLoadProvider)memoryCache, bitmapPool));
        this.dataLoadProviderRegistry.register(InputStream.class, File.class, (DataLoadProvider)new StreamFileDataLoadProvider());
        this.register((Class)File.class, (Class)ParcelFileDescriptor.class, (ModelLoaderFactory)new FileDescriptorFileLoader.Factory());
        this.register((Class)File.class, (Class)InputStream.class, (ModelLoaderFactory)new StreamFileLoader.Factory());
        this.register(Integer.TYPE, (Class)ParcelFileDescriptor.class, (ModelLoaderFactory)new FileDescriptorResourceLoader.Factory());
        this.register(Integer.TYPE, (Class)InputStream.class, (ModelLoaderFactory)new StreamResourceLoader.Factory());
        this.register((Class)Integer.class, (Class)ParcelFileDescriptor.class, (ModelLoaderFactory)new FileDescriptorResourceLoader.Factory());
        this.register((Class)Integer.class, (Class)InputStream.class, (ModelLoaderFactory)new StreamResourceLoader.Factory());
        this.register((Class)String.class, (Class)ParcelFileDescriptor.class, (ModelLoaderFactory)new FileDescriptorStringLoader.Factory());
        this.register((Class)String.class, (Class)InputStream.class, (ModelLoaderFactory)new StreamStringLoader.Factory());
        this.register((Class)Uri.class, (Class)ParcelFileDescriptor.class, (ModelLoaderFactory)new FileDescriptorUriLoader.Factory());
        this.register((Class)Uri.class, (Class)InputStream.class, (ModelLoaderFactory)new StreamUriLoader.Factory());
        this.register((Class)URL.class, (Class)InputStream.class, (ModelLoaderFactory)new StreamUrlLoader.Factory());
        this.register((Class)GlideUrl.class, (Class)InputStream.class, (ModelLoaderFactory)new HttpUrlGlideUrlLoader.Factory());
        this.register((Class)byte[].class, (Class)InputStream.class, (ModelLoaderFactory)new StreamByteArrayLoader.Factory());
        this.transcoderRegistry.register(Bitmap.class, GlideBitmapDrawable.class, (ResourceTranscoder)new GlideBitmapDrawableTranscoder(context.getResources(), bitmapPool));
        this.transcoderRegistry.register(GifBitmapWrapper.class, GlideDrawable.class, (ResourceTranscoder)new GifBitmapWrapperDrawableTranscoder((ResourceTranscoder)new GlideBitmapDrawableTranscoder(context.getResources(), bitmapPool)));
        this.bitmapCenterCrop = new CenterCrop(bitmapPool);
        this.drawableCenterCrop = new GifBitmapWrapperTransformation(bitmapPool, (Transformation)this.bitmapCenterCrop);
        this.bitmapFitCenter = new FitCenter(bitmapPool);
        this.drawableFitCenter = new GifBitmapWrapperTransformation(bitmapPool, (Transformation)this.bitmapFitCenter);
    }

    public static <T> ModelLoader<T, ParcelFileDescriptor> buildFileDescriptorModelLoader(Class<T> clazz, Context context) {
        return Glide.buildModelLoader(clazz, ParcelFileDescriptor.class, context);
    }

    public static <T> ModelLoader<T, ParcelFileDescriptor> buildFileDescriptorModelLoader(T t2, Context context) {
        return Glide.buildModelLoader(t2, ParcelFileDescriptor.class, context);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T, Y> ModelLoader<T, Y> buildModelLoader(Class<T> clazz, Class<Y> clazz2, Context context) {
        if (clazz != null) return Glide.get(context).getLoaderFactory().buildModelLoader(clazz, clazz2);
        if (!Log.isLoggable((String)TAG, (int)3)) return null;
        Log.d((String)TAG, (String)"Unable to load null model, setting placeholder only");
        return null;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T, Y> ModelLoader<T, Y> buildModelLoader(T object, Class<Y> clazz, Context context) {
        void var2_5;
        void var1_4;
        void var0_2;
        if (object == null) return Glide.buildModelLoader(var0_2, var1_4, (Context)var2_5);
        Class<?> clazz2 = object.getClass();
        return Glide.buildModelLoader(var0_2, var1_4, (Context)var2_5);
    }

    public static <T> ModelLoader<T, InputStream> buildStreamModelLoader(Class<T> clazz, Context context) {
        return Glide.buildModelLoader(clazz, InputStream.class, context);
    }

    public static <T> ModelLoader<T, InputStream> buildStreamModelLoader(T t2, Context context) {
        return Glide.buildModelLoader(t2, InputStream.class, context);
    }

    public static void clear(View view) {
        Glide.clear(new /* Unavailable Anonymous Inner Class!! */);
    }

    public static void clear(FutureTarget<?> futureTarget) {
        futureTarget.clear();
    }

    public static void clear(Target<?> target) {
        Util.assertMainThread();
        Request request = target.getRequest();
        if (request != null) {
            request.clear();
            target.setRequest(null);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Glide get(Context context) {
        if (glide == null) {
            synchronized (Glide.class) {
                if (glide == null) {
                    context = context.getApplicationContext();
                    Object object = new ManifestParser(context);
                    object = object.parse();
                    GlideBuilder glideBuilder = new GlideBuilder(context);
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        ((GlideModule)iterator.next()).applyOptions(context, glideBuilder);
                    }
                    glide = glideBuilder.createGlide();
                    object = object.iterator();
                    while (object.hasNext()) {
                        ((GlideModule)object.next()).registerComponents(context, glide);
                    }
                }
            }
        }
        return glide;
    }

    private GenericLoaderFactory getLoaderFactory() {
        return this.loaderFactory;
    }

    public static File getPhotoCacheDir(Context context) {
        return Glide.getPhotoCacheDir(context, "image_manager_disk_cache");
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static File getPhotoCacheDir(Context object, String object2) {
        File file;
        void var0_4;
        Object var2_10 = null;
        File file2 = object.getCacheDir();
        if (file2 == null) {
            Object var0_7 = var2_10;
            if (!Log.isLoggable((String)TAG, (int)6)) return var0_4;
            Log.e((String)TAG, (String)"default disk cache dir is null");
            Object var0_8 = var2_10;
            return var0_4;
        }
        if (!(file = new File(file2, (String)((Object)file))).mkdirs()) {
            Object var0_2 = var2_10;
            if (!file.exists()) return var0_4;
            if (!file.isDirectory()) {
                Object var0_3 = var2_10;
                return var0_4;
            }
        }
        File file3 = file;
        return var0_4;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Deprecated
    public static boolean isSetup() {
        if (glide == null) return false;
        return true;
    }

    @Deprecated
    public static void setup(GlideBuilder glideBuilder) {
        if (Glide.isSetup()) {
            throw new IllegalArgumentException("Glide is already setup, check with isSetup() first");
        }
        glide = glideBuilder.createGlide();
    }

    static void tearDown() {
        glide = null;
    }

    public static RequestManager with(Activity activity) {
        return RequestManagerRetriever.get().get(activity);
    }

    @TargetApi(value=11)
    public static RequestManager with(Fragment fragment) {
        return RequestManagerRetriever.get().get(fragment);
    }

    public static RequestManager with(Context context) {
        return RequestManagerRetriever.get().get(context);
    }

    public static RequestManager with(android.support.v4.app.Fragment fragment) {
        return RequestManagerRetriever.get().get(fragment);
    }

    public static RequestManager with(FragmentActivity fragmentActivity) {
        return RequestManagerRetriever.get().get(fragmentActivity);
    }

    <T, Z> DataLoadProvider<T, Z> buildDataProvider(Class<T> clazz, Class<Z> clazz2) {
        return this.dataLoadProviderRegistry.get(clazz, clazz2);
    }

    <R> Target<R> buildImageViewTarget(ImageView imageView, Class<R> clazz) {
        return this.imageViewTargetFactory.buildTarget(imageView, clazz);
    }

    <Z, R> ResourceTranscoder<Z, R> buildTranscoder(Class<Z> clazz, Class<R> clazz2) {
        return this.transcoderRegistry.get(clazz, clazz2);
    }

    public void clearDiskCache() {
        Util.assertBackgroundThread();
        this.getEngine().clearDiskCache();
    }

    public void clearMemory() {
        Util.assertMainThread();
        this.memoryCache.clearMemory();
        this.bitmapPool.clearMemory();
    }

    CenterCrop getBitmapCenterCrop() {
        return this.bitmapCenterCrop;
    }

    FitCenter getBitmapFitCenter() {
        return this.bitmapFitCenter;
    }

    public BitmapPool getBitmapPool() {
        return this.bitmapPool;
    }

    DecodeFormat getDecodeFormat() {
        return this.decodeFormat;
    }

    GifBitmapWrapperTransformation getDrawableCenterCrop() {
        return this.drawableCenterCrop;
    }

    GifBitmapWrapperTransformation getDrawableFitCenter() {
        return this.drawableFitCenter;
    }

    Engine getEngine() {
        return this.engine;
    }

    Handler getMainHandler() {
        return this.mainHandler;
    }

    public void preFillBitmapPool(PreFillType.Builder ... builderArray) {
        this.bitmapPreFiller.preFill(builderArray);
    }

    public <T, Y> void register(Class<T> clazz, Class<Y> clazz2, ModelLoaderFactory<T, Y> modelLoaderFactory) {
        if ((clazz = this.loaderFactory.register(clazz, clazz2, modelLoaderFactory)) != null) {
            clazz.teardown();
        }
    }

    public void setMemoryCategory(MemoryCategory memoryCategory) {
        Util.assertMainThread();
        this.memoryCache.setSizeMultiplier(memoryCategory.getMultiplier());
        this.bitmapPool.setSizeMultiplier(memoryCategory.getMultiplier());
    }

    public void trimMemory(int n2) {
        Util.assertMainThread();
        this.memoryCache.trimMemory(n2);
        this.bitmapPool.trimMemory(n2);
    }

    @Deprecated
    public <T, Y> void unregister(Class<T> clazz, Class<Y> clazz2) {
        if ((clazz = this.loaderFactory.unregister(clazz, clazz2)) != null) {
            clazz.teardown();
        }
    }
}

