/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide;

import android.widget.AbsListView;
import com.bumptech.glide.GenericRequestBuilder;
import com.bumptech.glide.Glide;
import com.bumptech.glide.ListPreloader;
import java.util.List;

public class ListPreloader<T>
implements AbsListView.OnScrollListener {
    private boolean isIncreasing = true;
    private int lastEnd;
    private int lastFirstVisible;
    private int lastStart;
    private final int maxPreload;
    private final PreloadSizeProvider<T> preloadDimensionProvider;
    private final PreloadModelProvider<T> preloadModelProvider;
    private final PreloadTargetQueue preloadTargetQueue;
    private int totalItemCount;

    @Deprecated
    public ListPreloader(int n2) {
        this.preloadModelProvider = new 1(this);
        this.preloadDimensionProvider = new 2(this);
        this.maxPreload = n2;
        this.preloadTargetQueue = new /* Unavailable Anonymous Inner Class!! */;
    }

    public ListPreloader(PreloadModelProvider<T> preloadModelProvider, PreloadSizeProvider<T> preloadSizeProvider, int n2) {
        this.preloadModelProvider = preloadModelProvider;
        this.preloadDimensionProvider = preloadSizeProvider;
        this.maxPreload = n2;
        this.preloadTargetQueue = new /* Unavailable Anonymous Inner Class!! */;
    }

    private void cancelAll() {
        for (int i2 = 0; i2 < this.maxPreload; ++i2) {
            Glide.clear(this.preloadTargetQueue.next(0, 0));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void preload(int n2, int n3) {
        int n4;
        int n5;
        if (n2 < n3) {
            n5 = Math.max(this.lastEnd, n2);
            n4 = n3;
        } else {
            n4 = Math.min(this.lastStart, n2);
            n5 = n3;
        }
        n4 = Math.min(this.totalItemCount, n4);
        n5 = Math.min(this.totalItemCount, Math.max(0, n5));
        if (n2 < n3) {
            for (n2 = n5; n2 < n4; ++n2) {
                this.preloadAdapterPosition(this.preloadModelProvider.getPreloadItems(n2), n2, true);
            }
        } else {
            for (n2 = n4 - 1; n2 >= n5; --n2) {
                this.preloadAdapterPosition(this.preloadModelProvider.getPreloadItems(n2), n2, false);
            }
        }
        this.lastStart = n5;
        this.lastEnd = n4;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void preload(int n2, boolean bl2) {
        if (this.isIncreasing != bl2) {
            this.isIncreasing = bl2;
            this.cancelAll();
        }
        int n3 = bl2 ? this.maxPreload : -this.maxPreload;
        this.preload(n2, n3 + n2);
    }

    private void preloadAdapterPosition(List<T> list, int n2, boolean bl2) {
        int n3 = list.size();
        if (bl2) {
            for (int i2 = 0; i2 < n3; ++i2) {
                this.preloadItem(list.get(i2), n2, i2);
            }
        } else {
            for (int i3 = n3 - 1; i3 >= 0; --i3) {
                this.preloadItem(list.get(i3), n2, i3);
            }
        }
    }

    private void preloadItem(T t2, int n2, int n3) {
        int[] nArray = this.preloadDimensionProvider.getPreloadSize(t2, n2, n3);
        if (nArray != null) {
            this.preloadModelProvider.getPreloadRequestBuilder(t2).into(this.preloadTargetQueue.next(nArray[0], nArray[1]));
        }
    }

    @Deprecated
    protected int[] getDimensions(T t2) {
        throw new IllegalStateException("You must either provide a PreloadDimensionProvider or override getDimensions()");
    }

    @Deprecated
    protected List<T> getItems(int n2, int n3) {
        throw new IllegalStateException("You must either provide a PreloadModelProvider or override getItems()");
    }

    @Deprecated
    protected GenericRequestBuilder getRequestBuilder(T t2) {
        throw new IllegalStateException("You must either provide a PreloadModelProvider, or override getRequestBuilder()");
    }

    /*
     * Enabled aggressive block sorting
     */
    public void onScroll(AbsListView absListView, int n2, int n3, int n4) {
        this.totalItemCount = n4;
        if (n2 > this.lastFirstVisible) {
            this.preload(n2 + n3, true);
        } else if (n2 < this.lastFirstVisible) {
            this.preload(n2, false);
        }
        this.lastFirstVisible = n2;
    }

    public void onScrollStateChanged(AbsListView absListView, int n2) {
    }
}

