/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.util;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.os.Build;
import android.os.Looper;
import com.bumptech.glide.util.Util;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Queue;

public final class Util {
    private static final char[] HEX_CHAR_ARRAY = "0123456789abcdef".toCharArray();
    private static final char[] SHA_1_CHARS;
    private static final char[] SHA_256_CHARS;

    static {
        SHA_256_CHARS = new char[64];
        SHA_1_CHARS = new char[40];
    }

    private Util() {
    }

    public static void assertBackgroundThread() {
        if (!Util.isOnBackgroundThread()) {
            throw new IllegalArgumentException("YOu must call this method on a background thread");
        }
    }

    public static void assertMainThread() {
        if (!Util.isOnMainThread()) {
            throw new IllegalArgumentException("You must call this method on the main thread");
        }
    }

    private static String bytesToHex(byte[] byArray, char[] cArray) {
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            int n2 = byArray[i2] & 0xFF;
            cArray[i2 * 2] = HEX_CHAR_ARRAY[n2 >>> 4];
            cArray[i2 * 2 + 1] = HEX_CHAR_ARRAY[n2 & 0xF];
        }
        return new String(cArray);
    }

    public static <T> Queue<T> createQueue(int n2) {
        return new ArrayDeque(n2);
    }

    public static int getBitmapByteSize(int n2, int n3, Bitmap.Config config) {
        return n2 * n3 * Util.getBytesPerPixel(config);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @TargetApi(value=19)
    public static int getBitmapByteSize(Bitmap bitmap) {
        if (Build.VERSION.SDK_INT < 19) return bitmap.getHeight() * bitmap.getRowBytes();
        try {
            return bitmap.getAllocationByteCount();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return bitmap.getHeight() * bitmap.getRowBytes();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int getBytesPerPixel(Bitmap.Config config) {
        Bitmap.Config config2 = config;
        if (config == null) {
            config2 = Bitmap.Config.ARGB_8888;
        }
        switch (1.$SwitchMap$android$graphics$Bitmap$Config[config2.ordinal()]) {
            default: {
                return 4;
            }
            case 1: {
                return 1;
            }
            case 2: 
            case 3: 
        }
        return 2;
    }

    @Deprecated
    public static int getSize(Bitmap bitmap) {
        return Util.getBitmapByteSize(bitmap);
    }

    public static <T> List<T> getSnapshot(Collection<T> object) {
        ArrayList arrayList = new ArrayList(object.size());
        object = object.iterator();
        while (object.hasNext()) {
            arrayList.add(object.next());
        }
        return arrayList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isOnBackgroundThread() {
        if (Util.isOnMainThread()) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isOnMainThread() {
        if (Looper.myLooper() != Looper.getMainLooper()) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isValidDimension(int n2) {
        if (n2 > 0) return true;
        if (n2 != Integer.MIN_VALUE) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isValidDimensions(int n2, int n3) {
        if (!Util.isValidDimension(n2)) return false;
        if (!Util.isValidDimension(n3)) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String sha1BytesToHex(byte[] object) {
        char[] cArray = SHA_1_CHARS;
        synchronized (cArray) {
            return Util.bytesToHex(object, SHA_1_CHARS);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String sha256BytesToHex(byte[] object) {
        char[] cArray = SHA_256_CHARS;
        synchronized (cArray) {
            return Util.bytesToHex(object, SHA_256_CHARS);
        }
    }
}

