/*
 * Decompiled with CFR 0.152.
 */
package com.common.gmacs.core;

import android.content.Context;
import android.net.Proxy;
import android.text.TextUtils;
import com.common.gmacs.core.ClientManager;
import com.common.gmacs.core.Gmacs;
import com.common.gmacs.downloader.RequestManager;
import com.common.gmacs.parse.contact.GmacsUser;
import com.common.gmacs.utils.GLog;
import com.common.gmacs.utils.GmacsEnvi;
import com.common.gmacs.utils.GmacsUtils;
import com.wuba.wchat.api.Define;
import com.wuba.wchat.api.a;
import com.wuba.wmdalite.api.WmdaLiteAPI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ClientManager {
    private static final String TAG = ClientManager.class.getSimpleName();
    private static ClientManager instance;
    public static String sAppName;
    private static final ExecutorService sExecutor;
    private static final ExecutorService sLinearExecutor;
    private int connectionStatus;
    private volatile ArrayList<ConnectListener> listenerArray = new ArrayList();
    private boolean loggedIn;
    private long loginTimeStamp;
    private PopLogViewListener popLogViewListener;

    static {
        sExecutor = new ThreadPoolExecutor(3, 10, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        sLinearExecutor = new ThreadPoolExecutor(0, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    }

    private ClientManager() {
    }

    static /* synthetic */ PopLogViewListener access$000(ClientManager clientManager) {
        return clientManager.popLogViewListener;
    }

    static /* synthetic */ long access$102(ClientManager clientManager, long l2) {
        clientManager.loginTimeStamp = l2;
        return l2;
    }

    static /* synthetic */ boolean access$202(ClientManager clientManager, boolean bl2) {
        clientManager.loggedIn = bl2;
        return bl2;
    }

    static /* synthetic */ int access$302(ClientManager clientManager, int n2) {
        clientManager.connectionStatus = n2;
        return n2;
    }

    static /* synthetic */ String access$400() {
        return TAG;
    }

    static /* synthetic */ void access$500(ClientManager clientManager, String string2) {
        clientManager.notifyTokenInvalidChanged(string2);
    }

    static /* synthetic */ void access$600(ClientManager clientManager) {
        clientManager.notifyConnectStatusChanged();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ClientManager getInstance() {
        if (instance == null) {
            synchronized (ClientManager.class) {
                if (instance == null) {
                    ClientManager clientManager;
                    instance = clientManager = new ClientManager();
                }
            }
        }
        return instance;
    }

    private void notifyConnectStatusChanged() {
        synchronized (this) {
            Iterator<ConnectListener> iterator = this.listenerArray.iterator();
            while (iterator.hasNext()) {
                iterator.next().connectStatusChanged(this.connectionStatus);
            }
            return;
        }
    }

    private void notifyTokenInvalidChanged(String string2) {
        synchronized (this) {
            Iterator<ConnectListener> iterator = this.listenerArray.iterator();
            while (iterator.hasNext()) {
                iterator.next().connectionTokenInvalid(string2);
            }
            return;
        }
    }

    public static void post(Runnable runnable) {
        sExecutor.execute(runnable);
    }

    public static void postLinear(Runnable runnable) {
        sLinearExecutor.execute(runnable);
    }

    private void regConnectListener() {
        a.a((a.b)new 4(this));
    }

    public static void setNetworkStatus(int n2) {
        a.a((Define.NetworkStatus)Define.NetworkStatus.valueOf((int)n2));
    }

    public void checkUserHasMsgAsync(String string2, int n2, CheckMergeCb checkMergeCb) {
        a.a((String)string2, (int)n2, (a.a)new 12(this, checkMergeCb));
    }

    public void cleanup() {
        a.a();
        this.loggedIn = false;
    }

    public void getCaptcha(GetCaptchaCb getCaptchaCb) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("normal_get", "0");
        a.a((String)"/msg/get_captcha", (boolean)true, hashMap, (a.j)new 10(this, getCaptchaCb));
    }

    public int getConnectionStatus() {
        return this.connectionStatus;
    }

    public long getLoginTimeStamp() {
        return this.loginTimeStamp;
    }

    public void getUserOnlineInfo(String string2, int n2, GetUserOnlineInfoCb getUserOnlineInfoCb) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("target_user_id", string2);
        hashMap.put("target_user_source", String.valueOf(n2));
        a.a((String)"/user/get_user_online_info", (boolean)true, hashMap, (a.j)new 11(this, getUserOnlineInfoCb));
    }

    public void init(String stringArray, String string2, String string3, String string4, boolean bl2) {
        boolean bl3 = false;
        Gmacs.getInstance().setLoggable(bl2);
        String string5 = GmacsEnvi.appContext.getCacheDir().getAbsolutePath() + "/gmacs/" + string2 + "/";
        String[] stringArray2 = stringArray;
        if (TextUtils.isEmpty((CharSequence)stringArray)) {
            stringArray2 = "GMACS";
        }
        sAppName = stringArray2;
        if (Gmacs.getInstance().setWMDAEnabled(true)) {
            stringArray = string4.split("\\-");
            WmdaLiteAPI.init((Context)GmacsEnvi.appContext, (String)stringArray[0], (String)stringArray[1], (String)"", (boolean)false, (boolean)false);
            WmdaLiteAPI.setActivityDurationTrackEnable((boolean)false);
        }
        if (!bl2) {
            bl3 = true;
        }
        if (!a.a((String)string5, (String)string2, (String)string3, (String)string4, (boolean)bl3)) {
            // empty if block
        }
        this.regConnectListener();
        this.regLogviewListener(new 1(this));
        this.regToastListener(new 2(this));
        this.setProxy();
    }

    public boolean isLoggedIn() {
        return this.loggedIn;
    }

    public void loginAsync(String string2, String string3, int n2, String string4, String string5, int n3, LoginCb loginCb) {
        a.a();
        this.loggedIn = true;
        GmacsUser.getInstance().init(string2, string3, n2, string4, string5, n3);
        String string6 = string2 + "_" + n2;
        RequestManager.getInstance().init(string6);
        ClientManager.setNetworkStatus(GmacsUtils.getNetworkStatus((Context)GmacsEnvi.appContext));
        a.a((String)string2, (String)string4, (String)string3, (String)string5, (int)n2, (a.c)new 3(this, string2, n2, loginCb));
    }

    public void mergeUserAsync(String string2, int n2, MergeUserCb mergeUserCb) {
        a.a((String)string2, (int)n2, (a.e)new 7(this, mergeUserCb));
    }

    public void regConnectListener(ConnectListener connectListener) {
        synchronized (this) {
            if (!this.listenerArray.contains(connectListener)) {
                this.listenerArray.add(connectListener);
            }
            return;
        }
    }

    public void regLogviewListener(OnPopLogViewListener onPopLogViewListener) {
        a.a((a.d)new 6(this, onPopLogViewListener));
    }

    public void regToastListener(OnPopToastListener onPopToastListener) {
        a.a((a.k)new 5(this, onPopToastListener));
    }

    public void registerLogViewListener(PopLogViewListener popLogViewListener) {
        this.popLogViewListener = popLogViewListener;
    }

    public void setProxy() {
        String string2 = Proxy.getDefaultHost();
        int n2 = Proxy.getDefaultPort();
        GLog.d(TAG, "setProxy.proHost:" + string2 + ",proPort:" + n2);
        String string3 = string2;
        if (TextUtils.isEmpty((CharSequence)string2)) {
            string3 = "";
        }
        string2 = new Define.ProxyInfo();
        ((Define.ProxyInfo)string2).Host = string3;
        ((Define.ProxyInfo)string2).Port = n2;
        ((Define.ProxyInfo)string2).Bypass = "";
        ((Define.ProxyInfo)string2).Pass = "";
        ((Define.ProxyInfo)string2).User = "";
        a.a((Define.ProxyInfo)string2);
    }

    public void setServerLevel(int n2) {
        a.a((Define.ServerLevel)Define.ServerLevel.valueOf((int)n2));
    }

    public void unRegConnectListener(ConnectListener connectListener) {
        synchronized (this) {
            if (this.listenerArray.contains(connectListener)) {
                this.listenerArray.remove(connectListener);
            }
            return;
        }
    }

    public void unRegisterLogViewListener() {
        this.popLogViewListener = null;
    }

    public void updateCaptcha(UpdateCaptchaCb updateCaptchaCb) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("normal_get", "1");
        a.a((String)"/msg/get_captcha", (boolean)true, hashMap, (a.j)new 9(this, updateCaptchaCb));
    }

    public void validateCaptcha(String string2, String string3, ValidateCaptchaCb validateCaptchaCb) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("userInput", string3);
        hashMap.put("responseId", string2);
        a.a((String)"/msg/validate_captcha", (boolean)true, hashMap, (a.j)new 8(this, validateCaptchaCb));
    }

    public static interface ConnectListener {
        public void connectStatusChanged(int var1);

        public void connectionTokenInvalid(String var1);
    }

    public static interface LoginCb {
        public void done(int var1, String var2);
    }

    public static interface PopLogViewListener {
        public void onShowLogView(String var1);
    }
}

