/*
 * Decompiled with CFR 0.152.
 */
package com.common.gmacs.msg.data;

import android.content.Context;
import android.content.res.Resources;
import android.text.SpannableStringBuilder;
import android.text.style.ForegroundColorSpan;
import com.common.gmacs.R;
import com.common.gmacs.msg.IMMessage;
import com.common.gmacs.utils.GmacsEnvi;
import org.json.JSONException;
import org.json.JSONObject;

public class IMImageMsg
extends IMMessage {
    public String extra;
    public String mHeight;
    public String mUrl;
    public String mWidth;
    public int progress;
    private SpannableStringBuilder style;

    public IMImageMsg() {
        super("image");
    }

    @Override
    public String getPlainText() {
        return "[\u56fe\u7247]";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SpannableStringBuilder getPlainTextSpannableStringBuilder(Context context) {
        if (this.style != null) return this.style;
        this.style = new SpannableStringBuilder((CharSequence)this.getPlainText());
        try {
            context = new ForegroundColorSpan(GmacsEnvi.appContext.getResources().getColor(R.color.gray_808080));
            this.style.setSpan((Object)context, 0, this.style.length(), 34);
            return this.style;
        }
        catch (Resources.NotFoundException notFoundException) {
            notFoundException.printStackTrace();
            return this.style;
        }
    }

    @Override
    public boolean isShowSenderName() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void parse(JSONObject jSONObject) {
        this.mUrl = jSONObject.optString("url");
        this.mWidth = jSONObject.optString("image_width");
        this.mHeight = jSONObject.optString("image_height");
        this.extra = jSONObject.optString("extra");
        if (this.style != null) return;
        this.style = new SpannableStringBuilder((CharSequence)this.getPlainText());
        try {
            jSONObject = new ForegroundColorSpan(GmacsEnvi.appContext.getResources().getColor(R.color.gray_808080));
            this.style.setSpan((Object)jSONObject, 0, this.style.length(), 34);
            return;
        }
        catch (Resources.NotFoundException notFoundException) {
            notFoundException.printStackTrace();
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void putInfoToJson(JSONObject jSONObject) {
        try {
            jSONObject.put("url", (Object)this.mUrl);
            jSONObject.put("image_width", (Object)this.mWidth);
            jSONObject.put("image_height", (Object)this.mHeight);
            jSONObject.put("extra", (Object)this.extra);
            return;
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            return;
        }
    }

    public String toString() {
        return "IMImageMsg{, mUrl='" + this.mUrl + '\'' + ", mWidth=" + this.mWidth + ", mHeight=" + this.mHeight + ", progress=" + this.progress + '}';
    }
}

