/*
 * Decompiled with CFR 0.152.
 */
package com.common.gmacs.msg.data;

import android.content.Context;
import android.text.SpannableStringBuilder;
import android.text.style.ForegroundColorSpan;
import com.common.gmacs.R;
import com.common.gmacs.msg.IMMessage;
import com.common.gmacs.utils.GmacsEnvi;
import com.common.gmacs.utils.GmacsUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class IMLocationMsg
extends IMMessage {
    public String extra;
    public String mAddress;
    public String mFromMapType = "baidu";
    public double mLatitude;
    public double mLongitude;
    public int mTradeType;
    private SpannableStringBuilder style;

    public IMLocationMsg() {
        super("location");
    }

    @Override
    public String getPlainText() {
        return "[\u4f4d\u7f6e]";
    }

    @Override
    public SpannableStringBuilder getPlainTextSpannableStringBuilder(Context context) {
        if (this.style == null) {
            this.style = new SpannableStringBuilder((CharSequence)this.getPlainText());
            context = new ForegroundColorSpan(GmacsEnvi.appContext.getResources().getColor(R.color.gray_808080));
            this.style.setSpan((Object)context, 0, this.style.length(), 34);
        }
        return this.style;
    }

    @Override
    public boolean isShowSenderName() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void parse(JSONObject jSONObject) {
        this.mAddress = jSONObject.optString("address");
        this.mFromMapType = jSONObject.optString("map_source", "baidu");
        this.extra = jSONObject.optString("extra");
        double d2 = jSONObject.optDouble("longitude", 0.0);
        double d3 = jSONObject.optDouble("latitude", 0.0);
        if (this.mFromMapType.equals("google")) {
            double[] dArray = GmacsUtils.gmacsBdEncrypt(d3, d2);
            this.mLatitude = dArray[0];
            this.mLongitude = dArray[1];
        } else {
            this.mLongitude = d2;
            this.mLatitude = d3;
        }
        this.mTradeType = jSONObject.optInt("tradeType");
        if (this.style == null) {
            this.style = new SpannableStringBuilder((CharSequence)this.getPlainText());
            jSONObject = new ForegroundColorSpan(GmacsEnvi.appContext.getResources().getColor(R.color.gray_808080));
            this.style.setSpan((Object)jSONObject, 0, this.style.length(), 34);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void putInfoToJson(JSONObject jSONObject) {
        try {
            jSONObject.put("address", (Object)this.mAddress);
            jSONObject.put("map_source", (Object)this.mFromMapType);
            jSONObject.put("longitude", this.mLongitude);
            jSONObject.put("latitude", this.mLatitude);
            jSONObject.put("tradeType", this.mTradeType);
            jSONObject.put("extra", (Object)this.extra);
            return;
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            return;
        }
    }
}

