/*
 * Decompiled with CFR 0.152.
 */
package com.common.gmacs.parse.message;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import com.common.gmacs.R;
import com.common.gmacs.core.Gmacs;
import com.common.gmacs.parse.contact.GmacsUser;
import com.common.gmacs.parse.message.GmacsUserInfo;
import com.common.gmacs.parse.message.Message;
import com.common.gmacs.parse.message.MessageDetail;
import com.common.gmacs.parse.talk.Talk;
import com.common.gmacs.parse.talk.TalkType;
import com.wuba.wchat.api.Define;
import java.util.ArrayList;
import java.util.List;

public class Message {
    public boolean hasSetShowTime;
    public boolean isDeleted;
    public boolean isTalkDeleted;
    public long mId;
    public long mLinkMsgId;
    public MessageDetail mMsgDetail;
    public long mMsgId;
    public MessageUserInfo mReceiverInfo;
    public MessageUserInfo mSenderInfo;
    public int mTalkType;
    public boolean shouldHideOnTalkList;
    public boolean shouldHideUnreadCount;
    public boolean shouldShowTime;

    public Message() {
    }

    public Message(int n2) {
        this.mTalkType = n2;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static Message buildMessage(Define.Msg object) {
        void var0_2;
        if (object == null) {
            return var0_2;
        }
        boolean bl2 = Message.checkIsSelfSendMessage(object);
        Message message = new Message();
        message.parseFromMsg((Define.Msg)object);
        message.mMsgDetail = new MessageDetail(message);
        message.mMsgDetail.parseFromMsg((Define.Msg)object, bl2);
        message.mMsgDetail.parseRefer((Define.Msg)object);
        boolean bl3 = message.mMsgDetail.getReadStatus() != 0;
        message.mSenderInfo = MessageUserInfo.parseSenderInfoFromMsg(object, bl3, bl2);
        message.mReceiverInfo = MessageUserInfo.parseReceiverInfoFromMsg(object);
        message.mMsgDetail.setMsgContent(message.mMsgDetail.parseMsgContent((Define.Msg)object));
        Message message2 = message;
        return var0_2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static List<Message> buildMessage(List<Define.Msg> iterator) {
        ArrayList<Message> arrayList = new ArrayList<Message>();
        if (iterator != null) {
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                arrayList.add(Message.buildMessage((Define.Msg)iterator.next()));
            }
        }
        return arrayList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Define.Msg buildMsg(Message message) {
        if (message == null) {
            return null;
        }
        Define.Msg msg = new Define.Msg();
        message.putIntoMsg(msg);
        return msg;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean checkIsSelfSendMessage(Define.Msg msg) {
        String string2 = msg.getSenderId();
        if (TextUtils.isEmpty((CharSequence)string2)) return false;
        if (!string2.equals(GmacsUser.getInstance().getUserId())) return false;
        if (msg.getSenderSource() != GmacsUser.getInstance().getSource()) return false;
        return true;
    }

    public void checkIsSelfSendMessage() {
        if (this.mSenderInfo.mUserId != null && this.mSenderInfo.mUserId.equals(GmacsUser.getInstance().getUserId()) && this.mSenderInfo.mUserSource == GmacsUser.getInstance().getSource() && this.mMsgDetail != null) {
            this.mMsgDetail.mIsSelfSendMsg = true;
            this.mMsgDetail.setMsgReadStatus(1);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        boolean bl2 = false;
        if (object == null) {
            return bl2;
        }
        if (object instanceof Message) {
            if (((Message)object).mId != this.mId) return bl2;
            return true;
        }
        if (!(object instanceof Talk)) return bl2;
        return ((Talk)object).getTalkId().equals(Talk.getTalkId(this));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public SpannableStringBuilder getPlainTextSpannableStringBuilder(Context object, boolean bl2) {
        void var2_8;
        SpannableStringBuilder spannableStringBuilder = null;
        if (this.mMsgDetail != null && (spannableStringBuilder = this.mMsgDetail.getPlainTextSpannableStringBuilder((Context)object)) != null && this.mMsgDetail.isShowSenderName() && TalkType.isGroupTalk(this) && var2_8 != false) {
            void var1_4;
            String string2 = "";
            if (this.mMsgDetail.mIsSelfSendMsg) {
                String string3 = string2;
                if (Gmacs.getInstance().getGmacsUserInfo() != null) {
                    String string4 = Gmacs.getInstance().getGmacsUserInfo().userName;
                }
            } else {
                String string5 = string2;
                if (this.mSenderInfo != null) {
                    String string6 = string2;
                    if (this.mSenderInfo.gmacsUserInfo != null) {
                        String string7 = this.mSenderInfo.gmacsUserInfo.userName;
                    }
                }
            }
            if (!TextUtils.isEmpty((CharSequence)var1_4)) {
                spannableStringBuilder.insert(0, (CharSequence)((String)var1_4 + ":"));
            }
        }
        return spannableStringBuilder;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MessageUserInfo getTalkOtherUserInfo() {
        if (this.mMsgDetail == null) return null;
        if (this.mMsgDetail.mIsSelfSendMsg) {
            return this.mReceiverInfo;
        }
        if (!TalkType.isGroupTalk(this)) return this.mSenderInfo;
        return this.mReceiverInfo;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void parseFromMsg(Define.Msg msg) {
        boolean bl2 = true;
        this.mTalkType = msg.getMsgType();
        this.mId = msg.getLocalId();
        this.mMsgId = msg.getMsgId();
        this.mLinkMsgId = msg.getLinkMsgId();
        boolean bl3 = msg.getIsDeleted() == 1;
        this.isDeleted = bl3;
        bl3 = msg.getIsTalkDeleted() == 1;
        this.isTalkDeleted = bl3;
        bl3 = msg.getUnreadCountHide() == 1;
        this.shouldHideUnreadCount = bl3;
        bl3 = msg.getTalkListHide() == 1 ? bl2 : false;
        this.shouldHideOnTalkList = bl3;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void putIntoMsg(Define.Msg msg) {
        int n2 = 1;
        if (this.mSenderInfo != null) {
            this.mSenderInfo.putSenderInfoIntoMsg(msg);
        }
        if (this.mReceiverInfo != null) {
            this.mReceiverInfo.putReceiverInfoIntoMsg(msg);
        }
        if (this.mMsgDetail != null) {
            this.mMsgDetail.putIntoMsg(msg);
        }
        msg.msg_type = this.mTalkType;
        msg.local_id = this.mId;
        msg.msg_id = this.mMsgId;
        int n3 = this.shouldHideUnreadCount ? 1 : 0;
        msg.unread_count_hide = n3;
        n3 = this.shouldHideOnTalkList ? n2 : 0;
        msg.talk_list_hide = n3;
    }

    public String toString() {
        return "Message{mSenderInfo=" + this.mSenderInfo + ", mReceiverInfo=" + this.mReceiverInfo + ", mTalkType=" + this.mTalkType + ", mMsgDetail=" + this.mMsgDetail + ", mId=" + this.mId + ", isDeleted=" + this.isDeleted + ", isTalkDeleted=" + this.isTalkDeleted + "}";
    }

    public static class MessageUserInfo
    implements Parcelable {
        public static final Parcelable.Creator<MessageUserInfo> CREATOR = new 1();
        public GmacsUserInfo gmacsUserInfo;
        public String mDeviceId;
        public int mTalkType;
        public String mUserId;
        public int mUserSource;

        public MessageUserInfo() {
        }

        protected MessageUserInfo(Parcel parcel) {
            this.mUserId = parcel.readString();
            this.mDeviceId = parcel.readString();
            this.mUserSource = parcel.readInt();
            this.mTalkType = parcel.readInt();
            this.gmacsUserInfo = (GmacsUserInfo)parcel.readParcelable(GmacsUserInfo.class.getClassLoader());
        }

        public static MessageUserInfo createLoginUserInfo() {
            MessageUserInfo messageUserInfo = new MessageUserInfo();
            messageUserInfo.mUserId = GmacsUser.getInstance().getUserId();
            messageUserInfo.mUserSource = GmacsUser.getInstance().getSource();
            messageUserInfo.mDeviceId = GmacsUser.getInstance().getDeviceId();
            messageUserInfo.gmacsUserInfo = Gmacs.getInstance().getGmacsUserInfo();
            return messageUserInfo;
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        static MessageUserInfo parseReceiverInfoFromMsg(Define.Msg object) {
            void var0_2;
            if (object == null) {
                return var0_2;
            }
            MessageUserInfo messageUserInfo = new MessageUserInfo();
            messageUserInfo.mTalkType = object.getMsgType();
            messageUserInfo.mUserId = object.getToId();
            messageUserInfo.mUserSource = object.getToSource();
            messageUserInfo.mDeviceId = object.getToDeviceId();
            MessageUserInfo messageUserInfo2 = messageUserInfo;
            return var0_2;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        static MessageUserInfo parseSenderInfoFromMsg(Define.Msg msg, boolean bl2, boolean bl3) {
            if (msg == null) {
                return null;
            }
            MessageUserInfo messageUserInfo = new MessageUserInfo();
            messageUserInfo.mTalkType = msg.getMsgType();
            messageUserInfo.mUserId = msg.getSenderId();
            messageUserInfo.mUserSource = msg.getSenderSource();
            messageUserInfo.mDeviceId = msg.getSenderDeviceId();
            MessageUserInfo messageUserInfo2 = messageUserInfo;
            if (bl3) return messageUserInfo2;
            messageUserInfo2 = messageUserInfo;
            if (bl2) return messageUserInfo2;
            messageUserInfo.gmacsUserInfo = GmacsUserInfo.parseFromUserJsonToModel(messageUserInfo.mUserId, messageUserInfo.mUserSource, msg.getSenderInfo());
            return messageUserInfo;
        }

        public int describeContents() {
            return 0;
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public String getUserName(Context object) {
            void var1_3;
            if (this.gmacsUserInfo == null) {
                String string2 = object.getResources().getString(R.string.default_user_name);
                return var1_3;
            }
            String string3 = this.gmacsUserInfo.userName;
            return var1_3;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean isAddFriend() {
            if (!"SYSTEM_FRIEND".equals(this.mUserId)) return false;
            if (this.mUserSource != 1999) return false;
            return true;
        }

        /*
         * Enabled aggressive block sorting
         */
        void putReceiverInfoIntoMsg(Define.Msg msg) {
            if (msg == null) {
                return;
            }
            msg.to_id = this.mUserId;
            String string2 = this.mDeviceId == null ? "" : this.mDeviceId;
            msg.to_device_id = string2;
            msg.to_source = this.mUserSource;
        }

        /*
         * Enabled aggressive block sorting
         */
        void putSenderInfoIntoMsg(Define.Msg msg) {
            if (msg == null) {
                return;
            }
            msg.sender_id = this.mUserId;
            msg.sender_device_id = this.mDeviceId;
            String string2 = this.gmacsUserInfo == null ? "" : this.gmacsUserInfo.parseFromUserModelToJson();
            msg.sender_info = string2;
            msg.sender_source = GmacsUser.getInstance().getSource();
        }

        public String toString() {
            return "MessageUserInfo{mUserId=" + this.mUserId + ", mDeviceId=" + this.mDeviceId + ", mUserSource=" + this.mUserSource + ", mTalkType=" + this.mTalkType + ", gmacsUserInfo=" + this.gmacsUserInfo + "}";
        }

        public void writeToParcel(Parcel parcel, int n2) {
            parcel.writeString(this.mUserId);
            parcel.writeString(this.mDeviceId);
            parcel.writeInt(this.mUserSource);
            parcel.writeInt(this.mTalkType);
            parcel.writeParcelable((Parcelable)this.gmacsUserInfo, 0);
        }
    }
}

