/*
 * Decompiled with CFR 0.152.
 */
package com.common.gmacs.parse.talk;

import android.content.Context;
import android.database.Cursor;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.text.style.ForegroundColorSpan;
import com.common.gmacs.R;
import com.common.gmacs.core.MessageManager;
import com.common.gmacs.parse.contact.Remark;
import com.common.gmacs.parse.message.Message;
import com.common.gmacs.parse.talk.TalkType;
import com.common.gmacs.provider.GmacsProviderManager;
import com.common.gmacs.provider.UserInfoDB;
import com.wuba.wchat.api.bean.TalkUserInfo;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;

public class Talk {
    public static final int TALK_STATE_END = 3;
    public static final int TALK_STATE_ING = 1;
    public static final int TALK_STATE_PAUSE = 2;
    public String mDraftBoxMsg;
    public long mDraftBoxMsgTime;
    private Message mLastMessage;
    public int mNoReadMsgCount;
    public String mTalkOtherDeviceId;
    public int mTalkOtherGender;
    public String mTalkOtherUserAvatar;
    public String mTalkOtherUserId;
    public String mTalkOtherUserName;
    public Remark mTalkOtherUserRemark;
    public int mTalkOtherUserSource;
    public int mTalkOtherUserType;
    private int mTalkState = 3;
    public int mTalkType;

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Talk buildTalk(com.wuba.wchat.api.bean.Talk object) {
        void var0_2;
        Talk talk = null;
        if (object == null) {
            Talk talk2 = talk;
            return var0_2;
        }
        talk = new Talk();
        talk.parseFromSDKTalk((com.wuba.wchat.api.bean.Talk)object);
        Talk talk3 = talk;
        return var0_2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static List<Talk> buildTalks(List<com.wuba.wchat.api.bean.Talk> iterator) {
        ArrayList<Talk> arrayList = new ArrayList<Talk>();
        if (iterator != null && !iterator.isEmpty()) {
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                arrayList.add(Talk.buildTalk((com.wuba.wchat.api.bean.Talk)iterator.next()));
            }
        }
        return arrayList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Talk createTalkByMessageUserInfo(Message.MessageUserInfo messageUserInfo) {
        if (messageUserInfo == null) return null;
        Talk talk = new Talk();
        talk.mTalkOtherUserId = messageUserInfo.mUserId;
        talk.mTalkOtherUserSource = messageUserInfo.mUserSource;
        talk.mTalkType = messageUserInfo.mTalkType;
        talk.mTalkOtherDeviceId = messageUserInfo.mDeviceId;
        Talk talk2 = talk;
        if (messageUserInfo.gmacsUserInfo == null) return talk2;
        talk.mTalkOtherUserAvatar = messageUserInfo.gmacsUserInfo.avatar;
        talk.mTalkOtherUserName = messageUserInfo.gmacsUserInfo.userName;
        talk.mTalkOtherGender = messageUserInfo.gmacsUserInfo.gender;
        talk.mTalkOtherUserType = messageUserInfo.gmacsUserInfo.userType;
        return talk;
    }

    public static String getTalkId(int n2, String string2) {
        return n2 + "-" + string2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getTalkId(Message object) {
        if (object == null) {
            return "";
        }
        if ((object = ((Message)object).getTalkOtherUserInfo()) == null) return "";
        if (TextUtils.isEmpty((CharSequence)((Message.MessageUserInfo)object).mUserId)) return "";
        return Talk.getTalkId(((Message.MessageUserInfo)object).mUserSource, ((Message.MessageUserInfo)object).mUserId);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (this == object) return true;
        if (!(object instanceof Talk)) return false;
        if (!((Talk)object).getTalkId().equals(this.getTalkId())) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SpannableStringBuilder getNewestMsgContent(Context context) {
        if (!TextUtils.isEmpty((CharSequence)this.mDraftBoxMsg)) {
            SpannableStringBuilder spannableStringBuilder = new SpannableStringBuilder((CharSequence)this.mDraftBoxMsg);
            spannableStringBuilder.insert(0, (CharSequence)"[\u8349\u7a3f]");
            spannableStringBuilder.setSpan((Object)new ForegroundColorSpan(context.getResources().getColor(R.color.red)), 0, 4, 34);
            return spannableStringBuilder;
        }
        if (this.mLastMessage != null) return this.mLastMessage.getPlainTextSpannableStringBuilder(context, true);
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getOtherName(String string2) {
        String string3 = "";
        if (this.mTalkOtherUserRemark != null) {
            string3 = this.mTalkOtherUserRemark.remark_name;
        }
        String string4 = string3;
        if (TextUtils.isEmpty((CharSequence)string3)) {
            string4 = string3;
            if (this.mLastMessage != null) {
                Message.MessageUserInfo messageUserInfo = this.mLastMessage.getTalkOtherUserInfo();
                string4 = string3;
                if (messageUserInfo.gmacsUserInfo != null) {
                    string4 = messageUserInfo.gmacsUserInfo.userName;
                }
            }
        }
        string3 = string4;
        if (TextUtils.isEmpty((CharSequence)string4)) {
            string3 = this.mTalkOtherUserName;
        }
        if (!TextUtils.isEmpty((CharSequence)string3)) return string3;
        if (TextUtils.isEmpty((CharSequence)string2)) return this.mTalkOtherUserId;
        return string2;
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean getTalkFromDBCache(String object, int n2) {
        boolean bl2;
        Cursor cursor;
        block7: {
            block6: {
                cursor = GmacsProviderManager.getInstance().query(UserInfoDB.CONTENT_URI, null, "user_id=? AND user_source=?", new String[]{object, String.valueOf(n2)}, null);
                if (cursor == null) break block6;
                if (!cursor.moveToFirst()) break block6;
                this.mTalkOtherUserId = object;
                this.mTalkOtherUserSource = n2;
                this.mTalkOtherUserName = cursor.getString(cursor.getColumnIndex("user_name"));
                this.mTalkOtherUserType = cursor.getInt(cursor.getColumnIndex("user_type"));
                this.mTalkOtherUserAvatar = cursor.getString(cursor.getColumnIndex("avatar"));
                this.mTalkOtherGender = cursor.getInt(cursor.getColumnIndex("gender"));
                String string2 = cursor.getString(cursor.getColumnIndex("remark"));
                if (TextUtils.isEmpty((CharSequence)string2)) break block6;
                this.mTalkOtherUserRemark = object = new Remark();
                this.mTalkOtherUserRemark.parseFromJsonString(string2);
                bl2 = true;
                break block7;
                catch (Exception exception) {
                    Cursor cursor2;
                    return false;
                    catch (Throwable throwable) {
                        void var1_5;
                        block8: {
                            cursor = null;
                            break block8;
                            catch (Throwable throwable2) {}
                        }
                        if (cursor == null) throw var1_5;
                        cursor.close();
                        throw var1_5;
                    }
                    catch (Exception exception2) {
                        cursor2 = cursor;
                    }
                    if (cursor2 == null) return false;
                    cursor2.close();
                    return false;
                }
            }
            bl2 = false;
        }
        boolean bl3 = bl2;
        if (cursor == null) return bl3;
        cursor.close();
        return bl2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getTalkId() {
        if (TextUtils.isEmpty((CharSequence)this.mTalkOtherUserId)) return "";
        return Talk.getTalkId(this.mTalkOtherUserSource, this.mTalkOtherUserId);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long getTalkUpdatetime() {
        if (this.mLastMessage == null) return 0L;
        if (this.mLastMessage.mMsgDetail == null) return 0L;
        if (this.mLastMessage.mMsgDetail.mMsgUpdateTime <= this.mDraftBoxMsgTime) return this.mDraftBoxMsgTime;
        return this.mLastMessage.mMsgDetail.mMsgUpdateTime;
    }

    public Message getmLastMessage() {
        return this.mLastMessage;
    }

    public boolean hasTheSameTalkIdWith(Message message) {
        return this.getTalkId().equals(Talk.getTalkId(message));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isTalking() {
        boolean bl2 = true;
        if (this.mTalkState != 1) return false;
        return bl2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean parseFromSDKTalk(com.wuba.wchat.api.bean.Talk object) {
        if (object == null) {
            return false;
        }
        this.parseFromSDKTalkExceptLastMsg((com.wuba.wchat.api.bean.Talk)object);
        this.mLastMessage = Message.buildMessage(object.getLastMsg());
        if (this.mLastMessage == null) return false;
        this.mTalkOtherDeviceId = this.mLastMessage.getTalkOtherUserInfo().mDeviceId;
        Message message = MessageManager.getInstance().getSendingMsgForTalk(Talk.getTalkId(this.mLastMessage), this.mLastMessage.mId);
        if (message == null) return false;
        this.mLastMessage = message;
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void parseFromSDKTalkExceptLastMsg(com.wuba.wchat.api.bean.Talk object) {
        String string2 = null;
        TalkUserInfo talkUserInfo = null;
        this.mTalkOtherUserSource = object.getOtherSource();
        this.mTalkOtherUserId = object.getOtherId();
        this.mNoReadMsgCount = object.getUnreadMsgCount();
        this.mTalkType = object.getTalkType();
        if (TalkType.isGroupTalk(this)) {
            if ((object = object.getTalkBaseInfo()) == null) return;
            this.mTalkOtherUserName = object.getName();
            string2 = object.getAvatarUrl();
            if (TextUtils.isEmpty((CharSequence)string2)) return;
            try {
                object = new JSONArray(string2);
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
                object = talkUserInfo;
            }
            if (object == null) return;
            this.mTalkOtherUserAvatar = object.optString(0);
            return;
        }
        talkUserInfo = object.getTalkUserInfo();
        if (talkUserInfo == null) return;
        this.mTalkOtherUserName = talkUserInfo.name;
        this.mTalkOtherUserAvatar = talkUserInfo.avatar_url;
        this.mTalkOtherUserType = talkUserInfo.user_type;
        this.mTalkOtherGender = talkUserInfo.gender;
        object = string2;
        if (!TextUtils.isEmpty((CharSequence)talkUserInfo.remark)) {
            object = new Remark();
            ((Remark)object).parseFromJsonString(talkUserInfo.remark);
        }
        this.mTalkOtherUserRemark = object;
    }

    public void setTalkState(int n2) {
        this.mTalkState = n2;
    }

    public String toString() {
        return "TalkImpl{mLastMessage=" + this.mLastMessage + ", mTalkType=" + this.mTalkType + ", mTalkOtherUserId='" + this.mTalkOtherUserId + '\'' + ", mTalkOtherUserName='" + this.mTalkOtherUserName + '\'' + ", mTalkOtherUserAvatar='" + this.mTalkOtherUserAvatar + '\'' + ", mTalkOtherUserSource=" + this.mTalkOtherUserSource + ", mTalkOtherUserType=" + this.mTalkOtherUserType + ", mTalkOtherGender=" + this.mTalkOtherGender + ", mTalkOtherUserRemark=" + this.mTalkOtherUserRemark + ", mNoReadMsgCount=" + this.mNoReadMsgCount + ", mDraftBoxMsg='" + this.mDraftBoxMsg + '\'' + ", mDraftBoxMsgTime=" + this.mDraftBoxMsgTime + ", mTalkState=" + this.mTalkState + '}';
    }
}

