/*
 * Decompiled with CFR 0.152.
 */
package com.common.gmacs.utils;

import android.content.Context;
import android.net.ConnectivityManager;
import android.os.Environment;
import android.os.Handler;
import android.os.Looper;
import android.os.StatFs;
import com.common.gmacs.utils.GLog;
import com.common.gmacs.utils.GmacsEnvi;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class GmacsUtils {
    private static final String TAG = GmacsUtils.class.getSimpleName();
    private static volatile GmacsUtils ourInstance;
    private Handler mHandler = new Handler(Looper.getMainLooper());
    private ThreadPoolExecutor mThreadPoolExecutor = new ThreadPoolExecutor(0, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());

    private GmacsUtils() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object deepClone(Serializable object) {
        Object var1_4 = null;
        try {
            Closeable closeable = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream((OutputStream)closeable);
            objectOutputStream.writeObject(object);
            object = new ByteArrayInputStream(((ByteArrayOutputStream)closeable).toByteArray());
            closeable = new ObjectInputStream((InputStream)object);
            return ((ObjectInputStream)closeable).readObject();
        }
        catch (Exception exception) {
            return var1_4;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return var1_4;
        }
        catch (IOException iOException) {
            return var1_4;
        }
    }

    public static int dipToPixel(float f2) {
        return (int)(GmacsEnvi.appContext.getResources().getDisplayMetrics().density * f2 + 0.5f);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static GmacsUtils getInstance() {
        if (ourInstance == null) {
            synchronized (GmacsUtils.class) {
                if (ourInstance == null) {
                    GmacsUtils gmacsUtils;
                    ourInstance = gmacsUtils = new GmacsUtils();
                }
            }
        }
        return ourInstance;
    }

    /*
     * Unable to fully structure code
     */
    public static int getNetworkStatus(Context var0) {
        block8: {
            if ((var0 = ((ConnectivityManager)var0.getSystemService("connectivity")).getActiveNetworkInfo()) == null || !var0.isConnected()) break block8;
            if (var0.getType() == 1) {
                var1_1 = 5;
lbl4:
                // 3 sources

                while (true) {
                    GLog.d(GmacsUtils.TAG, "Network Type : " + var1_1);
                    return var1_1;
                }
            }
            if (var0.getType() != 0) break block8;
            var2_2 = var0.getSubtypeName();
            GLog.d(GmacsUtils.TAG, "Network getSubtypeName : " + var2_2);
            var3_3 = var0.getSubtype();
            switch (var3_3) {
                default: {
                    if (!var2_2.equalsIgnoreCase("TD-SCDMA") && !var2_2.equalsIgnoreCase("WCDMA") && !var2_2.equalsIgnoreCase("CDMA2000")) break;
                    var1_1 = 3;
lbl15:
                    // 5 sources

                    while (true) {
                        GLog.d(GmacsUtils.TAG, "Network getSubtype : " + Integer.valueOf(var3_3).toString());
                        ** GOTO lbl4
                        break;
                    }
                }
                case 1: 
                case 2: 
                case 4: 
                case 7: 
                case 11: {
                    var1_1 = 2;
                    ** GOTO lbl15
                }
                case 3: 
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 10: 
                case 12: 
                case 14: 
                case 15: {
                    var1_1 = 3;
                    ** GOTO lbl15
                }
                case 13: {
                    var1_1 = 4;
                    ** GOTO lbl15
                }
            }
            var1_1 = 1;
            ** while (true)
        }
        var1_1 = 0;
        ** while (true)
    }

    public static long getSDAllSize() {
        StatFs statFs = new StatFs(Environment.getExternalStorageDirectory().getPath());
        long l2 = statFs.getBlockSize();
        return (long)statFs.getBlockCount() * l2 / 1024L / 1024L;
    }

    public static long getSDFreeSize() {
        StatFs statFs = new StatFs(Environment.getExternalStorageDirectory().getPath());
        long l2 = statFs.getBlockSize();
        return (long)statFs.getAvailableBlocks() * l2 / 1024L / 1024L;
    }

    public static double[] gmacsBdEncrypt(double d2, double d3) {
        double d4 = Math.sqrt(d2 * d2 + d3 * d3) + 2.0E-5 * Math.sin(d2 * Math.PI);
        d2 = Math.atan2(d2, d3) + 3.0E-6 * Math.cos(Math.PI * d3);
        return new double[]{Math.sin(d2) * d4 + 0.006, d4 * Math.cos(d2) + 0.0065};
    }

    public static int pixelToDip(float f2) {
        return (int)(f2 / GmacsEnvi.appContext.getResources().getDisplayMetrics().density + 0.5f);
    }

    public void execute(Runnable runnable) {
        if (runnable != null) {
            this.mThreadPoolExecutor.execute(runnable);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void runOnUiThread(Runnable runnable) {
        if (Looper.myLooper() != Looper.getMainLooper()) {
            this.mHandler.post(runnable);
            return;
        }
        runnable.run();
    }
}

