/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.FieldNamingStrategy;
import com.google.gson.Gson;
import com.google.gson.InstanceCreator;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonNull;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import com.google.gson.LongSerializationPolicy;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.internal.ConstructorConstructor;
import com.google.gson.internal.Excluder;
import com.google.gson.internal.Primitives;
import com.google.gson.internal.Streams;
import com.google.gson.internal.bind.ArrayTypeAdapter;
import com.google.gson.internal.bind.CollectionTypeAdapterFactory;
import com.google.gson.internal.bind.DateTypeAdapter;
import com.google.gson.internal.bind.JsonTreeReader;
import com.google.gson.internal.bind.JsonTreeWriter;
import com.google.gson.internal.bind.MapTypeAdapterFactory;
import com.google.gson.internal.bind.ObjectTypeAdapter;
import com.google.gson.internal.bind.ReflectiveTypeAdapterFactory;
import com.google.gson.internal.bind.SqlDateTypeAdapter;
import com.google.gson.internal.bind.TimeTypeAdapter;
import com.google.gson.internal.bind.TypeAdapters;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.google.gson.stream.MalformedJsonException;
import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class Gson {
    static final boolean DEFAULT_JSON_NON_EXECUTABLE = false;
    private static final String JSON_NON_EXECUTABLE_PREFIX = ")]}'\n";
    private final ThreadLocal<Map<TypeToken<?>, FutureTypeAdapter<?>>> calls = new 1(this);
    private final ConstructorConstructor constructorConstructor;
    final JsonDeserializationContext deserializationContext;
    private final List<TypeAdapterFactory> factories;
    private final boolean generateNonExecutableJson;
    private final boolean htmlSafe;
    private final boolean prettyPrinting;
    final JsonSerializationContext serializationContext;
    private final boolean serializeNulls;
    private final Map<TypeToken<?>, TypeAdapter<?>> typeTokenCache = Collections.synchronizedMap(new HashMap());

    public Gson() {
        this(Excluder.DEFAULT, (FieldNamingStrategy)FieldNamingPolicy.IDENTITY, Collections.emptyMap(), false, false, false, true, false, false, LongSerializationPolicy.DEFAULT, Collections.emptyList());
    }

    Gson(Excluder excluder, FieldNamingStrategy fieldNamingStrategy, Map<Type, InstanceCreator<?>> object, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, LongSerializationPolicy longSerializationPolicy, List<TypeAdapterFactory> list) {
        this.deserializationContext = new 2(this);
        this.serializationContext = new 3(this);
        this.constructorConstructor = new ConstructorConstructor(object);
        this.serializeNulls = bl2;
        this.generateNonExecutableJson = bl4;
        this.htmlSafe = bl5;
        this.prettyPrinting = bl6;
        object = new ArrayList();
        object.add(TypeAdapters.JSON_ELEMENT_FACTORY);
        object.add(ObjectTypeAdapter.FACTORY);
        object.addAll(list);
        object.add(TypeAdapters.STRING_FACTORY);
        object.add(TypeAdapters.INTEGER_FACTORY);
        object.add(TypeAdapters.BOOLEAN_FACTORY);
        object.add(TypeAdapters.BYTE_FACTORY);
        object.add(TypeAdapters.SHORT_FACTORY);
        object.add(TypeAdapters.newFactory(Long.TYPE, Long.class, this.longAdapter(longSerializationPolicy)));
        object.add(TypeAdapters.newFactory(Double.TYPE, Double.class, this.doubleAdapter(bl7)));
        object.add(TypeAdapters.newFactory(Float.TYPE, Float.class, this.floatAdapter(bl7)));
        object.add(TypeAdapters.NUMBER_FACTORY);
        object.add(TypeAdapters.CHARACTER_FACTORY);
        object.add(TypeAdapters.STRING_BUILDER_FACTORY);
        object.add(TypeAdapters.STRING_BUFFER_FACTORY);
        object.add(TypeAdapters.newFactory(BigDecimal.class, (TypeAdapter)TypeAdapters.BIG_DECIMAL));
        object.add(TypeAdapters.newFactory(BigInteger.class, (TypeAdapter)TypeAdapters.BIG_INTEGER));
        object.add(TypeAdapters.URL_FACTORY);
        object.add(TypeAdapters.URI_FACTORY);
        object.add(TypeAdapters.UUID_FACTORY);
        object.add(TypeAdapters.LOCALE_FACTORY);
        object.add(TypeAdapters.INET_ADDRESS_FACTORY);
        object.add(TypeAdapters.BIT_SET_FACTORY);
        object.add(DateTypeAdapter.FACTORY);
        object.add(TypeAdapters.CALENDAR_FACTORY);
        object.add(TimeTypeAdapter.FACTORY);
        object.add(SqlDateTypeAdapter.FACTORY);
        object.add(TypeAdapters.TIMESTAMP_FACTORY);
        object.add(ArrayTypeAdapter.FACTORY);
        object.add(TypeAdapters.ENUM_FACTORY);
        object.add(TypeAdapters.CLASS_FACTORY);
        object.add(excluder);
        object.add(new CollectionTypeAdapterFactory(this.constructorConstructor));
        object.add(new MapTypeAdapterFactory(this.constructorConstructor, bl3));
        object.add(new ReflectiveTypeAdapterFactory(this.constructorConstructor, fieldNamingStrategy, excluder));
        this.factories = Collections.unmodifiableList(object);
    }

    static /* synthetic */ void access$000(Gson gson, double d2) {
        gson.checkValidFloatingPoint(d2);
    }

    private static void assertFullConsumption(Object object, JsonReader jsonReader) {
        if (object != null) {
            try {
                if (jsonReader.peek() != JsonToken.END_DOCUMENT) {
                    object = new JsonIOException("JSON document was not fully consumed.");
                    throw object;
                }
            }
            catch (MalformedJsonException malformedJsonException) {
                throw new JsonSyntaxException((Throwable)malformedJsonException);
            }
            catch (IOException iOException) {
                throw new JsonIOException((Throwable)iOException);
            }
        }
    }

    private void checkValidFloatingPoint(double d2) {
        if (Double.isNaN(d2) || Double.isInfinite(d2)) {
            throw new IllegalArgumentException(d2 + " is not a valid double value as per JSON specification. To override this" + " behavior, use GsonBuilder.serializeSpecialDoubleValues() method.");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private TypeAdapter<Number> doubleAdapter(boolean bl2) {
        if (!bl2) return new 4(this);
        return TypeAdapters.DOUBLE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private TypeAdapter<Number> floatAdapter(boolean bl2) {
        if (!bl2) return new 5(this);
        return TypeAdapters.FLOAT;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private TypeAdapter<Number> longAdapter(LongSerializationPolicy longSerializationPolicy) {
        if (longSerializationPolicy != LongSerializationPolicy.DEFAULT) return new 6(this);
        return TypeAdapters.LONG;
    }

    private JsonWriter newJsonWriter(Writer writer) throws IOException {
        if (this.generateNonExecutableJson) {
            writer.write(JSON_NON_EXECUTABLE_PREFIX);
        }
        writer = new JsonWriter(writer);
        if (this.prettyPrinting) {
            writer.setIndent("  ");
        }
        writer.setSerializeNulls(this.serializeNulls);
        return writer;
    }

    public <T> T fromJson(JsonElement object, Class<T> clazz) throws JsonSyntaxException {
        object = this.fromJson((JsonElement)object, (Type)clazz);
        return Primitives.wrap(clazz).cast(object);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T> T fromJson(JsonElement object, Type type) throws JsonSyntaxException {
        void var2_5;
        void var1_3;
        if (object == null) {
            return var1_3;
        }
        T t2 = this.fromJson((JsonReader)new JsonTreeReader(object), (Type)var2_5);
        return var1_3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T fromJson(JsonReader jsonReader, Type object) throws JsonIOException, JsonSyntaxException {
        boolean bl2 = true;
        boolean bl3 = jsonReader.isLenient();
        jsonReader.setLenient(true);
        try {
            jsonReader.peek();
            bl2 = false;
            object = this.getAdapter(TypeToken.get(object)).read(jsonReader);
            return (T)object;
        }
        catch (EOFException eOFException) {
            if (bl2) {
                object = null;
                return (T)object;
            }
            JsonSyntaxException jsonSyntaxException = new JsonSyntaxException((Throwable)eOFException);
            throw jsonSyntaxException;
        }
        catch (IllegalStateException illegalStateException) {
            JsonSyntaxException jsonSyntaxException = new JsonSyntaxException((Throwable)illegalStateException);
            throw jsonSyntaxException;
        }
        catch (IOException iOException) {
            object = new JsonSyntaxException((Throwable)iOException);
            throw object;
        }
        finally {
            jsonReader.setLenient(bl3);
            return (T)object;
        }
    }

    public <T> T fromJson(Reader reader, Class<T> clazz) throws JsonSyntaxException, JsonIOException {
        reader = new JsonReader(reader);
        T t2 = this.fromJson((JsonReader)reader, clazz);
        Gson.assertFullConsumption(t2, (JsonReader)reader);
        return Primitives.wrap(clazz).cast(t2);
    }

    public <T> T fromJson(Reader reader, Type type) throws JsonIOException, JsonSyntaxException {
        reader = new JsonReader(reader);
        type = this.fromJson((JsonReader)reader, type);
        Gson.assertFullConsumption(type, (JsonReader)reader);
        return (T)type;
    }

    public <T> T fromJson(String string2, Class<T> clazz) throws JsonSyntaxException {
        string2 = this.fromJson(string2, (Type)clazz);
        return Primitives.wrap(clazz).cast(string2);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T> T fromJson(String string2, Type type) throws JsonSyntaxException {
        void var2_5;
        void var1_3;
        if (string2 == null) {
            return var1_3;
        }
        T t2 = this.fromJson((Reader)new StringReader(string2), (Type)var2_5);
        return var1_3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T> TypeAdapter<T> getAdapter(TypeToken<T> typeAdapter) {
        TypeAdapter typeAdapter2 = this.typeTokenCache.get(typeAdapter);
        if (typeAdapter2 != null) {
            return typeAdapter2;
        }
        Map<TypeToken<?>, FutureTypeAdapter<?>> map = this.calls.get();
        typeAdapter2 = map.get(typeAdapter);
        if (typeAdapter2 != null) {
            return typeAdapter2;
        }
        FutureTypeAdapter futureTypeAdapter = new /* Unavailable Anonymous Inner Class!! */;
        map.put((TypeToken<?>)typeAdapter, futureTypeAdapter);
        try {
            Iterator<TypeAdapterFactory> iterator = this.factories.iterator();
            while (iterator.hasNext()) {
                typeAdapter2 = iterator.next().create(this, typeAdapter);
                if (typeAdapter2 == null) continue;
                futureTypeAdapter.setDelegate(typeAdapter2);
                this.typeTokenCache.put((TypeToken<?>)typeAdapter, typeAdapter2);
                typeAdapter = typeAdapter2;
                return typeAdapter;
            }
            typeAdapter2 = new StringBuilder();
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(typeAdapter2.append("GSON cannot handle ").append(typeAdapter).toString());
            throw illegalArgumentException;
        }
        finally {
            map.remove(typeAdapter);
        }
    }

    public <T> TypeAdapter<T> getAdapter(Class<T> clazz) {
        return this.getAdapter(TypeToken.get(clazz));
    }

    public <T> TypeAdapter<T> getDelegateAdapter(TypeAdapterFactory typeAdapterFactory, TypeToken<T> typeToken) {
        Iterator<TypeAdapterFactory> iterator = this.factories.iterator();
        boolean bl2 = false;
        while (iterator.hasNext()) {
            TypeAdapterFactory typeAdapterFactory2 = iterator.next();
            if (!bl2) {
                if (typeAdapterFactory2 != typeAdapterFactory) continue;
                bl2 = true;
                continue;
            }
            if ((typeAdapterFactory2 = typeAdapterFactory2.create(this, typeToken)) == null) continue;
            return typeAdapterFactory2;
        }
        throw new IllegalArgumentException("GSON cannot serialize " + typeToken);
    }

    public String toJson(JsonElement jsonElement) {
        StringWriter stringWriter = new StringWriter();
        this.toJson(jsonElement, (Appendable)stringWriter);
        return stringWriter.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String toJson(Object object) {
        if (object != null) return this.toJson(object, object.getClass());
        return this.toJson(JsonNull.INSTANCE);
    }

    public String toJson(Object object, Type type) {
        StringWriter stringWriter = new StringWriter();
        this.toJson(object, type, stringWriter);
        return stringWriter.toString();
    }

    public void toJson(JsonElement jsonElement, JsonWriter jsonWriter) throws JsonIOException {
        boolean bl2 = jsonWriter.isLenient();
        jsonWriter.setLenient(true);
        boolean bl3 = jsonWriter.isHtmlSafe();
        jsonWriter.setHtmlSafe(this.htmlSafe);
        boolean bl4 = jsonWriter.getSerializeNulls();
        jsonWriter.setSerializeNulls(this.serializeNulls);
        try {
            Streams.write((JsonElement)jsonElement, (JsonWriter)jsonWriter);
            return;
        }
        catch (IOException iOException) {
            JsonIOException jsonIOException = new JsonIOException((Throwable)iOException);
            throw jsonIOException;
        }
        finally {
            jsonWriter.setLenient(bl2);
            jsonWriter.setHtmlSafe(bl3);
            jsonWriter.setSerializeNulls(bl4);
        }
    }

    public void toJson(JsonElement jsonElement, Appendable appendable) throws JsonIOException {
        try {
            this.toJson(jsonElement, this.newJsonWriter(Streams.writerForAppendable((Appendable)appendable)));
            return;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void toJson(Object object, Appendable appendable) throws JsonIOException {
        if (object != null) {
            this.toJson(object, object.getClass(), appendable);
            return;
        }
        this.toJson((JsonElement)JsonNull.INSTANCE, appendable);
    }

    public void toJson(Object object, Type jsonIOException, JsonWriter jsonWriter) throws JsonIOException {
        jsonIOException = this.getAdapter(TypeToken.get((Type)jsonIOException));
        boolean bl2 = jsonWriter.isLenient();
        jsonWriter.setLenient(true);
        boolean bl3 = jsonWriter.isHtmlSafe();
        jsonWriter.setHtmlSafe(this.htmlSafe);
        boolean bl4 = jsonWriter.getSerializeNulls();
        jsonWriter.setSerializeNulls(this.serializeNulls);
        try {
            jsonIOException.write(jsonWriter, object);
            return;
        }
        catch (IOException iOException) {
            jsonIOException = new JsonIOException((Throwable)iOException);
            throw jsonIOException;
        }
        finally {
            jsonWriter.setLenient(bl2);
            jsonWriter.setHtmlSafe(bl3);
            jsonWriter.setSerializeNulls(bl4);
        }
    }

    public void toJson(Object object, Type type, Appendable appendable) throws JsonIOException {
        try {
            this.toJson(object, type, this.newJsonWriter(Streams.writerForAppendable((Appendable)appendable)));
            return;
        }
        catch (IOException iOException) {
            throw new JsonIOException((Throwable)iOException);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JsonElement toJsonTree(Object object) {
        if (object != null) return this.toJsonTree(object, object.getClass());
        return JsonNull.INSTANCE;
    }

    public JsonElement toJsonTree(Object object, Type type) {
        JsonTreeWriter jsonTreeWriter = new JsonTreeWriter();
        this.toJson(object, type, (JsonWriter)jsonTreeWriter);
        return jsonTreeWriter.get();
    }

    public String toString() {
        return "{" + "serializeNulls:" + this.serializeNulls + "factories:" + this.factories + ",instanceCreators:" + this.constructorConstructor + "}";
    }
}

