/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.Hex;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoTypeWriter;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.Container;
import com.googlecode.mp4parser.DataSource;
import com.googlecode.mp4parser.annotations.DoNotParseDetail;
import com.googlecode.mp4parser.util.CastUtils;
import com.googlecode.mp4parser.util.Logger;
import com.googlecode.mp4parser.util.Path;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;

public abstract class AbstractBox
implements Box {
    static final /* synthetic */ boolean $assertionsDisabled;
    private static Logger LOG;
    private ByteBuffer content;
    long contentStartPosition;
    DataSource dataSource;
    private ByteBuffer deadBytes = null;
    boolean isParsed;
    boolean isRead;
    long memMapSize = -1L;
    long offset;
    private Container parent;
    protected String type;
    private byte[] userType;

    /*
     * Enabled aggressive block sorting
     */
    static {
        boolean bl2 = !AbstractBox.class.desiredAssertionStatus();
        $assertionsDisabled = bl2;
        LOG = Logger.getLogger(AbstractBox.class);
    }

    protected AbstractBox(String string2) {
        this.type = string2;
        this.isRead = true;
        this.isParsed = true;
    }

    protected AbstractBox(String string2, byte[] byArray) {
        this.type = string2;
        this.userType = byArray;
        this.isRead = true;
        this.isParsed = true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void getHeader(ByteBuffer byteBuffer) {
        if (this.isSmallBox()) {
            IsoTypeWriter.writeUInt32((ByteBuffer)byteBuffer, (long)this.getSize());
            byteBuffer.put(IsoFile.fourCCtoBytes(this.getType()));
        } else {
            IsoTypeWriter.writeUInt32((ByteBuffer)byteBuffer, (long)1L);
            byteBuffer.put(IsoFile.fourCCtoBytes(this.getType()));
            IsoTypeWriter.writeUInt64((ByteBuffer)byteBuffer, (long)this.getSize());
        }
        if ("uuid".equals(this.getType())) {
            byteBuffer.put(this.getUserType());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean isSmallBox() {
        int n2 = 8;
        if ("uuid".equals(this.getType())) {
            n2 = 24;
        }
        if (this.isRead) {
            if (this.isParsed) {
                long l2 = this.getContentSize();
                int n3 = this.deadBytes != null ? this.deadBytes.limit() : 0;
                if (l2 + (long)n3 + (long)n2 >= 0x100000000L) return false;
                return true;
            }
            if ((long)(n2 + this.content.limit()) >= 0x100000000L) return false;
            return true;
        }
        if (this.memMapSize + (long)n2 >= 0x100000000L) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readContent() {
        synchronized (this) {
            boolean bl2 = this.isRead;
            if (!bl2) {
                try {
                    Logger logger = LOG;
                    StringBuilder stringBuilder = new StringBuilder("mem mapping ");
                    logger.logDebug(stringBuilder.append(this.getType()).toString());
                    this.content = this.dataSource.map(this.contentStartPosition, this.memMapSize);
                    this.isRead = true;
                }
                catch (IOException iOException) {
                    RuntimeException runtimeException = new RuntimeException(iOException);
                    throw runtimeException;
                }
            }
            return;
        }
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    private boolean verify(ByteBuffer byteBuffer) {
        boolean bl2 = false;
        long l2 = this.getContentSize();
        int n2 = this.deadBytes != null ? this.deadBytes.limit() : 0;
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(CastUtils.l2i((long)(l2 + (long)n2)));
        this.getContent(byteBuffer2);
        boolean bl3 = true;
        while (true) {
            block9: {
                block8: {
                    block7: {
                        if (!bl3 || (bl3 = false)) break block7;
                        if (this.deadBytes == null) break block8;
                        this.deadBytes.rewind();
                    }
                    if (this.deadBytes.remaining() > 0) break block9;
                }
                byteBuffer.rewind();
                byteBuffer2.rewind();
                if (byteBuffer.remaining() == byteBuffer2.remaining()) break;
                LOG.logError(String.valueOf(this.getType()) + ": remaining differs " + byteBuffer.remaining() + " vs. " + byteBuffer2.remaining());
                return bl2;
            }
            byteBuffer2.put(this.deadBytes);
        }
        int n3 = byteBuffer.position();
        int n4 = byteBuffer.limit() - 1;
        n2 = byteBuffer2.limit() - 1;
        while (n4 >= n3) {
            byte by;
            byte by2 = byteBuffer.get(n4);
            if (by2 != (by = byteBuffer2.get(n2))) {
                LOG.logError(String.format("%s: buffers differ at %d: %2X/%2X", this.getType(), n4, by2, by));
                byte[] byArray = new byte[byteBuffer.remaining()];
                byte[] byArray2 = new byte[byteBuffer2.remaining()];
                byteBuffer.get(byArray);
                byteBuffer2.get(byArray2);
                System.err.println("original      : " + Hex.encodeHex((byte[])byArray, (int)4));
                System.err.println("reconstructed : " + Hex.encodeHex((byte[])byArray2, (int)4));
                return bl2;
            }
            --n4;
            --n2;
        }
        return true;
    }

    protected abstract void _parseDetails(ByteBuffer var1);

    /*
     * Enabled aggressive block sorting
     */
    public void getBox(WritableByteChannel writableByteChannel) throws IOException {
        ByteBuffer byteBuffer;
        block6: {
            block7: {
                int n2;
                block4: {
                    int n3;
                    block5: {
                        n2 = 8;
                        n3 = 16;
                        if (!this.isRead) break block4;
                        if (!this.isParsed) break block5;
                        byteBuffer = ByteBuffer.allocate(CastUtils.l2i((long)this.getSize()));
                        this.getHeader(byteBuffer);
                        this.getContent(byteBuffer);
                        if (this.deadBytes == null) break block6;
                        this.deadBytes.rewind();
                        break block7;
                    }
                    if (!this.isSmallBox()) {
                        n2 = 16;
                    }
                    if (!"uuid".equals(this.getType())) {
                        n3 = 0;
                    }
                    ByteBuffer byteBuffer2 = ByteBuffer.allocate(n2 + n3);
                    this.getHeader(byteBuffer2);
                    writableByteChannel.write((ByteBuffer)byteBuffer2.rewind());
                    writableByteChannel.write((ByteBuffer)this.content.position(0));
                    return;
                }
                if (!this.isSmallBox()) {
                    n2 = 16;
                }
                ByteBuffer byteBuffer3 = ByteBuffer.allocate(n2);
                this.getHeader(byteBuffer3);
                writableByteChannel.write((ByteBuffer)byteBuffer3.rewind());
                this.dataSource.transferTo(this.contentStartPosition, this.memMapSize, writableByteChannel);
                return;
            }
            while (this.deadBytes.remaining() > 0) {
                byteBuffer.put(this.deadBytes);
            }
        }
        writableByteChannel.write((ByteBuffer)byteBuffer.rewind());
    }

    protected abstract void getContent(ByteBuffer var1);

    protected abstract long getContentSize();

    public long getOffset() {
        return this.offset;
    }

    @DoNotParseDetail
    public Container getParent() {
        return this.parent;
    }

    @DoNotParseDetail
    public String getPath() {
        return Path.createPath((Box)this);
    }

    /*
     * Enabled aggressive block sorting
     */
    public long getSize() {
        int n2 = 0;
        long l2 = this.isRead ? (this.isParsed ? this.getContentSize() : (long)this.content.limit()) : this.memMapSize;
        int n3 = l2 >= 0xFFFFFFF8L ? 8 : 0;
        int n4 = "uuid".equals(this.getType()) ? 16 : 0;
        long l3 = n4 + (n3 + 8);
        if (this.deadBytes == null) {
            n3 = n2;
            return (long)n3 + (l2 + l3);
        }
        n3 = this.deadBytes.limit();
        return (long)n3 + (l2 + l3);
    }

    @DoNotParseDetail
    public String getType() {
        return this.type;
    }

    @DoNotParseDetail
    public byte[] getUserType() {
        return this.userType;
    }

    public boolean isParsed() {
        return this.isParsed;
    }

    @DoNotParseDetail
    public void parse(DataSource dataSource, ByteBuffer byteBuffer, long l2, BoxParser boxParser) throws IOException {
        this.contentStartPosition = dataSource.position();
        this.offset = this.contentStartPosition - (long)byteBuffer.remaining();
        this.memMapSize = l2;
        this.dataSource = dataSource;
        dataSource.position(dataSource.position() + l2);
        this.isRead = false;
        this.isParsed = false;
    }

    public final void parseDetails() {
        synchronized (this) {
            this.readContent();
            Object object = LOG;
            StringBuilder stringBuilder = new StringBuilder("parsing details of ");
            object.logDebug(stringBuilder.append(this.getType()).toString());
            if (this.content != null) {
                object = this.content;
                this.isParsed = true;
                ((ByteBuffer)object).rewind();
                this._parseDetails((ByteBuffer)object);
                if (((Buffer)object).remaining() > 0) {
                    this.deadBytes = ((ByteBuffer)object).slice();
                }
                this.content = null;
                if (!$assertionsDisabled && !this.verify((ByteBuffer)object)) {
                    object = new AssertionError();
                    throw object;
                }
            }
            return;
        }
    }

    protected void setDeadBytes(ByteBuffer byteBuffer) {
        this.deadBytes = byteBuffer;
    }

    @DoNotParseDetail
    public void setParent(Container container) {
        this.parent = container;
    }
}

