/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.boxes.mp4.objectdescriptors;

import com.coremedia.iso.Hex;
import com.coremedia.iso.IsoTypeWriter;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.BaseDescriptor;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.BitReaderBuffer;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.BitWriterBuffer;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.Descriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

@Descriptor(objectTypeIndication=64, tags={5})
public class AudioSpecificConfig
extends BaseDescriptor {
    public static Map<Integer, String> audioObjectTypeMap;
    public static Map<Integer, Integer> samplingFrequencyIndexMap;
    int aacScalefactorDataResilienceFlag;
    int aacSectionDataResilienceFlag;
    int aacSpectralDataResilienceFlag;
    int audioObjectType;
    int channelConfiguration;
    byte[] configBytes;
    int coreCoderDelay;
    int dependsOnCoreCoder;
    int directMapping;
    int epConfig;
    int erHvxcExtensionFlag;
    int extensionAudioObjectType;
    int extensionChannelConfiguration;
    int extensionFlag;
    int extensionFlag3;
    int extensionSamplingFrequency;
    int extensionSamplingFrequencyIndex;
    int fillBits;
    int frameLengthFlag;
    boolean gaSpecificConfig;
    int hilnContMode;
    int hilnEnhaLayer;
    int hilnEnhaQuantMode;
    int hilnFrameLength;
    int hilnMaxNumLine;
    int hilnQuantMode;
    int hilnSampleRateCode;
    int hvxcRateMode;
    int hvxcVarMode;
    int isBaseLayer;
    int layerNr;
    int layer_length;
    int numOfSubFrame;
    int paraExtensionFlag;
    int paraMode;
    boolean parametricSpecificConfig;
    int psPresentFlag;
    int sacPayloadEmbedding;
    int samplingFrequency;
    int samplingFrequencyIndex;
    int sbrPresentFlag;
    int syncExtensionType;
    int var_ScalableFlag;

    static {
        samplingFrequencyIndexMap = new HashMap<Integer, Integer>();
        audioObjectTypeMap = new HashMap<Integer, String>();
        samplingFrequencyIndexMap.put(0, 96000);
        samplingFrequencyIndexMap.put(1, 88200);
        samplingFrequencyIndexMap.put(2, 64000);
        samplingFrequencyIndexMap.put(3, 48000);
        samplingFrequencyIndexMap.put(4, 44100);
        samplingFrequencyIndexMap.put(5, 32000);
        samplingFrequencyIndexMap.put(6, 24000);
        samplingFrequencyIndexMap.put(7, 22050);
        samplingFrequencyIndexMap.put(8, 16000);
        samplingFrequencyIndexMap.put(9, 12000);
        samplingFrequencyIndexMap.put(10, 11025);
        samplingFrequencyIndexMap.put(11, 8000);
        audioObjectTypeMap.put(1, "AAC main");
        audioObjectTypeMap.put(2, "AAC LC");
        audioObjectTypeMap.put(3, "AAC SSR");
        audioObjectTypeMap.put(4, "AAC LTP");
        audioObjectTypeMap.put(5, "SBR");
        audioObjectTypeMap.put(6, "AAC Scalable");
        audioObjectTypeMap.put(7, "TwinVQ");
        audioObjectTypeMap.put(8, "CELP");
        audioObjectTypeMap.put(9, "HVXC");
        audioObjectTypeMap.put(10, "(reserved)");
        audioObjectTypeMap.put(11, "(reserved)");
        audioObjectTypeMap.put(12, "TTSI");
        audioObjectTypeMap.put(13, "Main synthetic");
        audioObjectTypeMap.put(14, "Wavetable synthesis");
        audioObjectTypeMap.put(15, "General MIDI");
        audioObjectTypeMap.put(16, "Algorithmic Synthesis and Audio FX");
        audioObjectTypeMap.put(17, "ER AAC LC");
        audioObjectTypeMap.put(18, "(reserved)");
        audioObjectTypeMap.put(19, "ER AAC LTP");
        audioObjectTypeMap.put(20, "ER AAC Scalable");
        audioObjectTypeMap.put(21, "ER TwinVQ");
        audioObjectTypeMap.put(22, "ER BSAC");
        audioObjectTypeMap.put(23, "ER AAC LD");
        audioObjectTypeMap.put(24, "ER CELP");
        audioObjectTypeMap.put(25, "ER HVXC");
        audioObjectTypeMap.put(26, "ER HILN");
        audioObjectTypeMap.put(27, "ER Parametric");
        audioObjectTypeMap.put(28, "SSC");
        audioObjectTypeMap.put(29, "PS");
        audioObjectTypeMap.put(30, "MPEG Surround");
        audioObjectTypeMap.put(31, "(escape)");
        audioObjectTypeMap.put(32, "Layer-1");
        audioObjectTypeMap.put(33, "Layer-2");
        audioObjectTypeMap.put(34, "Layer-3");
        audioObjectTypeMap.put(35, "DST");
        audioObjectTypeMap.put(36, "ALS");
        audioObjectTypeMap.put(37, "SLS");
        audioObjectTypeMap.put(38, "SLS non-core");
        audioObjectTypeMap.put(39, "ER AAC ELD");
        audioObjectTypeMap.put(40, "SMR Simple");
        audioObjectTypeMap.put(41, "SMR Main");
    }

    private int gaSpecificConfigSize() {
        return 0;
    }

    private int getAudioObjectType(BitReaderBuffer bitReaderBuffer) throws IOException {
        int n2;
        int n3 = n2 = bitReaderBuffer.readBits(5);
        if (n2 == 31) {
            n3 = bitReaderBuffer.readBits(6) + 32;
        }
        return n3;
    }

    private void parseErHvxcConfig(int n2, int n3, int n4, BitReaderBuffer bitReaderBuffer) throws IOException {
        this.hvxcVarMode = bitReaderBuffer.readBits(1);
        this.hvxcRateMode = bitReaderBuffer.readBits(2);
        this.erHvxcExtensionFlag = bitReaderBuffer.readBits(1);
        if (this.erHvxcExtensionFlag == 1) {
            this.var_ScalableFlag = bitReaderBuffer.readBits(1);
        }
    }

    private void parseGaSpecificConfig(int n2, int n3, int n4, BitReaderBuffer bitReaderBuffer) throws IOException {
        this.frameLengthFlag = bitReaderBuffer.readBits(1);
        this.dependsOnCoreCoder = bitReaderBuffer.readBits(1);
        if (this.dependsOnCoreCoder == 1) {
            this.coreCoderDelay = bitReaderBuffer.readBits(14);
        }
        this.extensionFlag = bitReaderBuffer.readBits(1);
        if (n3 == 0) {
            throw new UnsupportedOperationException("can't parse program_config_element yet");
        }
        if (n4 == 6 || n4 == 20) {
            this.layerNr = bitReaderBuffer.readBits(3);
        }
        if (this.extensionFlag == 1) {
            if (n4 == 22) {
                this.numOfSubFrame = bitReaderBuffer.readBits(5);
                this.layer_length = bitReaderBuffer.readBits(11);
            }
            if (n4 == 17 || n4 == 19 || n4 == 20 || n4 == 23) {
                this.aacSectionDataResilienceFlag = bitReaderBuffer.readBits(1);
                this.aacScalefactorDataResilienceFlag = bitReaderBuffer.readBits(1);
                this.aacSpectralDataResilienceFlag = bitReaderBuffer.readBits(1);
            }
            this.extensionFlag3 = bitReaderBuffer.readBits(1);
        }
        this.gaSpecificConfig = true;
    }

    private void parseHilnConfig(int n2, int n3, int n4, BitReaderBuffer bitReaderBuffer) throws IOException {
        this.hilnQuantMode = bitReaderBuffer.readBits(1);
        this.hilnMaxNumLine = bitReaderBuffer.readBits(8);
        this.hilnSampleRateCode = bitReaderBuffer.readBits(4);
        this.hilnFrameLength = bitReaderBuffer.readBits(12);
        this.hilnContMode = bitReaderBuffer.readBits(2);
    }

    private void parseHilnEnexConfig(int n2, int n3, int n4, BitReaderBuffer bitReaderBuffer) throws IOException {
        this.hilnEnhaLayer = bitReaderBuffer.readBits(1);
        if (this.hilnEnhaLayer == 1) {
            this.hilnEnhaQuantMode = bitReaderBuffer.readBits(2);
        }
    }

    private void parseParaConfig(int n2, int n3, int n4, BitReaderBuffer bitReaderBuffer) throws IOException {
        this.paraMode = bitReaderBuffer.readBits(2);
        if (this.paraMode != 1) {
            this.parseErHvxcConfig(n2, n3, n4, bitReaderBuffer);
        }
        if (this.paraMode != 0) {
            this.parseHilnConfig(n2, n3, n4, bitReaderBuffer);
        }
        this.paraExtensionFlag = bitReaderBuffer.readBits(1);
        this.parametricSpecificConfig = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseParametricSpecificConfig(int n2, int n3, int n4, BitReaderBuffer bitReaderBuffer) throws IOException {
        this.isBaseLayer = bitReaderBuffer.readBits(1);
        if (this.isBaseLayer == 1) {
            this.parseParaConfig(n2, n3, n4, bitReaderBuffer);
            return;
        }
        this.parseHilnEnexConfig(n2, n3, n4, bitReaderBuffer);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        boolean bl2 = true;
        if (this == object) {
            return bl2;
        }
        if (object == null) return false;
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (AudioSpecificConfig)object;
        if (this.aacScalefactorDataResilienceFlag != ((AudioSpecificConfig)object).aacScalefactorDataResilienceFlag) {
            return false;
        }
        if (this.aacSectionDataResilienceFlag != ((AudioSpecificConfig)object).aacSectionDataResilienceFlag) {
            return false;
        }
        if (this.aacSpectralDataResilienceFlag != ((AudioSpecificConfig)object).aacSpectralDataResilienceFlag) {
            return false;
        }
        if (this.audioObjectType != ((AudioSpecificConfig)object).audioObjectType) {
            return false;
        }
        if (this.channelConfiguration != ((AudioSpecificConfig)object).channelConfiguration) {
            return false;
        }
        if (this.coreCoderDelay != ((AudioSpecificConfig)object).coreCoderDelay) {
            return false;
        }
        if (this.dependsOnCoreCoder != ((AudioSpecificConfig)object).dependsOnCoreCoder) {
            return false;
        }
        if (this.directMapping != ((AudioSpecificConfig)object).directMapping) {
            return false;
        }
        if (this.epConfig != ((AudioSpecificConfig)object).epConfig) {
            return false;
        }
        if (this.erHvxcExtensionFlag != ((AudioSpecificConfig)object).erHvxcExtensionFlag) {
            return false;
        }
        if (this.extensionAudioObjectType != ((AudioSpecificConfig)object).extensionAudioObjectType) {
            return false;
        }
        if (this.extensionChannelConfiguration != ((AudioSpecificConfig)object).extensionChannelConfiguration) {
            return false;
        }
        if (this.extensionFlag != ((AudioSpecificConfig)object).extensionFlag) {
            return false;
        }
        if (this.extensionFlag3 != ((AudioSpecificConfig)object).extensionFlag3) {
            return false;
        }
        if (this.extensionSamplingFrequency != ((AudioSpecificConfig)object).extensionSamplingFrequency) {
            return false;
        }
        if (this.extensionSamplingFrequencyIndex != ((AudioSpecificConfig)object).extensionSamplingFrequencyIndex) {
            return false;
        }
        if (this.fillBits != ((AudioSpecificConfig)object).fillBits) {
            return false;
        }
        if (this.frameLengthFlag != ((AudioSpecificConfig)object).frameLengthFlag) {
            return false;
        }
        if (this.gaSpecificConfig != ((AudioSpecificConfig)object).gaSpecificConfig) {
            return false;
        }
        if (this.hilnContMode != ((AudioSpecificConfig)object).hilnContMode) {
            return false;
        }
        if (this.hilnEnhaLayer != ((AudioSpecificConfig)object).hilnEnhaLayer) {
            return false;
        }
        if (this.hilnEnhaQuantMode != ((AudioSpecificConfig)object).hilnEnhaQuantMode) {
            return false;
        }
        if (this.hilnFrameLength != ((AudioSpecificConfig)object).hilnFrameLength) {
            return false;
        }
        if (this.hilnMaxNumLine != ((AudioSpecificConfig)object).hilnMaxNumLine) {
            return false;
        }
        if (this.hilnQuantMode != ((AudioSpecificConfig)object).hilnQuantMode) {
            return false;
        }
        if (this.hilnSampleRateCode != ((AudioSpecificConfig)object).hilnSampleRateCode) {
            return false;
        }
        if (this.hvxcRateMode != ((AudioSpecificConfig)object).hvxcRateMode) {
            return false;
        }
        if (this.hvxcVarMode != ((AudioSpecificConfig)object).hvxcVarMode) {
            return false;
        }
        if (this.isBaseLayer != ((AudioSpecificConfig)object).isBaseLayer) {
            return false;
        }
        if (this.layerNr != ((AudioSpecificConfig)object).layerNr) {
            return false;
        }
        if (this.layer_length != ((AudioSpecificConfig)object).layer_length) {
            return false;
        }
        if (this.numOfSubFrame != ((AudioSpecificConfig)object).numOfSubFrame) {
            return false;
        }
        if (this.paraExtensionFlag != ((AudioSpecificConfig)object).paraExtensionFlag) {
            return false;
        }
        if (this.paraMode != ((AudioSpecificConfig)object).paraMode) {
            return false;
        }
        if (this.parametricSpecificConfig != ((AudioSpecificConfig)object).parametricSpecificConfig) {
            return false;
        }
        if (this.psPresentFlag != ((AudioSpecificConfig)object).psPresentFlag) {
            return false;
        }
        if (this.sacPayloadEmbedding != ((AudioSpecificConfig)object).sacPayloadEmbedding) {
            return false;
        }
        if (this.samplingFrequency != ((AudioSpecificConfig)object).samplingFrequency) {
            return false;
        }
        if (this.samplingFrequencyIndex != ((AudioSpecificConfig)object).samplingFrequencyIndex) {
            return false;
        }
        if (this.sbrPresentFlag != ((AudioSpecificConfig)object).sbrPresentFlag) {
            return false;
        }
        if (this.syncExtensionType != ((AudioSpecificConfig)object).syncExtensionType) {
            return false;
        }
        if (this.var_ScalableFlag != ((AudioSpecificConfig)object).var_ScalableFlag) {
            return false;
        }
        if (Arrays.equals(this.configBytes, ((AudioSpecificConfig)object).configBytes)) return bl2;
        return false;
    }

    public int getAudioObjectType() {
        return this.audioObjectType;
    }

    public int getChannelConfiguration() {
        return this.channelConfiguration;
    }

    public byte[] getConfigBytes() {
        return this.configBytes;
    }

    public int getExtensionAudioObjectType() {
        return this.extensionAudioObjectType;
    }

    public int getPsPresentFlag() {
        return this.psPresentFlag;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getSamplingFrequency() {
        if (this.samplingFrequencyIndex != 15) return samplingFrequencyIndexMap.get(this.samplingFrequencyIndex);
        return this.samplingFrequency;
    }

    public int getSbrPresentFlag() {
        return this.sbrPresentFlag;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int hashCode() {
        int n2 = 1;
        int n3 = this.configBytes != null ? Arrays.hashCode(this.configBytes) : 0;
        int n4 = this.audioObjectType;
        int n5 = this.samplingFrequencyIndex;
        int n6 = this.samplingFrequency;
        int n7 = this.channelConfiguration;
        int n8 = this.extensionAudioObjectType;
        int n9 = this.sbrPresentFlag;
        int n10 = this.psPresentFlag;
        int n11 = this.extensionSamplingFrequencyIndex;
        int n12 = this.extensionSamplingFrequency;
        int n13 = this.extensionChannelConfiguration;
        int n14 = this.sacPayloadEmbedding;
        int n15 = this.fillBits;
        int n16 = this.epConfig;
        int n17 = this.directMapping;
        int n18 = this.syncExtensionType;
        int n19 = this.frameLengthFlag;
        int n20 = this.dependsOnCoreCoder;
        int n21 = this.coreCoderDelay;
        int n22 = this.extensionFlag;
        int n23 = this.layerNr;
        int n24 = this.numOfSubFrame;
        int n25 = this.layer_length;
        int n26 = this.aacSectionDataResilienceFlag;
        int n27 = this.aacScalefactorDataResilienceFlag;
        int n28 = this.aacSpectralDataResilienceFlag;
        int n29 = this.extensionFlag3;
        int n30 = this.gaSpecificConfig ? 1 : 0;
        int n31 = this.isBaseLayer;
        int n32 = this.paraMode;
        int n33 = this.paraExtensionFlag;
        int n34 = this.hvxcVarMode;
        int n35 = this.hvxcRateMode;
        int n36 = this.erHvxcExtensionFlag;
        int n37 = this.var_ScalableFlag;
        int n38 = this.hilnQuantMode;
        int n39 = this.hilnMaxNumLine;
        int n40 = this.hilnSampleRateCode;
        int n41 = this.hilnFrameLength;
        int n42 = this.hilnContMode;
        int n43 = this.hilnEnhaLayer;
        int n44 = this.hilnEnhaQuantMode;
        if (this.parametricSpecificConfig) {
            return (((((((((((((((n30 + ((((((((((((((((((((((((((n3 * 31 + n4) * 31 + n5) * 31 + n6) * 31 + n7) * 31 + n8) * 31 + n9) * 31 + n10) * 31 + n11) * 31 + n12) * 31 + n13) * 31 + n14) * 31 + n15) * 31 + n16) * 31 + n17) * 31 + n18) * 31 + n19) * 31 + n20) * 31 + n21) * 31 + n22) * 31 + n23) * 31 + n24) * 31 + n25) * 31 + n26) * 31 + n27) * 31 + n28) * 31 + n29) * 31) * 31 + n31) * 31 + n32) * 31 + n33) * 31 + n34) * 31 + n35) * 31 + n36) * 31 + n37) * 31 + n38) * 31 + n39) * 31 + n40) * 31 + n41) * 31 + n42) * 31 + n43) * 31 + n44) * 31 + n2;
        }
        n2 = 0;
        return (((((((((((((((n30 + ((((((((((((((((((((((((((n3 * 31 + n4) * 31 + n5) * 31 + n6) * 31 + n7) * 31 + n8) * 31 + n9) * 31 + n10) * 31 + n11) * 31 + n12) * 31 + n13) * 31 + n14) * 31 + n15) * 31 + n16) * 31 + n17) * 31 + n18) * 31 + n19) * 31 + n20) * 31 + n21) * 31 + n22) * 31 + n23) * 31 + n24) * 31 + n25) * 31 + n26) * 31 + n27) * 31 + n28) * 31 + n29) * 31) * 31 + n31) * 31 + n32) * 31 + n33) * 31 + n34) * 31 + n35) * 31 + n36) * 31 + n37) * 31 + n38) * 31 + n39) * 31 + n40) * 31 + n41) * 31 + n42) * 31 + n43) * 31 + n44) * 31 + n2;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    @Override
    public void parseDetail(ByteBuffer var1_1) throws IOException {
        var2_2 = var1_1.slice();
        var2_2.limit(this.sizeOfInstance);
        var1_1.position(var1_1.position() + this.sizeOfInstance);
        this.configBytes = new byte[this.sizeOfInstance];
        var2_2.get(this.configBytes);
        var2_2.rewind();
        var1_1 = new BitReaderBuffer(var2_2);
        this.audioObjectType = this.getAudioObjectType((BitReaderBuffer)var1_1);
        this.samplingFrequencyIndex = var1_1.readBits(4);
        if (this.samplingFrequencyIndex == 15) {
            this.samplingFrequency = var1_1.readBits(24);
        }
        this.channelConfiguration = var1_1.readBits(4);
        if (this.audioObjectType == 5 || this.audioObjectType == 29) {
            this.extensionAudioObjectType = 5;
            this.sbrPresentFlag = 1;
            if (this.audioObjectType == 29) {
                this.psPresentFlag = 1;
            }
            this.extensionSamplingFrequencyIndex = var1_1.readBits(4);
            if (this.extensionSamplingFrequencyIndex == 15) {
                this.extensionSamplingFrequency = var1_1.readBits(24);
            }
            this.audioObjectType = this.getAudioObjectType((BitReaderBuffer)var1_1);
            if (this.audioObjectType == 22) {
                this.extensionChannelConfiguration = var1_1.readBits(4);
            }
        } else {
            this.extensionAudioObjectType = 0;
        }
        switch (this.audioObjectType) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                this.parseGaSpecificConfig(this.samplingFrequencyIndex, this.channelConfiguration, this.audioObjectType, (BitReaderBuffer)var1_1);
                ** break;
            }
            case 8: {
                throw new UnsupportedOperationException("can't parse CelpSpecificConfig yet");
            }
            case 9: {
                throw new UnsupportedOperationException("can't parse HvxcSpecificConfig yet");
            }
            case 12: {
                throw new UnsupportedOperationException("can't parse TTSSpecificConfig yet");
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                throw new UnsupportedOperationException("can't parse StructuredAudioSpecificConfig yet");
            }
            case 24: {
                throw new UnsupportedOperationException("can't parse ErrorResilientCelpSpecificConfig yet");
            }
            case 25: {
                throw new UnsupportedOperationException("can't parse ErrorResilientHvxcSpecificConfig yet");
            }
            case 26: 
            case 27: {
                this.parseParametricSpecificConfig(this.samplingFrequencyIndex, this.channelConfiguration, this.audioObjectType, (BitReaderBuffer)var1_1);
            }
lbl48:
            // 3 sources

            default: {
                switch (this.audioObjectType) {
                    case 17: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 39: {
                        this.epConfig = var1_1.readBits(2);
                        if (this.epConfig == 2 || this.epConfig == 3) {
                            throw new UnsupportedOperationException("can't parse ErrorProtectionSpecificConfig yet");
                        }
                        if (this.epConfig != 3) break;
                        this.directMapping = var1_1.readBits(1);
                        if (this.directMapping != 0) break;
                        throw new RuntimeException("not implemented");
                    }
                }
                if (this.extensionAudioObjectType != 5 && var1_1.remainingBits() >= 16) {
                    this.syncExtensionType = var1_1.readBits(11);
                    if (this.syncExtensionType == 695) {
                        this.extensionAudioObjectType = this.getAudioObjectType((BitReaderBuffer)var1_1);
                        if (this.extensionAudioObjectType == 5) {
                            this.sbrPresentFlag = var1_1.readBits(1);
                            if (this.sbrPresentFlag == 1) {
                                this.extensionSamplingFrequencyIndex = var1_1.readBits(4);
                                if (this.extensionSamplingFrequencyIndex == 15) {
                                    this.extensionSamplingFrequency = var1_1.readBits(24);
                                }
                                if (var1_1.remainingBits() >= 12) {
                                    this.syncExtensionType = var1_1.readBits(11);
                                    if (this.syncExtensionType == 1352) {
                                        this.psPresentFlag = var1_1.readBits(1);
                                    }
                                }
                            }
                        }
                        if (this.extensionAudioObjectType == 22) {
                            this.sbrPresentFlag = var1_1.readBits(1);
                            if (this.sbrPresentFlag == 1) {
                                this.extensionSamplingFrequencyIndex = var1_1.readBits(4);
                                if (this.extensionSamplingFrequencyIndex == 15) {
                                    this.extensionSamplingFrequency = var1_1.readBits(24);
                                }
                            }
                            this.extensionChannelConfiguration = var1_1.readBits(4);
                        }
                    }
                }
                return;
            }
            case 28: {
                throw new UnsupportedOperationException("can't parse SSCSpecificConfig yet");
            }
            case 30: {
                this.sacPayloadEmbedding = var1_1.readBits(1);
                throw new UnsupportedOperationException("can't parse SpatialSpecificConfig yet");
            }
            case 32: 
            case 33: 
            case 34: {
                throw new UnsupportedOperationException("can't parse MPEG_1_2_SpecificConfig yet");
            }
            case 35: {
                throw new UnsupportedOperationException("can't parse DSTSpecificConfig yet");
            }
            case 36: {
                this.fillBits = var1_1.readBits(5);
                throw new UnsupportedOperationException("can't parse ALSSpecificConfig yet");
            }
            case 37: 
            case 38: {
                throw new UnsupportedOperationException("can't parse SLSSpecificConfig yet");
            }
            case 39: {
                throw new UnsupportedOperationException("can't parse ELDSpecificConfig yet");
            }
            case 40: 
            case 41: 
        }
        throw new UnsupportedOperationException("can't parse SymbolicMusicSpecificConfig yet");
    }

    public ByteBuffer serialize() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(this.serializedSize());
        IsoTypeWriter.writeUInt8((ByteBuffer)byteBuffer, (int)5);
        IsoTypeWriter.writeUInt8((ByteBuffer)byteBuffer, (int)(this.serializedSize() - 2));
        BitWriterBuffer bitWriterBuffer = new BitWriterBuffer(byteBuffer);
        bitWriterBuffer.writeBits(this.audioObjectType, 5);
        bitWriterBuffer.writeBits(this.samplingFrequencyIndex, 4);
        if (this.samplingFrequencyIndex == 15) {
            throw new UnsupportedOperationException("can't serialize that yet");
        }
        bitWriterBuffer.writeBits(this.channelConfiguration, 4);
        return byteBuffer;
    }

    public int serializedSize() {
        if (this.audioObjectType == 2) {
            return 4 + this.gaSpecificConfigSize();
        }
        throw new UnsupportedOperationException("can't serialize that yet");
    }

    public void setAudioObjectType(int n2) {
        this.audioObjectType = n2;
    }

    public void setChannelConfiguration(int n2) {
        this.channelConfiguration = n2;
    }

    public void setSamplingFrequency(int n2) {
        this.samplingFrequency = n2;
    }

    public void setSamplingFrequencyIndex(int n2) {
        this.samplingFrequencyIndex = n2;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("AudioSpecificConfig");
        stringBuilder.append("{configBytes=").append(Hex.encodeHex((byte[])this.configBytes));
        stringBuilder.append(", audioObjectType=").append(this.audioObjectType).append(" (").append(audioObjectTypeMap.get(this.audioObjectType)).append(")");
        stringBuilder.append(", samplingFrequencyIndex=").append(this.samplingFrequencyIndex).append(" (").append(samplingFrequencyIndexMap.get(this.samplingFrequencyIndex)).append(")");
        stringBuilder.append(", samplingFrequency=").append(this.samplingFrequency);
        stringBuilder.append(", channelConfiguration=").append(this.channelConfiguration);
        if (this.extensionAudioObjectType > 0) {
            stringBuilder.append(", extensionAudioObjectType=").append(this.extensionAudioObjectType).append(" (").append(audioObjectTypeMap.get(this.extensionAudioObjectType)).append(")");
            stringBuilder.append(", sbrPresentFlag=").append(this.sbrPresentFlag);
            stringBuilder.append(", psPresentFlag=").append(this.psPresentFlag);
            stringBuilder.append(", extensionSamplingFrequencyIndex=").append(this.extensionSamplingFrequencyIndex).append(" (").append(samplingFrequencyIndexMap.get(this.extensionSamplingFrequencyIndex)).append(")");
            stringBuilder.append(", extensionSamplingFrequency=").append(this.extensionSamplingFrequency);
            stringBuilder.append(", extensionChannelConfiguration=").append(this.extensionChannelConfiguration);
        }
        stringBuilder.append(", syncExtensionType=").append(this.syncExtensionType);
        if (this.gaSpecificConfig) {
            stringBuilder.append(", frameLengthFlag=").append(this.frameLengthFlag);
            stringBuilder.append(", dependsOnCoreCoder=").append(this.dependsOnCoreCoder);
            stringBuilder.append(", coreCoderDelay=").append(this.coreCoderDelay);
            stringBuilder.append(", extensionFlag=").append(this.extensionFlag);
            stringBuilder.append(", layerNr=").append(this.layerNr);
            stringBuilder.append(", numOfSubFrame=").append(this.numOfSubFrame);
            stringBuilder.append(", layer_length=").append(this.layer_length);
            stringBuilder.append(", aacSectionDataResilienceFlag=").append(this.aacSectionDataResilienceFlag);
            stringBuilder.append(", aacScalefactorDataResilienceFlag=").append(this.aacScalefactorDataResilienceFlag);
            stringBuilder.append(", aacSpectralDataResilienceFlag=").append(this.aacSpectralDataResilienceFlag);
            stringBuilder.append(", extensionFlag3=").append(this.extensionFlag3);
        }
        if (this.parametricSpecificConfig) {
            stringBuilder.append(", isBaseLayer=").append(this.isBaseLayer);
            stringBuilder.append(", paraMode=").append(this.paraMode);
            stringBuilder.append(", paraExtensionFlag=").append(this.paraExtensionFlag);
            stringBuilder.append(", hvxcVarMode=").append(this.hvxcVarMode);
            stringBuilder.append(", hvxcRateMode=").append(this.hvxcRateMode);
            stringBuilder.append(", erHvxcExtensionFlag=").append(this.erHvxcExtensionFlag);
            stringBuilder.append(", var_ScalableFlag=").append(this.var_ScalableFlag);
            stringBuilder.append(", hilnQuantMode=").append(this.hilnQuantMode);
            stringBuilder.append(", hilnMaxNumLine=").append(this.hilnMaxNumLine);
            stringBuilder.append(", hilnSampleRateCode=").append(this.hilnSampleRateCode);
            stringBuilder.append(", hilnFrameLength=").append(this.hilnFrameLength);
            stringBuilder.append(", hilnContMode=").append(this.hilnContMode);
            stringBuilder.append(", hilnEnhaLayer=").append(this.hilnEnhaLayer);
            stringBuilder.append(", hilnEnhaQuantMode=").append(this.hilnEnhaQuantMode);
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

