/*
 * Decompiled with CFR 0.152.
 */
package com.megvii.livenessdetection;

import com.megvii.livenessdetection.DetectionFrame;
import com.megvii.livenessdetection.a.b;
import java.util.LinkedList;
import java.util.List;

public class FaceQualityManager {
    private float a = 0.5f;
    private float b = 0.5f;
    private int c = 0;
    public float faceMaxSizeRatioThreshold = 0.4f;
    public float faceWidthThreshold = 150.0f;
    public float gaussianBlurThreshold = 0.15f;
    public float integrityThreshold = 0.99f;
    public float maxBrightnessThreshold = 230.0f;
    public float minBrightnessThreshold = 70.0f;
    public float motionBlurThreshold = 0.2f;
    public int needHolding = 3;
    public float pitchThreshold = 0.17f;
    public float yawThreshold = 0.17f;

    public FaceQualityManager(float f2, float f3) {
        this.a = f2;
        this.b = f3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<FaceQualityErrorType> feedFrame(DetectionFrame linkedList) {
        synchronized (this) {
            LinkedList<FaceQualityErrorType> linkedList2 = new LinkedList<FaceQualityErrorType>();
            if (linkedList == null) {
                linkedList = new LinkedList<FaceQualityErrorType>("detectionFrame could not be null");
                throw linkedList;
            }
            int n2 = ((DetectionFrame)((Object)linkedList)).getRotation() % 180 == 0 ? ((DetectionFrame)((Object)linkedList)).getImageWidth() : ((DetectionFrame)((Object)linkedList)).getImageHeight();
            int n3 = ((DetectionFrame)((Object)linkedList)).getRotation() % 180 == 0 ? ((DetectionFrame)((Object)linkedList)).getImageHeight() : ((DetectionFrame)((Object)linkedList)).getImageWidth();
            b b2 = ((DetectionFrame)((Object)linkedList)).getFaceInfo();
            if (b2 == null) {
                linkedList2.add(FaceQualityErrorType.FACE_NOT_FOUND);
            } else {
                linkedList = ((DetectionFrame)((Object)linkedList)).getFacePos();
                float f2 = linkedList.centerX();
                float f3 = linkedList.centerY();
                float f4 = this.a;
                double d2 = Math.pow((float)n2 * (f2 - f4), 2.0);
                f4 = this.b;
                if ((float)Math.sqrt(Math.pow((float)n3 * (f3 - f4), 2.0) + d2) / (float)b2.a.width() > 0.5f) {
                    linkedList2.add(FaceQualityErrorType.FACE_OUT_OF_RECT);
                }
                if (Math.abs(b2.c) > this.yawThreshold || Math.abs(b2.d) > this.pitchThreshold) {
                    linkedList2.add(FaceQualityErrorType.FACE_POS_DEVIATED);
                }
                if (b2.m < this.integrityThreshold) {
                    linkedList2.add(FaceQualityErrorType.FACE_NONINTEGRITY);
                }
                if (b2.g < this.minBrightnessThreshold) {
                    linkedList2.add(FaceQualityErrorType.FACE_TOO_DARK);
                }
                if (b2.g > this.maxBrightnessThreshold) {
                    linkedList2.add(FaceQualityErrorType.FACE_TOO_BRIGHT);
                }
                if ((float)b2.a.width() < this.faceWidthThreshold) {
                    linkedList2.add(FaceQualityErrorType.FACE_TOO_SMALL);
                }
                if (linkedList.width() > this.faceMaxSizeRatioThreshold) {
                    linkedList2.add(FaceQualityErrorType.FACE_TOO_LARGE);
                }
                if (b2.f > this.motionBlurThreshold || b2.e > this.gaussianBlurThreshold) {
                    linkedList2.add(FaceQualityErrorType.FACE_TOO_BLURRY);
                }
                if (b2.x > 0.5f || b2.y > 0.5f) {
                    linkedList2.add(FaceQualityErrorType.FACE_EYE_OCCLUSIVE);
                }
                if (b2.z > 0.5f) {
                    linkedList2.add(FaceQualityErrorType.FACE_MOUTH_OCCLUSIVE);
                }
            }
            if (linkedList2.size() == 0) {
                n2 = this.c;
                this.c = n2 + 1;
                if (n2 >= this.needHolding) return new LinkedList<FaceQualityErrorType>(linkedList2);
                linkedList2.add(FaceQualityErrorType.FRAME_NEED_HOLDING);
                return new LinkedList<FaceQualityErrorType>(linkedList2);
            } else {
                this.c = 0;
            }
            return new LinkedList<FaceQualityErrorType>(linkedList2);
        }
    }

    public static enum FaceQualityErrorType {
        NONE,
        FRAME_NEED_HOLDING,
        FACE_NOT_FOUND,
        FACE_POS_DEVIATED,
        FACE_NONINTEGRITY,
        FACE_TOO_DARK,
        FACE_TOO_BRIGHT,
        FACE_TOO_SMALL,
        FACE_TOO_LARGE,
        FACE_TOO_BLURRY,
        FACE_OUT_OF_RECT,
        FACE_EYE_OCCLUSIVE,
        FACE_MOUTH_OCCLUSIVE;

    }
}

