/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp;

import com.squareup.okhttp.Authenticator;
import com.squareup.okhttp.CertificatePinner;
import com.squareup.okhttp.ConnectionSpec;
import com.squareup.okhttp.Dns;
import com.squareup.okhttp.HttpUrl;
import com.squareup.okhttp.Protocol;
import com.squareup.okhttp.internal.Util;
import java.net.Proxy;
import java.net.ProxySelector;
import java.util.List;
import javax.net.SocketFactory;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;

public final class Address {
    final Authenticator authenticator;
    final CertificatePinner certificatePinner;
    final List<ConnectionSpec> connectionSpecs;
    final Dns dns;
    final HostnameVerifier hostnameVerifier;
    final List<Protocol> protocols;
    final Proxy proxy;
    final ProxySelector proxySelector;
    final SocketFactory socketFactory;
    final SSLSocketFactory sslSocketFactory;
    final HttpUrl url;

    /*
     * Enabled aggressive block sorting
     */
    public Address(String string2, int n2, Dns dns, SocketFactory socketFactory, SSLSocketFactory sSLSocketFactory, HostnameVerifier hostnameVerifier, CertificatePinner certificatePinner, Authenticator authenticator, Proxy proxy, List<Protocol> list, List<ConnectionSpec> list2, ProxySelector proxySelector) {
        HttpUrl.Builder builder = new HttpUrl.Builder();
        String string3 = sSLSocketFactory != null ? "https" : "http";
        this.url = builder.scheme(string3).host(string2).port(n2).build();
        if (dns == null) {
            throw new IllegalArgumentException("dns == null");
        }
        this.dns = dns;
        if (socketFactory == null) {
            throw new IllegalArgumentException("socketFactory == null");
        }
        this.socketFactory = socketFactory;
        if (authenticator == null) {
            throw new IllegalArgumentException("authenticator == null");
        }
        this.authenticator = authenticator;
        if (list == null) {
            throw new IllegalArgumentException("protocols == null");
        }
        this.protocols = Util.immutableList(list);
        if (list2 == null) {
            throw new IllegalArgumentException("connectionSpecs == null");
        }
        this.connectionSpecs = Util.immutableList(list2);
        if (proxySelector == null) {
            throw new IllegalArgumentException("proxySelector == null");
        }
        this.proxySelector = proxySelector;
        this.proxy = proxy;
        this.sslSocketFactory = sSLSocketFactory;
        this.hostnameVerifier = hostnameVerifier;
        this.certificatePinner = certificatePinner;
    }

    public boolean equals(Object object) {
        boolean bl2;
        boolean bl3 = bl2 = false;
        if (object instanceof Address) {
            object = (Address)object;
            bl3 = bl2;
            if (this.url.equals((Object)((Address)object).url)) {
                bl3 = bl2;
                if (this.dns.equals(((Address)object).dns)) {
                    bl3 = bl2;
                    if (this.authenticator.equals(((Address)object).authenticator)) {
                        bl3 = bl2;
                        if (this.protocols.equals(((Address)object).protocols)) {
                            bl3 = bl2;
                            if (this.connectionSpecs.equals(((Address)object).connectionSpecs)) {
                                bl3 = bl2;
                                if (this.proxySelector.equals(((Address)object).proxySelector)) {
                                    bl3 = bl2;
                                    if (Util.equal((Object)this.proxy, (Object)((Address)object).proxy)) {
                                        bl3 = bl2;
                                        if (Util.equal((Object)this.sslSocketFactory, (Object)((Address)object).sslSocketFactory)) {
                                            bl3 = bl2;
                                            if (Util.equal((Object)this.hostnameVerifier, (Object)((Address)object).hostnameVerifier)) {
                                                bl3 = bl2;
                                                if (Util.equal((Object)this.certificatePinner, (Object)((Address)object).certificatePinner)) {
                                                    bl3 = true;
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return bl3;
    }

    public Authenticator getAuthenticator() {
        return this.authenticator;
    }

    public CertificatePinner getCertificatePinner() {
        return this.certificatePinner;
    }

    public List<ConnectionSpec> getConnectionSpecs() {
        return this.connectionSpecs;
    }

    public Dns getDns() {
        return this.dns;
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public List<Protocol> getProtocols() {
        return this.protocols;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public ProxySelector getProxySelector() {
        return this.proxySelector;
    }

    public SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    public SSLSocketFactory getSslSocketFactory() {
        return this.sslSocketFactory;
    }

    @Deprecated
    public String getUriHost() {
        return this.url.host();
    }

    @Deprecated
    public int getUriPort() {
        return this.url.port();
    }

    /*
     * Enabled aggressive block sorting
     */
    public int hashCode() {
        int n2 = 0;
        int n3 = this.url.hashCode();
        int n4 = this.dns.hashCode();
        int n5 = this.authenticator.hashCode();
        int n6 = this.protocols.hashCode();
        int n7 = this.connectionSpecs.hashCode();
        int n8 = this.proxySelector.hashCode();
        int n9 = this.proxy != null ? this.proxy.hashCode() : 0;
        int n10 = this.sslSocketFactory != null ? this.sslSocketFactory.hashCode() : 0;
        int n11 = this.hostnameVerifier != null ? this.hostnameVerifier.hashCode() : 0;
        if (this.certificatePinner != null) {
            n2 = this.certificatePinner.hashCode();
        }
        return (n11 + (n10 + (n9 + ((((((n3 + 527) * 31 + n4) * 31 + n5) * 31 + n6) * 31 + n7) * 31 + n8) * 31) * 31) * 31) * 31 + n2;
    }

    public HttpUrl url() {
        return this.url;
    }
}

