/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.mm.opensdk.modelmsg;

import android.os.Bundle;
import com.tencent.mm.opensdk.modelmsg.WXMediaMessage;
import com.tencent.mm.opensdk.utils.Log;
import java.io.File;

public class WXAppExtendObject
implements WXMediaMessage.IMediaObject {
    private static final int CONTENT_LENGTH_LIMIT = 0xA00000;
    private static final int EXTINFO_LENGTH_LIMIT = 2048;
    private static final int PATH_LENGTH_LIMIT = 10240;
    private static final String TAG = "MicroMsg.SDK.WXAppExtendObject";
    public String extInfo;
    public byte[] fileData;
    public String filePath;

    public WXAppExtendObject() {
    }

    public WXAppExtendObject(String string2, String string3) {
        this.extInfo = string2;
        this.filePath = string3;
    }

    public WXAppExtendObject(String string2, byte[] byArray) {
        this.extInfo = string2;
        this.fileData = byArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getFileSize(String object) {
        int n2;
        int n3 = n2 = 0;
        if (object == null) return n3;
        if (((String)object).length() == 0) {
            return n2;
        }
        object = new File((String)object);
        n3 = n2;
        if (!((File)object).exists()) return n3;
        return (int)((File)object).length();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean checkArgs() {
        boolean bl2 = false;
        if (!(this.extInfo != null && this.extInfo.length() != 0 || this.filePath != null && this.filePath.length() != 0 || this.fileData != null && this.fileData.length != 0)) {
            Log.e((String)TAG, (String)"checkArgs fail, all arguments is null");
            return bl2;
        }
        if (this.extInfo != null && this.extInfo.length() > 2048) {
            Log.e((String)TAG, (String)"checkArgs fail, extInfo is invalid");
            return bl2;
        }
        if (this.filePath != null && this.filePath.length() > 10240) {
            Log.e((String)TAG, (String)"checkArgs fail, filePath is invalid");
            return bl2;
        }
        if (this.filePath != null && this.getFileSize(this.filePath) > 0xA00000) {
            Log.e((String)TAG, (String)"checkArgs fail, fileSize is too large");
            return bl2;
        }
        if (this.fileData == null) return true;
        if (this.fileData.length <= 0xA00000) return true;
        Log.e((String)TAG, (String)"checkArgs fail, fileData is too large");
        return bl2;
    }

    @Override
    public void serialize(Bundle bundle) {
        bundle.putString("_wxappextendobject_extInfo", this.extInfo);
        bundle.putByteArray("_wxappextendobject_fileData", this.fileData);
        bundle.putString("_wxappextendobject_filePath", this.filePath);
    }

    @Override
    public int type() {
        return 7;
    }

    @Override
    public void unserialize(Bundle bundle) {
        this.extInfo = bundle.getString("_wxappextendobject_extInfo");
        this.fileData = bundle.getByteArray("_wxappextendobject_fileData");
        this.filePath = bundle.getString("_wxappextendobject_filePath");
    }
}

