/*
 * Decompiled with CFR 0.152.
 */
package com.wuba.android.wrtckit.controller;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Parcelable;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.TextView;
import com.android.gmacs.dragback.ParallaxBackActivityHelper;
import com.android.gmacs.logic.CommandLogic;
import com.android.gmacs.sound.SoundPlayer;
import com.android.gmacs.view.GmacsDialog;
import com.common.gmacs.core.CommandManager;
import com.common.gmacs.core.Gmacs;
import com.common.gmacs.core.MessageManager;
import com.common.gmacs.msg.data.IMCallMsg;
import com.common.gmacs.parse.command.CallCommand;
import com.common.gmacs.parse.contact.GmacsUser;
import com.common.gmacs.parse.message.Message;
import com.common.gmacs.utils.GLog;
import com.common.gmacs.utils.GmacsEnvi;
import com.common.gmacs.utils.GmacsUtils;
import com.common.gmacs.utils.NetworkUtil;
import com.wuba.android.wrtckit.R;
import com.wuba.android.wrtckit.WRTCRoomActivity;
import com.wuba.android.wrtckit.controller.WRTCManager;
import com.wuba.android.wrtckit.model.State;
import com.wuba.wrtc.api.OnEnterRoomCallback;
import com.wuba.wrtc.api.OnLoggingCallback;
import com.wuba.wrtc.api.OnRequestRoomCallback;
import com.wuba.wrtc.api.WRTCContext;
import java.util.HashMap;
import java.util.Map;
import org.wrtc.SurfaceViewRenderer;

public class WRTCManager
implements CommandLogic.WRTCProxy,
CommandManager.OnStartCallCb,
WRTCContext.WRTCStatusCallback {
    private static final int CHAT_TIME_COUNT = 31;
    private static final String TAG = WRTCManager.class.getSimpleName();
    private static volatile WRTCManager instance;
    private int chatTimeInSeconds;
    private volatile State mCurrentState;
    private int mRequestRoomCount;
    private StateSubscriber mStateSubscriber;
    private TimeCountHandler mTimeCountHandler;

    private WRTCManager() {
    }

    static /* synthetic */ State access$000(WRTCManager wRTCManager) {
        return wRTCManager.mCurrentState;
    }

    static /* synthetic */ void access$100(WRTCManager wRTCManager) {
        wRTCManager.notifyWRTCFinalState();
    }

    static /* synthetic */ void access$200(WRTCManager wRTCManager) {
        wRTCManager.joinToRoom();
    }

    static /* synthetic */ int access$300(WRTCManager wRTCManager) {
        return wRTCManager.mRequestRoomCount;
    }

    static /* synthetic */ int access$308(WRTCManager wRTCManager) {
        int n2 = wRTCManager.mRequestRoomCount;
        wRTCManager.mRequestRoomCount = n2 + 1;
        return n2;
    }

    static /* synthetic */ StateSubscriber access$400(WRTCManager wRTCManager) {
        return wRTCManager.mStateSubscriber;
    }

    static /* synthetic */ int access$500(WRTCManager wRTCManager) {
        return wRTCManager.chatTimeInSeconds;
    }

    static /* synthetic */ int access$508(WRTCManager wRTCManager) {
        int n2 = wRTCManager.chatTimeInSeconds;
        wRTCManager.chatTimeInSeconds = n2 + 1;
        return n2;
    }

    private void busy(String string2) {
        WRTCContext.getInstance().busy(string2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static WRTCManager getInstance() {
        if (instance == null) {
            synchronized (WRTCManager.class) {
                if (instance == null) {
                    WRTCManager wRTCManager;
                    instance = wRTCManager = new WRTCManager();
                }
            }
        }
        return instance;
    }

    private void initState(boolean bl2, CallCommand callCommand) {
        this.mCurrentState = new State();
        this.mRequestRoomCount = 0;
        this.mCurrentState.callCommand = callCommand;
        this.mCurrentState.isVideoCall = "video".equals(callCommand.callType);
        this.mCurrentState.isInitiator = bl2;
        this.mCurrentState.isSelfAction = bl2;
        this.mCurrentState.status = 6;
        this.mTimeCountHandler = new /* Unavailable Anonymous Inner Class!! */;
    }

    private void joinToRoom() {
        WRTCContext.getInstance().joinToRoom(true, (OnEnterRoomCallback)new 6(this));
    }

    private void notifyWRTCFinalState() {
        synchronized (this) {
            this.mTimeCountHandler.removeMessages(31);
            this.mCurrentState.durationInSeconds = this.chatTimeInSeconds;
            this.chatTimeInSeconds = 0;
            this.onWRTCFinalState(this.mCurrentState);
            this.mStateSubscriber = null;
            this.mCurrentState = null;
            this.mTimeCountHandler = null;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void onWRTCFinalState(State state) {
        int n2;
        Object object;
        boolean bl2;
        boolean bl3;
        Object object2;
        IMCallMsg iMCallMsg = new IMCallMsg();
        iMCallMsg.durationInSeconds = state.durationInSeconds;
        int n3 = state.isVideoCall ? 1 : 0;
        iMCallMsg.callType = n3;
        iMCallMsg.finalState = state.status <= 5 ? state.status : (iMCallMsg.durationInSeconds == 0 ? 0 : 3);
        Object object3 = state.callCommand;
        Object object4 = new Message.MessageUserInfo();
        ((Message.MessageUserInfo)object4).mUserId = ((CallCommand)object3).getOtherId();
        ((Message.MessageUserInfo)object4).mUserSource = ((CallCommand)object3).getOtherSource();
        ((Message.MessageUserInfo)object4).mTalkType = Gmacs.TalkType.TALKETYPE_NORMAL.getValue();
        7 var6_6 = new 7(this);
        if (state.isInitiator) {
            object2 = Message.MessageUserInfo.createLoginUserInfo();
            bl3 = true;
            bl2 = true;
            object = object4;
        } else {
            object = Message.MessageUserInfo.createLoginUserInfo();
            if (iMCallMsg.finalState == 0) {
                bl3 = false;
                bl2 = false;
                object2 = object4;
            } else {
                bl3 = true;
                bl2 = true;
                object2 = object4;
            }
        }
        MessageManager.getInstance().insertLocalMessage(((Message.MessageUserInfo)object4).mTalkType, (Message.MessageUserInfo)object2, (Message.MessageUserInfo)object, "", iMCallMsg, false, bl2, bl3, (MessageManager.InsertLocalMessageCb)var6_6);
        if (state.isInitiator) {
            object2 = GmacsUser.getInstance().getUserId();
            n2 = GmacsUser.getInstance().getSource();
            object4 = ((CallCommand)object3).otherId;
            n3 = ((CallCommand)object3).otherSource;
        } else {
            object2 = ((CallCommand)object3).otherId;
            n2 = ((CallCommand)object3).otherSource;
            object4 = GmacsUser.getInstance().getUserId();
            n3 = GmacsUser.getInstance().getSource();
        }
        iMCallMsg = CommandManager.getInstance();
        object3 = ((CallCommand)object3).roomId;
        long l2 = state.durationInSeconds;
        int n4 = state.statusCode;
        object = state.isVideoCall ? "video" : "audio";
        iMCallMsg.uploadCallState((String)object2, n2, (String)object4, n3, (String)object3, l2, "", n4, (String)object, state.wmdaData);
    }

    private void resetRoomWith(String string2) {
        WRTCContext.getInstance().resetRoomWith(string2);
    }

    private void setVideoResolution(int n2, int n3) {
        WRTCContext.getInstance().setVideoResolution(n2, n3);
    }

    public void accept() {
        if (this.mCurrentState != null) {
            this.mCurrentState.isSelfAction = true;
            WRTCContext.getInstance().accept();
        }
    }

    public void audioAccept() {
        if (this.mCurrentState != null) {
            this.mCurrentState.isVideoCall = false;
            this.mCurrentState.isSelfAction = true;
            WRTCContext.getInstance().audioAccept();
        }
    }

    public void cancel() {
        if (this.mCurrentState != null) {
            WRTCContext.getInstance().cancel();
            this.mCurrentState.status = 0;
            this.mCurrentState.statusCode = 201;
            this.mCurrentState.isSelfAction = true;
            if (this.mStateSubscriber != null) {
                this.mStateSubscriber.onFinishedWithState(this.mCurrentState);
            }
            this.notifyWRTCFinalState();
        }
    }

    public void changeRender(SurfaceViewRenderer surfaceViewRenderer, SurfaceViewRenderer surfaceViewRenderer2) {
        WRTCContext.getInstance().changeRender(surfaceViewRenderer, surfaceViewRenderer2);
    }

    public void doOnHasPermission() {
        WRTCContext.getInstance().enableOnConnectedToRoomInternal();
    }

    @Override
    public void finishCall() {
        this.hangup();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int getChattingType() {
        if (this.mCurrentState == null) return -1;
        if (!this.mCurrentState.isVideoCall) return 0;
        return 1;
    }

    public State getCurrentState() {
        return this.mCurrentState;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void hangup() {
        if (this.mCurrentState != null) {
            WRTCContext.getInstance().hangup();
            this.mCurrentState.status = 3;
            this.mCurrentState.statusCode = this.mCurrentState.isInitiator ? 203 : 204;
            this.mCurrentState.isSelfAction = true;
            if (this.mStateSubscriber != null) {
                this.mStateSubscriber.onFinishedWithState(this.mCurrentState);
            }
            this.notifyWRTCFinalState();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void init(String string2, String string3, String string4, String string5, int n2, String string6, Context object) {
        int n3 = 0;
        WRTCContext.setContext((Context)object);
        int n4 = n3;
        switch (Gmacs.getInstance().getServerEnvi()) {
            default: {
                n4 = n3;
                break;
            }
            case 4: {
                n4 = 1;
            }
            case 0: 
            case 3: {
                break;
            }
            case 1: 
            case 2: {
                n4 = 2;
            }
        }
        WRTCContext.setRelease((int)n4);
        WRTCContext.getInstance().setLoggingListener((OnLoggingCallback)new 1(this));
        CommandLogic.getInstance().setWRTCProxy(this);
        WRTCContext.getInstance().setWRTCCallback((WRTCContext.WRTCStatusCallback)this);
        object = new HashMap();
        ((HashMap)object).put("im_appid", string2);
        ((HashMap)object).put("client_type", string3);
        ((HashMap)object).put("im_token", string4);
        ((HashMap)object).put("userid", string5);
        ((HashMap)object).put("source", String.valueOf(n2));
        ((HashMap)object).put("deviceid", string6);
        WRTCContext.initWithUserInfo((Map)object);
    }

    public void initVideoEnable(boolean bl2) {
        if (this.mCurrentState != null) {
            WRTCContext.getInstance().initVideoEnable(bl2);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onAudioModeStatus(int n2) {
        switch (n2) {
            default: {
                n2 = 0;
                break;
            }
            case 3001: {
                n2 = 1;
                break;
            }
            case 3002: {
                n2 = 2;
                break;
            }
            case 3003: {
                n2 = 3;
            }
        }
        if (this.mStateSubscriber != null) {
            this.mStateSubscriber.onAudioModeChanged(n2);
        }
        if (this.mCurrentState != null) {
            this.mCurrentState.audioMode = n2;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onCallConnected(boolean bl2) {
        GLog.e(TAG, "onCallConnected:" + bl2);
        if (!bl2) return;
        if (this.mCurrentState == null) return;
        if (this.mCurrentState.status == 6) {
            this.mCurrentState.status = 8;
            GLog.e(TAG, "STATUS_P2P_WAITING_MSG");
            return;
        }
        if (this.mCurrentState.status != 7) return;
        this.mCurrentState.status = 9;
        this.mTimeCountHandler.removeMessages(31);
        this.mTimeCountHandler.sendEmptyMessage(31);
        switch (this.mCurrentState.connectMsg) {
            default: {
                return;
            }
            case 1: {
                if (this.mStateSubscriber == null) return;
                if (this.mCurrentState.isVideoCall) {
                    this.mStateSubscriber.onVideoConnected();
                    return;
                }
                this.mStateSubscriber.onAudioConnected();
                return;
            }
            case 2: {
                if (this.mStateSubscriber == null) return;
                this.mStateSubscriber.onVideoConnected();
                return;
            }
            case 3: 
        }
        if (this.mCurrentState.isVideoCall) {
            this.mCurrentState.isSelfAction = false;
            this.mCurrentState.isVideoCall = false;
            if (this.mStateSubscriber == null) return;
            this.mStateSubscriber.onVideoInvitingSwitchToAudioConnectedRemote();
            return;
        }
        if (this.mStateSubscriber == null) return;
        this.mStateSubscriber.onAudioConnected();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onNetworkAndFrameRateStats(int n2) {
        switch (n2) {
            case 4001: {
                if (this.mCurrentState != null) {
                    this.mCurrentState.networkStatus = 0;
                }
            }
            default: {
                break;
            }
            case 4002: {
                if (this.mCurrentState == null) break;
                this.mCurrentState.networkStatus = 1;
            }
        }
        if (this.mStateSubscriber != null && this.mCurrentState != null) {
            this.mStateSubscriber.onNetworkStats(this.mCurrentState.networkStatus);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void onReceivedCall(CallCommand callCommand) {
        if (this.mCurrentState == null) {
            this.initState(false, callCommand);
            WRTCManager.getInstance().resetRoomWith(callCommand.roomId);
            WRTCContext.getInstance().joinToRoom(false, (OnEnterRoomCallback)new 3(this, callCommand));
            return;
        }
        WRTCManager.getInstance().busy(callCommand.roomId);
        State state = new State();
        state.callCommand = callCommand;
        state.isInitiator = false;
        state.isVideoCall = "video".equals(callCommand.callType);
        state.isSelfAction = false;
        state.status = 0;
        this.onWRTCFinalState(state);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onRoomStatus(int n2) {
        GLog.e(TAG, n2 + "");
        if (this.mCurrentState == null) return;
        this.mCurrentState.statusCode = n2;
        switch (n2) {
            case 203: {
                GLog.d(TAG, "onRoomStatus:" + n2 + ":STATUS_CALLER_HANGUP");
                if (this.mCurrentState.isInitiator) return;
                this.mCurrentState.status = 3;
                this.mCurrentState.isSelfAction = false;
                if (this.mStateSubscriber != null) {
                    this.mStateSubscriber.onFinishedWithState(this.mCurrentState);
                }
                this.notifyWRTCFinalState();
                return;
            }
            case 204: {
                GLog.d(TAG, "onRoomStatus:" + n2 + ":STATUS_CALLEE_HANGUP");
                if (!this.mCurrentState.isInitiator) return;
                this.mCurrentState.status = 3;
                this.mCurrentState.isSelfAction = false;
                if (this.mStateSubscriber != null) {
                    this.mStateSubscriber.onFinishedWithState(this.mCurrentState);
                }
                this.notifyWRTCFinalState();
                return;
            }
            case 202: {
                if (!this.mCurrentState.isInitiator) return;
                this.mCurrentState.status = 1;
                this.mCurrentState.isSelfAction = false;
                if (this.mStateSubscriber != null) {
                    this.mStateSubscriber.onFinishedWithState(this.mCurrentState);
                }
                this.notifyWRTCFinalState();
                return;
            }
            case 201: {
                if (this.mCurrentState.isInitiator) return;
                this.mCurrentState.status = 0;
                this.mCurrentState.isSelfAction = false;
                if (this.mStateSubscriber != null) {
                    this.mStateSubscriber.onFinishedWithState(this.mCurrentState);
                }
                this.notifyWRTCFinalState();
                return;
            }
            case 207: {
                this.mCurrentState.status = this.mCurrentState.isInitiator ? 2 : 0;
                if (this.mStateSubscriber != null) {
                    this.mStateSubscriber.onFinishedWithState(this.mCurrentState);
                }
                this.notifyWRTCFinalState();
                return;
            }
            case 208: {
                this.mCurrentState.status = 4;
                this.mCurrentState.isSelfAction = false;
                if (this.mStateSubscriber != null) {
                    this.mStateSubscriber.onFinishedWithState(this.mCurrentState);
                }
                this.notifyWRTCFinalState();
                return;
            }
            case 205: 
            case 206: 
            case 209: {
                this.mCurrentState.status = 10;
                if (this.mStateSubscriber != null) {
                    this.mStateSubscriber.onError("\u5f02\u5e38\u4e2d\u65ad");
                }
                this.notifyWRTCFinalState();
                return;
            }
            case 101: {
                if (this.mCurrentState.status != 8) {
                    if (this.mCurrentState.status != 6) return;
                    this.mCurrentState.status = 7;
                    this.mCurrentState.connectMsg = 1;
                    return;
                }
                this.mCurrentState.status = 9;
                this.mTimeCountHandler.removeMessages(31);
                this.mTimeCountHandler.sendEmptyMessage(31);
                if (this.mStateSubscriber == null) return;
                if (this.mCurrentState.isVideoCall) {
                    this.mStateSubscriber.onVideoConnected();
                    return;
                }
                this.mStateSubscriber.onAudioConnected();
                return;
            }
            case 102: {
                if (this.mCurrentState.status == 8) {
                    this.mCurrentState.status = 9;
                    this.mTimeCountHandler.removeMessages(31);
                    this.mTimeCountHandler.sendEmptyMessage(31);
                    if (this.mStateSubscriber == null) return;
                    this.mStateSubscriber.onVideoConnected();
                    return;
                }
                if (this.mCurrentState.status != 6) return;
                this.mCurrentState.status = 7;
                this.mCurrentState.connectMsg = 2;
                return;
            }
            case 104: {
                if (this.mCurrentState.status != 8) {
                    if (this.mCurrentState.status != 6) return;
                    this.mCurrentState.status = 7;
                    this.mCurrentState.connectMsg = 3;
                    return;
                }
                this.mCurrentState.status = 9;
                this.mTimeCountHandler.removeMessages(31);
                this.mTimeCountHandler.sendEmptyMessage(31);
                if (this.mCurrentState.isVideoCall) {
                    this.mCurrentState.isSelfAction = false;
                    this.mCurrentState.isVideoCall = false;
                    if (this.mStateSubscriber == null) return;
                    this.mStateSubscriber.onVideoInvitingSwitchToAudioConnectedRemote();
                    return;
                }
                if (this.mStateSubscriber == null) return;
                this.mStateSubscriber.onAudioConnected();
                return;
            }
            case 1001: {
                GLog.d(TAG, "onRoomStatus:" + n2 + ":STATUS_CALL_AUDIO");
                if (!this.mCurrentState.isVideoCall) return;
                this.mCurrentState.isSelfAction = false;
                this.mCurrentState.isVideoCall = false;
                if (this.mStateSubscriber == null) return;
                if (this.mCurrentState.status == 9) {
                    this.mStateSubscriber.onVideoConnectedSwitchToAudioConnectedRemote();
                    return;
                }
                this.mStateSubscriber.onVideoInvitingSwitchToAudioInvitingRemote();
                return;
            }
            case 103: {
                GLog.d(TAG, "onRoomStatus:" + n2 + ":STATUS_INVITE_FULLED");
                return;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onRoomStatus(int n2, String string2) {
        GLog.e(TAG, string2);
        if (this.mCurrentState == null) return;
        this.mCurrentState.statusCode = n2;
        switch (n2) {
            case 2001: 
            case 2002: {
                this.mCurrentState.status = 3;
                this.mCurrentState.isSelfAction = false;
                if (this.mStateSubscriber != null) {
                    this.mStateSubscriber.onFinishedWithState(this.mCurrentState);
                }
                this.notifyWRTCFinalState();
            }
            default: {
                return;
            }
            case 2004: 
        }
        if (this.mStateSubscriber != null) {
            this.mStateSubscriber.onError(GmacsEnvi.appContext.getString(R.string.toast_chat_no_permission));
        }
        if (this.mCurrentState.isInitiator) {
            WRTCContext.getInstance().cancel();
            this.mCurrentState.status = 0;
            this.mCurrentState.isSelfAction = true;
            this.notifyWRTCFinalState();
            return;
        }
        WRTCContext.getInstance().hangup();
        this.mCurrentState.status = 3;
        this.mCurrentState.isSelfAction = true;
        this.notifyWRTCFinalState();
    }

    @Override
    public void onStartCall(int n2, String string2, String string3) {
        GmacsUtils.getInstance().runOnUiThread((Runnable)new 8(this, string3, n2, string2));
    }

    public void onToggleMicMode() {
        if (this.mTimeCountHandler != null) {
            this.mTimeCountHandler.post((Runnable)new 5(this));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean onToggleMicMute() {
        boolean bl2 = true;
        if (this.mCurrentState != null) {
            State state = this.mCurrentState;
            boolean bl3 = !WRTCContext.getInstance().onToggleMicMute();
            state.isMicMute = bl3;
        }
        if (this.mCurrentState == null) return false;
        if (!this.mCurrentState.isMicMute) return false;
        return bl2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void onVideoEnabled(boolean bl2) {
        if (this.mCurrentState == null) return;
        WRTCContext.getInstance().onVideoEnabled(bl2);
        this.mCurrentState.isVideoCall = bl2;
        if (bl2) return;
        if (this.mCurrentState.status == 6) {
            this.mStateSubscriber.onVideoInvitingSwitchToAudioInvitingLocal();
            return;
        }
        if (this.mCurrentState.status != 9) return;
        this.mStateSubscriber.onVideoConnectedSwitchToAudioConnectedLocal();
    }

    public void refuse() {
        if (this.mCurrentState != null) {
            WRTCContext.getInstance().refuse();
            this.mCurrentState.status = 1;
            this.mCurrentState.statusCode = 202;
            this.mCurrentState.isSelfAction = true;
            if (this.mStateSubscriber != null) {
                this.mStateSubscriber.onFinishedWithState(this.mCurrentState);
            }
            this.notifyWRTCFinalState();
        }
    }

    public void requestRoomInfo() {
        WRTCContext.getInstance().requestRoomInfo((OnRequestRoomCallback)new 4(this));
    }

    public void resume() {
        if (this.mCurrentState != null) {
            WRTCContext.getInstance().onResume();
        }
    }

    public void setWRTCStateSubscriber(StateSubscriber stateSubscriber) {
        this.mStateSubscriber = stateSubscriber;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean start(boolean bl2, CallCommand callCommand, SurfaceViewRenderer surfaceViewRenderer, SurfaceViewRenderer surfaceViewRenderer2) {
        boolean bl3 = true;
        if (bl2) {
            this.initState(true, callCommand);
        } else if (this.mCurrentState == null || this.mCurrentState.status == 10) {
            this.mCurrentState = null;
            return false;
        }
        WRTCContext.getInstance().initVideoRenderer(surfaceViewRenderer, surfaceViewRenderer2);
        return bl3;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void startCall(CallCommand object) {
        if (object == null) return;
        if (NetworkUtil.isNetworkAvailable()) {
            SoundPlayer.getInstance().stopPlayAndAnimation();
            Intent intent = new Intent((Context)GmacsEnvi.appContext, WRTCRoomActivity.class);
            intent.addFlags(0x10000000);
            intent.putExtra("callCommand", (Parcelable)object);
            GmacsEnvi.appContext.startActivity(intent);
            return;
        }
        Activity activity = ParallaxBackActivityHelper.getPeakActivity();
        if (activity == null) return;
        object = new GmacsDialog.Builder((Context)activity, 5);
        View view = LayoutInflater.from((Context)activity).inflate(R.layout.wrtc_dialog_layout, null);
        TextView textView = (TextView)view.findViewById(R.id.tv_dialog_message);
        activity = (TextView)view.findViewById(R.id.tv_neu_btn);
        textView.setText(R.string.no_network);
        activity.setVisibility(0);
        activity.setOnClickListener((View.OnClickListener)new 2(this, (GmacsDialog.Builder)object));
        ((GmacsDialog.Builder)object).initDialog(view);
        ((GmacsDialog.Builder)object).setCancelable(false).create().show();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void switchCamera() {
        if (this.mCurrentState != null) {
            State state = this.mCurrentState;
            boolean bl2 = !this.mCurrentState.isRearCamera;
            state.isRearCamera = bl2;
            WRTCContext.getInstance().switchCamera();
            if (this.mStateSubscriber != null) {
                this.mStateSubscriber.onCameraSwitch(this.mCurrentState.isRearCamera);
            }
        }
    }

    public void switchRender() {
        WRTCContext.getInstance().switchRender();
    }

    public static interface StateSubscriber {
        public void onAudioConnected();

        public void onAudioModeChanged(int var1);

        public void onCameraSwitch(boolean var1);

        public void onChatTimeChanged(int var1);

        public void onError(String var1);

        public void onFinishedWithState(State var1);

        public void onJoinedToRoom();

        public void onNetworkStats(int var1);

        public void onVideoConnected();

        public void onVideoConnectedSwitchToAudioConnectedLocal();

        public void onVideoConnectedSwitchToAudioConnectedRemote();

        public void onVideoInvitingSwitchToAudioConnectedRemote();

        public void onVideoInvitingSwitchToAudioInvitingLocal();

        public void onVideoInvitingSwitchToAudioInvitingRemote();
    }
}

