/*
 * Decompiled with CFR 0.152.
 */
package com.wuba.recorder.util;

import android.content.Context;

public class ScreenUtil {
    public static final int SCREEN_ORIENTATION_HORIZONTAL = 2;
    public static final int SCREEN_ORIENTATION_VERTICAL = 1;
    private static volatile ScreenUtil params;
    private final String TAG;
    public int densityDpi;
    public float fontScale;
    public float scale;
    public int screenHeight;
    public int screenOrientation;
    public int screenWidth;

    /*
     * Enabled aggressive block sorting
     */
    private ScreenUtil(Context context) {
        int n2 = 1;
        this.TAG = "SystemParams";
        this.screenOrientation = 1;
        context = context.getResources().getDisplayMetrics();
        this.screenWidth = context.widthPixels;
        this.screenHeight = context.heightPixels;
        this.densityDpi = context.densityDpi;
        this.scale = context.density;
        this.fontScale = context.scaledDensity;
        if (this.screenHeight <= this.screenWidth) {
            n2 = 2;
        }
        this.screenOrientation = n2;
    }

    public static int dip2px(Context context, float f2) {
        return (int)(ScreenUtil.getInstance((Context)context).scale * f2 + 0.5f);
    }

    public static int getHeight(Context context) {
        return ScreenUtil.getInstance((Context)context).screenHeight;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ScreenUtil getInstance(Context context) {
        if (params == null) {
            synchronized (ScreenUtil.class) {
                if (params == null) {
                    ScreenUtil screenUtil;
                    params = screenUtil = new ScreenUtil(context);
                }
            }
        }
        return params;
    }

    public static float getScale(Context context) {
        return ScreenUtil.getInstance((Context)context).scale;
    }

    public static int getWidth(Context context) {
        return ScreenUtil.getInstance((Context)context).screenWidth;
    }

    public static int px2dip(Context context, float f2) {
        return (int)(f2 / ScreenUtil.getInstance((Context)context).scale + 0.5f);
    }

    public static int px2sp(Context context, float f2) {
        return (int)(f2 / ScreenUtil.getInstance((Context)context).scale + 0.5f);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String toString() {
        String string2;
        StringBuilder stringBuilder = new StringBuilder().append("SystemParams:[screenWidth: ").append(this.screenWidth).append(" screenHeight: ").append(this.screenHeight).append(" scale: ").append(this.scale).append(" fontScale: ").append(this.fontScale).append(" densityDpi: ").append(this.densityDpi).append(" screenOrientation: ");
        if (this.screenOrientation == 1) {
            string2 = "vertical";
            return stringBuilder.append(string2).append("]").toString();
        }
        string2 = "horizontal";
        return stringBuilder.append(string2).append("]").toString();
    }
}

