/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.network;

import android.text.TextUtils;
import com.xiaomi.network.Fallback;
import com.xiaomi.network.HostManager;
import java.util.ArrayList;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONObject;

class Fallbacks {
    private String host;
    private final ArrayList<Fallback> mFallbacks = new ArrayList();

    public Fallbacks() {
    }

    public Fallbacks(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("the host is empty");
        }
        this.host = string2;
    }

    public void addFallback(Fallback fallback) {
        synchronized (this) {
            int n2 = 0;
            while (true) {
                block9: {
                    block8: {
                        if (n2 >= this.mFallbacks.size()) break block8;
                        if (!this.mFallbacks.get(n2).a(fallback)) break block9;
                        this.mFallbacks.set(n2, fallback);
                    }
                    if (n2 >= this.mFallbacks.size()) {
                        this.mFallbacks.add(fallback);
                    }
                    return;
                }
                ++n2;
            }
        }
    }

    public Fallbacks fromJSON(JSONObject jSONObject) {
        synchronized (this) {
            this.host = jSONObject.getString("host");
            jSONObject = jSONObject.getJSONArray("fbs");
            int n2 = 0;
            while (true) {
                if (n2 >= jSONObject.length()) break;
                ArrayList<Fallback> arrayList = this.mFallbacks;
                Fallback fallback = new Fallback(this.host);
                arrayList.add(fallback.a(jSONObject.getJSONObject(n2)));
                ++n2;
                continue;
                break;
            }
            return this;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Fallback getFallback() {
        synchronized (this) {
            int n2 = this.mFallbacks.size() - 1;
            while (n2 >= 0) {
                Fallback fallback = this.mFallbacks.get(n2);
                if (fallback.a()) {
                    HostManager.getInstance().setCurrentISP(fallback.e());
                    return fallback;
                }
                --n2;
            }
            return null;
        }
    }

    public ArrayList<Fallback> getFallbacks() {
        return this.mFallbacks;
    }

    public String getHost() {
        return this.host;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void purge(boolean bl2) {
        synchronized (this) {
            int n2 = this.mFallbacks.size() - 1;
            while (n2 >= 0) {
                Fallback fallback = this.mFallbacks.get(n2);
                if (bl2) {
                    if (fallback.c()) {
                        this.mFallbacks.remove(n2);
                    }
                } else if (!fallback.b()) {
                    this.mFallbacks.remove(n2);
                }
                --n2;
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JSONObject toJSON() {
        synchronized (this) {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("host", (Object)this.host);
            JSONArray jSONArray = new JSONArray();
            Iterator<Fallback> iterator = this.mFallbacks.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    jSONObject.put("fbs", (Object)jSONArray);
                    return jSONObject;
                }
                jSONArray.put((Object)iterator.next().f());
            }
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.host);
        stringBuilder.append("\n");
        Iterator<Fallback> iterator = this.mFallbacks.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(iterator.next());
        }
        return stringBuilder.toString();
    }
}

