/*
 * Decompiled with CFR 0.152.
 */
package org.wrtc;

import java.util.List;
import org.wrtc.AudioSource;
import org.wrtc.AudioTrack;
import org.wrtc.EglBase;
import org.wrtc.Logging;
import org.wrtc.MediaConstraints;
import org.wrtc.MediaStream;
import org.wrtc.PeerConnection;
import org.wrtc.PeerConnectionFactory;
import org.wrtc.VideoCapturer;
import org.wrtc.VideoSource;
import org.wrtc.VideoTrack;

public class PeerConnectionFactory {
    private static final String TAG = "PeerConnectionFactory";
    private static Thread networkThread;
    private static Thread signalingThread;
    private static Thread workerThread;
    private EglBase localEglbase;
    private final long nativeFactory;
    private EglBase remoteEglbase;

    static {
        System.loadLibrary("wrtc_so");
    }

    @Deprecated
    public PeerConnectionFactory() {
        this(null);
    }

    public PeerConnectionFactory(Options options) {
        this.nativeFactory = PeerConnectionFactory.nativeCreatePeerConnectionFactory(options);
        if (this.nativeFactory == 0L) {
            throw new RuntimeException("Failed to initialize PeerConnectionFactory!");
        }
    }

    public static native boolean initializeAndroidGlobals(Object var0, boolean var1, boolean var2, boolean var3);

    public static native void initializeFieldTrials(String var0);

    public static native void initializeInternalTracer();

    private static native long nativeCreateAudioSource(long var0, MediaConstraints var2);

    private static native long nativeCreateAudioTrack(long var0, String var2, long var3);

    private static native long nativeCreateLocalMediaStream(long var0, String var2);

    private static native long nativeCreateObserver(PeerConnection.Observer var0);

    private static native long nativeCreatePeerConnection(long var0, PeerConnection.RTCConfiguration var2, MediaConstraints var3, long var4);

    private static native long nativeCreatePeerConnectionFactory(Options var0);

    private static native long nativeCreateVideoSource(long var0, EglBase.Context var2, boolean var3);

    private static native long nativeCreateVideoTrack(long var0, String var2, long var3);

    private static native void nativeFreeFactory(long var0);

    private static native void nativeInitializeVideoCapturer(long var0, VideoCapturer var2, long var3, VideoCapturer.CapturerObserver var5);

    private static native void nativeSetVideoHwAccelerationOptions(long var0, Object var2, Object var3);

    private static native boolean nativeStartAecDump(long var0, int var2, int var3);

    private static native void nativeStopAecDump(long var0);

    private static native void nativeThreadsCallbacks(long var0);

    private static void onNetworkThreadReady() {
        networkThread = Thread.currentThread();
        Logging.d((String)TAG, (String)"onNetworkThreadReady");
    }

    private static void onSignalingThreadReady() {
        signalingThread = Thread.currentThread();
        Logging.d((String)TAG, (String)"onSignalingThreadReady");
    }

    private static void onWorkerThreadReady() {
        workerThread = Thread.currentThread();
        Logging.d((String)TAG, (String)"onWorkerThreadReady");
    }

    private static void printStackTrace(Thread stackTraceElementArray, String string2) {
        if (stackTraceElementArray != null && (stackTraceElementArray = stackTraceElementArray.getStackTrace()).length > 0) {
            Logging.d((String)TAG, (String)(string2 + " stacks trace:"));
            int n2 = stackTraceElementArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Logging.d((String)TAG, (String)stackTraceElementArray[i2].toString());
            }
        }
    }

    public static void printStackTraces() {
        PeerConnectionFactory.printStackTrace(networkThread, "Network thread");
        PeerConnectionFactory.printStackTrace(workerThread, "Worker thread");
        PeerConnectionFactory.printStackTrace(signalingThread, "Signaling thread");
    }

    public static native void shutdownInternalTracer();

    public static native boolean startInternalTracingCapture(String var0);

    public static native void stopInternalTracingCapture();

    public AudioSource createAudioSource(MediaConstraints mediaConstraints) {
        return new AudioSource(PeerConnectionFactory.nativeCreateAudioSource(this.nativeFactory, mediaConstraints));
    }

    public AudioTrack createAudioTrack(String string2, AudioSource audioSource) {
        return new AudioTrack(PeerConnectionFactory.nativeCreateAudioTrack(this.nativeFactory, string2, audioSource.nativeSource));
    }

    public MediaStream createLocalMediaStream(String string2) {
        return new MediaStream(PeerConnectionFactory.nativeCreateLocalMediaStream(this.nativeFactory, string2));
    }

    public PeerConnection createPeerConnection(List<PeerConnection.IceServer> list, MediaConstraints mediaConstraints, PeerConnection.Observer observer) {
        return this.createPeerConnection(new PeerConnection.RTCConfiguration(list), mediaConstraints, observer);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PeerConnection createPeerConnection(PeerConnection.RTCConfiguration rTCConfiguration, MediaConstraints mediaConstraints, PeerConnection.Observer observer) {
        long l2 = PeerConnectionFactory.nativeCreateObserver(observer);
        if (l2 == 0L) {
            return null;
        }
        long l3 = PeerConnectionFactory.nativeCreatePeerConnection(this.nativeFactory, rTCConfiguration, mediaConstraints, l2);
        if (l3 != 0L) return new PeerConnection(l3, l2);
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public VideoSource createVideoSource(VideoCapturer videoCapturer) {
        EglBase.Context context = this.localEglbase == null ? null : this.localEglbase.getEglBaseContext();
        long l2 = PeerConnectionFactory.nativeCreateVideoSource(this.nativeFactory, context, videoCapturer.isScreencast());
        context = new VideoCapturer.AndroidVideoTrackSourceObserver(l2);
        PeerConnectionFactory.nativeInitializeVideoCapturer(this.nativeFactory, videoCapturer, l2, (VideoCapturer.CapturerObserver)context);
        return new VideoSource(l2);
    }

    public VideoTrack createVideoTrack(String string2, VideoSource videoSource) {
        return new VideoTrack(PeerConnectionFactory.nativeCreateVideoTrack(this.nativeFactory, string2, videoSource.nativeSource));
    }

    public void dispose() {
        PeerConnectionFactory.nativeFreeFactory(this.nativeFactory);
        networkThread = null;
        workerThread = null;
        signalingThread = null;
        if (this.localEglbase != null) {
            this.localEglbase.release();
        }
        if (this.remoteEglbase != null) {
            this.remoteEglbase.release();
        }
    }

    @Deprecated
    public native void nativeSetOptions(long var1, Options var3);

    @Deprecated
    public void setOptions(Options options) {
        this.nativeSetOptions(this.nativeFactory, options);
    }

    public void setVideoHwAccelerationOptions(EglBase.Context context, EglBase.Context context2) {
        if (this.localEglbase != null) {
            Logging.w((String)TAG, (String)"Egl context already set.");
            this.localEglbase.release();
        }
        if (this.remoteEglbase != null) {
            Logging.w((String)TAG, (String)"Egl context already set.");
            this.remoteEglbase.release();
        }
        this.localEglbase = EglBase.create((EglBase.Context)context);
        this.remoteEglbase = EglBase.create((EglBase.Context)context2);
        PeerConnectionFactory.nativeSetVideoHwAccelerationOptions(this.nativeFactory, this.localEglbase.getEglBaseContext(), this.remoteEglbase.getEglBaseContext());
    }

    public boolean startAecDump(int n2, int n3) {
        return PeerConnectionFactory.nativeStartAecDump(this.nativeFactory, n2, n3);
    }

    public void stopAecDump() {
        PeerConnectionFactory.nativeStopAecDump(this.nativeFactory);
    }

    public void threadsCallbacks() {
        PeerConnectionFactory.nativeThreadsCallbacks(this.nativeFactory);
    }
}

