/*
 * Decompiled with CFR 0.152.
 */
package com.wuba.wplayer;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.media.MediaCodecList;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.ParcelFileDescriptor;
import android.os.PowerManager;
import android.text.TextUtils;
import android.view.Surface;
import android.view.SurfaceHolder;
import com.wuba.wplayer.cache.LogUtils;
import com.wuba.wplayer.misc.IMediaDataSource;
import com.wuba.wplayer.player.AbstractMediaPlayer;
import com.wuba.wplayer.player.IMediaPlayer;
import com.wuba.wplayer.player.MediaInfo;
import com.wuba.wplayer.player.WLibLoader;
import com.wuba.wplayer.player.WMediaCodecInfo;
import com.wuba.wplayer.player.WMediaMeta;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;

public final class WMediaPlayer
extends AbstractMediaPlayer {
    public static final int FFP_PROPV_DECODER_AVCODEC = 1;
    public static final int FFP_PROPV_DECODER_MEDIACODEC = 2;
    public static final int FFP_PROPV_DECODER_UNKNOWN = 0;
    public static final int FFP_PROPV_DECODER_VIDEOTOOLBOX = 3;
    public static final int FFP_PROP_FLOAT_PLAYBACK_RATE = 10003;
    public static final int FFP_PROP_INT64_AUDIO_CACHED_BYTES = 20008;
    public static final int FFP_PROP_INT64_AUDIO_CACHED_DURATION = 20006;
    public static final int FFP_PROP_INT64_AUDIO_CACHED_PACKETS = 20010;
    public static final int FFP_PROP_INT64_AUDIO_DECODER = 20004;
    public static final int FFP_PROP_INT64_SELECTED_AUDIO_STREAM = 20002;
    public static final int FFP_PROP_INT64_SELECTED_VIDEO_STREAM = 20001;
    public static final int FFP_PROP_INT64_VIDEO_CACHED_BYTES = 20007;
    public static final int FFP_PROP_INT64_VIDEO_CACHED_DURATION = 20005;
    public static final int FFP_PROP_INT64_VIDEO_CACHED_PACKETS = 20009;
    public static final int FFP_PROP_INT64_VIDEO_DECODER = 20003;
    public static final int IJK_LOG_DEBUG = 3;
    public static final int IJK_LOG_DEFAULT = 1;
    public static final int IJK_LOG_ERROR = 6;
    public static final int IJK_LOG_FATAL = 7;
    public static final int IJK_LOG_INFO = 4;
    public static final int IJK_LOG_SILENT = 8;
    public static final int IJK_LOG_UNKNOWN = 0;
    public static final int IJK_LOG_VERBOSE = 2;
    public static final int IJK_LOG_WARN = 5;
    private static final int MEDIA_BUFFERING_UPDATE = 3;
    private static final int MEDIA_ERROR = 100;
    private static final int MEDIA_INFO = 200;
    private static final int MEDIA_NOP = 0;
    private static final int MEDIA_PLAYBACK_COMPLETE = 2;
    private static final int MEDIA_PREPARED = 1;
    private static final int MEDIA_SEEK_COMPLETE = 4;
    protected static final int MEDIA_SET_VIDEO_SAR = 10001;
    private static final int MEDIA_SET_VIDEO_SIZE = 5;
    private static final int MEDIA_TIMED_TEXT = 99;
    public static final int OPT_CATEGORY_CODEC = 2;
    public static final int OPT_CATEGORY_FORMAT = 1;
    public static final int OPT_CATEGORY_PLAYER = 4;
    public static final int OPT_CATEGORY_SWS = 3;
    public static final int PROP_FLOAT_VIDEO_DECODE_FRAMES_PER_SECOND = 10001;
    public static final int PROP_FLOAT_VIDEO_OUTPUT_FRAMES_PER_SECOND = 10002;
    public static final int SDL_FCC_RV16 = 909203026;
    public static final int SDL_FCC_RV32 = 842225234;
    public static final int SDL_FCC_YV12 = 842094169;
    private static final String TAG = WMediaPlayer.class.getName();
    private static volatile boolean mIsLibLoaded;
    private static volatile boolean mIsNativeInitialized;
    private static final WLibLoader sLocalLibLoader;
    private String mDataSource;
    private b mEventHandler;
    private int mListenerContext;
    private long mNativeMediaDataSource;
    private long mNativeMediaPlayer;
    private int mNativeSurfaceTexture;
    private c mOnControlMessageListener;
    private d mOnMediaCodecSelectListener;
    private e mOnNativeInvokeListener;
    private boolean mScreenOnWhilePlaying;
    private boolean mStayAwake;
    private SurfaceHolder mSurfaceHolder;
    private int mVideoHeight;
    private int mVideoSarDen;
    private int mVideoSarNum;
    private int mVideoWidth;
    private PowerManager.WakeLock mWakeLock = null;

    static {
        sLocalLibLoader = new WLibLoader(){

            @Override
            public void loadLibrary(String string2) throws UnsatisfiedLinkError, SecurityException {
                System.loadLibrary(string2);
            }
        };
        mIsLibLoaded = false;
        mIsNativeInitialized = false;
    }

    public WMediaPlayer(WLibLoader wLibLoader, boolean bl2) {
        this.initPlayer(wLibLoader, bl2);
    }

    public WMediaPlayer(boolean bl2) {
        this(sLocalLibLoader, bl2);
    }

    private native String _getAudioCodecInfo();

    private static native String _getColorFormatName(int var0);

    private native int _getLoopCount();

    private native Bundle _getMediaMeta();

    private native float _getPropertyFloat(int var1, float var2);

    private native long _getPropertyLong(int var1, long var2);

    private native String _getVideoCodecInfo();

    private native void _pause() throws IllegalStateException;

    private native void _release();

    private native void _reset();

    private native void _setDataSource(IMediaDataSource var1) throws IllegalArgumentException, SecurityException, IllegalStateException;

    private native void _setDataSource(String var1, String[] var2, String[] var3) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException;

    private native void _setDataSourceFd(int var1) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException;

    private native void _setLoopCount(int var1);

    private native void _setOption(int var1, String var2, long var3);

    private native void _setOption(int var1, String var2, String var3);

    private native void _setPropertyFloat(int var1, float var2);

    private native void _setPropertyLong(int var1, long var2);

    private native void _setStreamSelected(int var1, boolean var2);

    private native void _setVideoSurface(Surface var1);

    private native void _start() throws IllegalStateException;

    private native void _stop() throws IllegalStateException;

    static /* synthetic */ int access$1002(WMediaPlayer wMediaPlayer, int n2) {
        wMediaPlayer.mVideoSarNum = n2;
        return n2;
    }

    static /* synthetic */ int access$1102(WMediaPlayer wMediaPlayer, int n2) {
        wMediaPlayer.mVideoSarDen = n2;
        return n2;
    }

    static /* synthetic */ int access$802(WMediaPlayer wMediaPlayer, int n2) {
        wMediaPlayer.mVideoWidth = n2;
        return n2;
    }

    static /* synthetic */ int access$902(WMediaPlayer wMediaPlayer, int n2) {
        wMediaPlayer.mVideoHeight = n2;
        return n2;
    }

    public static String getColorFormatName(int n2) {
        return WMediaPlayer._getColorFormatName(n2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void initNativeOnce() {
        synchronized (WMediaPlayer.class) {
            if (!mIsNativeInitialized) {
                WMediaPlayer.native_init();
                mIsNativeInitialized = true;
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void initPlayer(WLibLoader wLibLoader, boolean bl2) {
        WMediaPlayer.loadLibrariesOnce(wLibLoader);
        WMediaPlayer.initNativeOnce();
        wLibLoader = Looper.myLooper();
        this.mEventHandler = wLibLoader != null ? new b(this, (Looper)wLibLoader) : ((wLibLoader = Looper.getMainLooper()) != null ? new b(this, (Looper)wLibLoader) : null);
        this.native_setup(new WeakReference<WMediaPlayer>(this), bl2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void loadLibrariesOnce(WLibLoader wLibLoader) {
        synchronized (WMediaPlayer.class) {
            if (!mIsLibLoaded) {
                WLibLoader wLibLoader2 = wLibLoader;
                if (wLibLoader == null) {
                    wLibLoader2 = sLocalLibLoader;
                }
                wLibLoader2.loadLibrary("wffmpeg");
                wLibLoader2.loadLibrary("wsdl");
                wLibLoader2.loadLibrary("wplayer");
                mIsLibLoaded = true;
            }
            return;
        }
    }

    private native void native_finalize();

    private static native void native_init();

    private native void native_message_loop(Object var1);

    public static native void native_profileBegin(String var0);

    public static native void native_profileEnd();

    public static native void native_setLogLevel(int var0);

    private native void native_setup(Object var1, boolean var2);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean onNativeInvoke(Object object, int n2, Bundle bundle) {
        com.wuba.wplayer.a.a.a(TAG, "onNativeInvoke %d", n2);
        if (object == null) throw new IllegalStateException("<null weakThiz>.onNativeInvoke()");
        if (!(object instanceof WeakReference)) {
            throw new IllegalStateException("<null weakThiz>.onNativeInvoke()");
        }
        if ((object = (WMediaPlayer)((WeakReference)object).get()) == null) {
            throw new IllegalStateException("<null weakPlayer>.onNativeInvoke()");
        }
        e e2 = ((WMediaPlayer)object).mOnNativeInvokeListener;
        if (e2 != null && e2.a(n2, bundle)) {
            return true;
        }
        switch (n2) {
            default: {
                return false;
            }
            case 65536: 
        }
        object = ((WMediaPlayer)object).mOnControlMessageListener;
        if (object == null) {
            return false;
        }
        n2 = bundle.getInt("segment_index", -1);
        if (n2 < 0) {
            throw new InvalidParameterException("onNativeInvoke(invalid segment index)");
        }
        if ((object = object.a(n2)) == null) {
            throw new RuntimeException(new IOException("onNativeInvoke() = <NULL newUrl>"));
        }
        bundle.putString("url", (String)object);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String onSelectCodec(Object object, String string2, int n2, int n3) {
        if (object == null) return null;
        if (!(object instanceof WeakReference)) {
            return null;
        }
        WMediaPlayer wMediaPlayer = (WMediaPlayer)((WeakReference)object).get();
        if (wMediaPlayer == null) {
            return null;
        }
        d d2 = wMediaPlayer.mOnMediaCodecSelectListener;
        object = d2;
        if (d2 != null) return object.a(wMediaPlayer, string2, n2, n3);
        object = a.b;
        return object.a(wMediaPlayer, string2, n2, n3);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void postEventFromNative(Object object, int n2, int n3, int n4, Object object2) {
        if (object == null) {
            return;
        }
        if ((object = (WMediaPlayer)((WeakReference)object).get()) == null) return;
        if (n2 == 200 && n3 == 2) {
            ((WMediaPlayer)object).start();
        }
        if (((WMediaPlayer)object).mEventHandler == null) return;
        object2 = ((WMediaPlayer)object).mEventHandler.obtainMessage(n2, n3, n4, object2);
        ((WMediaPlayer)object).mEventHandler.sendMessage((Message)object2);
    }

    private void setDataSource(FileDescriptor fileDescriptor, long l2, long l3) throws IOException, IllegalArgumentException, IllegalStateException {
        this.setDataSource(fileDescriptor);
    }

    /*
     * Enabled aggressive block sorting
     */
    @SuppressLint(value={"Wakelock"})
    private void stayAwake(boolean bl2) {
        if (this.mWakeLock != null) {
            if (bl2 && !this.mWakeLock.isHeld()) {
                this.mWakeLock.acquire();
            } else if (!bl2 && this.mWakeLock.isHeld()) {
                this.mWakeLock.release();
            }
        }
        this.mStayAwake = bl2;
        this.updateSurfaceScreenOn();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateSurfaceScreenOn() {
        if (this.mSurfaceHolder != null) {
            SurfaceHolder surfaceHolder = this.mSurfaceHolder;
            boolean bl2 = this.mScreenOnWhilePlaying && this.mStayAwake;
            surfaceHolder.setKeepScreenOn(bl2);
        }
    }

    public native void _prepareAsync() throws IllegalStateException;

    public void deselectTrack(int n2) {
        this._setStreamSelected(n2, false);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        System.currentTimeMillis();
        new Thread(new Runnable(){

            @Override
            public void run() {
                WMediaPlayer.this.native_finalize();
            }
        }).start();
    }

    public long getAudioCachedBytes() {
        return this._getPropertyLong(20008, 0L);
    }

    public long getAudioCachedDuration() {
        return this._getPropertyLong(20006, 0L);
    }

    public long getAudioCachedPackets() {
        return this._getPropertyLong(20010, 0L);
    }

    public native int getAudioSessionId();

    public native long getCurrentPosition();

    public String getDataSource() {
        return this.mDataSource;
    }

    public native long getDuration();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MediaInfo getMediaInfo() {
        String string2;
        MediaInfo mediaInfo = new MediaInfo();
        mediaInfo.mMediaPlayerName = "ijkplayer";
        String string3 = this._getVideoCodecInfo();
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            String[] stringArray = string3.split(",");
            if (stringArray.length >= 2) {
                mediaInfo.mVideoDecoder = stringArray[0];
                mediaInfo.mVideoDecoderImpl = stringArray[1];
            } else if (stringArray.length >= 1) {
                mediaInfo.mVideoDecoder = stringArray[0];
                mediaInfo.mVideoDecoderImpl = "";
            }
        }
        if (!TextUtils.isEmpty((CharSequence)(string2 = this._getAudioCodecInfo()))) {
            String[] stringArray = string2.split(",");
            if (stringArray.length >= 2) {
                mediaInfo.mAudioDecoder = stringArray[0];
                mediaInfo.mAudioDecoderImpl = stringArray[1];
            } else if (stringArray.length >= 1) {
                mediaInfo.mAudioDecoder = stringArray[0];
                mediaInfo.mAudioDecoderImpl = "";
            }
        }
        try {
            mediaInfo.mMeta = WMediaMeta.parse(this._getMediaMeta());
            return mediaInfo;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return mediaInfo;
        }
    }

    public Bundle getMediaMeta() {
        return this._getMediaMeta();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getSelectedTrack(int n2) {
        switch (n2) {
            default: {
                return -1;
            }
            case 1: {
                return (int)this._getPropertyLong(20001, -1L);
            }
            case 2: 
        }
        return (int)this._getPropertyLong(20002, -1L);
    }

    @TargetApi(value=23)
    public float getSpeed(float f2) {
        return this._getPropertyFloat(10003, 0.0f);
    }

    /*
     * Enabled aggressive block sorting
     */
    public com.wuba.wplayer.misc.b[] getTrackInfo() {
        WMediaMeta.IjkStreamMeta ijkStreamMeta = null;
        Object object = this.getMediaMeta();
        if (object == null) {
            return ijkStreamMeta;
        }
        Object object2 = WMediaMeta.parse((Bundle)object);
        object = ijkStreamMeta;
        if (object2 == null) return object;
        object = ijkStreamMeta;
        if (((WMediaMeta)object2).mStreams == null) return object;
        object = new ArrayList();
        object2 = ((WMediaMeta)object2).mStreams.iterator();
        while (object2.hasNext()) {
            ijkStreamMeta = (WMediaMeta.IjkStreamMeta)object2.next();
            com.wuba.wplayer.misc.b b2 = new com.wuba.wplayer.misc.b(ijkStreamMeta);
            if (ijkStreamMeta.mType.equalsIgnoreCase("video")) {
                b2.b(1);
            } else if (ijkStreamMeta.mType.equalsIgnoreCase("audio")) {
                b2.b(2);
            }
            ((ArrayList)object).add(b2);
        }
        return ((ArrayList)object).toArray(new com.wuba.wplayer.misc.b[((ArrayList)object).size()]);
    }

    public long getVideoCachedBytes() {
        return this._getPropertyLong(20007, 0L);
    }

    public long getVideoCachedDuration() {
        return this._getPropertyLong(20005, 0L);
    }

    public long getVideoCachedPackets() {
        return this._getPropertyLong(20009, 0L);
    }

    public float getVideoDecodeFramesPerSecond() {
        return this._getPropertyFloat(10001, 0.0f);
    }

    public int getVideoDecoder() {
        return (int)this._getPropertyLong(20003, 0L);
    }

    public int getVideoHeight() {
        return this.mVideoHeight;
    }

    public float getVideoOutputFramesPerSecond() {
        return this._getPropertyFloat(10002, 0.0f);
    }

    public int getVideoSarDen() {
        return this.mVideoSarDen;
    }

    public int getVideoSarNum() {
        return this.mVideoSarNum;
    }

    public int getVideoWidth() {
        return this.mVideoWidth;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isLooping() {
        boolean bl2 = true;
        if (this._getLoopCount() == 1) return false;
        return bl2;
    }

    public boolean isPlayable() {
        return true;
    }

    public native boolean isPlaying();

    public native void native_setIsUseBuf(int var1);

    public void pause() throws IllegalStateException {
        this.stayAwake(false);
        this._pause();
    }

    public void prepareAsync() throws IllegalStateException {
        this._prepareAsync();
    }

    public void release() {
        this.stayAwake(false);
        this.updateSurfaceScreenOn();
        this.resetListeners();
        this._release();
    }

    public void reset() {
        this.stayAwake(false);
        this._reset();
        this.mEventHandler.removeCallbacksAndMessages(null);
        this.mVideoWidth = 0;
        this.mVideoHeight = 0;
    }

    @Override
    public void resetListeners() {
        super.resetListeners();
        this.mOnMediaCodecSelectListener = null;
    }

    public native void seekTo(long var1) throws IllegalStateException;

    public void selectTrack(int n2) {
        this._setStreamSelected(n2, true);
    }

    public void setAudioStreamType(int n2) {
    }

    public void setDataSource(Context context, Uri uri) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException {
        this.setDataSource(context, uri, null);
    }

    /*
     * Unable to fully structure code
     */
    @TargetApi(value=14)
    public void setDataSource(Context var1_1, Uri var2_4, Map<String, String> var3_10) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException {
        block23: {
            block22: {
                var4_11 = var2_4.getScheme();
                if ("file".equals(var4_11)) {
                    this.setDataSource(var2_4.getPath());
lbl4:
                    // 5 sources

                    return;
                }
                var5_12 = var2_4;
                if ("content".equals(var4_11)) {
                    var5_12 = var2_4;
                    if ("settings".equals(var2_4.getAuthority())) {
                        var5_12 = var2_4 = RingtoneManager.getActualDefaultRingtoneUri((Context)var1_1, (int)RingtoneManager.getDefaultType((Uri)var2_4));
                        if (var2_4 == null) {
                            throw new FileNotFoundException("Failed to resolve default ringtone");
                        }
                    }
                }
                var2_4 = null;
                var1_1 = var1_1.getContentResolver().openAssetFileDescriptor(var5_12, "r");
                if (var1_1 != null) break block22;
                if (var1_1 == null) ** GOTO lbl4
                var1_1.close();
                ** GOTO lbl4
            }
            if (var1_1.getDeclaredLength() >= 0L) break block23;
            this.setDataSource(var1_1.getFileDescriptor());
lbl24:
            // 2 sources

            while (true) {
                if (var1_1 != null) {
                    var1_1.close();
                }
                ** GOTO lbl4
                break;
            }
        }
        try {
            this.setDataSource(var1_1.getFileDescriptor(), var1_1.getStartOffset(), var1_1.getDeclaredLength());
            ** continue;
        }
        catch (SecurityException var2_5) lbl-1000:
        // 2 sources

        {
            while (true) {
                if (var1_1 != null) {
                    var1_1.close();
                }
lbl36:
                // 5 sources

                while (true) {
                    LogUtils.d(WMediaPlayer.TAG, "Couldn't open file on client side, trying server side");
                    this.setDataSource(var5_12.toString(), var3_10);
                    ** continue;
                    break;
                }
                break;
            }
        }
        catch (IOException var1_2) {
            var1_1 = null;
lbl42:
            // 2 sources

            while (true) {
                if (var1_1 == null) ** GOTO lbl36
                var1_1.close();
                ** continue;
                break;
            }
        }
        catch (Throwable var2_6) {
            var1_1 = null;
lbl48:
            // 2 sources

            while (true) {
                if (var1_1 != null) {
                    var1_1.close();
                }
                throw var2_7;
            }
        }
        catch (Throwable var2_8) {
            ** continue;
        }
        catch (IOException var2_9) {
            ** continue;
        }
        catch (SecurityException var1_3) {
            var1_1 = var2_4;
            ** continue;
        }
    }

    @Override
    public void setDataSource(IMediaDataSource iMediaDataSource) throws IllegalArgumentException, SecurityException, IllegalStateException {
        this._setDataSource(iMediaDataSource);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @TargetApi(value=13)
    public void setDataSource(FileDescriptor fileDescriptor) throws IOException, IllegalArgumentException, IllegalStateException {
        if (Build.VERSION.SDK_INT < 12) {
            try {
                Field field = fileDescriptor.getClass().getDeclaredField("descriptor");
                field.setAccessible(true);
                int n2 = field.getInt(fileDescriptor);
                this._setDataSourceFd(n2);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new RuntimeException(noSuchFieldException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(illegalAccessException);
            }
            return;
        }
        ParcelFileDescriptor parcelFileDescriptor = ParcelFileDescriptor.dup((FileDescriptor)fileDescriptor);
        try {
            this._setDataSourceFd(parcelFileDescriptor.getFd());
            return;
        }
        finally {
            parcelFileDescriptor.close();
            return;
        }
    }

    public void setDataSource(String string2) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException {
        this.mDataSource = string2;
        this._setDataSource(string2, null, null);
    }

    public void setDataSource(String string2, Map<String, String> object2) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException {
        if (object2 != null && !object2.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            for (Map.Entry entry : object2.entrySet()) {
                stringBuilder.append((String)entry.getKey());
                stringBuilder.append(":");
                if (!TextUtils.isEmpty((CharSequence)((String)entry.getValue()))) {
                    stringBuilder.append((String)entry.getValue());
                }
                stringBuilder.append("\r\n");
                this.setOption(1, "headers", stringBuilder.toString());
            }
        }
        this.setDataSource(string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setDisplay(SurfaceHolder object) {
        this.mSurfaceHolder = object;
        object = object != null ? object.getSurface() : null;
        this._setVideoSurface((Surface)object);
        this.updateSurfaceScreenOn();
    }

    public void setKeepInBackground(boolean bl2) {
    }

    public void setLogEnabled(boolean bl2) {
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setLooping(boolean bl2) {
        int n2 = bl2 ? 0 : 1;
        this.setOption(4, "loop", n2);
        this._setLoopCount(n2);
    }

    public void setOnControlMessageListener(c c2) {
        this.mOnControlMessageListener = c2;
    }

    public void setOnMediaCodecSelectListener(d d2) {
        this.mOnMediaCodecSelectListener = d2;
    }

    public void setOnNativeInvokeListener(e e2) {
        this.mOnNativeInvokeListener = e2;
    }

    public void setOption(int n2, String string2, long l2) {
        this._setOption(n2, string2, l2);
    }

    public void setOption(int n2, String string2, String string3) {
        this._setOption(n2, string2, string3);
    }

    public void setScreenOnWhilePlaying(boolean bl2) {
        if (this.mScreenOnWhilePlaying != bl2) {
            if (bl2 && this.mSurfaceHolder == null) {
                com.wuba.wplayer.a.a.w(TAG, "setScreenOnWhilePlaying(true) is ineffective without a SurfaceHolder");
            }
            this.mScreenOnWhilePlaying = bl2;
            this.updateSurfaceScreenOn();
        }
    }

    @TargetApi(value=23)
    public void setSpeed(float f2) {
        this._setPropertyFloat(10003, f2);
    }

    public void setSurface(Surface surface) {
        if (this.mScreenOnWhilePlaying && surface != null) {
            com.wuba.wplayer.a.a.w(TAG, "setScreenOnWhilePlaying(true) is ineffective for Surface");
        }
        this.mSurfaceHolder = null;
        this._setVideoSurface(surface);
        this.updateSurfaceScreenOn();
    }

    public native void setVolume(float var1, float var2);

    /*
     * Enabled aggressive block sorting
     */
    @SuppressLint(value={"Wakelock"})
    public void setWakeMode(Context context, int n2) {
        boolean bl2;
        if (this.mWakeLock != null) {
            if (this.mWakeLock.isHeld()) {
                bl2 = true;
                this.mWakeLock.release();
            } else {
                bl2 = false;
            }
            this.mWakeLock = null;
        } else {
            bl2 = false;
        }
        this.mWakeLock = ((PowerManager)context.getSystemService("power")).newWakeLock(0x20000000 | n2, WMediaPlayer.class.getName());
        this.mWakeLock.setReferenceCounted(false);
        if (bl2) {
            this.mWakeLock.acquire();
        }
    }

    public void start() throws IllegalStateException {
        this.stayAwake(true);
        this._start();
    }

    public void stop() throws IllegalStateException {
        this.stayAwake(false);
        this._stop();
    }

    public static class a
    implements d {
        public static final a b = new a();

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        @Override
        @TargetApi(value=16)
        public String a(IMediaPlayer var1_1, String var2_2, int var3_3, int var4_4) {
            block10: {
                block9: {
                    block8: {
                        if (Build.VERSION.SDK_INT < 16) {
                            var1_1 /* !! */  = null;
lbl3:
                            // 5 sources

                            return var1_1 /* !! */ ;
                        }
                        if (!TextUtils.isEmpty((CharSequence)var2_2)) break block8;
                        var1_1 /* !! */  = null;
                        ** GOTO lbl3
                    }
                    LogUtils.i(WMediaPlayer.access$200(), String.format(Locale.US, "onSelectCodec: mime=%s, profile=%d, level=%d", new Object[]{var2_2, var3_3, var4_4}));
                    var5_5 = new ArrayList<E>();
                    var6_6 = MediaCodecList.getCodecCount();
                    block1: for (var3_3 = 0; var3_3 < var6_6; ++var3_3) {
                        var7_7 = MediaCodecList.getCodecInfoAt((int)var3_3);
                        LogUtils.d(WMediaPlayer.access$200(), String.format(Locale.US, "  found codec: %s", new Object[]{var7_7.getName()}));
                        if (var7_7.isEncoder()) lbl-1000:
                        // 3 sources

                        {
                            continue block1;
                        }
                        var1_1 /* !! */  = var7_7.getSupportedTypes();
                        if (var1_1 /* !! */  == null) ** GOTO lbl-1000
                        var8_8 = var1_1 /* !! */ .length;
                        var4_4 = 0;
                        block3: while (true) {
                            if (var4_4 < var8_8) ** break;
                            ** continue;
                            var9_9 = var1_1 /* !! */ [var4_4];
                            if (!TextUtils.isEmpty((CharSequence)var9_9)) break;
lbl27:
                            // 3 sources

                            while (true) {
                                ++var4_4;
                                continue block3;
                                break;
                            }
                            break;
                        }
                        LogUtils.d(WMediaPlayer.access$200(), String.format(Locale.US, "    mime: %s", new Object[]{var9_9}));
                        if (!var9_9.equalsIgnoreCase((String)var2_2) || (var9_9 = WMediaCodecInfo.setupCandidate(var7_7, (String)var2_2)) == null) ** GOTO lbl27
                        var5_5.add(var9_9);
                        LogUtils.i(WMediaPlayer.access$200(), String.format(Locale.US, "candidate codec: %s rank=%d", new Object[]{var7_7.getName(), var9_9.mRank}));
                        var9_9.dumpProfileLevels((String)var2_2);
                        ** continue;
                    }
                    if (!var5_5.isEmpty()) break block9;
                    var1_1 /* !! */  = null;
                    ** GOTO lbl3
                }
                var1_1 /* !! */  = (WMediaCodecInfo)var5_5.get(0);
                var5_5 = var5_5.iterator();
                while (var5_5.hasNext()) {
                    var2_2 = (WMediaCodecInfo)var5_5.next();
                    if (var2_2.mRank <= var1_1 /* !! */ .mRank) continue;
                    var1_1 /* !! */  = var2_2;
                }
                if (var1_1 /* !! */ .mRank >= 600) break block10;
                LogUtils.w(WMediaPlayer.access$200(), String.format(Locale.US, "unaccetable codec: %s", new Object[]{var1_1 /* !! */ .mCodecInfo.getName()}));
                var1_1 /* !! */  = null;
                ** GOTO lbl3
            }
            LogUtils.i(WMediaPlayer.access$200(), String.format(Locale.US, "selected codec: %s rank=%d", new Object[]{var1_1 /* !! */ .mCodecInfo.getName(), var1_1 /* !! */ .mRank}));
            var1_1 /* !! */  = var1_1 /* !! */ .mCodecInfo.getName();
            ** while (true)
        }
    }

    private static class b
    extends Handler {
        private final WeakReference<WMediaPlayer> a;

        public b(WMediaPlayer wMediaPlayer, Looper looper) {
            super(looper);
            this.a = new WeakReference<WMediaPlayer>(wMediaPlayer);
        }

        /*
         * Enabled aggressive block sorting
         */
        public void handleMessage(Message message) {
            long l2;
            long l3;
            WMediaPlayer wMediaPlayer = (WMediaPlayer)this.a.get();
            if (wMediaPlayer == null || wMediaPlayer.mNativeMediaPlayer == 0L) {
                com.wuba.wplayer.a.a.w(TAG, "IjkMediaPlayer went away with unhandled events");
                return;
            }
            switch (message.what) {
                case 0: 
                case 99: {
                    return;
                }
                default: {
                    com.wuba.wplayer.a.a.e(TAG, "Unknown message type " + message.what);
                    return;
                }
                case 1: {
                    wMediaPlayer.notifyOnPrepared();
                    return;
                }
                case 2: {
                    wMediaPlayer.stayAwake(false);
                    wMediaPlayer.notifyOnCompletion();
                    return;
                }
                case 3: {
                    l2 = l3 = (long)message.arg1;
                    if (l3 < 0L) {
                        l2 = 0L;
                    }
                    l2 = (l3 = wMediaPlayer.getDuration()) > 0L ? l2 * 100L / l3 : 0L;
                }
                case 4: {
                    wMediaPlayer.notifyOnSeekComplete();
                    return;
                }
                case 5: {
                    WMediaPlayer.access$802(wMediaPlayer, message.arg1);
                    WMediaPlayer.access$902(wMediaPlayer, message.arg2);
                    wMediaPlayer.notifyOnVideoSizeChanged(wMediaPlayer.mVideoWidth, wMediaPlayer.mVideoHeight, wMediaPlayer.mVideoSarNum, wMediaPlayer.mVideoSarDen);
                    return;
                }
                case 100: {
                    com.wuba.wplayer.a.a.e(TAG, "Error (" + message.arg1 + "," + message.arg2 + ")");
                    if (!wMediaPlayer.notifyOnError(message.arg1, message.arg2)) {
                        wMediaPlayer.notifyOnCompletion();
                    }
                    wMediaPlayer.stayAwake(false);
                    return;
                }
                case 200: {
                    switch (message.arg1) {
                        default: {
                            break;
                        }
                        case 3: {
                            com.wuba.wplayer.a.a.i(TAG, "Info: MEDIA_INFO_VIDEO_RENDERING_START\n");
                        }
                    }
                    wMediaPlayer.notifyOnInfo(message.arg1, message.arg2);
                    return;
                }
                case 10001: {
                    WMediaPlayer.access$1002(wMediaPlayer, message.arg1);
                    WMediaPlayer.access$1102(wMediaPlayer, message.arg2);
                    wMediaPlayer.notifyOnVideoSizeChanged(wMediaPlayer.mVideoWidth, wMediaPlayer.mVideoHeight, wMediaPlayer.mVideoSarNum, wMediaPlayer.mVideoSarDen);
                    return;
                }
            }
            l3 = l2;
            if (l2 >= 100L) {
                l3 = 100L;
            }
            wMediaPlayer.notifyOnBufferingUpdate((int)l3);
        }
    }

    public static interface c {
        public String a(int var1);
    }

    public static interface d {
        public String a(IMediaPlayer var1, String var2, int var3, int var4);
    }

    public static interface e {
        public boolean a(int var1, Bundle var2);
    }
}

