/*
 * Decompiled with CFR 0.152.
 */
package com.wuba.wplayer.player;

import android.annotation.TargetApi;
import android.media.MediaCodecInfo;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import com.wuba.wplayer.cache.LogUtils;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;

public class WMediaCodecInfo {
    public static final int RANK_ACCEPTABLE = 700;
    public static final int RANK_LAST_CHANCE = 600;
    public static final int RANK_MAX = 1000;
    public static final int RANK_NON_STANDARD = 100;
    public static final int RANK_NO_SENSE = 0;
    public static final int RANK_SECURE = 300;
    public static final int RANK_SOFTWARE = 200;
    public static final int RANK_TESTED = 800;
    private static final String TAG = "WMediaCodecInfo";
    private static Map<String, Integer> sKnownCodecList;
    public MediaCodecInfo mCodecInfo;
    public String mMimeType;
    public int mRank = 0;

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Map<String, Integer> getKnownCodecList() {
        synchronized (WMediaCodecInfo.class) {
            void var0_1;
            if (sKnownCodecList != null) {
                Map<String, Integer> map = sKnownCodecList;
                return var0_1;
            }
            TreeMap<String, Integer> treeMap = new TreeMap<String, Integer>(String.CASE_INSENSITIVE_ORDER);
            sKnownCodecList = treeMap;
            sKnownCodecList.put("OMX.Nvidia.h264.decode", 800);
            sKnownCodecList.put("OMX.Nvidia.h264.decode.secure", 300);
            sKnownCodecList.put("OMX.Intel.hw_vd.h264", 801);
            sKnownCodecList.put("OMX.Intel.VideoDecoder.AVC", 800);
            sKnownCodecList.put("OMX.qcom.video.decoder.avc", 800);
            sKnownCodecList.put("OMX.ittiam.video.decoder.avc", 0);
            sKnownCodecList.put("OMX.SEC.avc.dec", 800);
            sKnownCodecList.put("OMX.SEC.AVC.Decoder", 799);
            sKnownCodecList.put("OMX.SEC.avcdec", 798);
            sKnownCodecList.put("OMX.SEC.avc.sw.dec", 200);
            sKnownCodecList.put("OMX.Exynos.avc.dec", 800);
            sKnownCodecList.put("OMX.Exynos.AVC.Decoder", 799);
            sKnownCodecList.put("OMX.k3.video.decoder.avc", 800);
            sKnownCodecList.put("OMX.IMG.MSVDX.Decoder.AVC", 800);
            sKnownCodecList.put("OMX.TI.DUCATI1.VIDEO.DECODER", 800);
            sKnownCodecList.put("OMX.rk.video_decoder.avc", 800);
            sKnownCodecList.put("OMX.amlogic.avc.decoder.awesome", 800);
            sKnownCodecList.put("OMX.MARVELL.VIDEO.HW.CODA7542DECODER", 800);
            sKnownCodecList.put("OMX.MARVELL.VIDEO.H264DECODER", 200);
            sKnownCodecList.remove("OMX.Action.Video.Decoder");
            sKnownCodecList.remove("OMX.allwinner.video.decoder.avc");
            sKnownCodecList.remove("OMX.BRCM.vc4.decoder.avc");
            sKnownCodecList.remove("OMX.brcm.video.h264.hw.decoder");
            sKnownCodecList.remove("OMX.brcm.video.h264.decoder");
            sKnownCodecList.remove("OMX.cosmo.video.decoder.avc");
            sKnownCodecList.remove("OMX.duos.h264.decoder");
            sKnownCodecList.remove("OMX.hantro.81x0.video.decoder");
            sKnownCodecList.remove("OMX.hantro.G1.video.decoder");
            sKnownCodecList.remove("OMX.hisi.video.decoder");
            sKnownCodecList.remove("OMX.LG.decoder.video.avc");
            sKnownCodecList.remove("OMX.MS.AVC.Decoder");
            sKnownCodecList.remove("OMX.RENESAS.VIDEO.DECODER.H264");
            sKnownCodecList.remove("OMX.RTK.video.decoder");
            sKnownCodecList.remove("OMX.sprd.h264.decoder");
            sKnownCodecList.remove("OMX.ST.VFM.H264Dec");
            sKnownCodecList.remove("OMX.vpu.video_decoder.avc");
            sKnownCodecList.remove("OMX.WMT.decoder.avc");
            sKnownCodecList.remove("OMX.bluestacks.hw.decoder");
            sKnownCodecList.put("OMX.google.h264.decoder", 200);
            sKnownCodecList.put("OMX.google.h264.lc.decoder", 200);
            sKnownCodecList.put("OMX.k3.ffmpeg.decoder", 200);
            sKnownCodecList.put("OMX.ffmpeg.video.decoder", 200);
            sKnownCodecList.put("OMX.sprd.soft.h264.decoder", 200);
            Map<String, Integer> map = sKnownCodecList;
            return var0_1;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getLevelName(int n2) {
        switch (n2) {
            default: {
                return "0";
            }
            case 1: {
                return "1";
            }
            case 2: {
                return "1b";
            }
            case 4: {
                return "11";
            }
            case 8: {
                return "12";
            }
            case 16: {
                return "13";
            }
            case 32: {
                return "2";
            }
            case 64: {
                return "21";
            }
            case 128: {
                return "22";
            }
            case 256: {
                return "3";
            }
            case 512: {
                return "31";
            }
            case 1024: {
                return "32";
            }
            case 2048: {
                return "4";
            }
            case 4096: {
                return "41";
            }
            case 8192: {
                return "42";
            }
            case 16384: {
                return "5";
            }
            case 32768: {
                return "51";
            }
            case 65536: 
        }
        return "52";
    }

    public static String getProfileLevelName(int n2, int n3) {
        return String.format(Locale.US, " %s Profile Level %s (%d,%d)", WMediaCodecInfo.getProfileName(n2), WMediaCodecInfo.getLevelName(n3), n2, n3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getProfileName(int n2) {
        switch (n2) {
            default: {
                return "Unknown";
            }
            case 1: {
                return "Baseline";
            }
            case 2: {
                return "Main";
            }
            case 4: {
                return "Extends";
            }
            case 8: {
                return "High";
            }
            case 16: {
                return "High10";
            }
            case 32: {
                return "High422";
            }
            case 64: 
        }
        return "High444";
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @TargetApi(value=16)
    public static WMediaCodecInfo setupCandidate(MediaCodecInfo object, String string2) {
        void var1_5;
        int n2;
        void var0_2;
        int n3 = 200;
        if (object == null || Build.VERSION.SDK_INT < 16) {
            Object var0_1 = null;
            return var0_2;
        }
        Object object2 = object.getName();
        if (TextUtils.isEmpty((CharSequence)object2)) {
            return var0_2;
        }
        if (!((String)(object2 = ((String)object2).toLowerCase(Locale.US))).startsWith("omx.")) {
            n2 = 100;
        } else {
            n2 = n3;
            if (!((String)object2).startsWith("omx.pv")) {
                n2 = n3;
                if (!((String)object2).startsWith("omx.google.")) {
                    n2 = n3;
                    if (!((String)object2).startsWith("omx.ffmpeg.")) {
                        n2 = n3;
                        if (!((String)object2).startsWith("omx.k3.ffmpeg.")) {
                            n2 = n3;
                            if (!((String)object2).startsWith("omx.avcodec.")) {
                                if (((String)object2).startsWith("omx.ittiam.")) {
                                    n2 = 0;
                                } else if (((String)object2).startsWith("omx.mtk.")) {
                                    n2 = Build.VERSION.SDK_INT < 18 ? 0 : 800;
                                } else {
                                    object2 = WMediaCodecInfo.getKnownCodecList().get(object2);
                                    if (object2 != null) {
                                        n2 = (Integer)object2;
                                    } else {
                                        try {
                                            object2 = object.getCapabilitiesForType((String)var1_5);
                                            n2 = object2 != null ? 700 : 600;
                                        }
                                        catch (Throwable throwable) {
                                            n2 = 600;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        object2 = new WMediaCodecInfo();
        ((WMediaCodecInfo)object2).mCodecInfo = object;
        ((WMediaCodecInfo)object2).mRank = n2;
        ((WMediaCodecInfo)object2).mMimeType = var1_5;
        Object object3 = object2;
        return var0_2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @TargetApi(value=16)
    public void dumpProfileLevels(String codecProfileLevelArray) {
        int n2 = 0;
        int n3 = 0;
        if (Build.VERSION.SDK_INT < 16) {
            return;
        }
        try {
            int n4;
            codecProfileLevelArray = this.mCodecInfo.getCapabilitiesForType((String)codecProfileLevelArray);
            if (codecProfileLevelArray == null || codecProfileLevelArray.profileLevels == null) {
                n4 = 0;
            } else {
                codecProfileLevelArray = codecProfileLevelArray.profileLevels;
                int n5 = codecProfileLevelArray.length;
                int n6 = 0;
                int n7 = 0;
                while (true) {
                    n2 = n3;
                    n4 = n7;
                    if (n6 >= n5) break;
                    MediaCodecInfo.CodecProfileLevel codecProfileLevel = codecProfileLevelArray[n6];
                    if (codecProfileLevel != null) {
                        n7 = Math.max(n7, codecProfileLevel.profile);
                        n3 = Math.max(n3, codecProfileLevel.level);
                    }
                    ++n6;
                }
            }
            Log.i((String)TAG, (String)String.format(Locale.US, "%s", WMediaCodecInfo.getProfileLevelName(n4, n2)));
            return;
        }
        catch (Throwable throwable) {
            LogUtils.i(TAG, "profile-level: exception");
            return;
        }
    }
}

