/*
 * Decompiled with CFR 0.152.
 */
package com.wuba.wrtc.api;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.AlertDialog;
import android.app.Fragment;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Build;
import android.support.annotation.StringRes;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import com.wuba.wrtc.api.AfterPermissionGranted;
import com.wuba.wrtc.api.EasyPermissions$1;
import com.wuba.wrtc.api.EasyPermissions$2;
import com.wuba.wrtc.api.EasyPermissions$3;
import com.wuba.wrtc.util.e;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class EasyPermissions {
    private static final String TAG = "EasyPermissions";

    static /* synthetic */ void access$000(Object object, String[] stringArray, int n2) {
        EasyPermissions.executePermissionsRequest(object, stringArray, n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void checkCallingObjectSuitability(Object object) {
        boolean bl2 = object instanceof Activity;
        boolean bl3 = object instanceof android.support.v4.app.Fragment;
        boolean bl4 = object instanceof Fragment;
        boolean bl5 = Build.VERSION.SDK_INT >= 23;
        if (!(bl3 || bl2 || bl4 && bl5)) {
            if (bl4) {
                throw new IllegalArgumentException("Target SDK needs to be greater than 23 if caller is android.app.Fragment");
            }
            throw new IllegalArgumentException("Caller must be an Activity or a Fragment.");
        }
        if (!(object instanceof PermissionCallbacks)) {
            throw new IllegalArgumentException("Caller must implement PermissionCallbacks.");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean checkDeniedPermissionsNeverAskAgain(Object object, String string2, @StringRes int n2, @StringRes int n3, List<String> iterator) {
        iterator = iterator.iterator();
        do {
            if (!iterator.hasNext()) return false;
        } while (EasyPermissions.shouldShowRequestPermissionRationale(object, (String)iterator.next()));
        if ((object = EasyPermissions.getActivity(object)) == null) {
            return true;
        }
        new AlertDialog.Builder((Context)object).setMessage((CharSequence)string2).setPositiveButton(n2, (DialogInterface.OnClickListener)new EasyPermissions$3((Activity)object)).setNegativeButton(n3, null).create().show();
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @TargetApi(value=23)
    private static void executePermissionsRequest(Object object, String[] stringArray, int n2) {
        EasyPermissions.checkCallingObjectSuitability(object);
        if (object instanceof Activity) {
            ActivityCompat.requestPermissions((Activity)((Activity)object), (String[])stringArray, (int)n2);
            return;
        }
        if (object instanceof android.support.v4.app.Fragment) {
            ((android.support.v4.app.Fragment)object).requestPermissions(stringArray, n2);
            return;
        }
        if (!(object instanceof Fragment)) return;
        ((Fragment)object).requestPermissions(stringArray, n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @TargetApi(value=11)
    private static Activity getActivity(Object object) {
        if (object instanceof Activity) {
            return (Activity)object;
        }
        if (object instanceof android.support.v4.app.Fragment) {
            return ((android.support.v4.app.Fragment)object).getActivity();
        }
        if (!(object instanceof Fragment)) return null;
        return ((Fragment)object).getActivity();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean hasPermissions(Context context, String ... stringArray) {
        boolean bl2 = true;
        if (Build.VERSION.SDK_INT < 23) {
            e.g(TAG, "hasPermissions: API version < M, returning true by default");
            return bl2;
        }
        int n2 = stringArray.length;
        int n3 = 0;
        while (true) {
            boolean bl3 = bl2;
            if (n3 >= n2) return bl3;
            if (ContextCompat.checkSelfPermission((Context)context, (String)stringArray[n3]) != 0) return false;
            boolean bl4 = true;
            if (!bl4) {
                return false;
            }
            ++n3;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isUsingAndroidAnnotations(Object object) {
        boolean bl2 = false;
        if (!object.getClass().getSimpleName().endsWith("_")) {
            return bl2;
        }
        try {
            boolean bl3 = Class.forName("org.androidannotations.api.view.HasViews").isInstance(object);
            return bl3;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return bl2;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void onRequestPermissionsResult(int n2, String[] stringArray, int[] nArray, Object object) {
        EasyPermissions.checkCallingObjectSuitability(object);
        PermissionCallbacks permissionCallbacks = (PermissionCallbacks)object;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string2 = stringArray[i2];
            if (nArray[i2] == 0) {
                arrayList.add(string2);
                continue;
            }
            arrayList2.add(string2);
        }
        if (!arrayList.isEmpty()) {
            permissionCallbacks.onPermissionsGranted(n2, arrayList);
        }
        if (!arrayList2.isEmpty()) {
            permissionCallbacks.onPermissionsDenied(n2, arrayList2);
        }
        if (!arrayList.isEmpty() && arrayList2.isEmpty()) {
            EasyPermissions.runAnnotatedMethods(object, n2);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void requestPermissions(Object object, String string2, @StringRes int n2, @StringRes int n3, int n4, String ... stringArray) {
        String string3;
        EasyPermissions.checkCallingObjectSuitability(object);
        PermissionCallbacks permissionCallbacks = (PermissionCallbacks)object;
        int n5 = stringArray.length;
        boolean bl2 = false;
        for (int i2 = 0; i2 < n5; ++i2) {
            string3 = stringArray[i2];
            bl2 = bl2 || EasyPermissions.shouldShowRequestPermissionRationale(object, string3);
        }
        if (!bl2) {
            EasyPermissions.executePermissionsRequest(object, stringArray, n4);
            return;
        }
        string3 = EasyPermissions.getActivity(object);
        if (string3 == null) {
            return;
        }
        new AlertDialog.Builder((Context)string3).setMessage((CharSequence)string2).setPositiveButton(n2, (DialogInterface.OnClickListener)new EasyPermissions$2(object, stringArray, n4)).setNegativeButton(n3, (DialogInterface.OnClickListener)new EasyPermissions$1(permissionCallbacks, n4, stringArray)).create().show();
    }

    public static void requestPermissions(Object object, String string2, int n2, String ... stringArray) {
        EasyPermissions.requestPermissions(object, string2, 17039370, 0x1040000, n2, stringArray);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void runAnnotatedMethods(Object object, int n2) {
        int n3 = 0;
        Object object2 = object.getClass();
        Method[] methodArray = object2;
        if (EasyPermissions.isUsingAndroidAnnotations(object)) {
            methodArray = ((Class)object2).getSuperclass();
        }
        methodArray = methodArray.getDeclaredMethods();
        int n4 = methodArray.length;
        while (n3 < n4) {
            object2 = methodArray[n3];
            if (((AccessibleObject)object2).isAnnotationPresent(AfterPermissionGranted.class) && ((Method)object2).getAnnotation(AfterPermissionGranted.class).value() == n2) {
                if (((Method)object2).getParameterTypes().length > 0) {
                    throw new RuntimeException("Cannot execute non-void method " + ((Method)object2).getName());
                }
                try {
                    if (!((AccessibleObject)object2).isAccessible()) {
                        ((Method)object2).setAccessible(true);
                    }
                    ((Method)object2).invoke(object, new Object[0]);
                }
                catch (IllegalAccessException illegalAccessException) {
                    e.a(TAG, "runDefaultMethod:IllegalAccessException", illegalAccessException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    e.a(TAG, "runDefaultMethod:InvocationTargetException", invocationTargetException);
                }
            }
            ++n3;
        }
        return;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @TargetApi(value=23)
    private static boolean shouldShowRequestPermissionRationale(Object object, String string2) {
        if (object instanceof Activity) {
            return ActivityCompat.shouldShowRequestPermissionRationale((Activity)((Activity)object), (String)string2);
        }
        if (object instanceof android.support.v4.app.Fragment) {
            return ((android.support.v4.app.Fragment)object).shouldShowRequestPermissionRationale(string2);
        }
        if (!(object instanceof Fragment)) return false;
        return ((Fragment)object).shouldShowRequestPermissionRationale(string2);
    }

    public static interface PermissionCallbacks
    extends ActivityCompat.OnRequestPermissionsResultCallback {
        public void onPermissionsDenied(int var1, List<String> var2);

        public void onPermissionsGranted(int var1, List<String> var2);
    }
}

