/*
 * Decompiled with CFR 0.152.
 */
package com.yintong.secure.widget;

import android.content.ContentResolver;
import android.os.Environment;
import android.os.SystemClock;
import android.provider.Settings;
import android.text.TextUtils;
import com.yintong.secure.widget.Cell;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class LockPatternUtils {
    public static final int FAILED_ATTEMPTS_BEFORE_RESET = 20;
    public static final int FAILED_ATTEMPTS_BEFORE_TIMEOUT = 5;
    public static final long FAILED_ATTEMPT_COUNTDOWN_INTERVAL_MS = 1000L;
    public static final long FAILED_ATTEMPT_TIMEOUT_MS = 30000L;
    private static final String LOCKOUT_ATTEMPT_DEADLINE = "lockscreen.lockoutattemptdeadline";
    private static final String LOCKOUT_PERMANENT_KEY = "lockscreen.lockedoutpermanently";
    private static final String LOCK_PATTERN_FILE = "/system/gesture.key";
    public static final int MIN_LOCK_PATTERN_SIZE = 4;
    public static final int MIN_PATTERN_REGISTER_FAIL = 3;
    private static final String PATTERN_EVER_CHOSEN = "lockscreen.patterneverchosen";
    private static final String TAG = "LockPatternUtils";
    private static String sLockPatternFilename;
    private final ContentResolver mContentResolver;

    public LockPatternUtils(ContentResolver contentResolver) {
        this.mContentResolver = contentResolver;
        if (sLockPatternFilename == null) {
            sLockPatternFilename = String.valueOf(Environment.getDataDirectory().getAbsolutePath()) + LOCK_PATTERN_FILE;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean getBoolean(String string2) {
        boolean bl2 = true;
        if (1 != Settings.System.getInt((ContentResolver)this.mContentResolver, (String)string2, (int)0)) return false;
        return bl2;
    }

    private long getLong(String string2, long l2) {
        return Settings.System.getLong((ContentResolver)this.mContentResolver, (String)string2, (long)l2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String lockPwd(List object) {
        if (object == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < object.size()) {
            int n3 = ((Cell)object.get(n2)).getRow();
            stringBuffer.append(((Cell)object.get(n2)).getColumn() + n3 * 3 + 1);
            ++n2;
        }
        return stringBuffer.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static byte[] patternToHash(List object) {
        if (object == null) {
            return null;
        }
        int n2 = object.size();
        byte[] byArray = new byte[n2];
        int n3 = 0;
        while (true) {
            if (n3 >= n2) {
                try {
                    return MessageDigest.getInstance("SHA-1").digest(byArray);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    return byArray;
                }
            }
            Cell cell = (Cell)object.get(n3);
            int n4 = cell.getRow();
            byArray[n3] = (byte)(cell.getColumn() + n4 * 3);
            ++n3;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String patternToString(List object) {
        if (object == null) {
            return "";
        }
        int n2 = object.size();
        byte[] byArray = new byte[n2];
        int n3 = 0;
        while (n3 < n2) {
            Cell cell = (Cell)object.get(n3);
            int n4 = cell.getRow();
            byArray[n3] = (byte)(cell.getColumn() + n4 * 3);
            ++n3;
        }
        return new String(byArray);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setBoolean(String string2, boolean bl2) {
        ContentResolver contentResolver = this.mContentResolver;
        int n2 = bl2 ? 1 : 0;
        Settings.System.putInt((ContentResolver)contentResolver, (String)string2, (int)n2);
    }

    private void setLong(String string2, long l2) {
        Settings.System.putLong((ContentResolver)this.mContentResolver, (String)string2, (long)l2);
    }

    public static List stringToPattern(String object) {
        ArrayList<Cell> arrayList = new ArrayList<Cell>();
        object = ((String)object).getBytes();
        int n2 = 0;
        while (n2 < ((Object)object).length) {
            Object object2 = object[n2];
            arrayList.add(Cell.of((int)(object2 / 3), (int)(object2 % 3)));
            ++n2;
        }
        return arrayList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean checkPattern(List list) {
        byte[] byArray;
        boolean bl2;
        block5: {
            bl2 = true;
            RandomAccessFile randomAccessFile = new RandomAccessFile(sLockPatternFilename, "r");
            byArray = new byte[(int)randomAccessFile.length()];
            int n2 = randomAccessFile.read(byArray, 0, byArray.length);
            randomAccessFile.close();
            if (n2 > 0) break block5;
            return bl2;
        }
        try {
            boolean bl3 = Arrays.equals(byArray, LockPatternUtils.patternToHash(list));
            return bl3;
        }
        catch (IOException iOException) {
            return bl2;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return bl2;
        }
    }

    public long getLockoutAttemptDeadline() {
        long l2;
        block3: {
            block2: {
                long l3;
                long l4 = this.getLong(LOCKOUT_ATTEMPT_DEADLINE, 0L);
                if (l4 < (l3 = SystemClock.elapsedRealtime())) break block2;
                l2 = l4;
                if (l4 <= l3 + 30000L) break block3;
            }
            l2 = 0L;
        }
        return l2;
    }

    public String getNextAlarm() {
        String string2;
        block3: {
            block2: {
                String string3 = Settings.System.getString((ContentResolver)this.mContentResolver, (String)"next_alarm_formatted");
                if (string3 == null) break block2;
                string2 = string3;
                if (!TextUtils.isEmpty((CharSequence)string3)) break block3;
            }
            string2 = null;
        }
        return string2;
    }

    public boolean isLockPatternEnabled() {
        return this.getBoolean("lock_pattern_autolock");
    }

    public boolean isPatternEverChosen() {
        return this.getBoolean(PATTERN_EVER_CHOSEN);
    }

    public boolean isPermanentlyLocked() {
        return this.getBoolean(LOCKOUT_PERMANENT_KEY);
    }

    public boolean isTactileFeedbackEnabled() {
        return this.getBoolean("lock_pattern_tactile_feedback_enabled");
    }

    public boolean isVisiblePatternEnabled() {
        return this.getBoolean("lock_pattern_visible_pattern");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveLockPattern(List list) {
        byte[] byArray = LockPatternUtils.patternToHash(list);
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(sLockPatternFilename, "rw");
            if (list == null) {
                randomAccessFile.setLength(0L);
            } else {
                randomAccessFile.write(byArray, 0, byArray.length);
            }
            randomAccessFile.close();
            this.setBoolean(PATTERN_EVER_CHOSEN, true);
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean savedPatternExists() {
        boolean bl2 = false;
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(sLockPatternFilename, "r");
            randomAccessFile.readByte();
            randomAccessFile.close();
            return true;
        }
        catch (IOException iOException) {
            return bl2;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return bl2;
        }
    }

    public void setLockPatternEnabled(boolean bl2) {
        this.setBoolean("lock_pattern_autolock", bl2);
    }

    public long setLockoutAttemptDeadline() {
        long l2 = SystemClock.elapsedRealtime() + 30000L;
        this.setLong(LOCKOUT_ATTEMPT_DEADLINE, l2);
        return l2;
    }

    public void setPermanentlyLocked(boolean bl2) {
        this.setBoolean(LOCKOUT_PERMANENT_KEY, bl2);
    }

    public void setTactileFeedbackEnabled(boolean bl2) {
        this.setBoolean("lock_pattern_tactile_feedback_enabled", bl2);
    }

    public void setVisiblePatternEnabled(boolean bl2) {
        this.setBoolean("lock_pattern_visible_pattern", bl2);
    }
}

