/*
 * Decompiled with CFR 0.152.
 */
package de.tavendo.autobahn;

import android.net.SSLCertificateSocketFactory;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import de.tavendo.autobahn.WebSocket;
import de.tavendo.autobahn.WebSocketConnection$1;
import de.tavendo.autobahn.WebSocketConnection$2;
import de.tavendo.autobahn.WebSocketConnection$3;
import de.tavendo.autobahn.WebSocketConnection$4;
import de.tavendo.autobahn.WebSocketException;
import de.tavendo.autobahn.WebSocketMessage;
import de.tavendo.autobahn.WebSocketOptions;
import de.tavendo.autobahn.WebSocketReader;
import de.tavendo.autobahn.WebSocketWriter;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.Socket;
import java.net.URI;
import javax.net.SocketFactory;

public class WebSocketConnection
implements WebSocket {
    private static final String TAG = WebSocketConnection.class.getName();
    private static final String WSS_URI_SCHEME = "wss";
    private static final String WS_READER = "WebSocketReader";
    private static final String WS_URI_SCHEME = "ws";
    private static final String WS_WRITER = "WebSocketWriter";
    private final Handler mHandler;
    private boolean mPreviousConnection = false;
    private Socket mSocket;
    private SocketThread mSocketThread;
    private WeakReference<WebSocket.WebSocketConnectionObserver> mWebSocketConnectionObserver;
    private WebSocketOptions mWebSocketOptions;
    private WebSocketReader mWebSocketReader;
    private String[] mWebSocketSubprotocols;
    private URI mWebSocketURI;
    private WebSocketWriter mWebSocketWriter;

    public WebSocketConnection() {
        Log.d((String)TAG, (String)"WebSocket connection created.");
        this.mHandler = new ThreadHandler(this);
    }

    static /* synthetic */ SocketThread access$2(WebSocketConnection webSocketConnection) {
        return webSocketConnection.mSocketThread;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void connect() {
        this.mSocketThread = new SocketThread(this.mWebSocketURI, this.mWebSocketOptions);
        this.mSocketThread.start();
        Object object = this.mSocketThread;
        synchronized (object) {
            try {
                this.mSocketThread.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.mSocketThread.getHandler().post((Runnable)new WebSocketConnection$3(this));
        object = this.mSocketThread;
        synchronized (object) {
            try {
                this.mSocketThread.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.mSocket = this.mSocketThread.getSocket();
        if (this.mSocket == null) {
            this.onClose(WebSocket.WebSocketConnectionObserver.WebSocketCloseNotification.CANNOT_CONNECT, this.mSocketThread.getFailureMessage());
            return;
        }
        if (!this.mSocket.isConnected()) {
            this.onClose(WebSocket.WebSocketConnectionObserver.WebSocketCloseNotification.CANNOT_CONNECT, "could not connect to WebSockets server");
            return;
        }
        try {
            this.createReader();
            this.createWriter();
            object = new WebSocketMessage.ClientHandshake(this.mWebSocketURI, null, this.mWebSocketSubprotocols);
            this.mWebSocketWriter.forward(object);
            return;
        }
        catch (Exception exception) {
            this.onClose(WebSocket.WebSocketConnectionObserver.WebSocketCloseNotification.INTERNAL_ERROR, exception.getLocalizedMessage());
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void failConnection(WebSocket.WebSocketConnectionObserver.WebSocketCloseNotification webSocketCloseNotification, String string2) {
        Log.d((String)TAG, (String)("fail connection [code = " + (Object)((Object)webSocketCloseNotification) + ", reason = " + string2));
        if (this.mWebSocketReader != null) {
            this.mWebSocketReader.quit();
            try {
                this.mWebSocketReader.join();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            Log.d((String)TAG, (String)"mReader already NULL");
        }
        if (this.mWebSocketWriter != null) {
            this.mWebSocketWriter.forward(new WebSocketMessage.Quit());
            try {
                this.mWebSocketWriter.join();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            Log.d((String)TAG, (String)"mWriter already NULL");
        }
        if (this.mSocket != null) {
            this.mSocketThread.getHandler().post((Runnable)new WebSocketConnection$1(this));
        } else {
            Log.d((String)TAG, (String)"mTransportChannel already NULL");
        }
        this.mSocketThread.getHandler().post((Runnable)new WebSocketConnection$2(this));
        this.onClose(webSocketCloseNotification, string2);
        Log.d((String)TAG, (String)"worker threads stopped");
    }

    /*
     * Enabled aggressive block sorting
     */
    private void handleMessage(Message object) {
        Object object2 = (WebSocket.WebSocketConnectionObserver)this.mWebSocketConnectionObserver.get();
        if (((Message)object).obj instanceof WebSocketMessage.TextMessage) {
            object = (WebSocketMessage.TextMessage)((Message)object).obj;
            if (object2 != null) {
                object2.onTextMessage(((WebSocketMessage.TextMessage)object).mPayload);
                return;
            }
            Log.d((String)TAG, (String)"could not call onTextMessage() .. handler already NULL");
            return;
        }
        if (((Message)object).obj instanceof WebSocketMessage.RawTextMessage) {
            object = (WebSocketMessage.RawTextMessage)((Message)object).obj;
            if (object2 != null) {
                object2.onRawTextMessage(((WebSocketMessage.RawTextMessage)object).mPayload);
                return;
            }
            Log.d((String)TAG, (String)"could not call onRawTextMessage() .. handler already NULL");
            return;
        }
        if (((Message)object).obj instanceof WebSocketMessage.BinaryMessage) {
            object = (WebSocketMessage.BinaryMessage)((Message)object).obj;
            if (object2 != null) {
                object2.onBinaryMessage(((WebSocketMessage.BinaryMessage)object).mPayload);
                return;
            }
            Log.d((String)TAG, (String)"could not call onBinaryMessage() .. handler already NULL");
            return;
        }
        if (((Message)object).obj instanceof WebSocketMessage.Ping) {
            object = (WebSocketMessage.Ping)((Message)object).obj;
            Log.d((String)TAG, (String)"WebSockets Ping received");
            object2 = new WebSocketMessage.Pong();
            ((WebSocketMessage.Pong)object2).mPayload = ((WebSocketMessage.Ping)object).mPayload;
            this.mWebSocketWriter.forward(object2);
            return;
        }
        if (((Message)object).obj instanceof WebSocketMessage.Pong) {
            object = (WebSocketMessage.Pong)((Message)object).obj;
            Log.d((String)TAG, (String)("WebSockets Pong received" + ((WebSocketMessage.Pong)object).mPayload));
            return;
        }
        if (((Message)object).obj instanceof WebSocketMessage.Close) {
            object = (WebSocketMessage.Close)((Message)object).obj;
            Log.d((String)TAG, (String)("WebSockets Close received (" + ((WebSocketMessage.Close)object).getCode() + " - " + ((WebSocketMessage.Close)object).getReason() + ")"));
            this.mWebSocketWriter.forward(new WebSocketMessage.Close(1000));
            return;
        }
        if (((Message)object).obj instanceof WebSocketMessage.ServerHandshake) {
            object = (WebSocketMessage.ServerHandshake)((Message)object).obj;
            Log.d((String)TAG, (String)"opening handshake received");
            if (!((WebSocketMessage.ServerHandshake)object).mSuccess) return;
            if (object2 != null) {
                object2.onOpen();
            } else {
                Log.d((String)TAG, (String)"could not call onOpen() .. handler already NULL");
            }
            this.mPreviousConnection = true;
            return;
        }
        if (((Message)object).obj instanceof WebSocketMessage.ConnectionLost) {
            this.failConnection(WebSocket.WebSocketConnectionObserver.WebSocketCloseNotification.CONNECTION_LOST, "WebSockets connection lost");
            return;
        }
        if (((Message)object).obj instanceof WebSocketMessage.ProtocolViolation) {
            this.failConnection(WebSocket.WebSocketConnectionObserver.WebSocketCloseNotification.PROTOCOL_ERROR, "WebSockets protocol violation");
            return;
        }
        if (((Message)object).obj instanceof WebSocketMessage.Error) {
            object = (WebSocketMessage.Error)((Message)object).obj;
            this.failConnection(WebSocket.WebSocketConnectionObserver.WebSocketCloseNotification.INTERNAL_ERROR, "WebSockets internal error (" + ((WebSocketMessage.Error)object).mException.toString() + ")");
            return;
        }
        if (((Message)object).obj instanceof WebSocketMessage.ServerError) {
            object = (WebSocketMessage.ServerError)((Message)object).obj;
            this.failConnection(WebSocket.WebSocketConnectionObserver.WebSocketCloseNotification.SERVER_ERROR, "Server error " + ((WebSocketMessage.ServerError)object).mStatusCode + " (" + ((WebSocketMessage.ServerError)object).mStatusMessage + ")");
            return;
        }
        this.processAppMessage(((Message)object).obj);
    }

    /*
     * Unable to fully structure code
     */
    private void onClose(WebSocket.WebSocketConnectionObserver.WebSocketCloseNotification var1_1, String var2_3) {
        block4: {
            if (var1_1 != WebSocket.WebSocketConnectionObserver.WebSocketCloseNotification.CANNOT_CONNECT && var1_1 != WebSocket.WebSocketConnectionObserver.WebSocketCloseNotification.CONNECTION_LOST) break block4;
            var3_4 = this.scheduleReconnect();
lbl3:
            // 2 sources

            while (true) {
                block5: {
                    var4_5 = (WebSocket.WebSocketConnectionObserver)this.mWebSocketConnectionObserver.get();
                    if (var4_5 == null) break block5;
                    if (!var3_4) ** GOTO lbl11
                    try {
                        var4_5.onClose(WebSocket.WebSocketConnectionObserver.WebSocketCloseNotification.RECONNECT, var2_3);
lbl9:
                        // 4 sources

                        return;
lbl11:
                        // 1 sources

                        var4_5.onClose(var1_1, var2_3);
                    }
                    catch (Exception var1_2) {
                        var1_2.printStackTrace();
                    }
                    ** GOTO lbl9
                }
                Log.d((String)WebSocketConnection.TAG, (String)"WebSocketObserver null");
                ** continue;
                break;
            }
        }
        var3_4 = false;
        ** while (true)
    }

    @Override
    public void connect(URI uRI, WebSocket.WebSocketConnectionObserver webSocketConnectionObserver) throws WebSocketException {
        this.connect(uRI, webSocketConnectionObserver, new WebSocketOptions());
    }

    @Override
    public void connect(URI uRI, WebSocket.WebSocketConnectionObserver webSocketConnectionObserver, WebSocketOptions webSocketOptions) throws WebSocketException {
        this.connect(uRI, null, webSocketConnectionObserver, webSocketOptions);
    }

    public void connect(URI uRI, String[] stringArray, WebSocket.WebSocketConnectionObserver webSocketConnectionObserver, WebSocketOptions webSocketOptions) throws WebSocketException {
        if (this.isConnected()) {
            throw new WebSocketException("already connected");
        }
        if (uRI == null) {
            throw new WebSocketException("WebSockets URI null.");
        }
        this.mWebSocketURI = uRI;
        if (!this.mWebSocketURI.getScheme().equals(WS_URI_SCHEME) && !this.mWebSocketURI.getScheme().equals(WSS_URI_SCHEME)) {
            throw new WebSocketException("unsupported scheme for WebSockets URI");
        }
        this.mWebSocketSubprotocols = stringArray;
        this.mWebSocketConnectionObserver = new WeakReference<WebSocket.WebSocketConnectionObserver>(webSocketConnectionObserver);
        this.mWebSocketOptions = new WebSocketOptions(webSocketOptions);
        this.connect();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void createReader() {
        this.mWebSocketReader = new WebSocketReader(this.mHandler, this.mSocket, this.mWebSocketOptions, WS_READER);
        this.mWebSocketReader.start();
        WebSocketReader webSocketReader = this.mWebSocketReader;
        synchronized (webSocketReader) {
            try {
                this.mWebSocketReader.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        Log.d((String)TAG, (String)"WebSocket reader created and started.");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void createWriter() {
        this.mWebSocketWriter = new WebSocketWriter(this.mHandler, this.mSocket, this.mWebSocketOptions, WS_WRITER);
        this.mWebSocketWriter.start();
        WebSocketWriter webSocketWriter = this.mWebSocketWriter;
        synchronized (webSocketWriter) {
            try {
                this.mWebSocketWriter.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        Log.d((String)TAG, (String)"WebSocket writer created and started.");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void disconnect() {
        if (this.mWebSocketWriter != null && this.mWebSocketWriter.isAlive()) {
            this.mWebSocketWriter.forward(new WebSocketMessage.Close());
        } else {
            Log.d((String)TAG, (String)"Could not send WebSocket Close .. writer already null");
        }
        this.mPreviousConnection = false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isConnected() {
        if (this.mSocket == null) return false;
        if (!this.mSocket.isConnected()) return false;
        if (this.mSocket.isClosed()) return false;
        return true;
    }

    protected void processAppMessage(Object object) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean reconnect() {
        if (this.isConnected()) return false;
        if (this.mWebSocketURI == null) return false;
        this.connect();
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean scheduleReconnect() {
        int n2 = this.mWebSocketOptions.getReconnectInterval();
        if (this.mSocket == null) return false;
        if (!this.mSocket.isConnected()) return false;
        if (!this.mPreviousConnection) return false;
        if (n2 <= 0) return false;
        boolean bl2 = true;
        if (!bl2) return bl2;
        Log.d((String)TAG, (String)"WebSocket reconnection scheduled");
        this.mHandler.postDelayed((Runnable)new WebSocketConnection$4(this), (long)n2);
        return bl2;
    }

    @Override
    public void sendBinaryMessage(byte[] byArray) {
        this.mWebSocketWriter.forward(new WebSocketMessage.BinaryMessage(byArray));
    }

    @Override
    public void sendRawTextMessage(byte[] byArray) {
        this.mWebSocketWriter.forward(new WebSocketMessage.RawTextMessage(byArray));
    }

    @Override
    public void sendTextMessage(String string2) {
        this.mWebSocketWriter.forward(new WebSocketMessage.TextMessage(string2));
    }

    public static class SocketThread
    extends Thread {
        private static final String WS_CONNECTOR = "WebSocketConnector";
        private String mFailureMessage = null;
        private Handler mHandler;
        private Socket mSocket = null;
        private final URI mWebSocketURI;

        public SocketThread(URI uRI, WebSocketOptions webSocketOptions) {
            this.setName(WS_CONNECTOR);
            this.mWebSocketURI = uRI;
        }

        public String getFailureMessage() {
            return this.mFailureMessage;
        }

        public Handler getHandler() {
            return this.mHandler;
        }

        public Socket getSocket() {
            return this.mSocket;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            Looper.prepare();
            this.mHandler = new Handler();
            synchronized (this) {
                this.notifyAll();
            }
            Looper.loop();
            Log.d((String)TAG, (String)"SocketThread exited.");
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void startConnection() {
            try {
                String string2 = this.mWebSocketURI.getHost();
                int n2 = this.mWebSocketURI.getPort();
                if (n2 == -1) {
                    n2 = this.mWebSocketURI.getScheme().equals(WebSocketConnection.WSS_URI_SCHEME) ? 443 : 80;
                }
                SocketFactory socketFactory = this.mWebSocketURI.getScheme().equalsIgnoreCase(WebSocketConnection.WSS_URI_SCHEME) ? SSLCertificateSocketFactory.getDefault() : SocketFactory.getDefault();
                this.mSocket = socketFactory.createSocket(string2, n2);
            }
            catch (IOException iOException) {
                this.mFailureMessage = iOException.getLocalizedMessage();
            }
            synchronized (this) {
                this.notifyAll();
                return;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void stopConnection() {
            try {
                this.mSocket.close();
                this.mSocket = null;
                return;
            }
            catch (IOException iOException) {
                this.mFailureMessage = iOException.getLocalizedMessage();
                return;
            }
        }
    }

    private static class ThreadHandler
    extends Handler {
        private final WeakReference<WebSocketConnection> mWebSocketConnection;

        public ThreadHandler(WebSocketConnection webSocketConnection) {
            this.mWebSocketConnection = new WeakReference<WebSocketConnection>(webSocketConnection);
        }

        public void handleMessage(Message message) {
            WebSocketConnection webSocketConnection = (WebSocketConnection)this.mWebSocketConnection.get();
            if (webSocketConnection != null) {
                webSocketConnection.handleMessage(message);
            }
        }
    }
}

