/*
 * Decompiled with CFR 0.152.
 */
package me.henrytao.smoothappbarlayout.base;

import android.support.annotation.NonNull;
import android.support.v4.widget.NestedScrollView;
import android.view.View;
import android.view.ViewTreeObserver;
import me.henrytao.smoothappbarlayout.R;
import me.henrytao.smoothappbarlayout.base.Observer;
import me.henrytao.smoothappbarlayout.base.OnScrollListener;
import me.henrytao.smoothappbarlayout.base.Utils;
import me.henrytao.smoothappbarlayout.widget.NestedScrollView;

public class ObservableNestedScrollView
implements NestedScrollView.OnScrollChangeListener,
Observer {
    private android.support.v4.widget.NestedScrollView mNestedScrollView;
    private OnScrollListener mOnScrollListener;
    private boolean mOverrideOnScrollListener;

    public ObservableNestedScrollView(@NonNull android.support.v4.widget.NestedScrollView nestedScrollView, boolean bl2) {
        this.mNestedScrollView = nestedScrollView;
        this.mOverrideOnScrollListener = bl2;
        if (this.mNestedScrollView.getTag(R.id.tag_observable_view) == null) {
            this.mNestedScrollView.setTag(R.id.tag_observable_view, (Object)true);
            this.init();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void init() {
        if (this.mNestedScrollView instanceof NestedScrollView) {
            ((NestedScrollView)this.mNestedScrollView).addOnScrollListener(this);
            return;
        }
        if (this.mOverrideOnScrollListener) {
            this.mNestedScrollView.setOnScrollChangeListener((NestedScrollView.OnScrollChangeListener)this);
            return;
        }
        this.mNestedScrollView.getViewTreeObserver().addOnScrollChangedListener(new ViewTreeObserver.OnScrollChangedListener(){

            public void onScrollChanged() {
                if (ObservableNestedScrollView.this.mOnScrollListener != null) {
                    int n2 = ObservableNestedScrollView.this.mNestedScrollView.getScrollX();
                    int n3 = ObservableNestedScrollView.this.mNestedScrollView.getScrollY();
                    ObservableNestedScrollView.this.mOnScrollListener.onScrollChanged((View)ObservableNestedScrollView.this.mNestedScrollView, n2, n3, n2 - Utils.parseInt(ObservableNestedScrollView.this.mNestedScrollView.getTag(R.id.tag_observable_view_last_scroll_x)), n3 - Utils.parseInt(ObservableNestedScrollView.this.mNestedScrollView.getTag(R.id.tag_observable_view_last_scroll_y)), true);
                    ObservableNestedScrollView.this.mNestedScrollView.setTag(R.id.tag_observable_view_last_scroll_x, (Object)n2);
                    ObservableNestedScrollView.this.mNestedScrollView.setTag(R.id.tag_observable_view_last_scroll_y, (Object)n3);
                }
            }
        });
    }

    public static ObservableNestedScrollView newInstance(@NonNull android.support.v4.widget.NestedScrollView object, boolean bl2, OnScrollListener onScrollListener) {
        object = new ObservableNestedScrollView((android.support.v4.widget.NestedScrollView)object, bl2);
        ((ObservableNestedScrollView)object).setOnScrollListener(onScrollListener);
        return object;
    }

    @Override
    public View getView() {
        return this.mNestedScrollView;
    }

    public void onScrollChange(android.support.v4.widget.NestedScrollView nestedScrollView, int n2, int n3, int n4, int n5) {
        if (this.mOnScrollListener != null) {
            this.mOnScrollListener.onScrollChanged((View)this.mNestedScrollView, n2, n3, n2 - n4, n3 - n5, true);
        }
    }

    @Override
    public void setOnScrollListener(OnScrollListener onScrollListener) {
        this.mOnScrollListener = onScrollListener;
    }
}

