/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.runtime.internal.cflowstack;

import java.util.ArrayList;
import java.util.Hashtable;
import org.aspectj.runtime.internal.cflowstack.ThreadCounter;

public class ThreadCounterImpl11
implements ThreadCounter {
    private static final int COLLECT_AT = 20000;
    private static final int MIN_COLLECT_AT = 100;
    private Counter cached_counter;
    private Thread cached_thread;
    private int change_count = 0;
    private Hashtable counters = new Hashtable();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Counter getThreadCounter() {
        synchronized (this) {
            Object object;
            if (Thread.currentThread() == this.cached_thread) return this.cached_counter;
            this.cached_thread = Thread.currentThread();
            this.cached_counter = (Counter)this.counters.get(this.cached_thread);
            if (this.cached_counter == null) {
                object = new Counter();
                this.cached_counter = object;
                this.counters.put(this.cached_thread, this.cached_counter);
            }
            ++this.change_count;
            int n2 = Math.max(1, this.counters.size());
            if (this.change_count <= Math.max(100, 20000 / n2)) return this.cached_counter;
            object = new ArrayList();
            Object object2 = this.counters.keys();
            while (object2.hasMoreElements()) {
                Thread thread = (Thread)object2.nextElement();
                if (thread.isAlive()) continue;
                object.add(thread);
            }
            object = object.iterator();
            while (object.hasNext()) {
                object2 = (Thread)object.next();
                this.counters.remove(object2);
            }
            this.change_count = 0;
            return this.cached_counter;
        }
    }

    @Override
    public void dec() {
        Counter counter = this.getThreadCounter();
        --counter.value;
    }

    @Override
    public void inc() {
        Counter counter = this.getThreadCounter();
        ++counter.value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isNotZero() {
        if (this.getThreadCounter().value == 0) return false;
        return true;
    }

    @Override
    public void removeThreadCounter() {
    }

    static class Counter {
        protected int value = 0;

        Counter() {
        }
    }
}

