/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.runtime.reflect;

import java.lang.ref.SoftReference;
import java.util.StringTokenizer;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.aspectj.runtime.reflect.StringMaker;

abstract class SignatureImpl
implements Signature {
    static Class[] EMPTY_CLASS_ARRAY;
    static String[] EMPTY_STRING_ARRAY;
    static final String INNER_SEP = ":";
    static final char SEP = '-';
    private static boolean useCache;
    Class declaringType;
    String declaringTypeName;
    ClassLoader lookupClassLoader = null;
    int modifiers = -1;
    String name;
    Cache stringCache;
    private String stringRep;

    static {
        useCache = true;
        EMPTY_STRING_ARRAY = new String[0];
        EMPTY_CLASS_ARRAY = new Class[0];
    }

    SignatureImpl(int n2, String string2, Class clazz) {
        this.modifiers = n2;
        this.name = string2;
        this.declaringType = clazz;
    }

    public SignatureImpl(String string2) {
        this.stringRep = string2;
    }

    private ClassLoader getLookupClassLoader() {
        if (this.lookupClassLoader == null) {
            this.lookupClassLoader = this.getClass().getClassLoader();
        }
        return this.lookupClassLoader;
    }

    static boolean getUseCache() {
        return useCache;
    }

    static void setUseCache(boolean bl2) {
        useCache = bl2;
    }

    void addFullTypeNames(StringBuffer stringBuffer, Class[] classArray) {
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            if (i2 > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.fullTypeName(classArray[i2]));
        }
    }

    void addShortTypeNames(StringBuffer stringBuffer, Class[] classArray) {
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            if (i2 > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.shortTypeName(classArray[i2]));
        }
    }

    void addTypeArray(StringBuffer stringBuffer, Class[] classArray) {
        this.addFullTypeNames(stringBuffer, classArray);
    }

    protected abstract String createToString(StringMaker var1);

    int extractInt(int n2) {
        return Integer.parseInt(this.extractString(n2), 16);
    }

    String extractString(int n2) {
        int n3 = 0;
        int n4 = this.stringRep.indexOf(45);
        int n5 = n2;
        n2 = n4;
        while (n5 > 0) {
            n3 = n2 + 1;
            n2 = this.stringRep.indexOf(45, n3);
            --n5;
        }
        n5 = n2;
        if (n2 == -1) {
            n5 = this.stringRep.length();
        }
        return this.stringRep.substring(n3, n5);
    }

    String[] extractStrings(int n2) {
        StringTokenizer stringTokenizer = new StringTokenizer(this.extractString(n2), INNER_SEP);
        int n3 = stringTokenizer.countTokens();
        String[] stringArray = new String[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            stringArray[n2] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    Class extractType(int n2) {
        return Factory.makeClass(this.extractString(n2), this.getLookupClassLoader());
    }

    Class[] extractTypes(int n2) {
        StringTokenizer stringTokenizer = new StringTokenizer(this.extractString(n2), INNER_SEP);
        int n3 = stringTokenizer.countTokens();
        Class[] classArray = new Class[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            classArray[n2] = Factory.makeClass(stringTokenizer.nextToken(), this.getLookupClassLoader());
        }
        return classArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    String fullTypeName(Class object) {
        if (object == null) {
            return "ANONYMOUS";
        }
        if (!((Class)object).isArray()) return ((Class)object).getName().replace('$', '.');
        return new StringBuffer().append(this.fullTypeName(((Class)object).getComponentType())).append("[]").toString();
    }

    @Override
    public Class getDeclaringType() {
        if (this.declaringType == null) {
            this.declaringType = this.extractType(2);
        }
        return this.declaringType;
    }

    @Override
    public String getDeclaringTypeName() {
        if (this.declaringTypeName == null) {
            this.declaringTypeName = this.getDeclaringType().getName();
        }
        return this.declaringTypeName;
    }

    @Override
    public int getModifiers() {
        if (this.modifiers == -1) {
            this.modifiers = this.extractInt(0);
        }
        return this.modifiers;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            this.name = this.extractString(1);
        }
        return this.name;
    }

    public void setLookupClassLoader(ClassLoader classLoader) {
        this.lookupClassLoader = classLoader;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    String shortTypeName(Class object) {
        if (object == null) {
            return "ANONYMOUS";
        }
        if (!((Class)object).isArray()) return this.stripPackageName(((Class)object).getName()).replace('$', '.');
        return new StringBuffer().append(this.shortTypeName(((Class)object).getComponentType())).append("[]").toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    String stripPackageName(String string2) {
        int n2 = string2.lastIndexOf(46);
        if (n2 != -1) return string2.substring(n2 + 1);
        return string2;
    }

    @Override
    public final String toLongString() {
        return this.toString(StringMaker.longStringMaker);
    }

    @Override
    public final String toShortString() {
        return this.toString(StringMaker.shortStringMaker);
    }

    @Override
    public final String toString() {
        return this.toString(StringMaker.middleStringMaker);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    String toString(StringMaker stringMaker) {
        Object object;
        Object object2 = object = null;
        if (useCache) {
            if (this.stringCache == null) {
                try {
                    this.stringCache = object2 = new CacheImpl();
                    object2 = object;
                }
                catch (Throwable throwable) {
                    useCache = false;
                    object2 = object;
                }
            } else {
                object2 = this.stringCache.get(stringMaker.cacheOffset);
            }
        }
        object = object2;
        if (object2 == null) {
            object = this.createToString(stringMaker);
        }
        if (useCache) {
            this.stringCache.set(stringMaker.cacheOffset, (String)object);
        }
        return object;
    }

    private static interface Cache {
        public String get(int var1);

        public void set(int var1, String var2);
    }

    private static final class CacheImpl
    implements Cache {
        private SoftReference toStringCacheRef;

        public CacheImpl() {
            this.makeCache();
        }

        private String[] array() {
            return (String[])this.toStringCacheRef.get();
        }

        private String[] makeCache() {
            String[] stringArray = new String[3];
            this.toStringCacheRef = new SoftReference<String[]>(stringArray);
            return stringArray;
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public String get(int n2) {
            void var2_4;
            String[] stringArray = this.array();
            if (stringArray == null) {
                return var2_4;
            }
            String string2 = stringArray[n2];
            return var2_4;
        }

        @Override
        public void set(int n2, String string2) {
            String[] stringArray;
            String[] stringArray2 = stringArray = this.array();
            if (stringArray == null) {
                stringArray2 = this.makeCache();
            }
            stringArray2[n2] = string2;
        }
    }
}

