/*
 * Decompiled with CFR 0.152.
 */
package org.wrtc;

import java.nio.ByteBuffer;

public class DataChannel {
    private final long nativeDataChannel;
    private long nativeObserver;

    public DataChannel(long l2) {
        this.nativeDataChannel = l2;
    }

    private native long registerObserverNative(Observer var1);

    private native boolean sendNative(byte[] var1, boolean var2);

    private native void unregisterObserverNative(long var1);

    public native long bufferedAmount();

    public native void close();

    public native void dispose();

    public native String label();

    public void registerObserver(Observer observer) {
        if (this.nativeObserver != 0L) {
            this.unregisterObserverNative(this.nativeObserver);
        }
        this.nativeObserver = this.registerObserverNative(observer);
    }

    public boolean send(Buffer buffer) {
        byte[] byArray = new byte[buffer.data.remaining()];
        buffer.data.get(byArray);
        return this.sendNative(byArray, buffer.binary);
    }

    public native State state();

    public void unregisterObserver() {
        this.unregisterObserverNative(this.nativeObserver);
    }

    public static class Buffer {
        public final boolean binary;
        public final ByteBuffer data;

        public Buffer(ByteBuffer byteBuffer, boolean bl2) {
            this.data = byteBuffer;
            this.binary = bl2;
        }
    }

    public static class Init {
        public int id = -1;
        public int maxRetransmitTimeMs = -1;
        public int maxRetransmits = -1;
        public boolean negotiated = false;
        public boolean ordered = true;
        public String protocol = "";

        public Init() {
        }

        private Init(boolean bl2, int n2, int n3, String string2, boolean bl3, int n4) {
            this.ordered = bl2;
            this.maxRetransmitTimeMs = n2;
            this.maxRetransmits = n3;
            this.protocol = string2;
            this.negotiated = bl3;
            this.id = n4;
        }
    }

    public static interface Observer {
        public void onBufferedAmountChange(long var1);

        public void onMessage(Buffer var1);

        public void onStateChange();
    }

    public static enum State {
        CONNECTING,
        OPEN,
        CLOSING,
        CLOSED;

    }
}

