/*
 * Decompiled with CFR 0.152.
 */
package org.wrtc;

import android.annotation.TargetApi;
import android.graphics.SurfaceTexture;
import android.opengl.EGL14;
import android.opengl.EGLConfig;
import android.opengl.EGLContext;
import android.opengl.EGLDisplay;
import android.opengl.EGLExt;
import android.opengl.EGLSurface;
import android.os.Build;
import android.view.Surface;
import org.wrtc.EglBase;
import org.wrtc.Logging;

@TargetApi(value=18)
public final class EglBase14
extends EglBase {
    private static final int CURRENT_SDK_VERSION = Build.VERSION.SDK_INT;
    private static final int EGLExt_SDK_VERSION = 18;
    private static final String TAG = "EglBase14";
    private EGLConfig eglConfig;
    private EGLContext eglContext;
    private EGLDisplay eglDisplay;
    private EGLSurface eglSurface = EGL14.EGL_NO_SURFACE;

    public EglBase14(Context context, int[] nArray) {
        this.eglDisplay = EglBase14.getEglDisplay();
        this.eglConfig = EglBase14.getEglConfig(this.eglDisplay, nArray);
        this.eglContext = EglBase14.createEglContext(context, this.eglDisplay, this.eglConfig);
    }

    private void checkIsNotReleased() {
        if (this.eglDisplay == EGL14.EGL_NO_DISPLAY || this.eglContext == EGL14.EGL_NO_CONTEXT || this.eglConfig == null) {
            throw new RuntimeException("This object has been released");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static EGLContext createEglContext(Context context, EGLDisplay eGLDisplay, EGLConfig eGLConfig) {
        if (context != null && context.egl14Context == EGL14.EGL_NO_CONTEXT) {
            throw new RuntimeException("Invalid sharedContext");
        }
        context = context == null ? EGL14.EGL_NO_CONTEXT : context.egl14Context;
        Object object = EglBase.lock;
        // MONITORENTER : object
        context = EGL14.eglCreateContext((EGLDisplay)eGLDisplay, (EGLConfig)eGLConfig, (EGLContext)context, (int[])new int[]{12440, 2, 12344}, (int)0);
        // MONITOREXIT : object
        if (context != EGL14.EGL_NO_CONTEXT) return context;
        throw new RuntimeException("Failed to create EGL context: 0x" + Integer.toHexString(EGL14.eglGetError()));
    }

    private void createSurfaceInternal(Object object) {
        if (!(object instanceof Surface) && !(object instanceof SurfaceTexture)) {
            throw new IllegalStateException("Input must be either a Surface or SurfaceTexture");
        }
        this.checkIsNotReleased();
        if (this.eglSurface != EGL14.EGL_NO_SURFACE) {
            throw new RuntimeException("Already has an EGLSurface");
        }
        this.eglSurface = EGL14.eglCreateWindowSurface((EGLDisplay)this.eglDisplay, (EGLConfig)this.eglConfig, (Object)object, (int[])new int[]{12344}, (int)0);
        if (this.eglSurface == EGL14.EGL_NO_SURFACE) {
            throw new RuntimeException("Failed to create window surface: 0x" + Integer.toHexString(EGL14.eglGetError()));
        }
    }

    private static EGLConfig getEglConfig(EGLDisplay eGLDisplay, int[] nArray) {
        EGLConfig[] eGLConfigArray = new EGLConfig[1];
        int[] nArray2 = new int[1];
        if (!EGL14.eglChooseConfig((EGLDisplay)eGLDisplay, (int[])nArray, (int)0, (EGLConfig[])eGLConfigArray, (int)0, (int)eGLConfigArray.length, (int[])nArray2, (int)0)) {
            throw new RuntimeException("eglChooseConfig failed: 0x" + Integer.toHexString(EGL14.eglGetError()));
        }
        if (nArray2[0] <= 0) {
            throw new RuntimeException("Unable to find any matching EGL config");
        }
        eGLDisplay = eGLConfigArray[0];
        if (eGLDisplay == null) {
            throw new RuntimeException("eglChooseConfig returned null");
        }
        return eGLDisplay;
    }

    private static EGLDisplay getEglDisplay() {
        EGLDisplay eGLDisplay = EGL14.eglGetDisplay((int)0);
        if (eGLDisplay == EGL14.EGL_NO_DISPLAY) {
            throw new RuntimeException("Unable to get EGL14 display: 0x" + Integer.toHexString(EGL14.eglGetError()));
        }
        int[] nArray = new int[2];
        if (!EGL14.eglInitialize((EGLDisplay)eGLDisplay, (int[])nArray, (int)0, (int[])nArray, (int)1)) {
            throw new RuntimeException("Unable to initialize EGL14: 0x" + Integer.toHexString(EGL14.eglGetError()));
        }
        return eGLDisplay;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean isEGL14Supported() {
        boolean bl2 = true;
        StringBuilder stringBuilder = new StringBuilder().append("SDK version: ").append(CURRENT_SDK_VERSION).append(". isEGL14Supported: ");
        boolean bl3 = CURRENT_SDK_VERSION >= 18;
        Logging.d(TAG, stringBuilder.append(bl3).toString());
        if (CURRENT_SDK_VERSION < 18) return false;
        return bl2;
    }

    @Override
    public void createDummyPbufferSurface() {
        this.createPbufferSurface(1, 1);
    }

    @Override
    public void createPbufferSurface(int n2, int n3) {
        this.checkIsNotReleased();
        if (this.eglSurface != EGL14.EGL_NO_SURFACE) {
            throw new RuntimeException("Already has an EGLSurface");
        }
        this.eglSurface = EGL14.eglCreatePbufferSurface((EGLDisplay)this.eglDisplay, (EGLConfig)this.eglConfig, (int[])new int[]{12375, n2, 12374, n3, 12344}, (int)0);
        if (this.eglSurface == EGL14.EGL_NO_SURFACE) {
            throw new RuntimeException("Failed to create pixel buffer surface with size " + n2 + "x" + n3 + ": 0x" + Integer.toHexString(EGL14.eglGetError()));
        }
    }

    @Override
    public void createSurface(SurfaceTexture surfaceTexture) {
        this.createSurfaceInternal(surfaceTexture);
    }

    @Override
    public void createSurface(Surface surface) {
        this.createSurfaceInternal(surface);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void detachCurrent() {
        Object object = EglBase.lock;
        synchronized (object) {
            if (!EGL14.eglMakeCurrent((EGLDisplay)this.eglDisplay, (EGLSurface)EGL14.EGL_NO_SURFACE, (EGLSurface)EGL14.EGL_NO_SURFACE, (EGLContext)EGL14.EGL_NO_CONTEXT)) {
                StringBuilder stringBuilder = new StringBuilder();
                RuntimeException runtimeException = new RuntimeException(stringBuilder.append("eglDetachCurrent failed: 0x").append(Integer.toHexString(EGL14.eglGetError())).toString());
                throw runtimeException;
            }
            return;
        }
    }

    @Override
    public Context getEglBaseContext() {
        return new Context(this.eglContext);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean hasSurface() {
        if (this.eglSurface == EGL14.EGL_NO_SURFACE) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void makeCurrent() {
        this.checkIsNotReleased();
        if (this.eglSurface == EGL14.EGL_NO_SURFACE) {
            throw new RuntimeException("No EGLSurface - can't make current");
        }
        Object object = EglBase.lock;
        synchronized (object) {
            if (!EGL14.eglMakeCurrent((EGLDisplay)this.eglDisplay, (EGLSurface)this.eglSurface, (EGLSurface)this.eglSurface, (EGLContext)this.eglContext)) {
                StringBuilder stringBuilder = new StringBuilder();
                RuntimeException runtimeException = new RuntimeException(stringBuilder.append("eglMakeCurrent failed: 0x").append(Integer.toHexString(EGL14.eglGetError())).toString());
                throw runtimeException;
            }
            return;
        }
    }

    @Override
    public void release() {
        this.checkIsNotReleased();
        this.releaseSurface();
        this.detachCurrent();
        EGL14.eglDestroyContext((EGLDisplay)this.eglDisplay, (EGLContext)this.eglContext);
        EGL14.eglReleaseThread();
        EGL14.eglTerminate((EGLDisplay)this.eglDisplay);
        this.eglContext = EGL14.EGL_NO_CONTEXT;
        this.eglDisplay = EGL14.EGL_NO_DISPLAY;
        this.eglConfig = null;
    }

    @Override
    public void releaseSurface() {
        if (this.eglSurface != EGL14.EGL_NO_SURFACE) {
            EGL14.eglDestroySurface((EGLDisplay)this.eglDisplay, (EGLSurface)this.eglSurface);
            this.eglSurface = EGL14.EGL_NO_SURFACE;
        }
    }

    @Override
    public int surfaceHeight() {
        int[] nArray = new int[1];
        EGL14.eglQuerySurface((EGLDisplay)this.eglDisplay, (EGLSurface)this.eglSurface, (int)12374, (int[])nArray, (int)0);
        return nArray[0];
    }

    @Override
    public int surfaceWidth() {
        int[] nArray = new int[1];
        EGL14.eglQuerySurface((EGLDisplay)this.eglDisplay, (EGLSurface)this.eglSurface, (int)12375, (int[])nArray, (int)0);
        return nArray[0];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void swapBuffers() {
        this.checkIsNotReleased();
        if (this.eglSurface == EGL14.EGL_NO_SURFACE) {
            throw new RuntimeException("No EGLSurface - can't swap buffers");
        }
        Object object = EglBase.lock;
        synchronized (object) {
            EGL14.eglSwapBuffers((EGLDisplay)this.eglDisplay, (EGLSurface)this.eglSurface);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void swapBuffers(long l2) {
        this.checkIsNotReleased();
        if (this.eglSurface == EGL14.EGL_NO_SURFACE) {
            throw new RuntimeException("No EGLSurface - can't swap buffers");
        }
        Object object = EglBase.lock;
        synchronized (object) {
            EGLExt.eglPresentationTimeANDROID((EGLDisplay)this.eglDisplay, (EGLSurface)this.eglSurface, (long)l2);
            EGL14.eglSwapBuffers((EGLDisplay)this.eglDisplay, (EGLSurface)this.eglSurface);
            return;
        }
    }

    public static class Context
    extends EglBase.Context {
        private final EGLContext egl14Context;

        public Context(EGLContext eGLContext) {
            this.egl14Context = eGLContext;
        }
    }
}

