/*
 * Decompiled with CFR 0.152.
 */
package org.wrtc;

import android.opengl.GLES20;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.view.Surface;
import java.util.concurrent.CountDownLatch;
import org.wrtc.EglBase;
import org.wrtc.EglRenderer$1;
import org.wrtc.EglRenderer$2;
import org.wrtc.EglRenderer$3;
import org.wrtc.EglRenderer$4;
import org.wrtc.EglRenderer$5;
import org.wrtc.GlUtil;
import org.wrtc.Logging;
import org.wrtc.RendererCommon;
import org.wrtc.ThreadUtils;
import org.wrtc.VideoRenderer;

public class EglRenderer
implements VideoRenderer.Callbacks {
    private static final int MAX_SURFACE_CLEAR_COUNT = 3;
    private static final String TAG = "EglRenderer";
    private RendererCommon.GlDrawer drawer;
    private EglBase eglBase;
    private final EglSurfaceCreation eglSurfaceCreationRunnable;
    private long firstFrameTimeNs;
    private final Object frameLock;
    private int framesDropped;
    private int framesReceived;
    private int framesRendered;
    private final Object handlerLock = new Object();
    private float layoutAspectRatio;
    private final Object layoutLock;
    private boolean mirror;
    private final String name;
    private VideoRenderer.I420Frame pendingFrame;
    private final Runnable renderFrameRunnable;
    private Handler renderThreadHandler;
    private long renderTimeNs;
    private final Object statisticsLock;
    private int surfaceHeight;
    private int surfaceWidth;
    private int[] yuvTextures = null;
    private final RendererCommon.YuvUploader yuvUploader = new RendererCommon.YuvUploader();

    public EglRenderer(String string2) {
        this.frameLock = new Object();
        this.layoutLock = new Object();
        this.statisticsLock = new Object();
        this.renderFrameRunnable = new EglRenderer$1(this);
        this.eglSurfaceCreationRunnable = new EglSurfaceCreation(null);
        this.name = string2;
    }

    static /* synthetic */ EglBase access$002(EglRenderer eglRenderer, EglBase eglBase) {
        eglRenderer.eglBase = eglBase;
        return eglBase;
    }

    static /* synthetic */ void access$100(EglRenderer eglRenderer) {
        eglRenderer.renderFrameOnRenderThread();
    }

    static /* synthetic */ RendererCommon.GlDrawer access$300(EglRenderer eglRenderer) {
        return eglRenderer.drawer;
    }

    static /* synthetic */ RendererCommon.GlDrawer access$302(EglRenderer eglRenderer, RendererCommon.GlDrawer glDrawer) {
        eglRenderer.drawer = glDrawer;
        return glDrawer;
    }

    static /* synthetic */ int[] access$400(EglRenderer eglRenderer) {
        return eglRenderer.yuvTextures;
    }

    static /* synthetic */ int[] access$402(EglRenderer eglRenderer, int[] nArray) {
        eglRenderer.yuvTextures = nArray;
        return nArray;
    }

    static /* synthetic */ void access$500(EglRenderer eglRenderer, String string2) {
        eglRenderer.logD(string2);
    }

    private void logD(String string2) {
        Logging.d(TAG, this.name + string2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void logStatistics() {
        Object object = this.statisticsLock;
        synchronized (object) {
            StringBuilder stringBuilder = new StringBuilder();
            this.logD(stringBuilder.append("Frames received: ").append(this.framesReceived).append(". Dropped: ").append(this.framesDropped).append(". Rendered: ").append(this.framesRendered).toString());
            if (this.framesReceived > 0 && this.framesRendered > 0) {
                long l2 = System.nanoTime() - this.firstFrameTimeNs;
                stringBuilder = new StringBuilder();
                this.logD(stringBuilder.append("Duration: ").append((int)((double)l2 / 1000000.0)).append(" ms. FPS: ").append((double)this.framesRendered * 1.0E9 / (double)l2).toString());
                stringBuilder = new StringBuilder();
                this.logD(stringBuilder.append("Average render time: ").append((int)(this.renderTimeNs / (long)(this.framesRendered * 1000))).append(" us.").toString());
            }
            return;
        }
    }

    private void makeBlack() {
        if (this.eglBase != null && this.eglBase.hasSurface()) {
            this.logD("clearSurface");
            GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            GLES20.glClear((int)16384);
            this.eglBase.swapBuffers();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void renderFrameOnRenderThread() {
        Object object = this.frameLock;
        // MONITORENTER : object
        if (this.pendingFrame == null) {
            // MONITOREXIT : object
            return;
        }
        VideoRenderer.I420Frame i420Frame = this.pendingFrame;
        this.pendingFrame = null;
        // MONITOREXIT : object
        if (this.eglBase == null || !this.eglBase.hasSurface()) {
            this.logD("Dropping frame - No surface");
            VideoRenderer.renderFrameDone(i420Frame);
            return;
        }
        long l2 = System.nanoTime();
        float[] fArray = RendererCommon.rotateTextureMatrix((float[])i420Frame.samplingMatrix, (float)i420Frame.rotationDegree);
        Object object2 = this.layoutLock;
        // MONITORENTER : object2
        int n2 = 0;
        while (this.eglBase.surfaceWidth() != this.surfaceWidth || this.eglBase.surfaceHeight() != this.surfaceHeight) {
            if (++n2 > 3) {
                this.logD("Failed to get surface of expected size - dropping frame.");
                VideoRenderer.renderFrameDone(i420Frame);
                // MONITOREXIT : object2
                return;
            }
            this.logD("Surface size mismatch - clearing surface.");
            this.makeBlack();
        }
        object = this.layoutAspectRatio > 0.0f ? (Object)RendererCommon.getLayoutMatrix((boolean)this.mirror, (float)((float)i420Frame.rotatedWidth() / (float)i420Frame.rotatedHeight()), (float)this.layoutAspectRatio) : (this.mirror ? (Object)RendererCommon.horizontalFlipMatrix() : (Object)RendererCommon.identityMatrix());
        object = RendererCommon.multiplyMatrices((float[])fArray, (float[])object);
        // MONITOREXIT : object2
        GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GLES20.glClear((int)16384);
        if (i420Frame.yuvFrame) {
            if (this.yuvTextures == null) {
                this.yuvTextures = new int[3];
                for (n2 = 0; n2 < 3; ++n2) {
                    this.yuvTextures[n2] = GlUtil.generateTexture(3553);
                }
            }
            this.yuvUploader.uploadYuvData(this.yuvTextures, i420Frame.width, i420Frame.height, i420Frame.yuvStrides, i420Frame.yuvPlanes);
            this.drawer.drawYuv(this.yuvTextures, (float[])object, i420Frame.rotatedWidth(), i420Frame.rotatedHeight(), 0, 0, this.surfaceWidth, this.surfaceHeight);
        } else {
            this.drawer.drawOes(i420Frame.textureId, (float[])object, i420Frame.rotatedWidth(), i420Frame.rotatedHeight(), 0, 0, this.surfaceWidth, this.surfaceHeight);
        }
        this.eglBase.swapBuffers();
        VideoRenderer.renderFrameDone(i420Frame);
        object = this.statisticsLock;
        // MONITORENTER : object
        if (this.framesRendered == 0) {
            this.firstFrameTimeNs = l2;
        }
        ++this.framesRendered;
        this.renderTimeNs += System.nanoTime() - l2;
        if (this.framesRendered % 300 == 0) {
            this.logStatistics();
        }
        // MONITOREXIT : object
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void runOnRenderThread(Runnable runnable) {
        Object object = this.handlerLock;
        synchronized (object) {
            if (this.renderThreadHandler != null) {
                this.renderThreadHandler.post(runnable);
            }
            return;
        }
    }

    public void createEglSurface(Surface surface) {
        this.eglSurfaceCreationRunnable.setSurface(surface);
        this.runOnRenderThread(this.eglSurfaceCreationRunnable);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void init(EglBase.Context object, int[] object2, RendererCommon.GlDrawer glDrawer) {
        Object object3 = this.handlerLock;
        synchronized (object3) {
            if (this.renderThreadHandler != null) {
                object2 = new StringBuilder;
                ((StringBuilder)object2)();
                object = new IllegalStateException(((StringBuilder)object2).append(this.name).append("Already initialized").toString());
                throw object;
            }
            this.logD("Initializing EglRenderer");
            this.drawer = glDrawer;
            Object object4 = new StringBuilder();
            glDrawer = new HandlerThread(((StringBuilder)object4).append(this.name).append(TAG).toString());
            glDrawer.start();
            object4 = new Handler(glDrawer.getLooper());
            this.renderThreadHandler = object4;
            glDrawer = this.renderThreadHandler;
            object4 = new EglRenderer$2(this, (EglBase.Context)object, (int[])object2);
            ThreadUtils.invokeAtFrontUninterruptibly((Handler)glDrawer, (Runnable)object4);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void release() {
        CountDownLatch countDownLatch = new CountDownLatch(1);
        Object object = this.handlerLock;
        synchronized (object) {
            if (this.renderThreadHandler == null) {
                this.logD("Already released");
                return;
            }
            Handler handler = this.renderThreadHandler;
            Runnable runnable = new EglRenderer$3(this, countDownLatch);
            handler.postAtFrontOfQueue(runnable);
            handler = this.renderThreadHandler.getLooper();
            Handler handler2 = this.renderThreadHandler;
            runnable = new EglRenderer$4(this, (Looper)handler);
            handler2.post(runnable);
            this.renderThreadHandler = null;
        }
        ThreadUtils.awaitUninterruptibly(countDownLatch);
        object = this.frameLock;
        synchronized (object) {
            if (this.pendingFrame != null) {
                VideoRenderer.renderFrameDone(this.pendingFrame);
                this.pendingFrame = null;
            }
        }
        this.resetStatistics();
        this.logD("Releasing done.");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void releaseEglSurface() {
        this.eglSurfaceCreationRunnable.setSurface(null);
        Object object = this.handlerLock;
        synchronized (object) {
            if (this.renderThreadHandler != null) {
                this.renderThreadHandler.removeCallbacks((Runnable)this.eglSurfaceCreationRunnable);
                Handler handler = this.renderThreadHandler;
                EglRenderer$5 eglRenderer$5 = new EglRenderer$5(this);
                ThreadUtils.invokeAtFrontUninterruptibly(handler, eglRenderer$5);
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void renderFrame(VideoRenderer.I420Frame i420Frame) {
        Object object = this.statisticsLock;
        synchronized (object) {
            ++this.framesReceived;
        }
        object = this.handlerLock;
        synchronized (object) {
            if (this.renderThreadHandler == null) {
                this.logD("Dropping frame - Not initialized or already released.");
                VideoRenderer.renderFrameDone(i420Frame);
                return;
            }
            Object object2 = this.frameLock;
            synchronized (object2) {
                if (this.pendingFrame != null) {
                    Object object3 = this.statisticsLock;
                    synchronized (object3) {
                        ++this.framesDropped;
                    }
                    VideoRenderer.renderFrameDone(this.pendingFrame);
                }
                this.pendingFrame = i420Frame;
                this.renderThreadHandler.post(this.renderFrameRunnable);
                return;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void resetStatistics() {
        Object object = this.statisticsLock;
        synchronized (object) {
            this.framesReceived = 0;
            this.framesDropped = 0;
            this.framesRendered = 0;
            this.firstFrameTimeNs = 0L;
            this.renderTimeNs = 0L;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setLayoutAspectRatio(float f2) {
        this.logD("setLayoutAspectRatio: " + f2);
        Object object = this.layoutLock;
        synchronized (object) {
            this.layoutAspectRatio = f2;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setMirror(boolean bl2) {
        this.logD("setMirror: " + bl2);
        Object object = this.layoutLock;
        synchronized (object) {
            this.mirror = bl2;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void surfaceSizeChanged(int n2, int n3) {
        this.logD("Surface size changed: " + n2 + "x" + n3);
        Object object = this.layoutLock;
        synchronized (object) {
            this.surfaceWidth = n2;
            this.surfaceHeight = n3;
            return;
        }
    }

    private class EglSurfaceCreation
    implements Runnable {
        private Surface surface;

        private EglSurfaceCreation() {
        }

        /* synthetic */ EglSurfaceCreation(EglRenderer$1 eglRenderer$1) {
            this();
        }

        @Override
        public void run() {
            synchronized (this) {
                if (this.surface != null && EglRenderer.this.eglBase != null && !EglRenderer.this.eglBase.hasSurface()) {
                    EglRenderer.this.eglBase.createSurface(this.surface);
                    EglRenderer.this.eglBase.makeCurrent();
                    GLES20.glPixelStorei((int)3317, (int)1);
                }
                return;
            }
        }

        public void setSurface(Surface surface) {
            synchronized (this) {
                this.surface = surface;
                return;
            }
        }
    }
}

