/*
 * Decompiled with CFR 0.152.
 */
package org.wrtc;

import android.opengl.GLES20;
import java.nio.FloatBuffer;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import org.wrtc.GlShader;
import org.wrtc.GlUtil;
import org.wrtc.RendererCommon;

public class GlRectDrawer
implements RendererCommon.GlDrawer {
    private static final FloatBuffer FULL_RECTANGLE_BUF = GlUtil.createFloatBuffer(new float[]{-1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f});
    private static final FloatBuffer FULL_RECTANGLE_TEX_BUF = GlUtil.createFloatBuffer(new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f});
    private static final String OES_FRAGMENT_SHADER_STRING = "#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nvarying vec2 interp_tc;\n\nuniform samplerExternalOES oes_tex;\n\nvoid main() {\n  gl_FragColor = texture2D(oes_tex, interp_tc);\n}\n";
    private static final String RGB_FRAGMENT_SHADER_STRING = "precision mediump float;\nvarying vec2 interp_tc;\n\nuniform sampler2D rgb_tex;\n\nvoid main() {\n  gl_FragColor = texture2D(rgb_tex, interp_tc);\n}\n";
    private static final String VERTEX_SHADER_STRING = "varying vec2 interp_tc;\nattribute vec4 in_pos;\nattribute vec4 in_tc;\n\nuniform mat4 texMatrix;\n\nvoid main() {\n    gl_Position = in_pos;\n    interp_tc = (texMatrix * in_tc).xy;\n}\n";
    private static final String YUV_FRAGMENT_SHADER_STRING = "precision mediump float;\nvarying vec2 interp_tc;\n\nuniform sampler2D y_tex;\nuniform sampler2D u_tex;\nuniform sampler2D v_tex;\n\nvoid main() {\n  float y = texture2D(y_tex, interp_tc).r;\n  float u = texture2D(u_tex, interp_tc).r - 0.5;\n  float v = texture2D(v_tex, interp_tc).r - 0.5;\n  gl_FragColor = vec4(y + 1.403 * v,                       y - 0.344 * u - 0.714 * v,                       y + 1.77 * u, 1);\n}\n";
    private final Map<String, Shader> shaders = new IdentityHashMap<String, Shader>();

    private void drawRectangle(int n2, int n3, int n4, int n5) {
        GLES20.glViewport((int)n2, (int)n3, (int)n4, (int)n5);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void prepareShader(String object, float[] fArray) {
        if (this.shaders.containsKey(object)) {
            object = this.shaders.get(object);
        } else {
            Shader shader = new Shader((String)object);
            this.shaders.put((String)object, shader);
            shader.glShader.useProgram();
            if (object == YUV_FRAGMENT_SHADER_STRING) {
                GLES20.glUniform1i((int)shader.glShader.getUniformLocation("y_tex"), (int)0);
                GLES20.glUniform1i((int)shader.glShader.getUniformLocation("u_tex"), (int)1);
                GLES20.glUniform1i((int)shader.glShader.getUniformLocation("v_tex"), (int)2);
            } else if (object == RGB_FRAGMENT_SHADER_STRING) {
                GLES20.glUniform1i((int)shader.glShader.getUniformLocation("rgb_tex"), (int)0);
            } else {
                if (object != OES_FRAGMENT_SHADER_STRING) {
                    throw new IllegalStateException("Unknown fragment shader: " + (String)object);
                }
                GLES20.glUniform1i((int)shader.glShader.getUniformLocation("oes_tex"), (int)0);
            }
            GlUtil.checkNoGLES2Error("Initialize fragment shader uniform values.");
            shader.glShader.setVertexAttribArray("in_pos", 2, FULL_RECTANGLE_BUF);
            shader.glShader.setVertexAttribArray("in_tc", 2, FULL_RECTANGLE_TEX_BUF);
            object = shader;
        }
        ((Shader)object).glShader.useProgram();
        GLES20.glUniformMatrix4fv((int)((Shader)object).texMatrixLocation, (int)1, (boolean)false, (float[])fArray, (int)0);
    }

    @Override
    public void drawOes(int n2, float[] fArray, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.prepareShader(OES_FRAGMENT_SHADER_STRING, fArray);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)36197, (int)n2);
        this.drawRectangle(n5, n6, n7, n8);
        GLES20.glBindTexture((int)36197, (int)0);
    }

    @Override
    public void drawRgb(int n2, float[] fArray, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.prepareShader(RGB_FRAGMENT_SHADER_STRING, fArray);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)n2);
        this.drawRectangle(n5, n6, n7, n8);
        GLES20.glBindTexture((int)3553, (int)0);
    }

    @Override
    public void drawYuv(int[] nArray, float[] fArray, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.prepareShader(YUV_FRAGMENT_SHADER_STRING, fArray);
        for (n2 = 0; n2 < 3; ++n2) {
            GLES20.glActiveTexture((int)(33984 + n2));
            GLES20.glBindTexture((int)3553, (int)nArray[n2]);
        }
        this.drawRectangle(n4, n5, n6, n7);
        for (n2 = 0; n2 < 3; ++n2) {
            GLES20.glActiveTexture((int)(33984 + n2));
            GLES20.glBindTexture((int)3553, (int)0);
        }
    }

    @Override
    public void release() {
        Iterator<Shader> iterator = this.shaders.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().glShader.release();
        }
        this.shaders.clear();
    }

    private static class Shader {
        public final GlShader glShader;
        public final int texMatrixLocation;

        public Shader(String string2) {
            this.glShader = new GlShader(GlRectDrawer.VERTEX_SHADER_STRING, string2);
            this.texMatrixLocation = this.glShader.getUniformLocation("texMatrix");
        }
    }
}

