/*
 * Decompiled with CFR 0.152.
 */
package org.wrtc;

import com.wuba.wrtc.api.OnLoggingCallback;
import com.wuba.wrtc.util.e;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.AbstractCollection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.wrtc.Logging$1;

public class Logging {
    private static final Logger fallbackLogger = Logger.getLogger("org.wrtc.Logging");
    private static volatile boolean loggingEnabled;
    private static volatile boolean nativeLibLoaded;
    private static OnLoggingCallback onLoggingCallback;
    private static volatile boolean tracingEnabled;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static {
        try {
            System.loadLibrary("wrtc_so");
            nativeLibLoaded = true;
            return;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            fallbackLogger.setLevel(Level.ALL);
            fallbackLogger.log(Level.WARNING, "Failed to load wrtc_so: ", unsatisfiedLinkError);
            return;
        }
    }

    public static void d(String string2, String string3) {
        Logging.log(Severity.LS_INFO, string2, string3);
    }

    public static void dt(String string2, String string3) {
        if (onLoggingCallback != null) {
            onLoggingCallback.onLogCallBack("wrtc: " + string2 + "-" + string3);
        }
        e.c(string2, string3);
    }

    public static void e(String string2, String string3) {
        Logging.log(Severity.LS_ERROR, string2, string3);
    }

    public static void e(String string2, String string3, Throwable throwable) {
        Logging.log(Severity.LS_ERROR, string2, string3);
        Logging.log(Severity.LS_ERROR, string2, throwable.toString());
        Logging.log(Severity.LS_ERROR, string2, Logging.getStackTraceString(throwable));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void enableLogThreads() {
        if (!nativeLibLoaded) {
            fallbackLogger.log(Level.WARNING, "Cannot enable log thread because native lib not loaded.");
            return;
        }
        Logging.nativeEnableLogThreads();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void enableLogTimeStamps() {
        if (!nativeLibLoaded) {
            fallbackLogger.log(Level.WARNING, "Cannot enable log timestamps because native lib not loaded.");
            return;
        }
        Logging.nativeEnableLogTimeStamps();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void enableLogToDebugOutput(Severity severity) {
        synchronized (Logging.class) {
            if (!nativeLibLoaded) {
                fallbackLogger.log(Level.WARNING, "Cannot enable logging because native lib not loaded.");
                return;
            }
            Logging.nativeEnableLogToDebugOutput(severity.ordinal());
            loggingEnabled = true;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void enableTracing(String string2, EnumSet<TraceLevel> iterator) {
        synchronized (Logging.class) {
            if (!nativeLibLoaded) {
                fallbackLogger.log(Level.WARNING, "Cannot enable tracing because native lib not loaded.");
            } else if (!tracingEnabled) {
                Iterator iterator2;
                iterator2 = ((AbstractCollection)((Object)iterator2)).iterator();
                int n2 = 0;
                while (iterator2.hasNext()) {
                    n2 = ((TraceLevel)((Object)iterator2.next())).level | n2;
                }
                Logging.nativeEnableTracing(string2, n2);
                tracingEnabled = true;
            }
            return;
        }
    }

    public static void et(String string2, String string3) {
        if (onLoggingCallback != null) {
            onLoggingCallback.onLogCallBack("wrtc: " + string2 + "-" + string3);
        }
        e.f(string2, string3);
    }

    public static void et(String string2, String string3, Throwable throwable) {
        if (onLoggingCallback != null) {
            onLoggingCallback.onLogCallBack("wrtc: " + string2 + "-" + string3);
        }
        e.a(string2, string3, throwable);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getStackTraceString(Throwable object) {
        if (object == null) {
            return "";
        }
        StringWriter stringWriter = new StringWriter();
        ((Throwable)object).printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    public static void initNativeLogCallBack() {
        synchronized (Logging.class) {
            Logging.setNativeLogCallBack();
            return;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static void log(Severity object, String string2, String string3) {
        void var0_2;
        void var2_7;
        void var1_6;
        if (loggingEnabled) {
            Logging.nativeLog(((Enum)object).ordinal(), (String)var1_6, (String)var2_7);
            return;
        }
        switch (Logging$1.$SwitchMap$org$wrtc$Logging$Severity[((Enum)object).ordinal()]) {
            default: {
                Level level = Level.FINE;
                break;
            }
            case 1: {
                Level level = Level.SEVERE;
                break;
            }
            case 2: {
                Level level = Level.WARNING;
                break;
            }
            case 3: {
                Level level = Level.INFO;
            }
        }
        fallbackLogger.log((Level)var0_2, (String)var1_6 + ": " + (String)var2_7);
    }

    private static native void nativeEnableLogThreads();

    private static native void nativeEnableLogTimeStamps();

    private static native void nativeEnableLogToDebugOutput(int var0);

    private static native void nativeEnableTracing(String var0, int var1);

    private static native void nativeLog(int var0, String var1, String var2);

    public static void onLogCallBack(String string2) {
        if (onLoggingCallback != null) {
            onLoggingCallback.onLogCallBack(string2);
        }
    }

    public static void setLoggingCallBack(OnLoggingCallback onLoggingCallback) {
        Logging.onLoggingCallback = onLoggingCallback;
    }

    private static native void setNativeLogCallBack();

    public static void v(String string2, String string3) {
        Logging.log(Severity.LS_VERBOSE, string2, string3);
    }

    public static void w(String string2, String string3) {
        if (onLoggingCallback != null) {
            onLoggingCallback.onLogCallBack(string3);
        }
        Logging.log(Severity.LS_WARNING, string2, string3);
    }

    public static void w(String string2, String string3, Throwable throwable) {
        Logging.log(Severity.LS_WARNING, string2, string3);
        Logging.log(Severity.LS_WARNING, string2, throwable.toString());
        Logging.log(Severity.LS_WARNING, string2, Logging.getStackTraceString(throwable));
    }

    public static enum Severity {
        LS_SENSITIVE,
        LS_VERBOSE,
        LS_INFO,
        LS_CALL_BACK,
        LS_WARNING,
        LS_ERROR,
        LS_NONE;

    }

    public static enum TraceLevel {
        TRACE_NONE(0),
        TRACE_STATEINFO(1),
        TRACE_WARNING(2),
        TRACE_ERROR(4),
        TRACE_CRITICAL(8),
        TRACE_APICALL(16),
        TRACE_DEFAULT(255),
        TRACE_MODULECALL(32),
        TRACE_MEMORY(256),
        TRACE_TIMER(512),
        TRACE_STREAM(1024),
        TRACE_DEBUG(2048),
        TRACE_INFO(4096),
        TRACE_TERSEINFO(8192),
        TRACE_ALL(65535);

        public final int level;

        private TraceLevel(int n3) {
            this.level = n3;
        }
    }
}

