/*
 * Decompiled with CFR 0.152.
 */
package org.wrtc;

import android.annotation.TargetApi;
import android.media.MediaCodec;
import android.media.MediaCodecList;
import android.media.MediaFormat;
import android.opengl.GLES20;
import android.os.Build;
import android.os.Bundle;
import android.view.Surface;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.wrtc.EglBase;
import org.wrtc.EglBase14;
import org.wrtc.GlRectDrawer;
import org.wrtc.Logging;
import org.wrtc.MediaCodecVideoEncoder$1;
import org.wrtc.ThreadUtils;

@TargetApi(value=19)
public class MediaCodecVideoEncoder {
    private static final int BITRATE_ADJUSTMENT_FPS = 30;
    private static final double BITRATE_CORRECTION_MAX_SCALE = 2.0;
    private static final double BITRATE_CORRECTION_SEC = 3.0;
    private static final int BITRATE_CORRECTION_STEPS = 10;
    private static final int COLOR_QCOM_FORMATYUV420PackedSemiPlanar32m = 2141391876;
    private static final int DEQUEUE_TIMEOUT = 0;
    private static final String[] H264_HW_EXCEPTION_MODELS;
    private static final String H264_MIME_TYPE = "video/avc";
    private static final int MAXIMUM_INITIAL_FPS = 30;
    private static final int MEDIA_CODEC_RELEASE_TIMEOUT_MS = 5000;
    private static final String TAG = "MediaCodecVideoEncoder";
    private static int TARGET_MAX_BITRATE = 0;
    private static final int VIDEO_ControlRateConstant = 2;
    private static final String VP8_MIME_TYPE = "video/x-vnd.on2.vp8";
    private static final String VP9_MIME_TYPE = "video/x-vnd.on2.vp9";
    private static int codecErrors;
    private static MediaCodecVideoEncoderErrorCallback errorCallback;
    private static final MediaCodecProperties exynosH264HwProperties;
    private static final MediaCodecProperties exynosVp8HwProperties;
    private static final MediaCodecProperties exynosVp9HwProperties;
    private static final MediaCodecProperties[] h264HwList;
    private static Set<String> hwEncoderDisabledTypes;
    private static final MediaCodecProperties qcomH264HwProperties;
    private static final MediaCodecProperties qcomVp8HwProperties;
    private static final MediaCodecProperties qcomVp9HwProperties;
    private static MediaCodecVideoEncoder runningInstance;
    private static final int[] supportedColorList;
    private static final int[] supportedSurfaceColorList;
    private static final MediaCodecProperties[] vp8HwList;
    private static final MediaCodecProperties[] vp9HwList;
    private double bitrateAccumulator;
    private double bitrateAccumulatorMax;
    private int bitrateAdjustmentScaleExp;
    private BitrateAdjustmentType bitrateAdjustmentType = BitrateAdjustmentType.NO_ADJUSTMENT;
    private double bitrateObservationTimeMs;
    private int colorFormat;
    private ByteBuffer configData = null;
    private GlRectDrawer drawer;
    private EglBase14 eglBase;
    private int height;
    private Surface inputSurface;
    private MediaCodec mediaCodec;
    private Thread mediaCodecThread;
    private ByteBuffer[] outputBuffers;
    private int targetBitrateBps;
    private int targetFps;
    private VideoCodecType type;
    private int width;

    static {
        runningInstance = null;
        errorCallback = null;
        TARGET_MAX_BITRATE = 0;
        codecErrors = 0;
        hwEncoderDisabledTypes = new HashSet<String>();
        qcomVp8HwProperties = new MediaCodecProperties("OMX.qcom.", 19, BitrateAdjustmentType.NO_ADJUSTMENT);
        exynosVp8HwProperties = new MediaCodecProperties("OMX.Exynos.", 23, BitrateAdjustmentType.DYNAMIC_ADJUSTMENT);
        vp8HwList = new MediaCodecProperties[]{qcomVp8HwProperties, exynosVp8HwProperties};
        qcomVp9HwProperties = new MediaCodecProperties("OMX.qcom.", 23, BitrateAdjustmentType.NO_ADJUSTMENT);
        exynosVp9HwProperties = new MediaCodecProperties("OMX.Exynos.", 23, BitrateAdjustmentType.NO_ADJUSTMENT);
        vp9HwList = new MediaCodecProperties[]{qcomVp9HwProperties, exynosVp9HwProperties};
        qcomH264HwProperties = new MediaCodecProperties("OMX.qcom.", 19, BitrateAdjustmentType.NO_ADJUSTMENT);
        exynosH264HwProperties = new MediaCodecProperties("OMX.Exynos.", 21, BitrateAdjustmentType.FRAMERATE_ADJUSTMENT);
        h264HwList = new MediaCodecProperties[]{qcomH264HwProperties, exynosH264HwProperties};
        H264_HW_EXCEPTION_MODELS = new String[]{"SAMSUNG-SGH-I337", "Nexus 7", "Nexus 4"};
        supportedColorList = new int[]{19, 21, 2141391872, 2141391876};
        supportedSurfaceColorList = new int[]{2130708361};
    }

    static /* synthetic */ MediaCodec access$000(MediaCodecVideoEncoder mediaCodecVideoEncoder) {
        return mediaCodecVideoEncoder.mediaCodec;
    }

    private void checkOnMediaCodecThread() {
        if (this.mediaCodecThread.getId() != Thread.currentThread().getId()) {
            throw new RuntimeException("MediaCodecVideoEncoder previously operated on " + this.mediaCodecThread + " but is now called on " + Thread.currentThread());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static MediaCodec createByCodecName(String string2) {
        try {
            return MediaCodec.createByCodecName((String)string2);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void disableH264HwCodec() {
        Logging.w(TAG, "H.264 encoding is disabled by application.");
        hwEncoderDisabledTypes.add(H264_MIME_TYPE);
    }

    public static void disableVp8HwCodec() {
        Logging.w(TAG, "VP8 encoding is disabled by application.");
        hwEncoderDisabledTypes.add(VP8_MIME_TYPE);
    }

    public static void disableVp9HwCodec() {
        Logging.w(TAG, "VP9 encoding is disabled by application.");
        hwEncoderDisabledTypes.add(VP9_MIME_TYPE);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private static EncoderProperties findHwEncoder(String var0, MediaCodecProperties[] var1_1, int[] var2_2) {
        block19: {
            block18: {
                block20: {
                    if (Build.VERSION.SDK_INT < 19) {
                        var0 = null;
lbl3:
                        // 4 sources

                        return var0;
                    }
                    if (!var0.equals("video/avc") || !Arrays.asList(MediaCodecVideoEncoder.H264_HW_EXCEPTION_MODELS).contains(Build.MODEL)) break block20;
                    Logging.w("MediaCodecVideoEncoder", "Model: " + Build.MODEL + " has black listed H.264 encoder.");
                    var0 = null;
                    ** GOTO lbl3
                }
                block5: for (var3_3 = 0; var3_3 < MediaCodecList.getCodecCount(); ++var3_3) {
                    try {
                        var4_4 = MediaCodecList.getCodecInfoAt((int)var3_3);
                    }
                    catch (IllegalArgumentException var5_6) {
                        Logging.e("MediaCodecVideoEncoder", "Cannot retrieve encoder codec info", var5_6);
                        var4_4 = null;
                    }
                    while (var4_4 == null || !var4_4.isEncoder()) lbl-1000:
                    // 5 sources

                    {
                        continue block5;
                    }
                    var5_5 /* !! */  = var4_4.getSupportedTypes();
                    var6_8 = var5_5 /* !! */ .length;
                    for (var7_9 = 0; var7_9 < var6_8; ++var7_9) {
                        if (!var5_5 /* !! */ [var7_9].equals(var0)) continue;
                        var8_10 = var4_4.getName();
lbl27:
                        // 2 sources

                        block9: while (true) {
                            if (var8_10 == null) ** GOTO lbl-1000
                            Logging.v("MediaCodecVideoEncoder", "Found candidate encoder " + var8_10);
                            var5_5 /* !! */  = BitrateAdjustmentType.NO_ADJUSTMENT;
                            for (Object var9_11 : var1_1) {
                                if (!var8_10.startsWith(var9_11.codecPrefix)) continue;
                                if (Build.VERSION.SDK_INT < var9_11.minSdk) {
                                    Logging.w("MediaCodecVideoEncoder", "Codec " + var8_10 + " is disabled due to SDK version " + Build.VERSION.SDK_INT);
                                    continue;
                                }
                                break block9;
                            }
                            break block18;
                            break;
                        }
                        if (var9_11.bitrateAdjustmentType != BitrateAdjustmentType.NO_ADJUSTMENT) {
                            var5_5 /* !! */  = var9_11.bitrateAdjustmentType;
                            Logging.w("MediaCodecVideoEncoder", "Codec " + var8_10 + " requires bitrate adjustment: " + var5_5 /* !! */ );
                        }
                        var7_9 = 1;
lbl42:
                        // 2 sources

                        while (true) {
                            if (var7_9 == 0) ** GOTO lbl-1000
                            try {
                                var4_4 = var4_4.getCapabilitiesForType((String)var0);
                            }
                            catch (IllegalArgumentException var5_7) {
                                Logging.e("MediaCodecVideoEncoder", "Cannot retrieve encoder capabilities", var5_7);
                                ** GOTO lbl-1000
                            }
                            var9_11 = var4_4.colorFormats;
                            var6_8 = ((Object)var9_11).length;
                            for (var7_9 = 0; var7_9 < var6_8; ++var7_9) {
                                var10_12 /* !! */  = (int)var9_11[var7_9];
                                Logging.v("MediaCodecVideoEncoder", "   Color: 0x" + Integer.toHexString(var10_12 /* !! */ ));
                            }
                            var10_12 /* !! */  = var2_2.length;
                            var7_9 = 0;
                            while (true) {
                                if (var7_9 < var10_12 /* !! */ ) ** break;
                                ** continue;
                                var11_13 = var2_2[var7_9];
                                for (Object var13_15 : (Object)var4_4.colorFormats) {
                                    if (var13_15 != var11_13) continue;
                                    Logging.d("MediaCodecVideoEncoder", "Found target encoder for mime " + (String)var0 + " : " + var8_10 + ". Color: 0x" + Integer.toHexString((int)var13_15) + ". Bitrate adjustment: " + var5_5 /* !! */ );
                                    var0 = new EncoderProperties(var8_10, (int)var13_15, (BitrateAdjustmentType)var5_5 /* !! */ );
                                    ** GOTO lbl3
                                }
                                ++var7_9;
                            }
                            break;
                        }
                    }
                    break block19;
                }
                var0 = null;
                ** while (true)
            }
            var7_9 = 0;
            ** while (true)
        }
        var8_10 = null;
        ** while (true)
    }

    private double getBitrateScale(int n2) {
        return Math.pow(2.0, (double)n2 / 10.0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isH264HwSupported() {
        if (hwEncoderDisabledTypes.contains(H264_MIME_TYPE)) return false;
        if (MediaCodecVideoEncoder.findHwEncoder(H264_MIME_TYPE, h264HwList, supportedColorList) == null) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isH264HwSupportedUsingTextures() {
        if (hwEncoderDisabledTypes.contains(H264_MIME_TYPE)) return false;
        if (MediaCodecVideoEncoder.findHwEncoder(H264_MIME_TYPE, h264HwList, supportedSurfaceColorList) == null) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isVp8HwSupported() {
        if (hwEncoderDisabledTypes.contains(VP8_MIME_TYPE)) return false;
        if (MediaCodecVideoEncoder.findHwEncoder(VP8_MIME_TYPE, vp8HwList, supportedColorList) == null) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isVp8HwSupportedUsingTextures() {
        if (hwEncoderDisabledTypes.contains(VP8_MIME_TYPE)) return false;
        if (MediaCodecVideoEncoder.findHwEncoder(VP8_MIME_TYPE, vp8HwList, supportedSurfaceColorList) == null) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isVp9HwSupported() {
        if (hwEncoderDisabledTypes.contains(VP9_MIME_TYPE)) return false;
        if (MediaCodecVideoEncoder.findHwEncoder(VP9_MIME_TYPE, vp9HwList, supportedColorList) == null) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isVp9HwSupportedUsingTextures() {
        if (hwEncoderDisabledTypes.contains(VP9_MIME_TYPE)) return false;
        if (MediaCodecVideoEncoder.findHwEncoder(VP9_MIME_TYPE, vp9HwList, supportedSurfaceColorList) == null) return false;
        return true;
    }

    public static void printStackTrace() {
        StackTraceElement[] stackTraceElementArray;
        if (runningInstance != null && MediaCodecVideoEncoder.runningInstance.mediaCodecThread != null && (stackTraceElementArray = MediaCodecVideoEncoder.runningInstance.mediaCodecThread.getStackTrace()).length > 0) {
            Logging.d(TAG, "MediaCodecVideoEncoder stacks trace:");
            int n2 = stackTraceElementArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Logging.d(TAG, stackTraceElementArray[i2].toString());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void reportEncodedFrame(int n2) {
        int n3 = 1;
        if (this.targetFps == 0) return;
        if (this.bitrateAdjustmentType != BitrateAdjustmentType.DYNAMIC_ADJUSTMENT) {
            return;
        }
        double d2 = (double)this.targetBitrateBps / (8.0 * (double)this.targetFps);
        double d3 = this.bitrateAccumulator;
        this.bitrateAccumulator = (double)n2 - d2 + d3;
        this.bitrateObservationTimeMs += 1000.0 / (double)this.targetFps;
        d2 = 3.0 * this.bitrateAccumulatorMax;
        this.bitrateAccumulator = Math.min(this.bitrateAccumulator, d2);
        this.bitrateAccumulator = Math.max(this.bitrateAccumulator, -d2);
        if (!(this.bitrateObservationTimeMs > 3000.0)) return;
        Logging.d(TAG, "Acc: " + (int)this.bitrateAccumulator + ". Max: " + (int)this.bitrateAccumulatorMax + ". ExpScale: " + this.bitrateAdjustmentScaleExp);
        if (this.bitrateAccumulator > this.bitrateAccumulatorMax) {
            this.bitrateAccumulator = this.bitrateAccumulatorMax;
            --this.bitrateAdjustmentScaleExp;
            n2 = n3;
        } else if (this.bitrateAccumulator < -this.bitrateAccumulatorMax) {
            ++this.bitrateAdjustmentScaleExp;
            this.bitrateAccumulator = -this.bitrateAccumulatorMax;
            n2 = n3;
        } else {
            n2 = 0;
        }
        if (n2 != 0) {
            this.bitrateAdjustmentScaleExp = Math.min(this.bitrateAdjustmentScaleExp, 10);
            this.bitrateAdjustmentScaleExp = Math.max(this.bitrateAdjustmentScaleExp, -10);
            Logging.d(TAG, "Adjusting bitrate scale to " + this.bitrateAdjustmentScaleExp + ". Value: " + this.getBitrateScale(this.bitrateAdjustmentScaleExp));
            this.setRates(this.targetBitrateBps / 1000, this.targetFps);
        }
        this.bitrateObservationTimeMs = 0.0;
    }

    public static void setErrorCallback(MediaCodecVideoEncoderErrorCallback mediaCodecVideoEncoderErrorCallback) {
        Logging.d(TAG, "Set error callback");
        errorCallback = mediaCodecVideoEncoderErrorCallback;
    }

    public static void setMediaCodecVideoEncoderMaxitrate(int n2) {
        TARGET_MAX_BITRATE = n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean setRates(int n2, int n3) {
        this.checkOnMediaCodecThread();
        int n4 = n2;
        if (TARGET_MAX_BITRATE != 0) {
            n4 = n2;
            if (n2 > TARGET_MAX_BITRATE) {
                n4 = TARGET_MAX_BITRATE;
            }
        }
        int n5 = n4 * 1000;
        if (this.bitrateAdjustmentType == BitrateAdjustmentType.DYNAMIC_ADJUSTMENT) {
            this.bitrateAccumulatorMax = (double)n5 / 8.0;
            if (this.targetBitrateBps > 0 && n5 < this.targetBitrateBps) {
                this.bitrateAccumulator = this.bitrateAccumulator * (double)n5 / (double)this.targetBitrateBps;
            }
        }
        this.targetBitrateBps = n5;
        n2 = n3;
        if (n3 > 25) {
            n2 = 25;
        }
        this.targetFps = n2;
        Logging.d(TAG, "setRates: " + n4 + " kbps. Fps: " + this.targetFps);
        try {
            Bundle bundle = new Bundle();
            bundle.putInt("video-bitrate", n5);
            this.mediaCodec.setParameters(bundle);
            return true;
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "setRates failed", illegalStateException);
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    int dequeueInputBuffer() {
        this.checkOnMediaCodecThread();
        try {
            return this.mediaCodec.dequeueInputBuffer(0L);
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "dequeueIntputBuffer failed", illegalStateException);
            return -2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    OutputBufferInfo dequeueOutputBuffer() {
        Object object;
        int n2;
        Object object2;
        boolean bl2 = true;
        this.checkOnMediaCodecThread();
        try {
            int n3;
            object2 = new MediaCodec.BufferInfo();
            n2 = n3 = this.mediaCodec.dequeueOutputBuffer(object2, 0L);
            if (n3 >= 0) {
                boolean bl3 = (object2.flags & 2) != 0;
                n2 = n3;
                if (bl3) {
                    object = new StringBuilder();
                    Logging.d(TAG, ((StringBuilder)object).append("Config frame generated. Offset: ").append(object2.offset).append(". Size: ").append(object2.size).toString());
                    this.configData = ByteBuffer.allocateDirect(object2.size);
                    this.outputBuffers[n3].position(object2.offset);
                    this.outputBuffers[n3].limit(object2.offset + object2.size);
                    this.configData.put(this.outputBuffers[n3]);
                    this.mediaCodec.releaseOutputBuffer(n3, false);
                    n2 = this.mediaCodec.dequeueOutputBuffer(object2, 0L);
                }
            }
            if (n2 >= 0) {
                object = this.outputBuffers[n2].duplicate();
                ((ByteBuffer)object).position(object2.offset);
                ((ByteBuffer)object).limit(object2.offset + object2.size);
                this.reportEncodedFrame(object2.size);
                if ((object2.flags & 1) == 0) {
                    bl2 = false;
                }
                if (bl2) {
                    Logging.d(TAG, "Sync frame generated");
                }
                if (!bl2) return new OutputBufferInfo(n2, ((ByteBuffer)object).slice(), bl2, object2.presentationTimeUs);
                if (this.type != VideoCodecType.VIDEO_CODEC_H264) return new OutputBufferInfo(n2, ((ByteBuffer)object).slice(), bl2, object2.presentationTimeUs);
                Comparable<StringBuilder> comparable = new Comparable<StringBuilder>();
                Logging.d(TAG, ((StringBuilder)comparable).append("Appending config frame of size ").append(this.configData.capacity()).append(" to output buffer with offset ").append(object2.offset).append(", size ").append(object2.size).toString());
                comparable = ByteBuffer.allocateDirect(this.configData.capacity() + object2.size);
                this.configData.rewind();
                ((ByteBuffer)comparable).put(this.configData);
                ((ByteBuffer)comparable).put((ByteBuffer)object);
                ((ByteBuffer)comparable).position(0);
                return new OutputBufferInfo(n2, (ByteBuffer)comparable, bl2, object2.presentationTimeUs);
            }
            if (n2 == -3) {
                this.outputBuffers = this.mediaCodec.getOutputBuffers();
                return this.dequeueOutputBuffer();
            }
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "dequeueOutputBuffer failed", illegalStateException);
            return new OutputBufferInfo(-1, null, false, -1L);
        }
        if (n2 == -2) {
            return this.dequeueOutputBuffer();
        }
        if (n2 == -1) {
            return null;
        }
        object = new StringBuilder();
        object2 = new RuntimeException(((StringBuilder)object).append("dequeueOutputBuffer: ").append(n2).toString());
        throw object2;
    }

    /*
     * Unable to fully structure code
     */
    boolean encodeBuffer(boolean var1_1, int var2_2, int var3_3, long var4_4) {
        this.checkOnMediaCodecThread();
        if (!var1_1) ** GOTO lbl8
        try {
            Logging.d("MediaCodecVideoEncoder", "Sync frame request");
            var6_5 = new Bundle();
            var6_5.putInt("request-sync", 0);
            this.mediaCodec.setParameters(var6_5);
lbl8:
            // 2 sources

            this.mediaCodec.queueInputBuffer(var2_2, 0, var3_3, var4_4, 0);
            var1_1 = true;
lbl10:
            // 2 sources

            return var1_1;
        }
        catch (IllegalStateException var6_6) {
            Logging.e("MediaCodecVideoEncoder", "encodeBuffer failed", var6_6);
            var1_1 = false;
            ** continue;
        }
    }

    /*
     * Unable to fully structure code
     */
    boolean encodeTexture(boolean var1_1, int var2_2, float[] var3_3, long var4_5) {
        this.checkOnMediaCodecThread();
        if (!var1_1) ** GOTO lbl8
        try {
            Logging.d("MediaCodecVideoEncoder", "Sync frame request");
            var6_6 = new Bundle();
            var6_6.putInt("request-sync", 0);
            this.mediaCodec.setParameters(var6_6);
lbl8:
            // 2 sources

            this.eglBase.makeCurrent();
            GLES20.glClear((int)16384);
            this.drawer.drawOes(var2_2, var3_3, this.width, this.height, 0, 0, this.width, this.height);
            this.eglBase.swapBuffers(TimeUnit.MICROSECONDS.toNanos(var4_5));
            var1_1 = true;
lbl13:
            // 2 sources

            return var1_1;
        }
        catch (RuntimeException var3_4) {
            Logging.e("MediaCodecVideoEncoder", "encodeTexture failed", var3_4);
            var1_1 = false;
            ** continue;
        }
    }

    ByteBuffer[] getInputBuffers() {
        ByteBuffer[] byteBufferArray = this.mediaCodec.getInputBuffers();
        Logging.d(TAG, "Input buffers: " + byteBufferArray.length);
        return byteBufferArray;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean initEncode(VideoCodecType object, int n2, int n3, int n4, int n5, EglBase14.Context context) {
        void var9_13;
        int n6;
        Object object2;
        boolean bl2 = context != null;
        Logging.d(TAG, "Java initEncode: " + object + " : " + n2 + " x " + n3 + ". @ " + n4 + " kbps. Fps: " + n5 + ". Encode from texture : " + bl2);
        this.width = n2;
        this.height = n3;
        if (this.mediaCodecThread != null) {
            throw new RuntimeException("Forgot to release()?");
        }
        if (object == VideoCodecType.VIDEO_CODEC_VP8) {
            void var9_11;
            object2 = vp8HwList;
            if (bl2) {
                int[] nArray = supportedSurfaceColorList;
            } else {
                int[] nArray = supportedColorList;
            }
            EncoderProperties encoderProperties = MediaCodecVideoEncoder.findHwEncoder(VP8_MIME_TYPE, (MediaCodecProperties[])object2, (int[])var9_11);
            object2 = VP8_MIME_TYPE;
            n6 = 100;
        } else if (object == VideoCodecType.VIDEO_CODEC_VP9) {
            void var9_16;
            object2 = vp9HwList;
            if (bl2) {
                int[] nArray = supportedSurfaceColorList;
            } else {
                int[] nArray = supportedColorList;
            }
            EncoderProperties encoderProperties = MediaCodecVideoEncoder.findHwEncoder(VP9_MIME_TYPE, (MediaCodecProperties[])object2, (int[])var9_16);
            object2 = VP9_MIME_TYPE;
            n6 = 100;
        } else if (object == VideoCodecType.VIDEO_CODEC_H264) {
            void var9_20;
            object2 = h264HwList;
            if (bl2) {
                int[] nArray = supportedSurfaceColorList;
            } else {
                int[] nArray = supportedColorList;
            }
            EncoderProperties encoderProperties = MediaCodecVideoEncoder.findHwEncoder(H264_MIME_TYPE, (MediaCodecProperties[])object2, (int[])var9_20);
            object2 = H264_MIME_TYPE;
            n6 = 20;
        } else {
            Object var9_23 = null;
            object2 = null;
            n6 = 0;
        }
        if (var9_13 == null) {
            throw new RuntimeException("Can not find HW encoder for " + object);
        }
        runningInstance = this;
        this.colorFormat = var9_13.colorFormat;
        this.bitrateAdjustmentType = var9_13.bitrateAdjustmentType;
        n5 = this.bitrateAdjustmentType == BitrateAdjustmentType.FRAMERATE_ADJUSTMENT ? 30 : Math.min(n5, 30);
        Logging.d(TAG, "Color format: " + this.colorFormat + ". Bitrate adjustment: " + (Object)((Object)this.bitrateAdjustmentType) + ". Initial fps: " + n5);
        this.targetBitrateBps = n4 * 1000;
        this.targetFps = n5;
        this.bitrateAccumulatorMax = (double)this.targetBitrateBps / 8.0;
        this.bitrateAccumulator = 0.0;
        this.bitrateObservationTimeMs = 0.0;
        this.bitrateAdjustmentScaleExp = 0;
        this.mediaCodecThread = Thread.currentThread();
        try {
            MediaFormat mediaFormat = MediaFormat.createVideoFormat((String)object2, (int)n2, (int)n3);
            mediaFormat.setInteger("bitrate", this.targetBitrateBps);
            mediaFormat.setInteger("bitrate-mode", 2);
            mediaFormat.setInteger("color-format", var9_13.colorFormat);
            mediaFormat.setInteger("frame-rate", this.targetFps);
            mediaFormat.setInteger("i-frame-interval", n6);
            object2 = new StringBuilder();
            Logging.d(TAG, ((StringBuilder)object2).append("  Format: ").append(mediaFormat).toString());
            this.mediaCodec = MediaCodecVideoEncoder.createByCodecName(var9_13.codecName);
            this.type = object;
            if (this.mediaCodec == null) {
                Logging.e(TAG, "Can not create media encoder");
                return false;
            }
            this.mediaCodec.configure(mediaFormat, null, null, 1);
            if (bl2) {
                this.eglBase = object = new EglBase14(context, EglBase.CONFIG_RECORDABLE);
                this.inputSurface = this.mediaCodec.createInputSurface();
                this.eglBase.createSurface(this.inputSurface);
                this.drawer = object = new GlRectDrawer();
            }
            this.mediaCodec.start();
            this.outputBuffers = this.mediaCodec.getOutputBuffers();
            object = new StringBuilder();
            Logging.d(TAG, ((StringBuilder)object).append("Output buffers: ").append(this.outputBuffers.length).toString());
            return true;
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "initEncode failed", illegalStateException);
            return false;
        }
    }

    void release() {
        Logging.d(TAG, "Java releaseEncoder");
        this.checkOnMediaCodecThread();
        CountDownLatch countDownLatch = new CountDownLatch(1);
        new Thread(new MediaCodecVideoEncoder$1(this, countDownLatch)).start();
        if (!ThreadUtils.awaitUninterruptibly(countDownLatch, 5000L)) {
            Logging.e(TAG, "Media encoder release timeout");
            ++codecErrors;
            if (errorCallback != null) {
                Logging.e(TAG, "Invoke codec error callback. Errors: " + codecErrors);
                errorCallback.onMediaCodecVideoEncoderCriticalError(codecErrors);
            }
        }
        this.mediaCodec = null;
        this.mediaCodecThread = null;
        if (this.drawer != null) {
            this.drawer.release();
            this.drawer = null;
        }
        if (this.eglBase != null) {
            this.eglBase.release();
            this.eglBase = null;
        }
        if (this.inputSurface != null) {
            this.inputSurface.release();
            this.inputSurface = null;
        }
        runningInstance = null;
        Logging.d(TAG, "Java releaseEncoder done");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean releaseOutputBuffer(int n2) {
        boolean bl2 = false;
        this.checkOnMediaCodecThread();
        try {
            this.mediaCodec.releaseOutputBuffer(n2, false);
            return true;
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "releaseOutputBuffer failed", illegalStateException);
            return bl2;
        }
    }

    public static enum BitrateAdjustmentType {
        NO_ADJUSTMENT,
        FRAMERATE_ADJUSTMENT,
        DYNAMIC_ADJUSTMENT;

    }

    private static class EncoderProperties {
        public final BitrateAdjustmentType bitrateAdjustmentType;
        public final String codecName;
        public final int colorFormat;

        public EncoderProperties(String string2, int n2, BitrateAdjustmentType bitrateAdjustmentType) {
            this.codecName = string2;
            this.colorFormat = n2;
            this.bitrateAdjustmentType = bitrateAdjustmentType;
        }
    }

    private static class MediaCodecProperties {
        public final BitrateAdjustmentType bitrateAdjustmentType;
        public final String codecPrefix;
        public final int minSdk;

        MediaCodecProperties(String string2, int n2, BitrateAdjustmentType bitrateAdjustmentType) {
            this.codecPrefix = string2;
            this.minSdk = n2;
            this.bitrateAdjustmentType = bitrateAdjustmentType;
        }
    }

    public static interface MediaCodecVideoEncoderErrorCallback {
        public void onMediaCodecVideoEncoderCriticalError(int var1);
    }

    static class OutputBufferInfo {
        public final ByteBuffer buffer;
        public final int index;
        public final boolean isKeyFrame;
        public final long presentationTimestampUs;

        public OutputBufferInfo(int n2, ByteBuffer byteBuffer, boolean bl2, long l2) {
            this.index = n2;
            this.buffer = byteBuffer;
            this.isKeyFrame = bl2;
            this.presentationTimestampUs = l2;
        }
    }

    public static enum VideoCodecType {
        VIDEO_CODEC_VP8,
        VIDEO_CODEC_VP9,
        VIDEO_CODEC_H264;

    }
}

