/*
 * Decompiled with CFR 0.152.
 */
package org.wrtc;

import android.content.Context;
import android.os.Build;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.wrtc.Logging;
import org.wrtc.NetworkMonitor$1;
import org.wrtc.NetworkMonitorAutoDetect;

public class NetworkMonitor {
    private static final String TAG = "NetworkMonitor";
    private static NetworkMonitor instance;
    private final Context applicationContext;
    private NetworkMonitorAutoDetect autoDetector;
    private NetworkMonitorAutoDetect.ConnectionType currentConnectionType = NetworkMonitorAutoDetect.ConnectionType.CONNECTION_UNKNOWN;
    private final ArrayList<Long> nativeNetworkObservers;
    private final ArrayList<NetworkObserver> networkObservers;

    /*
     * Enabled aggressive block sorting
     */
    private NetworkMonitor(Context context) {
        boolean bl2 = context != null;
        NetworkMonitor.assertIsTrue(bl2);
        if (context.getApplicationContext() != null) {
            context = context.getApplicationContext();
        }
        this.applicationContext = context;
        this.nativeNetworkObservers = new ArrayList();
        this.networkObservers = new ArrayList();
    }

    static /* synthetic */ void access$000(NetworkMonitor networkMonitor, NetworkMonitorAutoDetect.ConnectionType connectionType) {
        networkMonitor.updateCurrentConnectionType(connectionType);
    }

    static /* synthetic */ void access$100(NetworkMonitor networkMonitor, NetworkMonitorAutoDetect.NetworkInformation networkInformation) {
        networkMonitor.notifyObserversOfNetworkConnect(networkInformation);
    }

    static /* synthetic */ void access$200(NetworkMonitor networkMonitor, long l2) {
        networkMonitor.notifyObserversOfNetworkDisconnect(l2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void addNetworkObserver(NetworkObserver networkObserver) {
        if (NetworkMonitor.getInstance() == null) {
            return;
        }
        NetworkMonitor.getInstance().addNetworkObserverInternal(networkObserver);
    }

    private void addNetworkObserverInternal(NetworkObserver networkObserver) {
        this.networkObservers.add(networkObserver);
    }

    private static int androidSdkInt() {
        return Build.VERSION.SDK_INT;
    }

    private static void assertIsTrue(boolean bl2) {
        if (!bl2) {
            throw new AssertionError((Object)"Expected to be true");
        }
    }

    private void destroyAutoDetector() {
        if (this.autoDetector != null) {
            this.autoDetector.destroy();
            this.autoDetector = null;
        }
    }

    public static NetworkMonitorAutoDetect getAutoDetectorForTest() {
        return NetworkMonitor.getInstance().autoDetector;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private long getCurrentDefaultNetId() {
        if (this.autoDetector != null) return this.autoDetector.getDefaultNetId();
        return -1L;
    }

    public static NetworkMonitor getInstance() {
        return instance;
    }

    public static NetworkMonitor init(Context context) {
        if (!NetworkMonitor.isInitialized()) {
            instance = new NetworkMonitor(context);
        }
        return instance;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isInitialized() {
        if (instance == null) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isOnline() {
        if (NetworkMonitor.getInstance().getCurrentConnectionType() == NetworkMonitorAutoDetect.ConnectionType.CONNECTION_NONE) return false;
        return true;
    }

    private native void nativeNotifyConnectionTypeChanged(long var1);

    private native void nativeNotifyOfActiveNetworkList(long var1, NetworkMonitorAutoDetect.NetworkInformation[] var3);

    private native void nativeNotifyOfNetworkConnect(long var1, NetworkMonitorAutoDetect.NetworkInformation var3);

    private native void nativeNotifyOfNetworkDisconnect(long var1, long var3);

    private void notifyObserversOfConnectionTypeChange(NetworkMonitorAutoDetect.ConnectionType connectionType) {
        Iterator<Object> iterator = this.nativeNetworkObservers.iterator();
        while (iterator.hasNext()) {
            this.nativeNotifyConnectionTypeChanged(iterator.next());
        }
        iterator = this.networkObservers.iterator();
        while (iterator.hasNext()) {
            ((NetworkObserver)iterator.next()).onConnectionTypeChanged(connectionType);
        }
    }

    private void notifyObserversOfNetworkConnect(NetworkMonitorAutoDetect.NetworkInformation networkInformation) {
        Iterator<Long> iterator = this.nativeNetworkObservers.iterator();
        while (iterator.hasNext()) {
            this.nativeNotifyOfNetworkConnect(iterator.next(), networkInformation);
        }
    }

    private void notifyObserversOfNetworkDisconnect(long l2) {
        Iterator<Long> iterator = this.nativeNetworkObservers.iterator();
        while (iterator.hasNext()) {
            this.nativeNotifyOfNetworkDisconnect(iterator.next(), l2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void removeNetworkObserver(NetworkObserver networkObserver) {
        if (NetworkMonitor.getInstance() == null) {
            return;
        }
        NetworkMonitor.getInstance().removeNetworkObserverInternal(networkObserver);
    }

    private void removeNetworkObserverInternal(NetworkObserver networkObserver) {
        this.networkObservers.remove(networkObserver);
    }

    static void resetInstanceForTests(Context context) {
        instance = new NetworkMonitor(context);
    }

    public static void setAutoDetectConnectivityState(boolean bl2) {
        NetworkMonitor.getInstance().setAutoDetectConnectivityStateInternal(bl2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setAutoDetectConnectivityStateInternal(boolean bl2) {
        if (!bl2) {
            this.destroyAutoDetector();
            return;
        }
        if (this.autoDetector != null) return;
        this.autoDetector = new NetworkMonitorAutoDetect(new NetworkMonitor$1(this), this.applicationContext);
        this.updateCurrentConnectionType(NetworkMonitorAutoDetect.getConnectionType(this.autoDetector.getCurrentNetworkState()));
        this.updateActiveNetworkList();
    }

    private void startMonitoring(long l2) {
        Logging.d(TAG, "Start monitoring from native observer " + l2);
        this.nativeNetworkObservers.add(l2);
        this.setAutoDetectConnectivityStateInternal(true);
    }

    private void stopMonitoring(long l2) {
        Logging.d(TAG, "Stop monitoring from native observer " + l2);
        this.setAutoDetectConnectivityStateInternal(false);
        this.nativeNetworkObservers.remove(l2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateActiveNetworkList() {
        List<NetworkMonitorAutoDetect.NetworkInformation> list = this.autoDetector.getActiveNetworkList();
        if (list != null && list.size() != 0) {
            NetworkMonitorAutoDetect.NetworkInformation[] networkInformationArray = list.toArray(new NetworkMonitorAutoDetect.NetworkInformation[list.size()]);
            list = this.nativeNetworkObservers.iterator();
            while (list.hasNext()) {
                this.nativeNotifyOfActiveNetworkList((Long)list.next(), networkInformationArray);
            }
        }
    }

    private void updateCurrentConnectionType(NetworkMonitorAutoDetect.ConnectionType connectionType) {
        this.currentConnectionType = connectionType;
        this.notifyObserversOfConnectionTypeChange(connectionType);
    }

    public NetworkMonitorAutoDetect.ConnectionType getCurrentConnectionType() {
        return this.currentConnectionType;
    }

    public static interface NetworkObserver {
        public void onConnectionTypeChanged(NetworkMonitorAutoDetect.ConnectionType var1);
    }
}

