/*
 * Decompiled with CFR 0.152.
 */
package org.wrtc;

import android.annotation.SuppressLint;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.LinkAddress;
import android.net.LinkProperties;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.net.NetworkRequest;
import android.net.wifi.WifiInfo;
import android.os.Build;
import java.util.ArrayList;
import java.util.List;
import org.wrtc.Logging;
import org.wrtc.NetworkMonitorAutoDetect$1;

public class NetworkMonitorAutoDetect
extends BroadcastReceiver {
    static final long INVALID_NET_ID = -1L;
    private static final String TAG = "NetworkMonitorAutoDetect";
    private final ConnectivityManager.NetworkCallback allNetworkCallback;
    private ConnectionType connectionType;
    private ConnectivityManagerDelegate connectivityManagerDelegate;
    private final Context context;
    private final IntentFilter intentFilter;
    private boolean isRegistered;
    private final ConnectivityManager.NetworkCallback mobileNetworkCallback;
    private final Observer observer;
    private WifiManagerDelegate wifiManagerDelegate;
    private String wifiSSID;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressLint(value={"NewApi"})
    public NetworkMonitorAutoDetect(Observer object, Context context) {
        this.observer = object;
        this.context = context;
        this.connectivityManagerDelegate = new ConnectivityManagerDelegate(context);
        this.wifiManagerDelegate = new WifiManagerDelegate(context);
        object = this.connectivityManagerDelegate.getNetworkState();
        this.connectionType = NetworkMonitorAutoDetect.getConnectionType((NetworkState)object);
        this.wifiSSID = this.getWifiSSID((NetworkState)object);
        this.intentFilter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
        this.registerReceiver();
        if (!this.connectivityManagerDelegate.supportNetworkCallback()) {
            this.mobileNetworkCallback = null;
            this.allNetworkCallback = null;
            return;
        }
        object = new ConnectivityManager.NetworkCallback();
        try {
            this.connectivityManagerDelegate.requestMobileNetwork((ConnectivityManager.NetworkCallback)object);
        }
        catch (SecurityException securityException) {
            Logging.w(TAG, "Unable to obtain permission to request a cellular network.");
            object = null;
        }
        this.mobileNetworkCallback = object;
        this.allNetworkCallback = new SimpleNetworkCallback(null);
        this.connectivityManagerDelegate.registerNetworkCallback(this.allNetworkCallback);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void connectionTypeChanged(NetworkState object) {
        ConnectionType connectionType = NetworkMonitorAutoDetect.getConnectionType((NetworkState)object);
        object = this.getWifiSSID((NetworkState)object);
        if (connectionType == this.connectionType && ((String)object).equals(this.wifiSSID)) {
            return;
        }
        this.connectionType = connectionType;
        this.wifiSSID = object;
        Logging.d(TAG, "Network connectivity changed, type is: " + (Object)((Object)this.connectionType));
        this.observer.onConnectionTypeChanged(connectionType);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ConnectionType getConnectionType(NetworkState object) {
        void var0_2;
        if (!((NetworkState)object).isConnected()) {
            ConnectionType connectionType = ConnectionType.CONNECTION_NONE;
            return var0_2;
        }
        switch (((NetworkState)object).getNetworkType()) {
            default: {
                ConnectionType connectionType = ConnectionType.CONNECTION_UNKNOWN;
                return var0_2;
            }
            case 9: {
                ConnectionType connectionType = ConnectionType.CONNECTION_ETHERNET;
                return var0_2;
            }
            case 1: {
                ConnectionType connectionType = ConnectionType.CONNECTION_WIFI;
                return var0_2;
            }
            case 6: {
                ConnectionType connectionType = ConnectionType.CONNECTION_4G;
                return var0_2;
            }
            case 7: {
                ConnectionType connectionType = ConnectionType.CONNECTION_BLUETOOTH;
                return var0_2;
            }
            case 0: 
        }
        switch (((NetworkState)object).getNetworkSubType()) {
            default: {
                ConnectionType connectionType = ConnectionType.CONNECTION_UNKNOWN_CELLULAR;
                return var0_2;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 11: {
                ConnectionType connectionType = ConnectionType.CONNECTION_2G;
                return var0_2;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: {
                ConnectionType connectionType = ConnectionType.CONNECTION_3G;
                return var0_2;
            }
            case 13: 
        }
        ConnectionType connectionType = ConnectionType.CONNECTION_4G;
        return var0_2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getWifiSSID(NetworkState object) {
        if (NetworkMonitorAutoDetect.getConnectionType((NetworkState)object) == ConnectionType.CONNECTION_WIFI) return this.wifiManagerDelegate.getWifiSSID();
        return "";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @SuppressLint(value={"NewApi"})
    private static long networkToNetId(Network network) {
        if (Build.VERSION.SDK_INT < 23) return Integer.parseInt(network.toString());
        return network.getNetworkHandle();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void registerReceiver() {
        if (this.isRegistered) {
            return;
        }
        this.isRegistered = true;
        this.context.registerReceiver((BroadcastReceiver)this, this.intentFilter);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void unregisterReceiver() {
        if (!this.isRegistered) {
            return;
        }
        this.isRegistered = false;
        this.context.unregisterReceiver((BroadcastReceiver)this);
    }

    public void destroy() {
        if (this.allNetworkCallback != null) {
            this.connectivityManagerDelegate.releaseCallback(this.allNetworkCallback);
        }
        if (this.mobileNetworkCallback != null) {
            this.connectivityManagerDelegate.releaseCallback(this.mobileNetworkCallback);
        }
        this.unregisterReceiver();
    }

    List<NetworkInformation> getActiveNetworkList() {
        return this.connectivityManagerDelegate.getActiveNetworkList();
    }

    public NetworkState getCurrentNetworkState() {
        return this.connectivityManagerDelegate.getNetworkState();
    }

    public long getDefaultNetId() {
        return this.connectivityManagerDelegate.getDefaultNetId();
    }

    boolean isReceiverRegisteredForTesting() {
        return this.isRegistered;
    }

    public void onReceive(Context object, Intent intent) {
        object = this.getCurrentNetworkState();
        if ("android.net.conn.CONNECTIVITY_CHANGE".equals(intent.getAction())) {
            this.connectionTypeChanged((NetworkState)object);
        }
    }

    void setConnectivityManagerDelegateForTests(ConnectivityManagerDelegate connectivityManagerDelegate) {
        this.connectivityManagerDelegate = connectivityManagerDelegate;
    }

    void setWifiManagerDelegateForTests(WifiManagerDelegate wifiManagerDelegate) {
        this.wifiManagerDelegate = wifiManagerDelegate;
    }

    public static enum ConnectionType {
        CONNECTION_UNKNOWN,
        CONNECTION_ETHERNET,
        CONNECTION_WIFI,
        CONNECTION_4G,
        CONNECTION_3G,
        CONNECTION_2G,
        CONNECTION_UNKNOWN_CELLULAR,
        CONNECTION_BLUETOOTH,
        CONNECTION_NONE;

    }

    static class ConnectivityManagerDelegate {
        static final /* synthetic */ boolean $assertionsDisabled;
        private final ConnectivityManager connectivityManager;

        /*
         * Enabled aggressive block sorting
         */
        static {
            boolean bl2 = !NetworkMonitorAutoDetect.class.desiredAssertionStatus();
            $assertionsDisabled = bl2;
        }

        ConnectivityManagerDelegate() {
            this.connectivityManager = null;
        }

        ConnectivityManagerDelegate(Context context) {
            this.connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @SuppressLint(value={"NewApi"})
        private NetworkInformation networkToInfo(Network object) {
            void var1_3;
            Object var2_7 = null;
            LinkProperties linkProperties = this.connectivityManager.getLinkProperties(object);
            if (linkProperties == null) {
                Logging.w(NetworkMonitorAutoDetect.TAG, "Detected unknown network: " + object.toString());
                Object var1_2 = var2_7;
                return var1_3;
            }
            if (linkProperties.getInterfaceName() == null) {
                Logging.w(NetworkMonitorAutoDetect.TAG, "Null interface name for network " + object.toString());
                Object var1_4 = var2_7;
                return var1_3;
            }
            NetworkState networkState = this.getNetworkState((Network)object);
            ConnectionType connectionType = NetworkMonitorAutoDetect.getConnectionType(networkState);
            if (connectionType == ConnectionType.CONNECTION_NONE) {
                Logging.d(NetworkMonitorAutoDetect.TAG, "Network " + object.toString() + " is disconnected");
                Object var1_5 = var2_7;
                return var1_3;
            }
            if (connectionType == ConnectionType.CONNECTION_UNKNOWN || connectionType == ConnectionType.CONNECTION_UNKNOWN_CELLULAR) {
                Logging.d(NetworkMonitorAutoDetect.TAG, "Network " + object.toString() + " connection type is " + (Object)((Object)connectionType) + " because it has type " + networkState.getNetworkType() + " and subtype " + networkState.getNetworkSubType());
            }
            NetworkInformation networkInformation = new NetworkInformation(linkProperties.getInterfaceName(), connectionType, NetworkMonitorAutoDetect.networkToNetId(object), this.getIPAddresses(linkProperties));
            return var1_3;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        List<NetworkInformation> getActiveNetworkList() {
            if (!this.supportNetworkCallback()) {
                return null;
            }
            ArrayList<Object> arrayList = new ArrayList<Object>();
            Network[] networkArray = this.getAllNetworks();
            int n2 = networkArray.length;
            int n3 = 0;
            while (true) {
                Object object = arrayList;
                if (n3 >= n2) return object;
                object = this.networkToInfo(networkArray[n3]);
                if (object != null) {
                    arrayList.add(object);
                }
                ++n3;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @SuppressLint(value={"NewApi"})
        Network[] getAllNetworks() {
            if (this.connectivityManager != null) return this.connectivityManager.getAllNetworks();
            return new Network[0];
        }

        /*
         * Enabled aggressive block sorting
         */
        @SuppressLint(value={"NewApi"})
        long getDefaultNetId() {
            if (!this.supportNetworkCallback()) {
                return -1L;
            }
            NetworkInfo networkInfo = this.connectivityManager.getActiveNetworkInfo();
            if (networkInfo == null) {
                return -1L;
            }
            Network[] networkArray = this.getAllNetworks();
            int n2 = networkArray.length;
            int n3 = 0;
            long l2 = -1L;
            while (true) {
                long l3 = l2;
                if (n3 >= n2) return l3;
                Network network = networkArray[n3];
                if (!this.hasInternetCapability(network)) {
                    l3 = l2;
                } else {
                    NetworkInfo networkInfo2 = this.connectivityManager.getNetworkInfo(network);
                    l3 = l2;
                    if (networkInfo2 != null) {
                        l3 = l2;
                        if (networkInfo2.getType() == networkInfo.getType()) {
                            if (!$assertionsDisabled && l2 != -1L) {
                                throw new AssertionError();
                            }
                            l3 = NetworkMonitorAutoDetect.networkToNetId(network);
                        }
                    }
                }
                ++n3;
                l2 = l3;
            }
        }

        @SuppressLint(value={"NewApi"})
        IPAddress[] getIPAddresses(LinkProperties object) {
            IPAddress[] iPAddressArray = new IPAddress[object.getLinkAddresses().size()];
            object = object.getLinkAddresses().iterator();
            int n2 = 0;
            while (object.hasNext()) {
                iPAddressArray[n2] = new IPAddress(((LinkAddress)object.next()).getAddress().getAddress());
                ++n2;
            }
            return iPAddressArray;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        NetworkState getNetworkState() {
            if (this.connectivityManager != null) return this.getNetworkState(this.connectivityManager.getActiveNetworkInfo());
            return new NetworkState(false, -1, -1);
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @SuppressLint(value={"NewApi"})
        NetworkState getNetworkState(Network object) {
            void var1_3;
            if (this.connectivityManager == null) {
                NetworkState networkState = new NetworkState(false, -1, -1);
                return var1_3;
            }
            NetworkState networkState = this.getNetworkState(this.connectivityManager.getNetworkInfo(object));
            return var1_3;
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        NetworkState getNetworkState(NetworkInfo object) {
            void var1_3;
            if (object == null || !object.isConnected()) {
                NetworkState networkState = new NetworkState(false, -1, -1);
                return var1_3;
            }
            NetworkState networkState = new NetworkState(true, object.getType(), object.getSubtype());
            return var1_3;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @SuppressLint(value={"NewApi"})
        boolean hasInternetCapability(Network network) {
            boolean bl2 = false;
            if (this.connectivityManager == null) {
                return bl2;
            }
            network = this.connectivityManager.getNetworkCapabilities(network);
            boolean bl3 = bl2;
            if (network == null) return bl3;
            bl3 = bl2;
            if (!network.hasCapability(12)) return bl3;
            return true;
        }

        @SuppressLint(value={"NewApi"})
        public void registerNetworkCallback(ConnectivityManager.NetworkCallback networkCallback) {
            this.connectivityManager.registerNetworkCallback(new NetworkRequest.Builder().addCapability(12).build(), networkCallback);
        }

        @SuppressLint(value={"NewApi"})
        public void releaseCallback(ConnectivityManager.NetworkCallback networkCallback) {
            if (this.supportNetworkCallback()) {
                Logging.d(NetworkMonitorAutoDetect.TAG, "Unregister network callback");
                this.connectivityManager.unregisterNetworkCallback(networkCallback);
            }
        }

        @SuppressLint(value={"NewApi"})
        public void requestMobileNetwork(ConnectivityManager.NetworkCallback networkCallback) {
            NetworkRequest.Builder builder = new NetworkRequest.Builder();
            builder.addCapability(12).addTransportType(0);
            this.connectivityManager.requestNetwork(builder.build(), networkCallback);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean supportNetworkCallback() {
            if (Build.VERSION.SDK_INT < 21) return false;
            if (this.connectivityManager == null) return false;
            return true;
        }
    }

    public static class IPAddress {
        public final byte[] address;

        public IPAddress(byte[] byArray) {
            this.address = byArray;
        }
    }

    public static class NetworkInformation {
        public final long handle;
        public final IPAddress[] ipAddresses;
        public final String name;
        public final ConnectionType type;

        public NetworkInformation(String string2, ConnectionType connectionType, long l2, IPAddress[] iPAddressArray) {
            this.name = string2;
            this.type = connectionType;
            this.handle = l2;
            this.ipAddresses = iPAddressArray;
        }
    }

    static class NetworkState {
        private final boolean connected;
        private final int subtype;
        private final int type;

        public NetworkState(boolean bl2, int n2, int n3) {
            this.connected = bl2;
            this.type = n2;
            this.subtype = n3;
        }

        public int getNetworkSubType() {
            return this.subtype;
        }

        public int getNetworkType() {
            return this.type;
        }

        public boolean isConnected() {
            return this.connected;
        }
    }

    public static interface Observer {
        public void onConnectionTypeChanged(ConnectionType var1);

        public void onNetworkConnect(NetworkInformation var1);

        public void onNetworkDisconnect(long var1);
    }

    @SuppressLint(value={"NewApi"})
    private class SimpleNetworkCallback
    extends ConnectivityManager.NetworkCallback {
        private SimpleNetworkCallback() {
        }

        /* synthetic */ SimpleNetworkCallback(NetworkMonitorAutoDetect$1 networkMonitorAutoDetect$1) {
            this();
        }

        private void onNetworkChanged(Network object) {
            object = NetworkMonitorAutoDetect.this.connectivityManagerDelegate.networkToInfo(object);
            if (object != null) {
                NetworkMonitorAutoDetect.this.observer.onNetworkConnect((NetworkInformation)object);
            }
        }

        public void onAvailable(Network network) {
            Logging.d(NetworkMonitorAutoDetect.TAG, "Network becomes available: " + network.toString());
            this.onNetworkChanged(network);
        }

        public void onCapabilitiesChanged(Network network, NetworkCapabilities networkCapabilities) {
            Logging.d(NetworkMonitorAutoDetect.TAG, "capabilities changed: " + networkCapabilities.toString());
            this.onNetworkChanged(network);
        }

        public void onLinkPropertiesChanged(Network network, LinkProperties linkProperties) {
            Logging.d(NetworkMonitorAutoDetect.TAG, "link properties changed: " + linkProperties.toString());
            this.onNetworkChanged(network);
        }

        public void onLosing(Network network, int n2) {
            Logging.d(NetworkMonitorAutoDetect.TAG, "Network " + network.toString() + " is about to lose in " + n2 + "ms");
        }

        public void onLost(Network network) {
            Logging.d(NetworkMonitorAutoDetect.TAG, "Network " + network.toString() + " is disconnected");
            NetworkMonitorAutoDetect.this.observer.onNetworkDisconnect(NetworkMonitorAutoDetect.networkToNetId(network));
        }
    }

    static class WifiManagerDelegate {
        private final Context context;

        WifiManagerDelegate() {
            this.context = null;
        }

        WifiManagerDelegate(Context context) {
            this.context = context;
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        String getWifiSSID() {
            void var1_4;
            String string2;
            WifiInfo wifiInfo;
            Intent intent = this.context.registerReceiver(null, new IntentFilter("android.net.wifi.STATE_CHANGE"));
            if (intent != null && (wifiInfo = (WifiInfo)intent.getParcelableExtra("wifiInfo")) != null && (string2 = wifiInfo.getSSID()) != null) {
                return var1_4;
            }
            String string3 = "";
            return var1_4;
        }
    }
}

