/*
 * Decompiled with CFR 0.152.
 */
package org.wrtc.voiceengine;

import android.content.Context;
import android.media.AudioRecord;
import android.os.Process;
import java.nio.ByteBuffer;
import org.wrtc.Logging;
import org.wrtc.ThreadUtils;
import org.wrtc.voiceengine.WebRtcAudioEffects;
import org.wrtc.voiceengine.WebRtcAudioUtils;

public class WebRtcAudioRecord {
    private static final long AUDIO_RECORD_THREAD_JOIN_TIMEOUT_MS = 2000L;
    private static final int BITS_PER_SAMPLE = 16;
    private static final int BUFFERS_PER_SECOND = 100;
    private static final int BUFFER_SIZE_FACTOR = 2;
    private static final int CALLBACK_BUFFER_SIZE_MS = 10;
    private static final boolean DEBUG = false;
    private static final String TAG = "WebRtcAudioRecord";
    private static volatile boolean microphoneMute = false;
    private AudioRecord audioRecord = null;
    private AudioRecordThread audioThread = null;
    private ByteBuffer byteBuffer;
    private final Context context;
    private WebRtcAudioEffects effects = null;
    private byte[] emptyBytes;
    private final long nativeAudioRecord;

    WebRtcAudioRecord(Context context, long l2) {
        Logging.d(TAG, "ctor" + WebRtcAudioUtils.getThreadInfo());
        this.context = context;
        this.nativeAudioRecord = l2;
        this.effects = WebRtcAudioEffects.create();
    }

    private static void assertTrue(boolean bl2) {
        if (!bl2) {
            throw new AssertionError((Object)"Expected condition to be true");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean enableBuiltInAEC(boolean bl2) {
        Logging.d(TAG, "enableBuiltInAEC(" + bl2 + ')');
        if (this.effects != null) return this.effects.setAEC(bl2);
        Logging.e(TAG, "Built-in AEC is not supported on this platform");
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean enableBuiltInAGC(boolean bl2) {
        Logging.d(TAG, "enableBuiltInAGC(" + bl2 + ')');
        if (this.effects != null) return this.effects.setAGC(bl2);
        Logging.e(TAG, "Built-in AGC is not supported on this platform");
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean enableBuiltInNS(boolean bl2) {
        Logging.d(TAG, "enableBuiltInNS(" + bl2 + ')');
        if (this.effects != null) return this.effects.setNS(bl2);
        Logging.e(TAG, "Built-in NS is not supported on this platform");
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int initRecording(int n2, int n3) {
        Logging.d(TAG, "initRecording(sampleRate=" + n2 + ", channels=" + n3 + ")");
        if (!WebRtcAudioUtils.hasPermission(this.context, "android.permission.RECORD_AUDIO")) {
            Logging.e(TAG, "RECORD_AUDIO permission is missing");
            return -1;
        }
        if (this.audioRecord != null) {
            Logging.e(TAG, "InitRecording() called twice without StopRecording()");
            return -1;
        }
        int n4 = n2 / 100;
        this.byteBuffer = ByteBuffer.allocateDirect(n3 * 2 * n4);
        Logging.d(TAG, "byteBuffer.capacity: " + this.byteBuffer.capacity());
        this.emptyBytes = new byte[this.byteBuffer.capacity()];
        this.nativeCacheDirectBufferAddress(this.byteBuffer, this.nativeAudioRecord);
        n3 = AudioRecord.getMinBufferSize((int)n2, (int)16, (int)2);
        if (n3 == -1 || n3 == -2) {
            Logging.e(TAG, "AudioRecord.getMinBufferSize failed: " + n3);
            return -1;
        }
        Logging.d(TAG, "AudioRecord.getMinBufferSize: " + n3);
        n3 = Math.max(n3 * 2, this.byteBuffer.capacity());
        Logging.d(TAG, "bufferSizeInBytes: " + n3);
        try {
            AudioRecord audioRecord;
            this.audioRecord = audioRecord = new AudioRecord(7, n2, 16, 2, n3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Logging.e(TAG, illegalArgumentException.getMessage());
            return -1;
        }
        if (this.audioRecord == null || this.audioRecord.getState() != 1) {
            Logging.e(TAG, "Failed to create a new AudioRecord instance");
            return -1;
        }
        Logging.d(TAG, "AudioRecord session ID: " + this.audioRecord.getAudioSessionId() + ", audio format: " + this.audioRecord.getAudioFormat() + ", channels: " + this.audioRecord.getChannelCount() + ", sample rate: " + this.audioRecord.getSampleRate());
        if (this.effects == null) return n4;
        this.effects.enable(this.audioRecord.getAudioSessionId());
        return n4;
    }

    private native void nativeCacheDirectBufferAddress(ByteBuffer var1, long var2);

    private native void nativeDataIsRecorded(int var1, long var2);

    public static void setMicrophoneMute(boolean bl2) {
        Logging.w(TAG, "setMicrophoneMute(" + bl2 + ")");
        microphoneMute = bl2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean startRecording() {
        boolean bl2 = false;
        Logging.d(TAG, "startRecording");
        boolean bl3 = this.audioRecord != null;
        WebRtcAudioRecord.assertTrue(bl3);
        bl3 = this.audioThread == null;
        WebRtcAudioRecord.assertTrue(bl3);
        try {
            this.audioRecord.startRecording();
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "AudioRecord.startRecording failed: " + illegalStateException.getMessage());
            return bl2;
        }
        if (this.audioRecord.getRecordingState() != 3) {
            Logging.e(TAG, "AudioRecord.startRecording failed");
            return bl2;
        }
        this.audioThread = new AudioRecordThread("AudioRecordJavaThread");
        this.audioThread.start();
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean stopRecording() {
        Logging.d(TAG, "stopRecording");
        boolean bl2 = this.audioThread != null;
        WebRtcAudioRecord.assertTrue(bl2);
        this.audioThread.stopThread();
        if (!ThreadUtils.joinUninterruptibly(this.audioThread, 2000L)) {
            Logging.e(TAG, "Join of AudioRecordJavaThread timed out");
        }
        this.audioThread = null;
        if (this.effects != null) {
            this.effects.release();
        }
        this.audioRecord.release();
        this.audioRecord = null;
        return true;
    }

    private class AudioRecordThread
    extends Thread {
        private volatile boolean keepAlive;

        public AudioRecordThread(String string2) {
            super(string2);
            this.keepAlive = true;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            Process.setThreadPriority((int)-19);
            Logging.d(WebRtcAudioRecord.TAG, "AudioRecordThread" + WebRtcAudioUtils.getThreadInfo());
            boolean bl2 = WebRtcAudioRecord.this.audioRecord.getRecordingState() == 3;
            WebRtcAudioRecord.assertTrue(bl2);
            System.nanoTime();
            while (this.keepAlive) {
                int n2 = WebRtcAudioRecord.this.audioRecord.read(WebRtcAudioRecord.this.byteBuffer, WebRtcAudioRecord.this.byteBuffer.capacity());
                if (n2 == WebRtcAudioRecord.this.byteBuffer.capacity()) {
                    if (microphoneMute) {
                        WebRtcAudioRecord.this.byteBuffer.clear();
                        WebRtcAudioRecord.this.byteBuffer.put(WebRtcAudioRecord.this.emptyBytes);
                    }
                    WebRtcAudioRecord.this.nativeDataIsRecorded(n2, WebRtcAudioRecord.this.nativeAudioRecord);
                    continue;
                }
                Logging.e(WebRtcAudioRecord.TAG, "AudioRecord.read failed: " + n2);
                if (n2 != -3) continue;
                this.keepAlive = false;
            }
            try {
                if (WebRtcAudioRecord.this.audioRecord == null) return;
                WebRtcAudioRecord.this.audioRecord.stop();
                return;
            }
            catch (IllegalStateException illegalStateException) {
                Logging.e(WebRtcAudioRecord.TAG, "AudioRecord.stop failed: " + illegalStateException.getMessage());
                return;
            }
        }

        public void stopThread() {
            Logging.d(WebRtcAudioRecord.TAG, "stopThread");
            this.keepAlive = false;
        }
    }
}

