/*
 * Decompiled with CFR 0.152.
 */
package org.wrtc.voiceengine;

import android.annotation.TargetApi;
import android.content.Context;
import android.media.AudioManager;
import android.media.AudioTrack;
import android.os.Process;
import java.nio.ByteBuffer;
import org.wrtc.Logging;
import org.wrtc.voiceengine.WebRtcAudioUtils;

public class WebRtcAudioTrack {
    private static final int BITS_PER_SAMPLE = 16;
    private static final int BUFFERS_PER_SECOND = 100;
    private static final int CALLBACK_BUFFER_SIZE_MS = 10;
    private static final boolean DEBUG = false;
    private static final String TAG = "WebRtcAudioTrack";
    private static volatile boolean speakerMute = false;
    private final AudioManager audioManager;
    private AudioTrackThread audioThread = null;
    private AudioTrack audioTrack = null;
    private ByteBuffer byteBuffer;
    private final Context context;
    private byte[] emptyBytes;
    private final long nativeAudioTrack;

    WebRtcAudioTrack(Context context, long l2) {
        Logging.d(TAG, "ctor" + WebRtcAudioUtils.getThreadInfo());
        this.context = context;
        this.nativeAudioTrack = l2;
        this.audioManager = (AudioManager)context.getSystemService("audio");
    }

    private static void assertTrue(boolean bl2) {
        if (!bl2) {
            throw new AssertionError((Object)"Expected condition to be true");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private int getStreamMaxVolume() {
        Logging.d(TAG, "getStreamMaxVolume");
        boolean bl2 = this.audioManager != null;
        WebRtcAudioTrack.assertTrue(bl2);
        return this.audioManager.getStreamMaxVolume(0);
    }

    /*
     * Enabled aggressive block sorting
     */
    private int getStreamVolume() {
        Logging.d(TAG, "getStreamVolume");
        boolean bl2 = this.audioManager != null;
        WebRtcAudioTrack.assertTrue(bl2);
        return this.audioManager.getStreamVolume(0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean initPlayout(int n2, int n3) {
        Logging.d(TAG, "initPlayout(sampleRate=" + n2 + ", channels=" + n3 + ")");
        ByteBuffer byteBuffer = this.byteBuffer;
        this.byteBuffer = ByteBuffer.allocateDirect(n3 * 2 * (n2 / 100));
        Logging.d(TAG, "byteBuffer.capacity: " + this.byteBuffer.capacity());
        this.emptyBytes = new byte[this.byteBuffer.capacity()];
        this.nativeCacheDirectBufferAddress(this.byteBuffer, this.nativeAudioTrack);
        n3 = AudioTrack.getMinBufferSize((int)n2, (int)4, (int)2);
        Logging.d(TAG, "AudioTrack.getMinBufferSize: " + n3);
        if (n3 < this.byteBuffer.capacity()) {
            Logging.e(TAG, "AudioTrack.getMinBufferSize returns an invalid value.");
            return false;
        }
        if (this.audioTrack != null) {
            Logging.e(TAG, "Conflict with existing AudioTrack.");
            return false;
        }
        try {
            byteBuffer = new AudioTrack(0, n2, 4, 2, n3, 1);
            this.audioTrack = byteBuffer;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Logging.d(TAG, illegalArgumentException.getMessage());
            return false;
        }
        if (this.audioTrack.getState() == 1) return true;
        Logging.e(TAG, "Initialization of audio track failed.");
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @TargetApi(value=21)
    private boolean isVolumeFixed() {
        if (WebRtcAudioUtils.runningOnLollipopOrHigher()) return this.audioManager.isVolumeFixed();
        return false;
    }

    private native void nativeCacheDirectBufferAddress(ByteBuffer var1, long var2);

    private native void nativeGetPlayoutData(int var1, long var2);

    public static void setSpeakerMute(boolean bl2) {
        Logging.w(TAG, "setSpeakerMute(" + bl2 + ")");
        speakerMute = bl2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean setStreamVolume(int n2) {
        boolean bl2 = false;
        Logging.d(TAG, "setStreamVolume(" + n2 + ")");
        boolean bl3 = this.audioManager != null;
        WebRtcAudioTrack.assertTrue(bl3);
        if (this.isVolumeFixed()) {
            Logging.e(TAG, "The device implements a fixed volume policy.");
            return bl2;
        }
        this.audioManager.setStreamVolume(0, n2, 0);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean startPlayout() {
        boolean bl2 = false;
        Logging.d(TAG, "startPlayout");
        boolean bl3 = this.audioTrack != null;
        WebRtcAudioTrack.assertTrue(bl3);
        bl3 = this.audioThread == null;
        WebRtcAudioTrack.assertTrue(bl3);
        if (this.audioTrack.getState() != 1) {
            Logging.e(TAG, "Audio track is not successfully initialized.");
            return bl2;
        }
        this.audioThread = new AudioTrackThread("AudioTrackJavaThread");
        this.audioThread.start();
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean stopPlayout() {
        Logging.d(TAG, "stopPlayout");
        boolean bl2 = this.audioThread != null;
        WebRtcAudioTrack.assertTrue(bl2);
        this.audioThread.joinThread();
        this.audioThread = null;
        if (this.audioTrack != null) {
            this.audioTrack.release();
            this.audioTrack = null;
        }
        return true;
    }

    private class AudioTrackThread
    extends Thread {
        private volatile boolean keepAlive;

        public AudioTrackThread(String string2) {
            super(string2);
            this.keepAlive = true;
        }

        @TargetApi(value=21)
        private int writeOnLollipop(AudioTrack audioTrack, ByteBuffer byteBuffer, int n2) {
            return audioTrack.write(byteBuffer, n2, 0);
        }

        private int writePreLollipop(AudioTrack audioTrack, ByteBuffer byteBuffer, int n2) {
            return audioTrack.write(byteBuffer.array(), byteBuffer.arrayOffset(), n2);
        }

        public void joinThread() {
            this.keepAlive = false;
            while (this.isAlive()) {
                try {
                    this.join();
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            boolean bl2;
            boolean bl3 = true;
            Process.setThreadPriority((int)-19);
            Logging.d(WebRtcAudioTrack.TAG, "AudioTrackThread" + WebRtcAudioUtils.getThreadInfo());
            try {
                WebRtcAudioTrack.this.audioTrack.play();
                bl2 = WebRtcAudioTrack.this.audioTrack.getPlayState() == 3;
                WebRtcAudioTrack.assertTrue(bl2);
            }
            catch (IllegalStateException illegalStateException) {
                Logging.e(WebRtcAudioTrack.TAG, "AudioTrack.play failed: " + illegalStateException.getMessage());
                return;
            }
            int n2 = WebRtcAudioTrack.this.byteBuffer.capacity();
            while (this.keepAlive) {
                int n3;
                WebRtcAudioTrack.this.nativeGetPlayoutData(n2, WebRtcAudioTrack.this.nativeAudioTrack);
                bl2 = n2 <= WebRtcAudioTrack.this.byteBuffer.remaining();
                WebRtcAudioTrack.assertTrue(bl2);
                if (speakerMute) {
                    WebRtcAudioTrack.this.byteBuffer.clear();
                    WebRtcAudioTrack.this.byteBuffer.put(WebRtcAudioTrack.this.emptyBytes);
                    WebRtcAudioTrack.this.byteBuffer.position(0);
                }
                if ((n3 = WebRtcAudioUtils.runningOnLollipopOrHigher() ? this.writeOnLollipop(WebRtcAudioTrack.this.audioTrack, WebRtcAudioTrack.this.byteBuffer, n2) : this.writePreLollipop(WebRtcAudioTrack.this.audioTrack, WebRtcAudioTrack.this.byteBuffer, n2)) != n2) {
                    Logging.e(WebRtcAudioTrack.TAG, "AudioTrack.write failed: " + n3);
                    if (n3 == -3) {
                        this.keepAlive = false;
                    }
                }
                WebRtcAudioTrack.this.byteBuffer.rewind();
            }
            try {
                WebRtcAudioTrack.this.audioTrack.stop();
            }
            catch (IllegalStateException illegalStateException) {
                Logging.e(WebRtcAudioTrack.TAG, "AudioTrack.stop failed: " + illegalStateException.getMessage());
            }
            bl2 = WebRtcAudioTrack.this.audioTrack.getPlayState() == 1 ? bl3 : false;
            WebRtcAudioTrack.assertTrue(bl2);
            WebRtcAudioTrack.this.audioTrack.flush();
        }
    }
}

