/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.view;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.os.Build;
import android.support.v4.view.ViewConfigurationCompat;
import android.support.v7.appcompat.R;
import android.view.ViewConfiguration;

public class ActionBarPolicy {
    private Context mContext;

    private ActionBarPolicy(Context context) {
        this.mContext = context;
    }

    public static ActionBarPolicy get(Context context) {
        return new ActionBarPolicy(context);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean enableHomeButtonByDefault() {
        if (this.mContext.getApplicationInfo().targetSdkVersion >= 14) return false;
        return true;
    }

    public int getEmbeddedMenuWidthLimit() {
        return this.mContext.getResources().getDisplayMetrics().widthPixels / 2;
    }

    public int getMaxActionButtons() {
        return this.mContext.getResources().getInteger(R.integer.abc_max_action_buttons);
    }

    public int getStackedTabMaxWidth() {
        return this.mContext.getResources().getDimensionPixelSize(R.dimen.abc_action_bar_stacked_tab_max_width);
    }

    public int getTabContainerHeight() {
        TypedArray typedArray = this.mContext.obtainStyledAttributes(null, R.styleable.ActionBar, R.attr.actionBarStyle, 0);
        int n2 = typedArray.getLayoutDimension(R.styleable.ActionBar_height, 0);
        Resources resources = this.mContext.getResources();
        int n3 = n2;
        if (!this.hasEmbeddedTabs()) {
            n3 = Math.min(n2, resources.getDimensionPixelSize(R.dimen.abc_action_bar_stacked_max_height));
        }
        typedArray.recycle();
        return n3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasEmbeddedTabs() {
        if (this.mContext.getApplicationInfo().targetSdkVersion < 16) return this.mContext.getResources().getBoolean(R.bool.abc_action_bar_embed_tabs_pre_jb);
        return this.mContext.getResources().getBoolean(R.bool.abc_action_bar_embed_tabs);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean showsOverflowMenuButton() {
        boolean bl = true;
        if (Build.VERSION.SDK_INT >= 19) {
            return bl;
        }
        if (!ViewConfigurationCompat.hasPermanentMenuKey((ViewConfiguration)ViewConfiguration.get((Context)this.mContext))) return bl;
        return false;
    }
}

