/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.widget;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Parcelable;
import android.support.v4.view.NestedScrollingParent;
import android.support.v4.view.NestedScrollingParentHelper;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.ViewPropertyAnimatorCompat;
import android.support.v4.view.ViewPropertyAnimatorListener;
import android.support.v4.view.ViewPropertyAnimatorListenerAdapter;
import android.support.v4.widget.ScrollerCompat;
import android.support.v7.appcompat.R;
import android.support.v7.view.menu.MenuPresenter;
import android.support.v7.widget.ActionBarContainer;
import android.support.v7.widget.ContentFrameLayout;
import android.support.v7.widget.DecorContentParent;
import android.support.v7.widget.DecorToolbar;
import android.support.v7.widget.Toolbar;
import android.support.v7.widget.ViewUtils;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.view.Menu;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;

public class ActionBarOverlayLayout
extends ViewGroup
implements NestedScrollingParent,
DecorContentParent {
    static final int[] ATTRS = new int[]{R.attr.actionBarSize, 16842841};
    private static final String TAG = "ActionBarOverlayLayout";
    private final int ACTION_BAR_ANIMATE_DELAY;
    private int mActionBarHeight;
    private ActionBarContainer mActionBarTop;
    private ActionBarVisibilityCallback mActionBarVisibilityCallback;
    private final Runnable mAddActionBarHideOffset;
    private boolean mAnimatingForFling;
    private final Rect mBaseContentInsets = new Rect();
    private final Rect mBaseInnerInsets;
    private ContentFrameLayout mContent;
    private final Rect mContentInsets;
    private ViewPropertyAnimatorCompat mCurrentActionBarTopAnimator;
    private DecorToolbar mDecorToolbar;
    private ScrollerCompat mFlingEstimator;
    private boolean mHasNonEmbeddedTabs;
    private boolean mHideOnContentScroll;
    private int mHideOnContentScrollReference;
    private boolean mIgnoreWindowContentOverlay;
    private final Rect mInnerInsets;
    private final Rect mLastBaseContentInsets = new Rect();
    private final Rect mLastInnerInsets;
    private int mLastSystemUiVisibility;
    private boolean mOverlayMode;
    private final NestedScrollingParentHelper mParentHelper;
    private final Runnable mRemoveActionBarHideOffset;
    private final ViewPropertyAnimatorListener mTopAnimatorListener;
    private Drawable mWindowContentOverlay;
    private int mWindowVisibility = 0;

    public ActionBarOverlayLayout(Context context) {
        this(context, null);
    }

    public ActionBarOverlayLayout(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.mContentInsets = new Rect();
        this.mBaseInnerInsets = new Rect();
        this.mInnerInsets = new Rect();
        this.mLastInnerInsets = new Rect();
        this.ACTION_BAR_ANIMATE_DELAY = 600;
        this.mTopAnimatorListener = new ViewPropertyAnimatorListenerAdapter(){

            public void onAnimationCancel(View view) {
                ActionBarOverlayLayout.access$002(ActionBarOverlayLayout.this, null);
                ActionBarOverlayLayout.access$102(ActionBarOverlayLayout.this, false);
            }

            public void onAnimationEnd(View view) {
                ActionBarOverlayLayout.access$002(ActionBarOverlayLayout.this, null);
                ActionBarOverlayLayout.access$102(ActionBarOverlayLayout.this, false);
            }
        };
        this.mRemoveActionBarHideOffset = new Runnable(){

            @Override
            public void run() {
                ActionBarOverlayLayout.this.haltActionBarHideOffsetAnimations();
                ActionBarOverlayLayout.access$002(ActionBarOverlayLayout.this, ViewCompat.animate((View)ActionBarOverlayLayout.this.mActionBarTop).translationY(0.0f).setListener(ActionBarOverlayLayout.this.mTopAnimatorListener));
            }
        };
        this.mAddActionBarHideOffset = new Runnable(){

            @Override
            public void run() {
                ActionBarOverlayLayout.this.haltActionBarHideOffsetAnimations();
                ActionBarOverlayLayout.access$002(ActionBarOverlayLayout.this, ViewCompat.animate((View)ActionBarOverlayLayout.this.mActionBarTop).translationY((float)(-ActionBarOverlayLayout.this.mActionBarTop.getHeight())).setListener(ActionBarOverlayLayout.this.mTopAnimatorListener));
            }
        };
        this.init(context);
        this.mParentHelper = new NestedScrollingParentHelper((ViewGroup)this);
    }

    static /* synthetic */ ViewPropertyAnimatorCompat access$002(ActionBarOverlayLayout actionBarOverlayLayout, ViewPropertyAnimatorCompat viewPropertyAnimatorCompat) {
        actionBarOverlayLayout.mCurrentActionBarTopAnimator = viewPropertyAnimatorCompat;
        return viewPropertyAnimatorCompat;
    }

    static /* synthetic */ boolean access$102(ActionBarOverlayLayout actionBarOverlayLayout, boolean bl) {
        actionBarOverlayLayout.mAnimatingForFling = bl;
        return bl;
    }

    private void addActionBarHideOffset() {
        this.haltActionBarHideOffsetAnimations();
        this.mAddActionBarHideOffset.run();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean applyInsets(View object, Rect rect, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        void var5_6;
        void var6_7;
        boolean bl5;
        void var2_3;
        boolean bl6;
        boolean bl7 = false;
        LayoutParams layoutParams = (LayoutParams)object.getLayoutParams();
        boolean bl8 = bl7;
        if (bl6) {
            bl8 = bl7;
            if (layoutParams.leftMargin != var2_3.left) {
                layoutParams.leftMargin = var2_3.left;
                bl8 = true;
            }
        }
        bl6 = bl8;
        if (bl5) {
            bl6 = bl8;
            if (layoutParams.topMargin != var2_3.top) {
                layoutParams.topMargin = var2_3.top;
                bl6 = true;
            }
        }
        bl5 = bl6;
        if (var6_7 != false) {
            bl5 = bl6;
            if (layoutParams.rightMargin != var2_3.right) {
                layoutParams.rightMargin = var2_3.right;
                bl5 = true;
            }
        }
        if (var5_6 == false) return bl5;
        if (layoutParams.bottomMargin == var2_3.bottom) return bl5;
        layoutParams.bottomMargin = var2_3.bottom;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private DecorToolbar getDecorToolbar(View object) {
        if (object instanceof DecorToolbar) {
            return (DecorToolbar)object;
        }
        if (!(object instanceof Toolbar)) throw new IllegalStateException("Can't make a decor toolbar out of " + object.getClass().getSimpleName());
        return ((Toolbar)object).getWrapper();
    }

    private void haltActionBarHideOffsetAnimations() {
        this.removeCallbacks(this.mRemoveActionBarHideOffset);
        this.removeCallbacks(this.mAddActionBarHideOffset);
        if (this.mCurrentActionBarTopAnimator != null) {
            this.mCurrentActionBarTopAnimator.cancel();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void init(Context context) {
        boolean bl = true;
        TypedArray typedArray = this.getContext().getTheme().obtainStyledAttributes(ATTRS);
        this.mActionBarHeight = typedArray.getDimensionPixelSize(0, 0);
        this.mWindowContentOverlay = typedArray.getDrawable(1);
        boolean bl2 = this.mWindowContentOverlay == null;
        this.setWillNotDraw(bl2);
        typedArray.recycle();
        bl2 = context.getApplicationInfo().targetSdkVersion < 19 ? bl : false;
        this.mIgnoreWindowContentOverlay = bl2;
        this.mFlingEstimator = ScrollerCompat.create((Context)context);
    }

    private void postAddActionBarHideOffset() {
        this.haltActionBarHideOffsetAnimations();
        this.postDelayed(this.mAddActionBarHideOffset, 600L);
    }

    private void postRemoveActionBarHideOffset() {
        this.haltActionBarHideOffsetAnimations();
        this.postDelayed(this.mRemoveActionBarHideOffset, 600L);
    }

    private void removeActionBarHideOffset() {
        this.haltActionBarHideOffsetAnimations();
        this.mRemoveActionBarHideOffset.run();
    }

    private boolean shouldHideActionBarOnFling(float f2, float f3) {
        boolean bl = false;
        this.mFlingEstimator.fling(0, 0, 0, (int)f3, 0, 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
        if (this.mFlingEstimator.getFinalY() > this.mActionBarTop.getHeight()) {
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean canShowOverflowMenu() {
        this.pullChildren();
        return this.mDecorToolbar.canShowOverflowMenu();
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return layoutParams instanceof LayoutParams;
    }

    @Override
    public void dismissPopups() {
        this.pullChildren();
        this.mDecorToolbar.dismissPopupMenus();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void draw(Canvas canvas) {
        super.draw(canvas);
        if (this.mWindowContentOverlay != null && !this.mIgnoreWindowContentOverlay) {
            int n2 = this.mActionBarTop.getVisibility() == 0 ? (int)((float)this.mActionBarTop.getBottom() + ViewCompat.getTranslationY((View)this.mActionBarTop) + 0.5f) : 0;
            this.mWindowContentOverlay.setBounds(0, n2, this.getWidth(), this.mWindowContentOverlay.getIntrinsicHeight() + n2);
            this.mWindowContentOverlay.draw(canvas);
        }
    }

    protected boolean fitSystemWindows(Rect rect) {
        this.pullChildren();
        if ((ViewCompat.getWindowSystemUiVisibility((View)this) & 0x100) != 0) {
            // empty if block
        }
        boolean bl = this.applyInsets((View)this.mActionBarTop, rect, true, true, false, true);
        this.mBaseInnerInsets.set(rect);
        ViewUtils.computeFitSystemWindows((View)this, (Rect)this.mBaseInnerInsets, (Rect)this.mBaseContentInsets);
        if (!this.mLastBaseContentInsets.equals((Object)this.mBaseContentInsets)) {
            this.mLastBaseContentInsets.set(this.mBaseContentInsets);
            bl = true;
        }
        if (bl) {
            this.requestLayout();
        }
        return true;
    }

    protected LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-1, -1);
    }

    public LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return new LayoutParams(this.getContext(), attributeSet);
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return new LayoutParams(layoutParams);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getActionBarHideOffset() {
        if (this.mActionBarTop == null) return 0;
        return -((int)ViewCompat.getTranslationY((View)this.mActionBarTop));
    }

    public int getNestedScrollAxes() {
        return this.mParentHelper.getNestedScrollAxes();
    }

    @Override
    public CharSequence getTitle() {
        this.pullChildren();
        return this.mDecorToolbar.getTitle();
    }

    @Override
    public boolean hasIcon() {
        this.pullChildren();
        return this.mDecorToolbar.hasIcon();
    }

    @Override
    public boolean hasLogo() {
        this.pullChildren();
        return this.mDecorToolbar.hasLogo();
    }

    @Override
    public boolean hideOverflowMenu() {
        this.pullChildren();
        return this.mDecorToolbar.hideOverflowMenu();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void initFeature(int n2) {
        this.pullChildren();
        switch (n2) {
            case 2: {
                this.mDecorToolbar.initProgress();
                return;
            }
            case 5: {
                this.mDecorToolbar.initIndeterminateProgress();
                return;
            }
            case 109: {
                this.setOverlayMode(true);
                return;
            }
        }
    }

    public boolean isHideOnContentScrollEnabled() {
        return this.mHideOnContentScroll;
    }

    public boolean isInOverlayMode() {
        return this.mOverlayMode;
    }

    @Override
    public boolean isOverflowMenuShowPending() {
        this.pullChildren();
        return this.mDecorToolbar.isOverflowMenuShowPending();
    }

    @Override
    public boolean isOverflowMenuShowing() {
        this.pullChildren();
        return this.mDecorToolbar.isOverflowMenuShowing();
    }

    protected void onConfigurationChanged(Configuration configuration) {
        if (Build.VERSION.SDK_INT >= 8) {
            super.onConfigurationChanged(configuration);
        }
        this.init(this.getContext());
        ViewCompat.requestApplyInsets((View)this);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.haltActionBarHideOffsetAnimations();
    }

    protected void onLayout(boolean bl, int n2, int n3, int n4, int n5) {
        n3 = this.getChildCount();
        n4 = this.getPaddingLeft();
        this.getPaddingRight();
        n5 = this.getPaddingTop();
        this.getPaddingBottom();
        for (n2 = 0; n2 < n3; ++n2) {
            View view = this.getChildAt(n2);
            if (view.getVisibility() == 8) continue;
            LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
            int n6 = view.getMeasuredWidth();
            int n7 = view.getMeasuredHeight();
            int n8 = layoutParams.leftMargin + n4;
            int n9 = layoutParams.topMargin + n5;
            view.layout(n8, n9, n6 + n8, n7 + n9);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void onMeasure(int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        LayoutParams layoutParams;
        block6: {
            block5: {
                this.pullChildren();
                this.measureChildWithMargins((View)this.mActionBarTop, n2, 0, n3, 0);
                layoutParams = (LayoutParams)this.mActionBarTop.getLayoutParams();
                n9 = Math.max(0, this.mActionBarTop.getMeasuredWidth() + layoutParams.leftMargin + layoutParams.rightMargin);
                n8 = this.mActionBarTop.getMeasuredHeight();
                n7 = layoutParams.topMargin;
                n6 = Math.max(0, layoutParams.bottomMargin + (n8 + n7));
                n5 = ViewUtils.combineMeasuredStates((int)0, (int)ViewCompat.getMeasuredState((View)this.mActionBarTop));
                n8 = (ViewCompat.getWindowSystemUiVisibility((View)this) & 0x100) != 0 ? 1 : 0;
                if (n8 == 0) break block5;
                n7 = n4 = this.mActionBarHeight;
                if (this.mHasNonEmbeddedTabs) {
                    n7 = n4;
                    if (this.mActionBarTop.getTabContainer() != null) {
                        n7 = n4 + this.mActionBarHeight;
                    }
                }
                break block6;
            }
            n7 = this.mActionBarTop.getVisibility() != 8 ? this.mActionBarTop.getMeasuredHeight() : 0;
        }
        this.mContentInsets.set(this.mBaseContentInsets);
        this.mInnerInsets.set(this.mBaseInnerInsets);
        if (!this.mOverlayMode && n8 == 0) {
            layoutParams = this.mContentInsets;
            ((Rect)layoutParams).top = n7 + ((Rect)layoutParams).top;
            layoutParams = this.mContentInsets;
            ((Rect)layoutParams).bottom += 0;
        } else {
            layoutParams = this.mInnerInsets;
            ((Rect)layoutParams).top = n7 + ((Rect)layoutParams).top;
            layoutParams = this.mInnerInsets;
            ((Rect)layoutParams).bottom += 0;
        }
        this.applyInsets((View)this.mContent, this.mContentInsets, true, true, true, true);
        if (!this.mLastInnerInsets.equals((Object)this.mInnerInsets)) {
            this.mLastInnerInsets.set(this.mInnerInsets);
            this.mContent.dispatchFitSystemWindows(this.mInnerInsets);
        }
        this.measureChildWithMargins((View)this.mContent, n2, 0, n3, 0);
        layoutParams = (LayoutParams)this.mContent.getLayoutParams();
        n7 = Math.max(n9, this.mContent.getMeasuredWidth() + layoutParams.leftMargin + layoutParams.rightMargin);
        n8 = this.mContent.getMeasuredHeight();
        n4 = layoutParams.topMargin;
        n4 = Math.max(n6, layoutParams.bottomMargin + (n8 + n4));
        n6 = ViewUtils.combineMeasuredStates((int)n5, (int)ViewCompat.getMeasuredState((View)this.mContent));
        n8 = this.getPaddingLeft();
        n5 = this.getPaddingRight();
        n4 = Math.max(n4 + (this.getPaddingTop() + this.getPaddingBottom()), this.getSuggestedMinimumHeight());
        this.setMeasuredDimension(ViewCompat.resolveSizeAndState((int)Math.max(n7 + (n8 + n5), this.getSuggestedMinimumWidth()), (int)n2, (int)n6), ViewCompat.resolveSizeAndState((int)n4, (int)n3, (int)(n6 << 16)));
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean onNestedFling(View view, float f2, float f3, boolean bl) {
        boolean bl2 = true;
        if (!this.mHideOnContentScroll) return false;
        if (!bl) {
            return false;
        }
        if (this.shouldHideActionBarOnFling(f2, f3)) {
            this.addActionBarHideOffset();
        } else {
            this.removeActionBarHideOffset();
        }
        this.mAnimatingForFling = true;
        return bl2;
    }

    public boolean onNestedPreFling(View view, float f2, float f3) {
        return false;
    }

    public void onNestedPreScroll(View view, int n2, int n3, int[] nArray) {
    }

    public void onNestedScroll(View view, int n2, int n3, int n4, int n5) {
        this.mHideOnContentScrollReference += n3;
        this.setActionBarHideOffset(this.mHideOnContentScrollReference);
    }

    public void onNestedScrollAccepted(View view, View view2, int n2) {
        this.mParentHelper.onNestedScrollAccepted(view, view2, n2);
        this.mHideOnContentScrollReference = this.getActionBarHideOffset();
        this.haltActionBarHideOffsetAnimations();
        if (this.mActionBarVisibilityCallback != null) {
            this.mActionBarVisibilityCallback.onContentScrollStarted();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean onStartNestedScroll(View view, View view2, int n2) {
        if ((n2 & 2) == 0) return false;
        if (this.mActionBarTop.getVisibility() == 0) return this.mHideOnContentScroll;
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void onStopNestedScroll(View view) {
        if (this.mHideOnContentScroll && !this.mAnimatingForFling) {
            if (this.mHideOnContentScrollReference <= this.mActionBarTop.getHeight()) {
                this.postRemoveActionBarHideOffset();
            } else {
                this.postAddActionBarHideOffset();
            }
        }
        if (this.mActionBarVisibilityCallback != null) {
            this.mActionBarVisibilityCallback.onContentScrollStopped();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void onWindowSystemUiVisibilityChanged(int n2) {
        boolean bl = true;
        if (Build.VERSION.SDK_INT >= 16) {
            super.onWindowSystemUiVisibilityChanged(n2);
        }
        this.pullChildren();
        int n3 = this.mLastSystemUiVisibility;
        this.mLastSystemUiVisibility = n2;
        boolean bl2 = (n2 & 4) == 0;
        boolean bl3 = (n2 & 0x100) != 0;
        if (this.mActionBarVisibilityCallback != null) {
            ActionBarVisibilityCallback actionBarVisibilityCallback = this.mActionBarVisibilityCallback;
            if (bl3) {
                bl = false;
            }
            actionBarVisibilityCallback.enableContentAnimations(bl);
            if (bl2 || !bl3) {
                this.mActionBarVisibilityCallback.showForSystem();
            } else {
                this.mActionBarVisibilityCallback.hideForSystem();
            }
        }
        if (((n3 ^ n2) & 0x100) != 0 && this.mActionBarVisibilityCallback != null) {
            ViewCompat.requestApplyInsets((View)this);
        }
    }

    protected void onWindowVisibilityChanged(int n2) {
        super.onWindowVisibilityChanged(n2);
        this.mWindowVisibility = n2;
        if (this.mActionBarVisibilityCallback != null) {
            this.mActionBarVisibilityCallback.onWindowVisibilityChanged(n2);
        }
    }

    void pullChildren() {
        if (this.mContent == null) {
            this.mContent = (ContentFrameLayout)this.findViewById(R.id.action_bar_activity_content);
            this.mActionBarTop = (ActionBarContainer)this.findViewById(R.id.action_bar_container);
            this.mDecorToolbar = this.getDecorToolbar(this.findViewById(R.id.action_bar));
        }
    }

    @Override
    public void restoreToolbarHierarchyState(SparseArray<Parcelable> sparseArray) {
        this.pullChildren();
        this.mDecorToolbar.restoreHierarchyState(sparseArray);
    }

    @Override
    public void saveToolbarHierarchyState(SparseArray<Parcelable> sparseArray) {
        this.pullChildren();
        this.mDecorToolbar.saveHierarchyState(sparseArray);
    }

    public void setActionBarHideOffset(int n2) {
        this.haltActionBarHideOffsetAnimations();
        n2 = Math.max(0, Math.min(n2, this.mActionBarTop.getHeight()));
        ViewCompat.setTranslationY((View)this.mActionBarTop, (float)(-n2));
    }

    public void setActionBarVisibilityCallback(ActionBarVisibilityCallback actionBarVisibilityCallback) {
        this.mActionBarVisibilityCallback = actionBarVisibilityCallback;
        if (this.getWindowToken() != null) {
            this.mActionBarVisibilityCallback.onWindowVisibilityChanged(this.mWindowVisibility);
            if (this.mLastSystemUiVisibility != 0) {
                this.onWindowSystemUiVisibilityChanged(this.mLastSystemUiVisibility);
                ViewCompat.requestApplyInsets((View)this);
            }
        }
    }

    public void setHasNonEmbeddedTabs(boolean bl) {
        this.mHasNonEmbeddedTabs = bl;
    }

    public void setHideOnContentScrollEnabled(boolean bl) {
        if (bl != this.mHideOnContentScroll) {
            this.mHideOnContentScroll = bl;
            if (!bl) {
                this.haltActionBarHideOffsetAnimations();
                this.setActionBarHideOffset(0);
            }
        }
    }

    @Override
    public void setIcon(int n2) {
        this.pullChildren();
        this.mDecorToolbar.setIcon(n2);
    }

    @Override
    public void setIcon(Drawable drawable2) {
        this.pullChildren();
        this.mDecorToolbar.setIcon(drawable2);
    }

    @Override
    public void setLogo(int n2) {
        this.pullChildren();
        this.mDecorToolbar.setLogo(n2);
    }

    @Override
    public void setMenu(Menu menu, MenuPresenter.Callback callback) {
        this.pullChildren();
        this.mDecorToolbar.setMenu(menu, callback);
    }

    @Override
    public void setMenuPrepared() {
        this.pullChildren();
        this.mDecorToolbar.setMenuPrepared();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setOverlayMode(boolean bl) {
        this.mOverlayMode = bl;
        bl = bl && this.getContext().getApplicationInfo().targetSdkVersion < 19;
        this.mIgnoreWindowContentOverlay = bl;
    }

    public void setShowingForActionMode(boolean bl) {
    }

    @Override
    public void setUiOptions(int n2) {
    }

    @Override
    public void setWindowCallback(Window.Callback callback) {
        this.pullChildren();
        this.mDecorToolbar.setWindowCallback(callback);
    }

    @Override
    public void setWindowTitle(CharSequence charSequence) {
        this.pullChildren();
        this.mDecorToolbar.setWindowTitle(charSequence);
    }

    public boolean shouldDelayChildPressedState() {
        return false;
    }

    @Override
    public boolean showOverflowMenu() {
        this.pullChildren();
        return this.mDecorToolbar.showOverflowMenu();
    }

    public static interface ActionBarVisibilityCallback {
        public void enableContentAnimations(boolean var1);

        public void hideForSystem();

        public void onContentScrollStarted();

        public void onContentScrollStopped();

        public void onWindowVisibilityChanged(int var1);

        public void showForSystem();
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams {
        public LayoutParams(int n2, int n3) {
            super(n2, n3);
        }

        public LayoutParams(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
        }

        public LayoutParams(ViewGroup.LayoutParams layoutParams) {
            super(layoutParams);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams marginLayoutParams) {
            super(marginLayoutParams);
        }
    }
}

