/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.widget;

import android.content.Context;
import android.content.res.Configuration;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.support.v4.view.ActionProvider;
import android.support.v7.appcompat.R;
import android.support.v7.transition.ActionBarTransition;
import android.support.v7.view.ActionBarPolicy;
import android.support.v7.view.menu.ActionMenuItemView;
import android.support.v7.view.menu.BaseMenuPresenter;
import android.support.v7.view.menu.MenuBuilder;
import android.support.v7.view.menu.MenuItemImpl;
import android.support.v7.view.menu.MenuPopupHelper;
import android.support.v7.view.menu.MenuPresenter;
import android.support.v7.view.menu.MenuView;
import android.support.v7.view.menu.SubMenuBuilder;
import android.support.v7.widget.ActionMenuView;
import android.support.v7.widget.AppCompatImageView;
import android.support.v7.widget.ListPopupWindow;
import android.util.SparseBooleanArray;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import java.util.ArrayList;

class ActionMenuPresenter
extends BaseMenuPresenter
implements ActionProvider.SubUiVisibilityListener {
    private static final String TAG = "ActionMenuPresenter";
    private final SparseBooleanArray mActionButtonGroups = new SparseBooleanArray();
    private ActionButtonSubmenu mActionButtonPopup;
    private int mActionItemWidthLimit;
    private boolean mExpandedActionViewsExclusive;
    private int mMaxItems;
    private boolean mMaxItemsSet;
    private int mMinCellSize;
    int mOpenSubMenuId;
    private OverflowMenuButton mOverflowButton;
    private OverflowPopup mOverflowPopup;
    private Drawable mPendingOverflowIcon;
    private boolean mPendingOverflowIconSet;
    private ActionMenuPopupCallback mPopupCallback;
    final PopupPresenterCallback mPopupPresenterCallback = new PopupPresenterCallback();
    private OpenOverflowRunnable mPostedOpenRunnable;
    private boolean mReserveOverflow;
    private boolean mReserveOverflowSet;
    private View mScrapActionButtonView;
    private boolean mStrictWidthLimit;
    private int mWidthLimit;
    private boolean mWidthLimitSet;

    public ActionMenuPresenter(Context context) {
        super(context, R.layout.abc_action_menu_layout, R.layout.abc_action_menu_item_layout);
    }

    static /* synthetic */ OverflowPopup access$202(ActionMenuPresenter actionMenuPresenter, OverflowPopup overflowPopup) {
        actionMenuPresenter.mOverflowPopup = overflowPopup;
        return overflowPopup;
    }

    static /* synthetic */ OpenOverflowRunnable access$302(ActionMenuPresenter actionMenuPresenter, OpenOverflowRunnable openOverflowRunnable) {
        actionMenuPresenter.mPostedOpenRunnable = openOverflowRunnable;
        return openOverflowRunnable;
    }

    static /* synthetic */ ActionButtonSubmenu access$802(ActionMenuPresenter actionMenuPresenter, ActionButtonSubmenu actionButtonSubmenu) {
        actionMenuPresenter.mActionButtonPopup = actionButtonSubmenu;
        return actionButtonSubmenu;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private View findViewForItem(MenuItem menuItem) {
        ViewGroup viewGroup = (ViewGroup)this.mMenuView;
        if (viewGroup == null) {
            return null;
        }
        int n2 = viewGroup.getChildCount();
        int n3 = 0;
        while (n3 < n2) {
            View view = viewGroup.getChildAt(n3);
            if (view instanceof MenuView.ItemView) {
                View view2 = view;
                if (((MenuView.ItemView)view).getItemData() == menuItem) return view2;
            }
            ++n3;
        }
        return null;
    }

    @Override
    public void bindItemView(MenuItemImpl object, MenuView.ItemView itemView) {
        itemView.initialize((MenuItemImpl)object, 0);
        object = (ActionMenuView)this.mMenuView;
        itemView = (ActionMenuItemView)itemView;
        ((ActionMenuItemView)itemView).setItemInvoker((MenuBuilder.ItemInvoker)object);
        if (this.mPopupCallback == null) {
            this.mPopupCallback = new ActionMenuPopupCallback();
        }
        ((ActionMenuItemView)itemView).setPopupCallback(this.mPopupCallback);
    }

    public boolean dismissPopupMenus() {
        return this.hideOverflowMenu() | this.hideSubMenus();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean filterLeftoverView(ViewGroup viewGroup, int n2) {
        if (viewGroup.getChildAt(n2) != this.mOverflowButton) return super.filterLeftoverView(viewGroup, n2);
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean flagActionItems() {
        int n2;
        MenuItemImpl menuItemImpl;
        int n3;
        int n4;
        int n5;
        int n6;
        ViewGroup viewGroup;
        int n7;
        int n8;
        int n9;
        int n10;
        ArrayList<MenuItemImpl> arrayList;
        block32: {
            block33: {
                arrayList = this.mMenu.getVisibleItems();
                n10 = arrayList.size();
                n9 = this.mMaxItems;
                n8 = this.mActionItemWidthLimit;
                n7 = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
                viewGroup = (ViewGroup)this.mMenuView;
                n6 = 0;
                n5 = 0;
                n4 = 0;
                for (n3 = 0; n3 < n10; ++n3) {
                    menuItemImpl = arrayList.get(n3);
                    if (menuItemImpl.requiresActionButton()) {
                        ++n6;
                    } else if (menuItemImpl.requestsActionButton()) {
                        ++n5;
                    } else {
                        n4 = 1;
                    }
                    if (!this.mExpandedActionViewsExclusive || !menuItemImpl.isActionViewExpanded()) continue;
                    n9 = 0;
                }
                n3 = n9;
                if (!this.mReserveOverflow) break block32;
                if (n4 != 0) break block33;
                n3 = n9;
                if (n6 + n5 <= n9) break block32;
            }
            n3 = n9 - 1;
        }
        n3 -= n6;
        menuItemImpl = this.mActionButtonGroups;
        menuItemImpl.clear();
        n9 = 0;
        if (this.mStrictWidthLimit) {
            n9 = n8 / this.mMinCellSize;
            n6 = this.mMinCellSize;
            n5 = this.mMinCellSize;
            n2 = n8 % n6 / n9 + n5;
        } else {
            n2 = 0;
        }
        int n11 = 0;
        n4 = 0;
        n6 = n9;
        n9 = n3;
        n5 = n8;
        n3 = n4;
        while (true) {
            block35: {
                int n12;
                boolean bl;
                int n13;
                View view;
                MenuItemImpl menuItemImpl2;
                block31: {
                    block37: {
                        block36: {
                            block34: {
                                if (n11 >= n10) {
                                    return true;
                                }
                                menuItemImpl2 = arrayList.get(n11);
                                if (!menuItemImpl2.requiresActionButton()) break block34;
                                view = this.getItemView(menuItemImpl2, this.mScrapActionButtonView, viewGroup);
                                if (this.mScrapActionButtonView == null) {
                                    this.mScrapActionButtonView = view;
                                }
                                if (this.mStrictWidthLimit) {
                                    n4 = n6 - ActionMenuView.measureChildForCells(view, n2, n6, n7, 0);
                                } else {
                                    view.measure(n7, n7);
                                    n4 = n6;
                                }
                                n6 = view.getMeasuredWidth();
                                if (n3 == 0) {
                                    n3 = n6;
                                }
                                if ((n8 = menuItemImpl2.getGroupId()) != 0) {
                                    menuItemImpl.put(n8, true);
                                }
                                menuItemImpl2.setIsActionButton(true);
                                n8 = n5 - n6;
                                n6 = n9;
                                n5 = n4;
                                n9 = n8;
                                break block35;
                            }
                            if (!menuItemImpl2.requestsActionButton()) break block36;
                            n13 = menuItemImpl2.getGroupId();
                            bl = menuItemImpl.get(n13);
                            n12 = !(n9 <= 0 && !bl || n5 <= 0 || this.mStrictWidthLimit && n6 <= 0) ? 1 : 0;
                            if (n12 == 0) break block37;
                            view = this.getItemView(menuItemImpl2, this.mScrapActionButtonView, viewGroup);
                            if (this.mScrapActionButtonView == null) {
                                this.mScrapActionButtonView = view;
                            }
                            if (this.mStrictWidthLimit) {
                                n4 = ActionMenuView.measureChildForCells(view, n2, n6, n7, 0);
                                if (n4 == 0) {
                                    n12 = 0;
                                }
                                n6 -= n4;
                            } else {
                                view.measure(n7, n7);
                            }
                            n4 = view.getMeasuredWidth();
                            n8 = n5 - n4;
                            n5 = n3;
                            if (n3 == 0) {
                                n5 = n4;
                            }
                            if (this.mStrictWidthLimit) {
                                n3 = n8 >= 0 ? 1 : 0;
                                n12 &= n3;
                                n4 = n5;
                                n3 = n6;
                                n5 = n8;
                                n6 = n4;
                                break block31;
                            } else {
                                n3 = n8 + n5 > 0 ? 1 : 0;
                                n12 &= n3;
                                n3 = n6;
                                n6 = n5;
                                n5 = n8;
                            }
                            break block31;
                        }
                        menuItemImpl2.setIsActionButton(false);
                        n4 = n9;
                        n9 = n5;
                        n5 = n6;
                        n6 = n4;
                        break block35;
                    }
                    n4 = n3;
                    n3 = n6;
                    n6 = n4;
                }
                if (n12 != 0 && n13 != 0) {
                    menuItemImpl.put(n13, true);
                } else if (bl) {
                    menuItemImpl.put(n13, false);
                    for (n8 = 0; n8 < n11; ++n8) {
                        view = arrayList.get(n8);
                        n4 = n9;
                        if (view.getGroupId() == n13) {
                            n4 = n9;
                            if (view.isActionButton()) {
                                n4 = n9 + 1;
                            }
                            view.setIsActionButton(false);
                        }
                        n9 = n4;
                    }
                }
                n4 = n9;
                if (n12 != 0) {
                    n4 = n9 - 1;
                }
                menuItemImpl2.setIsActionButton(n12 != 0);
                n9 = n5;
                n5 = n3;
                n3 = n6;
                n6 = n4;
            }
            ++n11;
            n4 = n6;
            n6 = n5;
            n5 = n9;
            n9 = n4;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public View getItemView(MenuItemImpl object, View view, ViewGroup viewGroup) {
        View view2 = object.getActionView();
        if (view2 == null || object.hasCollapsibleActionView()) {
            view2 = super.getItemView((MenuItemImpl)object, view, viewGroup);
        }
        int n2 = object.isActionViewExpanded() ? 8 : 0;
        view2.setVisibility(n2);
        object = (ActionMenuView)viewGroup;
        view = view2.getLayoutParams();
        if (!((ActionMenuView)object).checkLayoutParams((ViewGroup.LayoutParams)view)) {
            view2.setLayoutParams((ViewGroup.LayoutParams)((ActionMenuView)object).generateLayoutParams((ViewGroup.LayoutParams)view));
        }
        return view2;
    }

    @Override
    public MenuView getMenuView(ViewGroup object) {
        object = super.getMenuView((ViewGroup)object);
        ((ActionMenuView)object).setPresenter(this);
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Drawable getOverflowIcon() {
        if (this.mOverflowButton != null) {
            return this.mOverflowButton.getDrawable();
        }
        if (!this.mPendingOverflowIconSet) return null;
        return this.mPendingOverflowIcon;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hideOverflowMenu() {
        if (this.mPostedOpenRunnable != null && this.mMenuView != null) {
            ((View)this.mMenuView).removeCallbacks((Runnable)this.mPostedOpenRunnable);
            this.mPostedOpenRunnable = null;
            return true;
        }
        OverflowPopup overflowPopup = this.mOverflowPopup;
        if (overflowPopup == null) return false;
        overflowPopup.dismiss();
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hideSubMenus() {
        if (this.mActionButtonPopup == null) return false;
        this.mActionButtonPopup.dismiss();
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void initForMenu(Context object, MenuBuilder menuBuilder) {
        super.initForMenu((Context)object, menuBuilder);
        menuBuilder = object.getResources();
        object = ActionBarPolicy.get((Context)object);
        if (!this.mReserveOverflowSet) {
            this.mReserveOverflow = ((ActionBarPolicy)object).showsOverflowMenuButton();
        }
        if (!this.mWidthLimitSet) {
            this.mWidthLimit = ((ActionBarPolicy)object).getEmbeddedMenuWidthLimit();
        }
        if (!this.mMaxItemsSet) {
            this.mMaxItems = ((ActionBarPolicy)object).getMaxActionButtons();
        }
        int n2 = this.mWidthLimit;
        if (this.mReserveOverflow) {
            if (this.mOverflowButton == null) {
                this.mOverflowButton = new OverflowMenuButton(this.mSystemContext);
                if (this.mPendingOverflowIconSet) {
                    this.mOverflowButton.setImageDrawable(this.mPendingOverflowIcon);
                    this.mPendingOverflowIcon = null;
                    this.mPendingOverflowIconSet = false;
                }
                int n3 = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
                this.mOverflowButton.measure(n3, n3);
            }
            n2 -= this.mOverflowButton.getMeasuredWidth();
        } else {
            this.mOverflowButton = null;
        }
        this.mActionItemWidthLimit = n2;
        this.mMinCellSize = (int)(56.0f * menuBuilder.getDisplayMetrics().density);
        this.mScrapActionButtonView = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isOverflowMenuShowPending() {
        if (this.mPostedOpenRunnable != null) return true;
        if (!this.isOverflowMenuShowing()) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isOverflowMenuShowing() {
        if (this.mOverflowPopup == null) return false;
        if (!this.mOverflowPopup.isShowing()) return false;
        return true;
    }

    public boolean isOverflowReserved() {
        return this.mReserveOverflow;
    }

    @Override
    public void onCloseMenu(MenuBuilder menuBuilder, boolean bl) {
        this.dismissPopupMenus();
        super.onCloseMenu(menuBuilder, bl);
    }

    public void onConfigurationChanged(Configuration configuration) {
        if (!this.mMaxItemsSet) {
            this.mMaxItems = this.mContext.getResources().getInteger(R.integer.abc_max_action_buttons);
        }
        if (this.mMenu != null) {
            this.mMenu.onItemsChanged(true);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onRestoreInstanceState(Parcelable parcelable) {
        if (!(parcelable instanceof SavedState)) {
            return;
        }
        parcelable = (SavedState)parcelable;
        if (parcelable.openSubMenuId <= 0) return;
        parcelable = this.mMenu.findItem(parcelable.openSubMenuId);
        if (parcelable == null) return;
        this.onSubMenuSelected((SubMenuBuilder)parcelable.getSubMenu());
    }

    @Override
    public Parcelable onSaveInstanceState() {
        SavedState savedState = new SavedState();
        savedState.openSubMenuId = this.mOpenSubMenuId;
        return savedState;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean onSubMenuSelected(SubMenuBuilder subMenuBuilder) {
        if (!subMenuBuilder.hasVisibleItems()) {
            return false;
        }
        Object object = subMenuBuilder;
        while (((SubMenuBuilder)object).getParentMenu() != this.mMenu) {
            object = (SubMenuBuilder)((SubMenuBuilder)object).getParentMenu();
        }
        View view = this.findViewForItem(((SubMenuBuilder)object).getItem());
        object = view;
        if (view == null) {
            if (this.mOverflowButton == null) {
                return false;
            }
            object = this.mOverflowButton;
        }
        this.mOpenSubMenuId = subMenuBuilder.getItem().getItemId();
        this.mActionButtonPopup = new ActionButtonSubmenu(this, this.mContext, subMenuBuilder);
        this.mActionButtonPopup.setAnchorView((View)object);
        this.mActionButtonPopup.show();
        super.onSubMenuSelected(subMenuBuilder);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onSubUiVisibilityChanged(boolean bl) {
        if (bl) {
            super.onSubMenuSelected(null);
            return;
        }
        this.mMenu.close(false);
    }

    public void setExpandedActionViewsExclusive(boolean bl) {
        this.mExpandedActionViewsExclusive = bl;
    }

    public void setItemLimit(int n2) {
        this.mMaxItems = n2;
        this.mMaxItemsSet = true;
    }

    public void setMenuView(ActionMenuView actionMenuView) {
        this.mMenuView = actionMenuView;
        actionMenuView.initialize(this.mMenu);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setOverflowIcon(Drawable drawable2) {
        if (this.mOverflowButton != null) {
            this.mOverflowButton.setImageDrawable(drawable2);
            return;
        }
        this.mPendingOverflowIconSet = true;
        this.mPendingOverflowIcon = drawable2;
    }

    public void setReserveOverflow(boolean bl) {
        this.mReserveOverflow = bl;
        this.mReserveOverflowSet = true;
    }

    public void setWidthLimit(int n2, boolean bl) {
        this.mWidthLimit = n2;
        this.mStrictWidthLimit = bl;
        this.mWidthLimitSet = true;
    }

    @Override
    public boolean shouldIncludeItem(int n2, MenuItemImpl menuItemImpl) {
        return menuItemImpl.isActionButton();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean showOverflowMenu() {
        boolean bl = true;
        if (!this.mReserveOverflow) return false;
        if (this.isOverflowMenuShowing()) return false;
        if (this.mMenu == null) return false;
        if (this.mMenuView == null) return false;
        if (this.mPostedOpenRunnable != null) return false;
        if (this.mMenu.getNonActionItems().isEmpty()) return false;
        this.mPostedOpenRunnable = new OpenOverflowRunnable(new OverflowPopup(this.mContext, this.mMenu, (View)this.mOverflowButton, true));
        ((View)this.mMenuView).post((Runnable)this.mPostedOpenRunnable);
        super.onSubMenuSelected(null);
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void updateMenuView(boolean bl) {
        int n2;
        int n3 = 1;
        int n4 = 0;
        Object object = (ViewGroup)((View)this.mMenuView).getParent();
        if (object != null) {
            ActionBarTransition.beginDelayedTransition((ViewGroup)object);
        }
        super.updateMenuView(bl);
        ((View)this.mMenuView).requestLayout();
        if (this.mMenu != null) {
            object = this.mMenu.getActionItems();
            int n5 = ((ArrayList)object).size();
            for (n2 = 0; n2 < n5; ++n2) {
                ActionProvider actionProvider = ((MenuItemImpl)((ArrayList)object).get(n2)).getSupportActionProvider();
                if (actionProvider == null) continue;
                actionProvider.setSubUiVisibilityListener((ActionProvider.SubUiVisibilityListener)this);
            }
        }
        object = this.mMenu != null ? this.mMenu.getNonActionItems() : null;
        n2 = n4;
        if (this.mReserveOverflow) {
            n2 = n4;
            if (object != null) {
                n2 = ((ArrayList)object).size();
                n2 = n2 == 1 ? (!((MenuItemImpl)((ArrayList)object).get(0)).isActionViewExpanded() ? 1 : 0) : (n2 > 0 ? n3 : 0);
            }
        }
        if (n2 != 0) {
            if (this.mOverflowButton == null) {
                this.mOverflowButton = new OverflowMenuButton(this.mSystemContext);
            }
            if ((object = (ViewGroup)this.mOverflowButton.getParent()) != this.mMenuView) {
                if (object != null) {
                    object.removeView((View)this.mOverflowButton);
                }
                object = (ActionMenuView)this.mMenuView;
                object.addView((View)this.mOverflowButton, (ViewGroup.LayoutParams)((ActionMenuView)object).generateOverflowButtonLayoutParams());
            }
        } else if (this.mOverflowButton != null && this.mOverflowButton.getParent() == this.mMenuView) {
            ((ViewGroup)this.mMenuView).removeView((View)this.mOverflowButton);
        }
        ((ActionMenuView)this.mMenuView).setOverflowReserved(this.mReserveOverflow);
    }

    private class ActionButtonSubmenu
    extends MenuPopupHelper {
        private SubMenuBuilder mSubMenu;
        final /* synthetic */ ActionMenuPresenter this$0;

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        public ActionButtonSubmenu(ActionMenuPresenter actionMenuPresenter, Context object, SubMenuBuilder subMenuBuilder) {
            void var3_7;
            boolean bl = false;
            this.this$0 = actionMenuPresenter;
            super((Context)object, (MenuBuilder)var3_7, null, false, R.attr.actionOverflowMenuStyle);
            this.mSubMenu = var3_7;
            if (!((MenuItemImpl)var3_7.getItem()).isActionButton()) {
                void var2_4;
                if (actionMenuPresenter.mOverflowButton == null) {
                    View view = (View)actionMenuPresenter.mMenuView;
                } else {
                    OverflowMenuButton overflowMenuButton = actionMenuPresenter.mOverflowButton;
                }
                this.setAnchorView((View)var2_4);
            }
            this.setCallback(actionMenuPresenter.mPopupPresenterCallback);
            int n2 = var3_7.size();
            int n3 = 0;
            while (true) {
                block8: {
                    boolean bl2;
                    block7: {
                        bl2 = bl;
                        if (n3 >= n2) break block7;
                        actionMenuPresenter = var3_7.getItem(n3);
                        if (!actionMenuPresenter.isVisible() || actionMenuPresenter.getIcon() == null) break block8;
                        bl2 = true;
                    }
                    this.setForceShowIcon(bl2);
                    return;
                }
                ++n3;
            }
        }

        @Override
        public void onDismiss() {
            super.onDismiss();
            ActionMenuPresenter.access$802(this.this$0, null);
            this.this$0.mOpenSubMenuId = 0;
        }
    }

    private class ActionMenuPopupCallback
    extends ActionMenuItemView.PopupCallback {
        private ActionMenuPopupCallback() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public ListPopupWindow getPopup() {
            if (ActionMenuPresenter.this.mActionButtonPopup == null) return null;
            return ActionMenuPresenter.this.mActionButtonPopup.getPopup();
        }
    }

    private class OpenOverflowRunnable
    implements Runnable {
        private OverflowPopup mPopup;

        public OpenOverflowRunnable(OverflowPopup overflowPopup) {
            this.mPopup = overflowPopup;
        }

        @Override
        public void run() {
            ActionMenuPresenter.this.mMenu.changeMenuMode();
            View view = (View)ActionMenuPresenter.this.mMenuView;
            if (view != null && view.getWindowToken() != null && this.mPopup.tryShow()) {
                ActionMenuPresenter.access$202(ActionMenuPresenter.this, this.mPopup);
            }
            ActionMenuPresenter.access$302(ActionMenuPresenter.this, null);
        }
    }

    private class OverflowMenuButton
    extends AppCompatImageView
    implements ActionMenuView.ActionMenuChildView {
        private final float[] mTempPts;

        public OverflowMenuButton(Context context) {
            super(context, null, R.attr.actionOverflowButtonStyle);
            this.mTempPts = new float[2];
            this.setClickable(true);
            this.setFocusable(true);
            this.setVisibility(0);
            this.setEnabled(true);
            this.setOnTouchListener(new ListPopupWindow.ForwardingListener((View)this){

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public ListPopupWindow getPopup() {
                    if (ActionMenuPresenter.this.mOverflowPopup != null) return ActionMenuPresenter.this.mOverflowPopup.getPopup();
                    return null;
                }

                @Override
                public boolean onForwardingStarted() {
                    ActionMenuPresenter.this.showOverflowMenu();
                    return true;
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public boolean onForwardingStopped() {
                    if (ActionMenuPresenter.this.mPostedOpenRunnable != null) {
                        return false;
                    }
                    ActionMenuPresenter.this.hideOverflowMenu();
                    return true;
                }
            });
        }

        @Override
        public boolean needsDividerAfter() {
            return false;
        }

        @Override
        public boolean needsDividerBefore() {
            return false;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean performClick() {
            if (super.performClick()) {
                return true;
            }
            this.playSoundEffect(0);
            ActionMenuPresenter.this.showOverflowMenu();
            return true;
        }

        protected boolean setFrame(int n2, int n3, int n4, int n5) {
            boolean bl = super.setFrame(n2, n3, n4, n5);
            Drawable drawable2 = this.getDrawable();
            Drawable drawable3 = this.getBackground();
            if (drawable2 != null && drawable3 != null) {
                int n6 = this.getWidth();
                n5 = this.getHeight();
                n2 = Math.max(n6, n5) / 2;
                int n7 = this.getPaddingLeft();
                int n8 = this.getPaddingRight();
                n3 = this.getPaddingTop();
                n4 = this.getPaddingBottom();
                n8 = (n6 + (n7 - n8)) / 2;
                n3 = (n5 + (n3 - n4)) / 2;
                DrawableCompat.setHotspotBounds((Drawable)drawable3, (int)(n8 - n2), (int)(n3 - n2), (int)(n8 + n2), (int)(n3 + n2));
            }
            return bl;
        }
    }

    private class OverflowPopup
    extends MenuPopupHelper {
        public OverflowPopup(Context context, MenuBuilder menuBuilder, View view, boolean bl) {
            super(context, menuBuilder, view, bl, R.attr.actionOverflowMenuStyle);
            this.setGravity(0x800005);
            this.setCallback(ActionMenuPresenter.this.mPopupPresenterCallback);
        }

        @Override
        public void onDismiss() {
            super.onDismiss();
            if (ActionMenuPresenter.this.mMenu != null) {
                ActionMenuPresenter.this.mMenu.close();
            }
            ActionMenuPresenter.access$202(ActionMenuPresenter.this, null);
        }
    }

    private class PopupPresenterCallback
    implements MenuPresenter.Callback {
        private PopupPresenterCallback() {
        }

        @Override
        public void onCloseMenu(MenuBuilder menuBuilder, boolean bl) {
            MenuPresenter.Callback callback;
            if (menuBuilder instanceof SubMenuBuilder) {
                ((SubMenuBuilder)menuBuilder).getRootMenu().close(false);
            }
            if ((callback = ActionMenuPresenter.this.getCallback()) != null) {
                callback.onCloseMenu(menuBuilder, bl);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean onOpenSubMenu(MenuBuilder menuBuilder) {
            boolean bl = false;
            if (menuBuilder == null) {
                return bl;
            }
            ActionMenuPresenter.this.mOpenSubMenuId = ((SubMenuBuilder)menuBuilder).getItem().getItemId();
            MenuPresenter.Callback callback = ActionMenuPresenter.this.getCallback();
            if (callback == null) return false;
            return callback.onOpenSubMenu(menuBuilder);
        }
    }

    private static class SavedState
    implements Parcelable {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel parcel) {
                return new SavedState(parcel);
            }

            public SavedState[] newArray(int n2) {
                return new SavedState[n2];
            }
        };
        public int openSubMenuId;

        SavedState() {
        }

        SavedState(Parcel parcel) {
            this.openSubMenuId = parcel.readInt();
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel parcel, int n2) {
            parcel.writeInt(this.openSubMenuId);
        }
    }
}

