/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.widget;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.graphics.drawable.Drawable;
import android.support.v4.view.ActionProvider;
import android.support.v4.view.ViewCompat;
import android.support.v7.appcompat.R;
import android.support.v7.widget.ActivityChooserModel;
import android.support.v7.widget.LinearLayoutCompat;
import android.support.v7.widget.ListPopupWindow;
import android.support.v7.widget.TintTypedArray;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.PopupWindow;
import android.widget.TextView;

public class ActivityChooserView
extends ViewGroup
implements ActivityChooserModel.ActivityChooserModelClient {
    private static final String LOG_TAG = "ActivityChooserView";
    private final LinearLayoutCompat mActivityChooserContent;
    private final Drawable mActivityChooserContentBackground;
    private final ActivityChooserViewAdapter mAdapter;
    private final Callbacks mCallbacks;
    private int mDefaultActionButtonContentDescription;
    private final FrameLayout mDefaultActivityButton;
    private final ImageView mDefaultActivityButtonImage;
    private final FrameLayout mExpandActivityOverflowButton;
    private final ImageView mExpandActivityOverflowButtonImage;
    private int mInitialActivityCount = 4;
    private boolean mIsAttachedToWindow;
    private boolean mIsSelectingDefaultActivity;
    private final int mListPopupMaxWidth;
    private ListPopupWindow mListPopupWindow;
    private final DataSetObserver mModelDataSetOberver = new DataSetObserver(){

        public void onChanged() {
            super.onChanged();
            ActivityChooserView.this.mAdapter.notifyDataSetChanged();
        }

        public void onInvalidated() {
            super.onInvalidated();
            ActivityChooserView.this.mAdapter.notifyDataSetInvalidated();
        }
    };
    private PopupWindow.OnDismissListener mOnDismissListener;
    private final ViewTreeObserver.OnGlobalLayoutListener mOnGlobalLayoutListener = new ViewTreeObserver.OnGlobalLayoutListener(){

        /*
         * Enabled aggressive block sorting
         */
        public void onGlobalLayout() {
            if (!ActivityChooserView.this.isShowingPopup()) return;
            if (!ActivityChooserView.this.isShown()) {
                ActivityChooserView.this.getListPopupWindow().dismiss();
                return;
            }
            ActivityChooserView.this.getListPopupWindow().show();
            if (ActivityChooserView.this.mProvider == null) return;
            ActivityChooserView.this.mProvider.subUiVisibilityChanged(true);
        }
    };
    ActionProvider mProvider;

    public ActivityChooserView(Context context) {
        this(context, null);
    }

    public ActivityChooserView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public ActivityChooserView(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.ActivityChooserView, n2, 0);
        this.mInitialActivityCount = typedArray.getInt(R.styleable.ActivityChooserView_initialActivityCount, 4);
        attributeSet = typedArray.getDrawable(R.styleable.ActivityChooserView_expandActivityOverflowButtonDrawable);
        typedArray.recycle();
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.abc_activity_chooser_view, (ViewGroup)this, true);
        this.mCallbacks = new Callbacks();
        this.mActivityChooserContent = (LinearLayoutCompat)this.findViewById(R.id.activity_chooser_view_content);
        this.mActivityChooserContentBackground = this.mActivityChooserContent.getBackground();
        this.mDefaultActivityButton = (FrameLayout)this.findViewById(R.id.default_activity_button);
        this.mDefaultActivityButton.setOnClickListener((View.OnClickListener)this.mCallbacks);
        this.mDefaultActivityButton.setOnLongClickListener((View.OnLongClickListener)this.mCallbacks);
        this.mDefaultActivityButtonImage = (ImageView)this.mDefaultActivityButton.findViewById(R.id.image);
        typedArray = (FrameLayout)this.findViewById(R.id.expand_activities_button);
        typedArray.setOnClickListener((View.OnClickListener)this.mCallbacks);
        typedArray.setOnTouchListener((View.OnTouchListener)new ListPopupWindow.ForwardingListener((View)typedArray){

            @Override
            public ListPopupWindow getPopup() {
                return ActivityChooserView.this.getListPopupWindow();
            }

            @Override
            protected boolean onForwardingStarted() {
                ActivityChooserView.this.showPopup();
                return true;
            }

            @Override
            protected boolean onForwardingStopped() {
                ActivityChooserView.this.dismissPopup();
                return true;
            }
        });
        this.mExpandActivityOverflowButton = typedArray;
        this.mExpandActivityOverflowButtonImage = (ImageView)typedArray.findViewById(R.id.image);
        this.mExpandActivityOverflowButtonImage.setImageDrawable((Drawable)attributeSet);
        this.mAdapter = new ActivityChooserViewAdapter();
        this.mAdapter.registerDataSetObserver(new DataSetObserver(){

            public void onChanged() {
                super.onChanged();
                ActivityChooserView.this.updateAppearance();
            }
        });
        context = context.getResources();
        this.mListPopupMaxWidth = Math.max(context.getDisplayMetrics().widthPixels / 2, context.getDimensionPixelSize(R.dimen.abc_config_prefDialogWidth));
    }

    static /* synthetic */ boolean access$602(ActivityChooserView activityChooserView, boolean bl) {
        activityChooserView.mIsSelectingDefaultActivity = bl;
        return bl;
    }

    private ListPopupWindow getListPopupWindow() {
        if (this.mListPopupWindow == null) {
            this.mListPopupWindow = new ListPopupWindow(this.getContext());
            this.mListPopupWindow.setAdapter((ListAdapter)this.mAdapter);
            this.mListPopupWindow.setAnchorView((View)this);
            this.mListPopupWindow.setModal(true);
            this.mListPopupWindow.setOnItemClickListener(this.mCallbacks);
            this.mListPopupWindow.setOnDismissListener(this.mCallbacks);
        }
        return this.mListPopupWindow;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void showPopupUnchecked(int n2) {
        ListPopupWindow listPopupWindow;
        if (this.mAdapter.getDataModel() == null) {
            throw new IllegalStateException("No data model. Did you call #setDataModel?");
        }
        this.getViewTreeObserver().addOnGlobalLayoutListener(this.mOnGlobalLayoutListener);
        boolean bl = this.mDefaultActivityButton.getVisibility() == 0;
        int n3 = this.mAdapter.getActivityCount();
        int n4 = bl ? 1 : 0;
        if (n2 != Integer.MAX_VALUE && n3 > n4 + n2) {
            this.mAdapter.setShowFooterView(true);
            this.mAdapter.setMaxActivityCount(n2 - 1);
        } else {
            this.mAdapter.setShowFooterView(false);
            this.mAdapter.setMaxActivityCount(n2);
        }
        if (!(listPopupWindow = this.getListPopupWindow()).isShowing()) {
            if (this.mIsSelectingDefaultActivity || !bl) {
                this.mAdapter.setShowDefaultActivity(true, bl);
            } else {
                this.mAdapter.setShowDefaultActivity(false, false);
            }
            listPopupWindow.setContentWidth(Math.min(this.mAdapter.measureContentWidth(), this.mListPopupMaxWidth));
            listPopupWindow.show();
            if (this.mProvider != null) {
                this.mProvider.subUiVisibilityChanged(true);
            }
            listPopupWindow.getListView().setContentDescription((CharSequence)this.getContext().getString(R.string.abc_activitychooserview_choose_application));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateAppearance() {
        if (this.mAdapter.getCount() > 0) {
            this.mExpandActivityOverflowButton.setEnabled(true);
        } else {
            this.mExpandActivityOverflowButton.setEnabled(false);
        }
        int n2 = this.mAdapter.getActivityCount();
        int n3 = this.mAdapter.getHistorySize();
        if (n2 == 1 || n2 > 1 && n3 > 0) {
            this.mDefaultActivityButton.setVisibility(0);
            ResolveInfo resolveInfo = this.mAdapter.getDefaultActivity();
            PackageManager packageManager = this.getContext().getPackageManager();
            this.mDefaultActivityButtonImage.setImageDrawable(resolveInfo.loadIcon(packageManager));
            if (this.mDefaultActionButtonContentDescription != 0) {
                CharSequence charSequence = resolveInfo.loadLabel(packageManager);
                String string2 = this.getContext().getString(this.mDefaultActionButtonContentDescription, new Object[]{charSequence});
                this.mDefaultActivityButton.setContentDescription((CharSequence)string2);
            }
        } else {
            this.mDefaultActivityButton.setVisibility(8);
        }
        if (this.mDefaultActivityButton.getVisibility() == 0) {
            this.mActivityChooserContent.setBackgroundDrawable(this.mActivityChooserContentBackground);
            return;
        }
        this.mActivityChooserContent.setBackgroundDrawable(null);
    }

    public boolean dismissPopup() {
        if (this.isShowingPopup()) {
            this.getListPopupWindow().dismiss();
            ViewTreeObserver viewTreeObserver = this.getViewTreeObserver();
            if (viewTreeObserver.isAlive()) {
                viewTreeObserver.removeGlobalOnLayoutListener(this.mOnGlobalLayoutListener);
            }
        }
        return true;
    }

    public ActivityChooserModel getDataModel() {
        return this.mAdapter.getDataModel();
    }

    public boolean isShowingPopup() {
        return this.getListPopupWindow().isShowing();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        ActivityChooserModel activityChooserModel = this.mAdapter.getDataModel();
        if (activityChooserModel != null) {
            activityChooserModel.registerObserver(this.mModelDataSetOberver);
        }
        this.mIsAttachedToWindow = true;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        ActivityChooserModel activityChooserModel = this.mAdapter.getDataModel();
        if (activityChooserModel != null) {
            activityChooserModel.unregisterObserver(this.mModelDataSetOberver);
        }
        if ((activityChooserModel = this.getViewTreeObserver()).isAlive()) {
            activityChooserModel.removeGlobalOnLayoutListener(this.mOnGlobalLayoutListener);
        }
        if (this.isShowingPopup()) {
            this.dismissPopup();
        }
        this.mIsAttachedToWindow = false;
    }

    protected void onLayout(boolean bl, int n2, int n3, int n4, int n5) {
        this.mActivityChooserContent.layout(0, 0, n4 - n2, n5 - n3);
        if (!this.isShowingPopup()) {
            this.dismissPopup();
        }
    }

    protected void onMeasure(int n2, int n3) {
        LinearLayoutCompat linearLayoutCompat = this.mActivityChooserContent;
        int n4 = n3;
        if (this.mDefaultActivityButton.getVisibility() != 0) {
            n4 = View.MeasureSpec.makeMeasureSpec((int)View.MeasureSpec.getSize((int)n3), (int)0x40000000);
        }
        this.measureChild((View)linearLayoutCompat, n2, n4);
        this.setMeasuredDimension(linearLayoutCompat.getMeasuredWidth(), linearLayoutCompat.getMeasuredHeight());
    }

    @Override
    public void setActivityChooserModel(ActivityChooserModel activityChooserModel) {
        this.mAdapter.setDataModel(activityChooserModel);
        if (this.isShowingPopup()) {
            this.dismissPopup();
            this.showPopup();
        }
    }

    public void setDefaultActionButtonContentDescription(int n2) {
        this.mDefaultActionButtonContentDescription = n2;
    }

    public void setExpandActivityOverflowButtonContentDescription(int n2) {
        String string2 = this.getContext().getString(n2);
        this.mExpandActivityOverflowButtonImage.setContentDescription((CharSequence)string2);
    }

    public void setExpandActivityOverflowButtonDrawable(Drawable drawable2) {
        this.mExpandActivityOverflowButtonImage.setImageDrawable(drawable2);
    }

    public void setInitialActivityCount(int n2) {
        this.mInitialActivityCount = n2;
    }

    public void setOnDismissListener(PopupWindow.OnDismissListener onDismissListener) {
        this.mOnDismissListener = onDismissListener;
    }

    public void setProvider(ActionProvider actionProvider) {
        this.mProvider = actionProvider;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean showPopup() {
        boolean bl;
        boolean bl2 = bl = false;
        if (this.isShowingPopup()) return bl2;
        if (!this.mIsAttachedToWindow) {
            return bl;
        }
        this.mIsSelectingDefaultActivity = false;
        this.showPopupUnchecked(this.mInitialActivityCount);
        return true;
    }

    private class ActivityChooserViewAdapter
    extends BaseAdapter {
        private static final int ITEM_VIEW_TYPE_ACTIVITY = 0;
        private static final int ITEM_VIEW_TYPE_COUNT = 3;
        private static final int ITEM_VIEW_TYPE_FOOTER = 1;
        public static final int MAX_ACTIVITY_COUNT_DEFAULT = 4;
        public static final int MAX_ACTIVITY_COUNT_UNLIMITED = Integer.MAX_VALUE;
        private ActivityChooserModel mDataModel;
        private boolean mHighlightDefaultActivity;
        private int mMaxActivityCount = 4;
        private boolean mShowDefaultActivity;
        private boolean mShowFooterView;

        private ActivityChooserViewAdapter() {
        }

        public int getActivityCount() {
            return this.mDataModel.getActivityCount();
        }

        public int getCount() {
            int n2;
            int n3 = n2 = this.mDataModel.getActivityCount();
            if (!this.mShowDefaultActivity) {
                n3 = n2;
                if (this.mDataModel.getDefaultActivity() != null) {
                    n3 = n2 - 1;
                }
            }
            n3 = n2 = Math.min(n3, this.mMaxActivityCount);
            if (this.mShowFooterView) {
                n3 = n2 + 1;
            }
            return n3;
        }

        public ActivityChooserModel getDataModel() {
            return this.mDataModel;
        }

        public ResolveInfo getDefaultActivity() {
            return this.mDataModel.getDefaultActivity();
        }

        public int getHistorySize() {
            return this.mDataModel.getHistorySize();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Object getItem(int n2) {
            switch (this.getItemViewType(n2)) {
                default: {
                    throw new IllegalArgumentException();
                }
                case 1: {
                    return null;
                }
                case 0: 
            }
            int n3 = n2;
            if (this.mShowDefaultActivity) return this.mDataModel.getActivity(n3);
            n3 = n2;
            if (this.mDataModel.getDefaultActivity() == null) return this.mDataModel.getActivity(n3);
            n3 = n2 + 1;
            return this.mDataModel.getActivity(n3);
        }

        public long getItemId(int n2) {
            return n2;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public int getItemViewType(int n2) {
            if (!this.mShowFooterView) return 0;
            if (n2 != this.getCount() - 1) return 0;
            return 1;
        }

        public boolean getShowDefaultActivity() {
            return this.mShowDefaultActivity;
        }

        /*
         * Enabled aggressive block sorting
         */
        public View getView(int n2, View view, ViewGroup viewGroup) {
            View view2;
            block10: {
                block9: {
                    switch (this.getItemViewType(n2)) {
                        default: {
                            throw new IllegalArgumentException();
                        }
                        case 1: {
                            if (view != null) {
                                view2 = view;
                                if (view.getId() == 1) return view2;
                            }
                            view2 = LayoutInflater.from((Context)ActivityChooserView.this.getContext()).inflate(R.layout.abc_activity_chooser_view_list_item, viewGroup, false);
                            view2.setId(1);
                            ((TextView)view2.findViewById(R.id.title)).setText((CharSequence)ActivityChooserView.this.getContext().getString(R.string.abc_activity_chooser_view_see_all));
                            return view2;
                        }
                        case 0: 
                    }
                    if (view == null) break block9;
                    view2 = view;
                    if (view.getId() == R.id.list_item) break block10;
                }
                view2 = LayoutInflater.from((Context)ActivityChooserView.this.getContext()).inflate(R.layout.abc_activity_chooser_view_list_item, viewGroup, false);
            }
            viewGroup = ActivityChooserView.this.getContext().getPackageManager();
            ImageView imageView = (ImageView)view2.findViewById(R.id.icon);
            view = (ResolveInfo)this.getItem(n2);
            imageView.setImageDrawable(view.loadIcon((PackageManager)viewGroup));
            ((TextView)view2.findViewById(R.id.title)).setText(view.loadLabel((PackageManager)viewGroup));
            if (this.mShowDefaultActivity && n2 == 0 && this.mHighlightDefaultActivity) {
                ViewCompat.setActivated((View)view2, (boolean)true);
                return view2;
            }
            ViewCompat.setActivated((View)view2, (boolean)false);
            return view2;
        }

        public int getViewTypeCount() {
            return 3;
        }

        public int measureContentWidth() {
            int n2 = this.mMaxActivityCount;
            this.mMaxActivityCount = Integer.MAX_VALUE;
            int n3 = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
            int n4 = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
            int n5 = this.getCount();
            View view = null;
            int n6 = 0;
            for (int i2 = 0; i2 < n5; ++i2) {
                view = this.getView(i2, view, null);
                view.measure(n3, n4);
                n6 = Math.max(n6, view.getMeasuredWidth());
            }
            this.mMaxActivityCount = n2;
            return n6;
        }

        public void setDataModel(ActivityChooserModel activityChooserModel) {
            ActivityChooserModel activityChooserModel2 = ActivityChooserView.this.mAdapter.getDataModel();
            if (activityChooserModel2 != null && ActivityChooserView.this.isShown()) {
                activityChooserModel2.unregisterObserver(ActivityChooserView.this.mModelDataSetOberver);
            }
            this.mDataModel = activityChooserModel;
            if (activityChooserModel != null && ActivityChooserView.this.isShown()) {
                activityChooserModel.registerObserver(ActivityChooserView.this.mModelDataSetOberver);
            }
            this.notifyDataSetChanged();
        }

        public void setMaxActivityCount(int n2) {
            if (this.mMaxActivityCount != n2) {
                this.mMaxActivityCount = n2;
                this.notifyDataSetChanged();
            }
        }

        public void setShowDefaultActivity(boolean bl, boolean bl2) {
            if (this.mShowDefaultActivity != bl || this.mHighlightDefaultActivity != bl2) {
                this.mShowDefaultActivity = bl;
                this.mHighlightDefaultActivity = bl2;
                this.notifyDataSetChanged();
            }
        }

        public void setShowFooterView(boolean bl) {
            if (this.mShowFooterView != bl) {
                this.mShowFooterView = bl;
                this.notifyDataSetChanged();
            }
        }
    }

    private class Callbacks
    implements View.OnClickListener,
    View.OnLongClickListener,
    AdapterView.OnItemClickListener,
    PopupWindow.OnDismissListener {
        private Callbacks() {
        }

        private void notifyOnDismissListener() {
            if (ActivityChooserView.this.mOnDismissListener != null) {
                ActivityChooserView.this.mOnDismissListener.onDismiss();
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void onClick(View view) {
            if (view == ActivityChooserView.this.mDefaultActivityButton) {
                ActivityChooserView.this.dismissPopup();
                view = ActivityChooserView.this.mAdapter.getDefaultActivity();
                int n2 = ActivityChooserView.this.mAdapter.getDataModel().getActivityIndex((ResolveInfo)view);
                view = ActivityChooserView.this.mAdapter.getDataModel().chooseActivity(n2);
                if (view != null) {
                    view.addFlags(524288);
                    ActivityChooserView.this.getContext().startActivity((Intent)view);
                }
                return;
            }
            if (view != ActivityChooserView.this.mExpandActivityOverflowButton) throw new IllegalArgumentException();
            ActivityChooserView.access$602(ActivityChooserView.this, false);
            ActivityChooserView.this.showPopupUnchecked(ActivityChooserView.this.mInitialActivityCount);
        }

        public void onDismiss() {
            this.notifyOnDismissListener();
            if (ActivityChooserView.this.mProvider != null) {
                ActivityChooserView.this.mProvider.subUiVisibilityChanged(false);
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        public void onItemClick(AdapterView<?> intent, View view, int n2, long l2) {
            switch (((ActivityChooserViewAdapter)intent.getAdapter()).getItemViewType(n2)) {
                default: {
                    throw new IllegalArgumentException();
                }
                case 1: {
                    ActivityChooserView.this.showPopupUnchecked(Integer.MAX_VALUE);
                    return;
                }
                case 0: 
            }
            ActivityChooserView.this.dismissPopup();
            if (ActivityChooserView.this.mIsSelectingDefaultActivity) {
                if (n2 <= 0) return;
                ActivityChooserView.this.mAdapter.getDataModel().setDefaultActivity(n2);
                return;
            }
            if (!ActivityChooserView.this.mAdapter.getShowDefaultActivity()) {
                ++n2;
            }
            if ((intent = ActivityChooserView.this.mAdapter.getDataModel().chooseActivity(n2)) == null) return;
            intent.addFlags(524288);
            ActivityChooserView.this.getContext().startActivity(intent);
        }

        public boolean onLongClick(View view) {
            if (view == ActivityChooserView.this.mDefaultActivityButton) {
                if (ActivityChooserView.this.mAdapter.getCount() > 0) {
                    ActivityChooserView.access$602(ActivityChooserView.this, true);
                    ActivityChooserView.this.showPopupUnchecked(ActivityChooserView.this.mInitialActivityCount);
                }
                return true;
            }
            throw new IllegalArgumentException();
        }
    }

    public static class InnerLayout
    extends LinearLayoutCompat {
        private static final int[] TINT_ATTRS = new int[]{16842964};

        public InnerLayout(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
            context = TintTypedArray.obtainStyledAttributes((Context)context, (AttributeSet)attributeSet, (int[])TINT_ATTRS);
            this.setBackgroundDrawable(context.getDrawable(0));
            context.recycle();
        }
    }
}

