/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.widget;

import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.Nullable;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.support.v4.widget.CompoundButtonCompat;
import android.support.v7.appcompat.R;
import android.support.v7.widget.AppCompatDrawableManager;
import android.support.v7.widget.DrawableUtils;
import android.util.AttributeSet;
import android.widget.CompoundButton;

class AppCompatCompoundButtonHelper {
    private ColorStateList mButtonTintList = null;
    private PorterDuff.Mode mButtonTintMode = null;
    private final AppCompatDrawableManager mDrawableManager;
    private boolean mHasButtonTint = false;
    private boolean mHasButtonTintMode = false;
    private boolean mSkipNextApply;
    private final CompoundButton mView;

    AppCompatCompoundButtonHelper(CompoundButton compoundButton, AppCompatDrawableManager appCompatDrawableManager) {
        this.mView = compoundButton;
        this.mDrawableManager = appCompatDrawableManager;
    }

    void applyButtonTint() {
        Drawable drawable2 = CompoundButtonCompat.getButtonDrawable((CompoundButton)this.mView);
        if (drawable2 != null && (this.mHasButtonTint || this.mHasButtonTintMode)) {
            drawable2 = DrawableCompat.wrap((Drawable)drawable2).mutate();
            if (this.mHasButtonTint) {
                DrawableCompat.setTintList((Drawable)drawable2, (ColorStateList)this.mButtonTintList);
            }
            if (this.mHasButtonTintMode) {
                DrawableCompat.setTintMode((Drawable)drawable2, (PorterDuff.Mode)this.mButtonTintMode);
            }
            if (drawable2.isStateful()) {
                drawable2.setState(this.mView.getDrawableState());
            }
            this.mView.setButtonDrawable(drawable2);
        }
    }

    int getCompoundPaddingLeft(int n2) {
        int n3 = n2;
        if (Build.VERSION.SDK_INT < 17) {
            Drawable drawable2 = CompoundButtonCompat.getButtonDrawable((CompoundButton)this.mView);
            n3 = n2;
            if (drawable2 != null) {
                n3 = n2 + drawable2.getIntrinsicWidth();
            }
        }
        return n3;
    }

    ColorStateList getSupportButtonTintList() {
        return this.mButtonTintList;
    }

    PorterDuff.Mode getSupportButtonTintMode() {
        return this.mButtonTintMode;
    }

    void loadFromAttributes(AttributeSet attributeSet, int n2) {
        TypedArray typedArray = this.mView.getContext().obtainStyledAttributes(attributeSet, R.styleable.CompoundButton, n2, 0);
        try {
            if (typedArray.hasValue(R.styleable.CompoundButton_android_button) && (n2 = typedArray.getResourceId(R.styleable.CompoundButton_android_button, 0)) != 0) {
                this.mView.setButtonDrawable(this.mDrawableManager.getDrawable(this.mView.getContext(), n2));
            }
            if (typedArray.hasValue(R.styleable.CompoundButton_buttonTint)) {
                CompoundButtonCompat.setButtonTintList((CompoundButton)this.mView, (ColorStateList)typedArray.getColorStateList(R.styleable.CompoundButton_buttonTint));
            }
            if (typedArray.hasValue(R.styleable.CompoundButton_buttonTintMode)) {
                CompoundButtonCompat.setButtonTintMode((CompoundButton)this.mView, (PorterDuff.Mode)DrawableUtils.parseTintMode(typedArray.getInt(R.styleable.CompoundButton_buttonTintMode, -1), null));
            }
            return;
        }
        finally {
            typedArray.recycle();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void onSetButtonDrawable() {
        if (this.mSkipNextApply) {
            this.mSkipNextApply = false;
            return;
        }
        this.mSkipNextApply = true;
        this.applyButtonTint();
    }

    void setSupportButtonTintList(ColorStateList colorStateList) {
        this.mButtonTintList = colorStateList;
        this.mHasButtonTint = true;
        this.applyButtonTint();
    }

    void setSupportButtonTintMode(@Nullable PorterDuff.Mode mode) {
        this.mButtonTintMode = mode;
        this.mHasButtonTintMode = true;
        this.applyButtonTint();
    }

    static interface DirectSetButtonDrawableInterface {
        public void setButtonDrawable(Drawable var1);
    }
}

