/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.graphics.drawable.AnimatedVectorDrawableCompat;
import android.support.graphics.drawable.VectorDrawableCompat;
import android.support.v4.content.ContextCompat;
import android.support.v4.graphics.ColorUtils;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.support.v4.util.ArrayMap;
import android.support.v4.util.LongSparseArray;
import android.support.v4.util.LruCache;
import android.support.v7.appcompat.R;
import android.support.v7.widget.DrawableUtils;
import android.support.v7.widget.ThemeUtils;
import android.support.v7.widget.TintInfo;
import android.support.v7.widget.VectorEnabledTintResources;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseArray;
import android.util.TypedValue;
import android.util.Xml;
import java.lang.ref.WeakReference;
import java.util.WeakHashMap;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public final class AppCompatDrawableManager {
    private static final int[] COLORFILTER_COLOR_BACKGROUND_MULTIPLY;
    private static final int[] COLORFILTER_COLOR_CONTROL_ACTIVATED;
    private static final int[] COLORFILTER_TINT_COLOR_CONTROL_NORMAL;
    private static final ColorFilterLruCache COLOR_FILTER_CACHE;
    private static final boolean DEBUG = false;
    private static final PorterDuff.Mode DEFAULT_MODE;
    private static AppCompatDrawableManager INSTANCE;
    private static final String PLATFORM_VD_CLAZZ = "android.graphics.drawable.VectorDrawable";
    private static final String SKIP_DRAWABLE_TAG = "appcompat_skip_skip";
    private static final String TAG = "AppCompatDrawableManager";
    private static final int[] TINT_CHECKABLE_BUTTON_LIST;
    private static final int[] TINT_COLOR_CONTROL_NORMAL;
    private static final int[] TINT_COLOR_CONTROL_STATE_LIST;
    private ArrayMap<String, InflateDelegate> mDelegates;
    private final Object mDrawableCacheLock = new Object();
    private final WeakHashMap<Context, LongSparseArray<WeakReference<Drawable.ConstantState>>> mDrawableCaches = new WeakHashMap(0);
    private boolean mHasCheckedVectorDrawableSetup;
    private SparseArray<String> mKnownDrawableIdTags;
    private WeakHashMap<Context, SparseArray<ColorStateList>> mTintLists;
    private TypedValue mTypedValue;

    static {
        DEFAULT_MODE = PorterDuff.Mode.SRC_IN;
        COLOR_FILTER_CACHE = new ColorFilterLruCache(6);
        COLORFILTER_TINT_COLOR_CONTROL_NORMAL = new int[]{R.drawable.abc_textfield_search_default_mtrl_alpha, R.drawable.abc_textfield_default_mtrl_alpha, R.drawable.abc_ab_share_pack_mtrl_alpha};
        TINT_COLOR_CONTROL_NORMAL = new int[]{R.drawable.abc_ic_ab_back_mtrl_am_alpha, R.drawable.abc_ic_go_search_api_mtrl_alpha, R.drawable.abc_ic_search_api_mtrl_alpha, R.drawable.abc_ic_commit_search_api_mtrl_alpha, R.drawable.abc_ic_clear_mtrl_alpha, R.drawable.abc_ic_menu_share_mtrl_alpha, R.drawable.abc_ic_menu_copy_mtrl_am_alpha, R.drawable.abc_ic_menu_cut_mtrl_alpha, R.drawable.abc_ic_menu_selectall_mtrl_alpha, R.drawable.abc_ic_menu_paste_mtrl_am_alpha, R.drawable.abc_ic_menu_moreoverflow_mtrl_alpha, R.drawable.abc_ic_voice_search_api_mtrl_alpha};
        COLORFILTER_COLOR_CONTROL_ACTIVATED = new int[]{R.drawable.abc_textfield_activated_mtrl_alpha, R.drawable.abc_textfield_search_activated_mtrl_alpha, R.drawable.abc_cab_background_top_mtrl_alpha, R.drawable.abc_text_cursor_material};
        COLORFILTER_COLOR_BACKGROUND_MULTIPLY = new int[]{R.drawable.abc_popup_background_mtrl_mult, R.drawable.abc_cab_background_internal_bg, R.drawable.abc_menu_hardkey_panel_mtrl_mult};
        TINT_COLOR_CONTROL_STATE_LIST = new int[]{R.drawable.abc_edit_text_material, R.drawable.abc_tab_indicator_material, R.drawable.abc_textfield_search_material, R.drawable.abc_spinner_mtrl_am_alpha, R.drawable.abc_spinner_textfield_background_material, R.drawable.abc_ratingbar_full_material, R.drawable.abc_switch_track_mtrl_alpha, R.drawable.abc_switch_thumb_material, R.drawable.abc_btn_default_mtrl_shape, R.drawable.abc_btn_borderless_material};
        TINT_CHECKABLE_BUTTON_LIST = new int[]{R.drawable.abc_btn_check_material, R.drawable.abc_btn_radio_material};
    }

    private void addDelegate(@NonNull String string2, @NonNull InflateDelegate inflateDelegate) {
        if (this.mDelegates == null) {
            this.mDelegates = new ArrayMap();
        }
        this.mDelegates.put((Object)string2, (Object)inflateDelegate);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean addDrawableToCache(@NonNull Context object, long l2, @NonNull Drawable longSparseArray) {
        Drawable.ConstantState constantState = longSparseArray.getConstantState();
        if (constantState == null) {
            return false;
        }
        Object object2 = this.mDrawableCacheLock;
        synchronized (object2) {
            LongSparseArray longSparseArray2;
            longSparseArray = longSparseArray2 = this.mDrawableCaches.get(object);
            if (longSparseArray2 == null) {
                longSparseArray = new LongSparseArray();
                this.mDrawableCaches.put((Context)object, (LongSparseArray<WeakReference<Drawable.ConstantState>>)longSparseArray);
            }
            object = new WeakReference(constantState);
            longSparseArray.put(l2, object);
            return true;
        }
    }

    private void addTintListToCache(@NonNull Context context, @DrawableRes int n2, @NonNull ColorStateList colorStateList) {
        SparseArray sparseArray;
        if (this.mTintLists == null) {
            this.mTintLists = new WeakHashMap();
        }
        SparseArray sparseArray2 = sparseArray = this.mTintLists.get(context);
        if (sparseArray == null) {
            sparseArray2 = new SparseArray();
            this.mTintLists.put(context, (SparseArray<ColorStateList>)sparseArray2);
        }
        sparseArray2.append(n2, (Object)colorStateList);
    }

    private static boolean arrayContains(int[] nArray, int n2) {
        boolean bl = false;
        int n3 = nArray.length;
        int n4 = 0;
        while (true) {
            block4: {
                boolean bl2;
                block3: {
                    bl2 = bl;
                    if (n4 >= n3) break block3;
                    if (nArray[n4] != n2) break block4;
                    bl2 = true;
                }
                return bl2;
            }
            ++n4;
        }
    }

    private ColorStateList createBorderlessButtonColorStateList(Context context) {
        return this.createButtonColorStateList(context, 0);
    }

    private ColorStateList createButtonColorStateList(Context object, @ColorInt int n2) {
        int n3 = ThemeUtils.getThemeAttrColor(object, R.attr.colorControlHighlight);
        int[] nArray = ThemeUtils.DISABLED_STATE_SET;
        int n4 = ThemeUtils.getDisabledThemeAttrColor(object, R.attr.colorButtonNormal);
        int[] nArray2 = ThemeUtils.PRESSED_STATE_SET;
        int n5 = ColorUtils.compositeColors((int)n3, (int)n2);
        object = ThemeUtils.FOCUSED_STATE_SET;
        n3 = ColorUtils.compositeColors((int)n3, (int)n2);
        return new ColorStateList((int[][])new int[][]{nArray, nArray2, (int[])object, ThemeUtils.EMPTY_STATE_SET}, new int[]{n4, n5, n3, n2});
    }

    private static long createCacheKey(TypedValue typedValue) {
        return (long)typedValue.assetCookie << 32 | (long)typedValue.data;
    }

    private ColorStateList createCheckableButtonColorStateList(Context context) {
        int[] nArray = ThemeUtils.DISABLED_STATE_SET;
        int n2 = ThemeUtils.getDisabledThemeAttrColor(context, R.attr.colorControlNormal);
        int[] nArray2 = ThemeUtils.CHECKED_STATE_SET;
        int n3 = ThemeUtils.getThemeAttrColor(context, R.attr.colorControlActivated);
        int[] nArray3 = ThemeUtils.EMPTY_STATE_SET;
        int n4 = ThemeUtils.getThemeAttrColor(context, R.attr.colorControlNormal);
        return new ColorStateList((int[][])new int[][]{nArray, nArray2, nArray3}, new int[]{n2, n3, n4});
    }

    private ColorStateList createColoredButtonColorStateList(Context context) {
        return this.createButtonColorStateList(context, ThemeUtils.getThemeAttrColor(context, R.attr.colorAccent));
    }

    private ColorStateList createDefaultButtonColorStateList(Context context) {
        return this.createButtonColorStateList(context, ThemeUtils.getThemeAttrColor(context, R.attr.colorButtonNormal));
    }

    private ColorStateList createDefaultColorStateList(Context context) {
        int n2 = ThemeUtils.getThemeAttrColor(context, R.attr.colorControlNormal);
        int n3 = ThemeUtils.getThemeAttrColor(context, R.attr.colorControlActivated);
        int[] nArray = ThemeUtils.DISABLED_STATE_SET;
        int n4 = ThemeUtils.getDisabledThemeAttrColor(context, R.attr.colorControlNormal);
        return new ColorStateList((int[][])new int[][]{nArray, ThemeUtils.FOCUSED_STATE_SET, ThemeUtils.ACTIVATED_STATE_SET, ThemeUtils.PRESSED_STATE_SET, ThemeUtils.CHECKED_STATE_SET, ThemeUtils.SELECTED_STATE_SET, ThemeUtils.EMPTY_STATE_SET}, new int[]{n4, n3, n3, n3, n3, n3, n2});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Drawable createDrawableIfNeeded(@NonNull Context context, @DrawableRes int n2) {
        if (this.mTypedValue == null) {
            this.mTypedValue = new TypedValue();
        }
        TypedValue typedValue = this.mTypedValue;
        context.getResources().getValue(n2, typedValue, true);
        long l2 = AppCompatDrawableManager.createCacheKey(typedValue);
        Drawable drawable2 = this.getCachedDrawable(context, l2);
        if (drawable2 != null) {
            return drawable2;
        }
        if (n2 == R.drawable.abc_cab_background_top_material) {
            drawable2 = new LayerDrawable(new Drawable[]{this.getDrawable(context, R.drawable.abc_cab_background_internal_bg), this.getDrawable(context, R.drawable.abc_cab_background_top_mtrl_alpha)});
        }
        Drawable drawable3 = drawable2;
        if (drawable2 == null) return drawable3;
        drawable2.setChangingConfigurations(typedValue.changingConfigurations);
        this.addDrawableToCache(context, l2, drawable2);
        return drawable2;
    }

    private ColorStateList createEditTextColorStateList(Context context) {
        int[] nArray = ThemeUtils.DISABLED_STATE_SET;
        int n2 = ThemeUtils.getDisabledThemeAttrColor(context, R.attr.colorControlNormal);
        int[] nArray2 = ThemeUtils.NOT_PRESSED_OR_FOCUSED_STATE_SET;
        int n3 = ThemeUtils.getThemeAttrColor(context, R.attr.colorControlNormal);
        int[] nArray3 = ThemeUtils.EMPTY_STATE_SET;
        int n4 = ThemeUtils.getThemeAttrColor(context, R.attr.colorControlActivated);
        return new ColorStateList((int[][])new int[][]{nArray, nArray2, nArray3}, new int[]{n2, n3, n4});
    }

    private ColorStateList createSeekbarThumbColorStateList(Context context) {
        int[] nArray = ThemeUtils.DISABLED_STATE_SET;
        int n2 = ThemeUtils.getDisabledThemeAttrColor(context, R.attr.colorControlActivated);
        int[] nArray2 = ThemeUtils.EMPTY_STATE_SET;
        int n3 = ThemeUtils.getThemeAttrColor(context, R.attr.colorControlActivated);
        return new ColorStateList((int[][])new int[][]{nArray, nArray2}, new int[]{n2, n3});
    }

    private ColorStateList createSpinnerColorStateList(Context context) {
        int[] nArray = ThemeUtils.DISABLED_STATE_SET;
        int n2 = ThemeUtils.getDisabledThemeAttrColor(context, R.attr.colorControlNormal);
        int[] nArray2 = ThemeUtils.NOT_PRESSED_OR_FOCUSED_STATE_SET;
        int n3 = ThemeUtils.getThemeAttrColor(context, R.attr.colorControlNormal);
        int[] nArray3 = ThemeUtils.EMPTY_STATE_SET;
        int n4 = ThemeUtils.getThemeAttrColor(context, R.attr.colorControlActivated);
        return new ColorStateList((int[][])new int[][]{nArray, nArray2, nArray3}, new int[]{n2, n3, n4});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ColorStateList createSwitchThumbColorStateList(Context context) {
        int[][] nArrayArray = new int[3][];
        int[] nArray = new int[3];
        ColorStateList colorStateList = ThemeUtils.getThemeAttrColorStateList(context, R.attr.colorSwitchThumbNormal);
        if (colorStateList != null && colorStateList.isStateful()) {
            nArrayArray[0] = ThemeUtils.DISABLED_STATE_SET;
            nArray[0] = colorStateList.getColorForState(nArrayArray[0], 0);
            nArrayArray[1] = ThemeUtils.CHECKED_STATE_SET;
            nArray[1] = ThemeUtils.getThemeAttrColor(context, R.attr.colorControlActivated);
            nArrayArray[2] = ThemeUtils.EMPTY_STATE_SET;
            nArray[2] = colorStateList.getDefaultColor();
            return new ColorStateList((int[][])nArrayArray, nArray);
        }
        nArrayArray[0] = ThemeUtils.DISABLED_STATE_SET;
        nArray[0] = ThemeUtils.getDisabledThemeAttrColor(context, R.attr.colorSwitchThumbNormal);
        nArrayArray[1] = ThemeUtils.CHECKED_STATE_SET;
        nArray[1] = ThemeUtils.getThemeAttrColor(context, R.attr.colorControlActivated);
        nArrayArray[2] = ThemeUtils.EMPTY_STATE_SET;
        nArray[2] = ThemeUtils.getThemeAttrColor(context, R.attr.colorSwitchThumbNormal);
        return new ColorStateList((int[][])nArrayArray, nArray);
    }

    private ColorStateList createSwitchTrackColorStateList(Context context) {
        int[] nArray = ThemeUtils.DISABLED_STATE_SET;
        int n2 = ThemeUtils.getThemeAttrColor(context, 0x1010030, 0.1f);
        int[] nArray2 = ThemeUtils.CHECKED_STATE_SET;
        int n3 = ThemeUtils.getThemeAttrColor(context, R.attr.colorControlActivated, 0.3f);
        int[] nArray3 = ThemeUtils.EMPTY_STATE_SET;
        int n4 = ThemeUtils.getThemeAttrColor(context, 0x1010030, 0.3f);
        return new ColorStateList((int[][])new int[][]{nArray, nArray2, nArray3}, new int[]{n2, n3, n4});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static PorterDuffColorFilter createTintFilter(ColorStateList colorStateList, PorterDuff.Mode mode, int[] nArray) {
        if (colorStateList == null) return null;
        if (mode != null) return AppCompatDrawableManager.getPorterDuffColorFilter(colorStateList.getColorForState(nArray, 0), mode);
        return null;
    }

    public static AppCompatDrawableManager get() {
        if (INSTANCE == null) {
            INSTANCE = new AppCompatDrawableManager();
            AppCompatDrawableManager.installDefaultInflateDelegates(INSTANCE);
        }
        return INSTANCE;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Drawable getCachedDrawable(@NonNull Context context, long l2) {
        Object object = this.mDrawableCacheLock;
        synchronized (object) {
            LongSparseArray<WeakReference<Drawable.ConstantState>> longSparseArray = this.mDrawableCaches.get(context);
            if (longSparseArray == null) {
                return null;
            }
            WeakReference weakReference = (WeakReference)longSparseArray.get(l2);
            if (weakReference == null) return null;
            if ((weakReference = (Drawable.ConstantState)weakReference.get()) != null) {
                return weakReference.newDrawable(context.getResources());
            }
            longSparseArray.delete(l2);
            return null;
        }
    }

    public static PorterDuffColorFilter getPorterDuffColorFilter(int n2, PorterDuff.Mode mode) {
        PorterDuffColorFilter porterDuffColorFilter;
        PorterDuffColorFilter porterDuffColorFilter2 = porterDuffColorFilter = COLOR_FILTER_CACHE.get(n2, mode);
        if (porterDuffColorFilter == null) {
            porterDuffColorFilter2 = new PorterDuffColorFilter(n2, mode);
            COLOR_FILTER_CACHE.put(n2, mode, porterDuffColorFilter2);
        }
        return porterDuffColorFilter2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ColorStateList getTintListFromCache(@NonNull Context colorStateList, @DrawableRes int n2) {
        if (this.mTintLists == null) return null;
        if ((colorStateList = this.mTintLists.get(colorStateList)) == null) return null;
        return (ColorStateList)colorStateList.get(n2);
    }

    private static void installDefaultInflateDelegates(@NonNull AppCompatDrawableManager appCompatDrawableManager) {
        int n2 = Build.VERSION.SDK_INT;
        if (n2 < 23) {
            appCompatDrawableManager.addDelegate("vector", new VdcInflateDelegate());
            if (n2 >= 11) {
                appCompatDrawableManager.addDelegate("animated-vector", new AvdcInflateDelegate());
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isVectorDrawable(@NonNull Drawable drawable2) {
        if (drawable2 instanceof VectorDrawableCompat) return true;
        if (!PLATFORM_VD_CLAZZ.equals(drawable2.getClass().getName())) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Drawable loadDrawableFromDelegates(@NonNull Context object, @DrawableRes int n2) {
        String string2;
        block15: {
            if (this.mDelegates == null) return null;
            if (this.mDelegates.isEmpty()) return null;
            if (this.mKnownDrawableIdTags != null) {
                string2 = (String)this.mKnownDrawableIdTags.get(n2);
                if (SKIP_DRAWABLE_TAG.equals(string2)) return null;
                if (string2 != null && this.mDelegates.get((Object)string2) == null) {
                    return null;
                }
            } else {
                this.mKnownDrawableIdTags = new SparseArray();
            }
            if (this.mTypedValue == null) {
                this.mTypedValue = new TypedValue();
            }
            TypedValue typedValue = this.mTypedValue;
            Object object2 = object.getResources();
            object2.getValue(n2, typedValue, true);
            long l2 = AppCompatDrawableManager.createCacheKey(typedValue);
            string2 = this.getCachedDrawable((Context)object, l2);
            if (string2 != null) {
                return string2;
            }
            String string3 = string2;
            if (typedValue.string != null) {
                string3 = string2;
                if (typedValue.string.toString().endsWith(".xml")) {
                    string3 = string2;
                    try {
                        int n3;
                        XmlResourceParser xmlResourceParser = object2.getXml(n2);
                        string3 = string2;
                        AttributeSet attributeSet = Xml.asAttributeSet((XmlPullParser)xmlResourceParser);
                        do {
                            string3 = string2;
                        } while ((n3 = xmlResourceParser.next()) != 2 && n3 != 1);
                        if (n3 != 2) {
                            string3 = string2;
                            string3 = string2;
                            object = new XmlPullParserException("No start tag found");
                            string3 = string2;
                            throw object;
                        }
                        string3 = string2;
                        object2 = xmlResourceParser.getName();
                        string3 = string2;
                        this.mKnownDrawableIdTags.append(n2, object2);
                        string3 = string2;
                        InflateDelegate inflateDelegate = (InflateDelegate)this.mDelegates.get(object2);
                        object2 = string2;
                        if (inflateDelegate != null) {
                            string3 = string2;
                            object2 = inflateDelegate.createFromXmlInner((Context)object, (XmlPullParser)xmlResourceParser, attributeSet, object.getTheme());
                        }
                        if (object2 != null) {
                            string3 = object2;
                            object2.setChangingConfigurations(typedValue.changingConfigurations);
                            string3 = object2;
                            boolean bl = this.addDrawableToCache((Context)object, l2, (Drawable)object2);
                            if (bl) {
                                // empty if block
                            }
                        }
                        string2 = object2;
                        break block15;
                    }
                    catch (Exception exception) {
                        Log.e((String)TAG, (String)"Exception while inflating drawable", (Throwable)exception);
                    }
                }
            }
            string2 = string3;
        }
        object = string2;
        if (string2 != null) return object;
        this.mKnownDrawableIdTags.append(n2, (Object)SKIP_DRAWABLE_TAG);
        return string2;
    }

    private void removeDelegate(@NonNull String string2, @NonNull InflateDelegate inflateDelegate) {
        if (this.mDelegates != null && this.mDelegates.get((Object)string2) == inflateDelegate) {
            this.mDelegates.remove((Object)string2);
        }
    }

    private static void setPorterDuffColorFilter(Drawable drawable2, int n2, PorterDuff.Mode mode) {
        Drawable drawable3 = drawable2;
        if (DrawableUtils.canSafelyMutateDrawable(drawable2)) {
            drawable3 = drawable2.mutate();
        }
        drawable2 = mode;
        if (mode == null) {
            drawable2 = DEFAULT_MODE;
        }
        drawable3.setColorFilter((ColorFilter)AppCompatDrawableManager.getPorterDuffColorFilter(n2, (PorterDuff.Mode)drawable2));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Drawable tintDrawable(@NonNull Context context, @DrawableRes int n2, boolean bl, @NonNull Drawable drawable2) {
        ColorStateList colorStateList = this.getTintList(context, n2);
        if (colorStateList != null) {
            context = drawable2;
            if (DrawableUtils.canSafelyMutateDrawable(drawable2)) {
                context = drawable2.mutate();
            }
            context = DrawableCompat.wrap((Drawable)context);
            DrawableCompat.setTintList((Drawable)context, (ColorStateList)colorStateList);
            drawable2 = this.getTintMode(n2);
            colorStateList = context;
            if (drawable2 == null) return colorStateList;
            DrawableCompat.setTintMode((Drawable)context, (PorterDuff.Mode)drawable2);
            return context;
        }
        if (n2 == R.drawable.abc_seekbar_track_material) {
            colorStateList = (LayerDrawable)drawable2;
            AppCompatDrawableManager.setPorterDuffColorFilter(colorStateList.findDrawableByLayerId(0x1020000), ThemeUtils.getThemeAttrColor(context, R.attr.colorControlNormal), DEFAULT_MODE);
            AppCompatDrawableManager.setPorterDuffColorFilter(colorStateList.findDrawableByLayerId(16908303), ThemeUtils.getThemeAttrColor(context, R.attr.colorControlNormal), DEFAULT_MODE);
            AppCompatDrawableManager.setPorterDuffColorFilter(colorStateList.findDrawableByLayerId(16908301), ThemeUtils.getThemeAttrColor(context, R.attr.colorControlActivated), DEFAULT_MODE);
            return drawable2;
        }
        if (n2 == R.drawable.abc_ratingbar_indicator_material || n2 == R.drawable.abc_ratingbar_small_material) {
            colorStateList = (LayerDrawable)drawable2;
            AppCompatDrawableManager.setPorterDuffColorFilter(colorStateList.findDrawableByLayerId(0x1020000), ThemeUtils.getDisabledThemeAttrColor(context, R.attr.colorControlNormal), DEFAULT_MODE);
            AppCompatDrawableManager.setPorterDuffColorFilter(colorStateList.findDrawableByLayerId(16908303), ThemeUtils.getThemeAttrColor(context, R.attr.colorControlActivated), DEFAULT_MODE);
            AppCompatDrawableManager.setPorterDuffColorFilter(colorStateList.findDrawableByLayerId(16908301), ThemeUtils.getThemeAttrColor(context, R.attr.colorControlActivated), DEFAULT_MODE);
            return drawable2;
        }
        colorStateList = drawable2;
        if (AppCompatDrawableManager.tintDrawableUsingColorFilter(context, n2, drawable2)) return colorStateList;
        colorStateList = drawable2;
        if (!bl) return colorStateList;
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void tintDrawable(Drawable drawable2, TintInfo tintInfo, int[] nArray) {
        if (DrawableUtils.canSafelyMutateDrawable(drawable2) && drawable2.mutate() != drawable2) {
            Log.d((String)TAG, (String)"Mutated drawable is not the same instance as the input.");
            return;
        }
        if (tintInfo.mHasTintList || tintInfo.mHasTintMode) {
            ColorStateList colorStateList = tintInfo.mHasTintList ? tintInfo.mTintList : null;
            tintInfo = tintInfo.mHasTintMode ? tintInfo.mTintMode : DEFAULT_MODE;
            drawable2.setColorFilter((ColorFilter)AppCompatDrawableManager.createTintFilter(colorStateList, (PorterDuff.Mode)tintInfo, nArray));
        } else {
            drawable2.clearColorFilter();
        }
        if (Build.VERSION.SDK_INT > 23) return;
        drawable2.invalidateSelf();
    }

    /*
     * Enabled aggressive block sorting
     */
    static boolean tintDrawableUsingColorFilter(@NonNull Context context, @DrawableRes int n2, @NonNull Drawable drawable2) {
        boolean bl;
        int n3;
        boolean bl2 = true;
        PorterDuff.Mode mode = DEFAULT_MODE;
        if (AppCompatDrawableManager.arrayContains(COLORFILTER_TINT_COLOR_CONTROL_NORMAL, n2)) {
            n3 = R.attr.colorControlNormal;
            bl = true;
            n2 = -1;
        } else if (AppCompatDrawableManager.arrayContains(COLORFILTER_COLOR_CONTROL_ACTIVATED, n2)) {
            n3 = R.attr.colorControlActivated;
            bl = true;
            n2 = -1;
        } else if (AppCompatDrawableManager.arrayContains(COLORFILTER_COLOR_BACKGROUND_MULTIPLY, n2)) {
            mode = PorterDuff.Mode.MULTIPLY;
            bl = true;
            n3 = 0x1010031;
            n2 = -1;
        } else {
            if (n2 != R.drawable.abc_list_divider_mtrl_alpha) return false;
            n3 = 0x1010030;
            n2 = Math.round(40.8f);
            bl = true;
        }
        if (!bl) {
            return false;
        }
        Drawable drawable3 = drawable2;
        if (DrawableUtils.canSafelyMutateDrawable(drawable2)) {
            drawable3 = drawable2.mutate();
        }
        drawable3.setColorFilter((ColorFilter)AppCompatDrawableManager.getPorterDuffColorFilter(ThemeUtils.getThemeAttrColor(context, n3), mode));
        boolean bl3 = bl2;
        if (n2 == -1) return bl3;
        drawable3.setAlpha(n2);
        return bl2;
    }

    public Drawable getDrawable(@NonNull Context context, @DrawableRes int n2) {
        return this.getDrawable(context, n2, false);
    }

    public Drawable getDrawable(@NonNull Context context, @DrawableRes int n2, boolean bl) {
        Drawable drawable2;
        Drawable drawable3 = drawable2 = this.loadDrawableFromDelegates(context, n2);
        if (drawable2 == null) {
            drawable3 = this.createDrawableIfNeeded(context, n2);
        }
        drawable2 = drawable3;
        if (drawable3 == null) {
            drawable2 = ContextCompat.getDrawable((Context)context, (int)n2);
        }
        drawable3 = drawable2;
        if (drawable2 != null) {
            drawable3 = this.tintDrawable(context, n2, bl, drawable2);
        }
        if (drawable3 != null) {
            DrawableUtils.fixDrawable(drawable3);
        }
        return drawable3;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final ColorStateList getTintList(@NonNull Context context, @DrawableRes int n2) {
        ColorStateList colorStateList;
        ColorStateList colorStateList2 = colorStateList = this.getTintListFromCache(context, n2);
        if (colorStateList != null) return colorStateList2;
        if (n2 == R.drawable.abc_edit_text_material) {
            colorStateList = this.createEditTextColorStateList(context);
        } else if (n2 == R.drawable.abc_switch_track_mtrl_alpha) {
            colorStateList = this.createSwitchTrackColorStateList(context);
        } else if (n2 == R.drawable.abc_switch_thumb_material) {
            colorStateList = this.createSwitchThumbColorStateList(context);
        } else if (n2 == R.drawable.abc_btn_default_mtrl_shape) {
            colorStateList = this.createDefaultButtonColorStateList(context);
        } else if (n2 == R.drawable.abc_btn_borderless_material) {
            colorStateList = this.createBorderlessButtonColorStateList(context);
        } else if (n2 == R.drawable.abc_btn_colored_material) {
            colorStateList = this.createColoredButtonColorStateList(context);
        } else if (n2 == R.drawable.abc_spinner_mtrl_am_alpha || n2 == R.drawable.abc_spinner_textfield_background_material) {
            colorStateList = this.createSpinnerColorStateList(context);
        } else if (AppCompatDrawableManager.arrayContains(TINT_COLOR_CONTROL_NORMAL, n2)) {
            colorStateList = ThemeUtils.getThemeAttrColorStateList(context, R.attr.colorControlNormal);
        } else if (AppCompatDrawableManager.arrayContains(TINT_COLOR_CONTROL_STATE_LIST, n2)) {
            colorStateList = this.createDefaultColorStateList(context);
        } else if (AppCompatDrawableManager.arrayContains(TINT_CHECKABLE_BUTTON_LIST, n2)) {
            colorStateList = this.createCheckableButtonColorStateList(context);
        } else if (n2 == R.drawable.abc_seekbar_thumb_material) {
            colorStateList = this.createSeekbarThumbColorStateList(context);
        }
        colorStateList2 = colorStateList;
        if (colorStateList == null) return colorStateList2;
        this.addTintListToCache(context, n2, colorStateList);
        return colorStateList;
    }

    final PorterDuff.Mode getTintMode(int n2) {
        PorterDuff.Mode mode = null;
        if (n2 == R.drawable.abc_switch_thumb_material) {
            mode = PorterDuff.Mode.MULTIPLY;
        }
        return mode;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final Drawable onDrawableLoadedFromResources(@NonNull Context context, @NonNull VectorEnabledTintResources vectorEnabledTintResources, @DrawableRes int n2) {
        Drawable drawable2;
        Drawable drawable3 = drawable2 = this.loadDrawableFromDelegates(context, n2);
        if (drawable2 == null) {
            drawable3 = vectorEnabledTintResources.superGetDrawable(n2);
        }
        if (drawable3 == null) return null;
        return this.tintDrawable(context, n2, false, drawable3);
    }

    private static class AvdcInflateDelegate
    implements InflateDelegate {
        private AvdcInflateDelegate() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Drawable createFromXmlInner(@NonNull Context context, @NonNull XmlPullParser xmlPullParser, @NonNull AttributeSet attributeSet, @Nullable Resources.Theme theme) {
            try {
                return AnimatedVectorDrawableCompat.createFromXmlInner((Context)context, (Resources)context.getResources(), (XmlPullParser)xmlPullParser, (AttributeSet)attributeSet, (Resources.Theme)theme);
            }
            catch (Exception exception) {
                Log.e((String)"AvdcInflateDelegate", (String)"Exception while inflating <animated-vector>", (Throwable)exception);
                return null;
            }
        }
    }

    private static class ColorFilterLruCache
    extends LruCache<Integer, PorterDuffColorFilter> {
        public ColorFilterLruCache(int n2) {
            super(n2);
        }

        private static int generateCacheKey(int n2, PorterDuff.Mode mode) {
            return (n2 + 31) * 31 + mode.hashCode();
        }

        PorterDuffColorFilter get(int n2, PorterDuff.Mode mode) {
            return (PorterDuffColorFilter)this.get(ColorFilterLruCache.generateCacheKey(n2, mode));
        }

        PorterDuffColorFilter put(int n2, PorterDuff.Mode mode, PorterDuffColorFilter porterDuffColorFilter) {
            return (PorterDuffColorFilter)this.put(ColorFilterLruCache.generateCacheKey(n2, mode), porterDuffColorFilter);
        }
    }

    private static interface InflateDelegate {
        public Drawable createFromXmlInner(@NonNull Context var1, @NonNull XmlPullParser var2, @NonNull AttributeSet var3, @Nullable Resources.Theme var4);
    }

    private static class VdcInflateDelegate
    implements InflateDelegate {
        private VdcInflateDelegate() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Drawable createFromXmlInner(@NonNull Context context, @NonNull XmlPullParser xmlPullParser, @NonNull AttributeSet attributeSet, @Nullable Resources.Theme theme) {
            try {
                return VectorDrawableCompat.createFromXmlInner((Resources)context.getResources(), (XmlPullParser)xmlPullParser, (AttributeSet)attributeSet, (Resources.Theme)theme);
            }
            catch (Exception exception) {
                Log.e((String)"VdcInflateDelegate", (String)"Exception while inflating <vector>", (Throwable)exception);
                return null;
            }
        }
    }
}

