/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.widget;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import android.support.v4.widget.PopupWindowCompat;
import android.support.v7.appcompat.R;
import android.support.v7.widget.TintTypedArray;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewTreeObserver;
import android.widget.PopupWindow;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;

public class AppCompatPopupWindow
extends PopupWindow {
    private static final boolean COMPAT_OVERLAP_ANCHOR;
    private static final String TAG = "AppCompatPopupWindow";
    private boolean mOverlapAnchor;

    /*
     * Enabled aggressive block sorting
     */
    static {
        boolean bl = Build.VERSION.SDK_INT < 21;
        COMPAT_OVERLAP_ANCHOR = bl;
    }

    public AppCompatPopupWindow(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
        context = TintTypedArray.obtainStyledAttributes((Context)context, (AttributeSet)attributeSet, (int[])R.styleable.PopupWindow, (int)n2, (int)0);
        if (context.hasValue(R.styleable.PopupWindow_overlapAnchor)) {
            this.setSupportOverlapAnchor(context.getBoolean(R.styleable.PopupWindow_overlapAnchor, false));
        }
        this.setBackgroundDrawable(context.getDrawable(R.styleable.PopupWindow_android_popupBackground));
        context.recycle();
        if (Build.VERSION.SDK_INT < 14) {
            AppCompatPopupWindow.wrapOnScrollChangedListener(this);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void wrapOnScrollChangedListener(final PopupWindow popupWindow) {
        try {
            final Field field = PopupWindow.class.getDeclaredField("mAnchor");
            field.setAccessible(true);
            Field field2 = PopupWindow.class.getDeclaredField("mOnScrollChangedListener");
            field2.setAccessible(true);
            final ViewTreeObserver.OnScrollChangedListener onScrollChangedListener = (ViewTreeObserver.OnScrollChangedListener)field2.get(popupWindow);
            ViewTreeObserver.OnScrollChangedListener onScrollChangedListener2 = new ViewTreeObserver.OnScrollChangedListener(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void onScrollChanged() {
                    try {
                        WeakReference weakReference = (WeakReference)field.get(popupWindow);
                        if (weakReference == null) return;
                        if (weakReference.get() == null) {
                            return;
                        }
                        onScrollChangedListener.onScrollChanged();
                        return;
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        return;
                    }
                }
            };
            field2.set(popupWindow, onScrollChangedListener2);
            return;
        }
        catch (Exception exception) {
            Log.d((String)TAG, (String)"Exception while installing workaround OnScrollChangedListener", (Throwable)exception);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean getSupportOverlapAnchor() {
        if (!COMPAT_OVERLAP_ANCHOR) return PopupWindowCompat.getOverlapAnchor((PopupWindow)this);
        return this.mOverlapAnchor;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setSupportOverlapAnchor(boolean bl) {
        if (COMPAT_OVERLAP_ANCHOR) {
            this.mOverlapAnchor = bl;
            return;
        }
        PopupWindowCompat.setOverlapAnchor((PopupWindow)this, (boolean)bl);
    }

    public void showAsDropDown(View view, int n2, int n3) {
        int n4 = n3;
        if (COMPAT_OVERLAP_ANCHOR) {
            n4 = n3;
            if (this.mOverlapAnchor) {
                n4 = n3 - view.getHeight();
            }
        }
        super.showAsDropDown(view, n2, n4);
    }

    @TargetApi(value=19)
    public void showAsDropDown(View view, int n2, int n3, int n4) {
        int n5 = n3;
        if (COMPAT_OVERLAP_ANCHOR) {
            n5 = n3;
            if (this.mOverlapAnchor) {
                n5 = n3 - view.getHeight();
            }
        }
        super.showAsDropDown(view, n2, n5, n4);
    }

    public void update(View view, int n2, int n3, int n4, int n5) {
        if (COMPAT_OVERLAP_ANCHOR && this.mOverlapAnchor) {
            n3 -= view.getHeight();
        }
        super.update(view, n2, n3, n4, n5);
    }
}

