/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.widget;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.Region;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.support.v4.view.MotionEventCompat;
import android.support.v4.view.ViewCompat;
import android.support.v7.appcompat.R;
import android.support.v7.text.AllCapsTransformationMethod;
import android.support.v7.widget.AppCompatDrawableManager;
import android.support.v7.widget.DrawableUtils;
import android.support.v7.widget.TintTypedArray;
import android.support.v7.widget.ViewUtils;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.method.TransformationMethod;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.animation.Animation;
import android.view.animation.Transformation;
import android.widget.CompoundButton;

public class SwitchCompat
extends CompoundButton {
    private static final String ACCESSIBILITY_EVENT_CLASS_NAME = "android.widget.Switch";
    private static final int[] CHECKED_STATE_SET = new int[]{0x10100A0};
    private static final int MONOSPACE = 3;
    private static final int SANS = 1;
    private static final int SERIF = 2;
    private static final int THUMB_ANIMATION_DURATION = 250;
    private static final int TOUCH_MODE_DOWN = 1;
    private static final int TOUCH_MODE_DRAGGING = 2;
    private static final int TOUCH_MODE_IDLE = 0;
    private final AppCompatDrawableManager mDrawableManager;
    private int mMinFlingVelocity;
    private Layout mOffLayout;
    private Layout mOnLayout;
    private ThumbAnimation mPositionAnimator;
    private boolean mShowText;
    private boolean mSplitTrack;
    private int mSwitchBottom;
    private int mSwitchHeight;
    private int mSwitchLeft;
    private int mSwitchMinWidth;
    private int mSwitchPadding;
    private int mSwitchRight;
    private int mSwitchTop;
    private TransformationMethod mSwitchTransformationMethod;
    private int mSwitchWidth;
    private final Rect mTempRect;
    private ColorStateList mTextColors;
    private CharSequence mTextOff;
    private CharSequence mTextOn;
    private TextPaint mTextPaint;
    private Drawable mThumbDrawable;
    private float mThumbPosition;
    private int mThumbTextPadding;
    private int mThumbWidth;
    private int mTouchMode;
    private int mTouchSlop;
    private float mTouchX;
    private float mTouchY;
    private Drawable mTrackDrawable;
    private VelocityTracker mVelocityTracker = VelocityTracker.obtain();

    public SwitchCompat(Context context) {
        this(context, null);
    }

    public SwitchCompat(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, R.attr.switchStyle);
    }

    public SwitchCompat(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
        this.mTempRect = new Rect();
        this.mTextPaint = new TextPaint(1);
        Resources resources = this.getResources();
        this.mTextPaint.density = resources.getDisplayMetrics().density;
        attributeSet = TintTypedArray.obtainStyledAttributes((Context)context, (AttributeSet)attributeSet, (int[])R.styleable.SwitchCompat, (int)n2, (int)0);
        this.mThumbDrawable = attributeSet.getDrawable(R.styleable.SwitchCompat_android_thumb);
        if (this.mThumbDrawable != null) {
            this.mThumbDrawable.setCallback((Drawable.Callback)this);
        }
        this.mTrackDrawable = attributeSet.getDrawable(R.styleable.SwitchCompat_track);
        if (this.mTrackDrawable != null) {
            this.mTrackDrawable.setCallback((Drawable.Callback)this);
        }
        this.mTextOn = attributeSet.getText(R.styleable.SwitchCompat_android_textOn);
        this.mTextOff = attributeSet.getText(R.styleable.SwitchCompat_android_textOff);
        this.mShowText = attributeSet.getBoolean(R.styleable.SwitchCompat_showText, true);
        this.mThumbTextPadding = attributeSet.getDimensionPixelSize(R.styleable.SwitchCompat_thumbTextPadding, 0);
        this.mSwitchMinWidth = attributeSet.getDimensionPixelSize(R.styleable.SwitchCompat_switchMinWidth, 0);
        this.mSwitchPadding = attributeSet.getDimensionPixelSize(R.styleable.SwitchCompat_switchPadding, 0);
        this.mSplitTrack = attributeSet.getBoolean(R.styleable.SwitchCompat_splitTrack, false);
        n2 = attributeSet.getResourceId(R.styleable.SwitchCompat_switchTextAppearance, 0);
        if (n2 != 0) {
            this.setSwitchTextAppearance(context, n2);
        }
        this.mDrawableManager = AppCompatDrawableManager.get();
        attributeSet.recycle();
        context = ViewConfiguration.get((Context)context);
        this.mTouchSlop = context.getScaledTouchSlop();
        this.mMinFlingVelocity = context.getScaledMinimumFlingVelocity();
        this.refreshDrawableState();
        this.setChecked(this.isChecked());
    }

    static /* synthetic */ ThumbAnimation access$102(SwitchCompat switchCompat, ThumbAnimation thumbAnimation) {
        switchCompat.mPositionAnimator = thumbAnimation;
        return thumbAnimation;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void animateThumbToCheckedState(final boolean bl) {
        if (this.mPositionAnimator != null) {
            this.cancelPositionAnimator();
        }
        float f2 = this.mThumbPosition;
        float f3 = bl ? 1.0f : 0.0f;
        this.mPositionAnimator = new ThumbAnimation(f2, f3);
        this.mPositionAnimator.setDuration(250L);
        this.mPositionAnimator.setAnimationListener(new Animation.AnimationListener(){

            /*
             * Enabled aggressive block sorting
             */
            public void onAnimationEnd(Animation object) {
                if (SwitchCompat.this.mPositionAnimator == object) {
                    SwitchCompat switchCompat = SwitchCompat.this;
                    float f2 = bl ? 1.0f : 0.0f;
                    switchCompat.setThumbPosition(f2);
                    SwitchCompat.access$102(SwitchCompat.this, null);
                }
            }

            public void onAnimationRepeat(Animation animation) {
            }

            public void onAnimationStart(Animation animation) {
            }
        });
        this.startAnimation(this.mPositionAnimator);
    }

    private void cancelPositionAnimator() {
        if (this.mPositionAnimator != null) {
            this.clearAnimation();
            this.mPositionAnimator = null;
        }
    }

    private void cancelSuperTouch(MotionEvent motionEvent) {
        motionEvent = MotionEvent.obtain((MotionEvent)motionEvent);
        motionEvent.setAction(3);
        super.onTouchEvent(motionEvent);
        motionEvent.recycle();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static float constrain(float f2, float f3, float f4) {
        if (f2 < f3) {
            return f3;
        }
        if (!(f2 > f4)) return f2;
        return f4;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean getTargetCheckedState() {
        if (!(this.mThumbPosition > 0.5f)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getThumbOffset() {
        float f2;
        if (ViewUtils.isLayoutRtl((View)this)) {
            f2 = 1.0f - this.mThumbPosition;
            return (int)(f2 * (float)this.getThumbScrollRange() + 0.5f);
        }
        f2 = this.mThumbPosition;
        return (int)(f2 * (float)this.getThumbScrollRange() + 0.5f);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getThumbScrollRange() {
        Rect rect;
        if (this.mTrackDrawable == null) return 0;
        Rect rect2 = this.mTempRect;
        this.mTrackDrawable.getPadding(rect2);
        if (this.mThumbDrawable != null) {
            rect = DrawableUtils.getOpticalBounds(this.mThumbDrawable);
            return this.mSwitchWidth - this.mThumbWidth - rect2.left - rect2.right - rect.left - rect.right;
        }
        rect = DrawableUtils.INSETS_NONE;
        return this.mSwitchWidth - this.mThumbWidth - rect2.left - rect2.right - rect.left - rect.right;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean hitThumb(float f2, float f3) {
        boolean bl = false;
        if (this.mThumbDrawable == null) {
            return bl;
        }
        int n2 = this.getThumbOffset();
        this.mThumbDrawable.getPadding(this.mTempRect);
        int n3 = this.mSwitchTop;
        int n4 = this.mTouchSlop;
        int n5 = n2 + this.mSwitchLeft - this.mTouchSlop;
        int n6 = this.mThumbWidth;
        int n7 = this.mTempRect.left;
        n2 = this.mTempRect.right;
        int n8 = this.mTouchSlop;
        int n9 = this.mSwitchBottom;
        int n10 = this.mTouchSlop;
        boolean bl2 = bl;
        if (!(f2 > (float)n5)) return bl2;
        bl2 = bl;
        if (!(f2 < (float)(n6 + n5 + n7 + n2 + n8))) return bl2;
        bl2 = bl;
        if (!(f3 > (float)(n3 - n4))) return bl2;
        bl2 = bl;
        if (!(f3 < (float)(n9 + n10))) return bl2;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Layout makeLayout(CharSequence charSequence) {
        int n2;
        if (this.mSwitchTransformationMethod != null) {
            charSequence = this.mSwitchTransformationMethod.getTransformation(charSequence, (View)this);
        }
        TextPaint textPaint = this.mTextPaint;
        if (charSequence != null) {
            n2 = (int)Math.ceil(Layout.getDesiredWidth((CharSequence)charSequence, (TextPaint)this.mTextPaint));
            return new StaticLayout(charSequence, textPaint, n2, Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, true);
        }
        n2 = 0;
        return new StaticLayout(charSequence, textPaint, n2, Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, true);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setSwitchTypefaceByIndex(int n2, int n3) {
        Typeface typeface = null;
        switch (n2) {
            case 1: {
                typeface = Typeface.SANS_SERIF;
                break;
            }
            case 2: {
                typeface = Typeface.SERIF;
                break;
            }
            case 3: {
                typeface = Typeface.MONOSPACE;
                break;
            }
        }
        this.setSwitchTypeface(typeface, n3);
    }

    private void setThumbPosition(float f2) {
        this.mThumbPosition = f2;
        this.invalidate();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void stopDrag(MotionEvent motionEvent) {
        boolean bl;
        boolean bl2;
        block7: {
            block5: {
                block6: {
                    bl2 = true;
                    this.mTouchMode = 0;
                    boolean bl3 = motionEvent.getAction() == 1 && this.isEnabled();
                    bl = this.isChecked();
                    if (!bl3) break block5;
                    this.mVelocityTracker.computeCurrentVelocity(1000);
                    float f2 = this.mVelocityTracker.getXVelocity();
                    if (!(Math.abs(f2) > (float)this.mMinFlingVelocity)) break block6;
                    if (ViewUtils.isLayoutRtl((View)this)) {
                        if (!(f2 < 0.0f)) {
                            bl2 = false;
                        }
                        break block7;
                    } else if (!(f2 > 0.0f)) {
                        bl2 = false;
                    }
                    break block7;
                }
                bl2 = this.getTargetCheckedState();
                break block7;
            }
            bl2 = bl;
        }
        if (bl2 != bl) {
            this.playSoundEffect(0);
        }
        this.setChecked(bl2);
        this.cancelSuperTouch(motionEvent);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void draw(Canvas canvas) {
        int n2;
        int n3;
        Rect rect = this.mTempRect;
        int n4 = this.mSwitchLeft;
        int n5 = this.mSwitchTop;
        int n6 = this.mSwitchRight;
        int n7 = this.mSwitchBottom;
        int n8 = n4 + this.getThumbOffset();
        Rect rect2 = this.mThumbDrawable != null ? DrawableUtils.getOpticalBounds(this.mThumbDrawable) : DrawableUtils.INSETS_NONE;
        if (this.mTrackDrawable != null) {
            int n9;
            this.mTrackDrawable.getPadding(rect);
            int n10 = rect.left;
            if (rect2 != null) {
                n3 = n4;
                if (rect2.left > rect.left) {
                    n3 = n4 + (rect2.left - rect.left);
                }
                n9 = rect2.top > rect.top ? rect2.top - rect.top + n5 : n5;
                n4 = n6;
                if (rect2.right > rect.right) {
                    n4 = n6 - (rect2.right - rect.right);
                }
                n2 = rect2.bottom > rect.bottom ? n7 - (rect2.bottom - rect.bottom) : n7;
            } else {
                n2 = n7;
                n9 = n5;
                n3 = n4;
                n4 = n6;
            }
            this.mTrackDrawable.setBounds(n3, n9, n4, n2);
            n3 = n10 + n8;
        } else {
            n3 = n8;
        }
        if (this.mThumbDrawable != null) {
            this.mThumbDrawable.getPadding(rect);
            n2 = n3 - rect.left;
            n3 = n3 + this.mThumbWidth + rect.right;
            this.mThumbDrawable.setBounds(n2, n5, n3, n7);
            rect2 = this.getBackground();
            if (rect2 != null) {
                DrawableCompat.setHotspotBounds((Drawable)rect2, (int)n2, (int)n5, (int)n3, (int)n7);
            }
        }
        super.draw(canvas);
    }

    public void drawableHotspotChanged(float f2, float f3) {
        if (Build.VERSION.SDK_INT >= 21) {
            super.drawableHotspotChanged(f2, f3);
        }
        if (this.mThumbDrawable != null) {
            DrawableCompat.setHotspot((Drawable)this.mThumbDrawable, (float)f2, (float)f3);
        }
        if (this.mTrackDrawable != null) {
            DrawableCompat.setHotspot((Drawable)this.mTrackDrawable, (float)f2, (float)f3);
        }
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        int[] nArray = this.getDrawableState();
        if (this.mThumbDrawable != null) {
            this.mThumbDrawable.setState(nArray);
        }
        if (this.mTrackDrawable != null) {
            this.mTrackDrawable.setState(nArray);
        }
        this.invalidate();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getCompoundPaddingLeft() {
        int n2;
        if (!ViewUtils.isLayoutRtl((View)this)) {
            return super.getCompoundPaddingLeft();
        }
        int n3 = n2 = super.getCompoundPaddingLeft() + this.mSwitchWidth;
        if (TextUtils.isEmpty((CharSequence)this.getText())) return n3;
        return n2 + this.mSwitchPadding;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getCompoundPaddingRight() {
        int n2;
        if (ViewUtils.isLayoutRtl((View)this)) {
            return super.getCompoundPaddingRight();
        }
        int n3 = n2 = super.getCompoundPaddingRight() + this.mSwitchWidth;
        if (TextUtils.isEmpty((CharSequence)this.getText())) return n3;
        return n2 + this.mSwitchPadding;
    }

    public boolean getShowText() {
        return this.mShowText;
    }

    public boolean getSplitTrack() {
        return this.mSplitTrack;
    }

    public int getSwitchMinWidth() {
        return this.mSwitchMinWidth;
    }

    public int getSwitchPadding() {
        return this.mSwitchPadding;
    }

    public CharSequence getTextOff() {
        return this.mTextOff;
    }

    public CharSequence getTextOn() {
        return this.mTextOn;
    }

    public Drawable getThumbDrawable() {
        return this.mThumbDrawable;
    }

    public int getThumbTextPadding() {
        return this.mThumbTextPadding;
    }

    public Drawable getTrackDrawable() {
        return this.mTrackDrawable;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void jumpDrawablesToCurrentState() {
        if (Build.VERSION.SDK_INT >= 11) {
            super.jumpDrawablesToCurrentState();
            if (this.mThumbDrawable != null) {
                this.mThumbDrawable.jumpToCurrentState();
            }
            if (this.mTrackDrawable != null) {
                this.mTrackDrawable.jumpToCurrentState();
            }
            this.cancelPositionAnimator();
            float f2 = this.isChecked() ? 1.0f : 0.0f;
            this.setThumbPosition(f2);
        }
    }

    protected int[] onCreateDrawableState(int n2) {
        int[] nArray = super.onCreateDrawableState(n2 + 1);
        if (this.isChecked()) {
            SwitchCompat.mergeDrawableStates((int[])nArray, (int[])CHECKED_STATE_SET);
        }
        return nArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void onDraw(Canvas canvas) {
        int n2;
        super.onDraw(canvas);
        Rect rect = this.mTempRect;
        Drawable drawable2 = this.mTrackDrawable;
        if (drawable2 != null) {
            drawable2.getPadding(rect);
        } else {
            rect.setEmpty();
        }
        int n3 = this.mSwitchTop;
        int n4 = this.mSwitchBottom;
        int n5 = rect.top;
        int n6 = rect.bottom;
        Drawable drawable3 = this.mThumbDrawable;
        if (drawable2 != null) {
            if (this.mSplitTrack && drawable3 != null) {
                Rect rect2 = DrawableUtils.getOpticalBounds(drawable3);
                drawable3.copyBounds(rect);
                rect.left += rect2.left;
                rect.right -= rect2.right;
                n2 = canvas.save();
                canvas.clipRect(rect, Region.Op.DIFFERENCE);
                drawable2.draw(canvas);
                canvas.restoreToCount(n2);
            } else {
                drawable2.draw(canvas);
            }
        }
        int n7 = canvas.save();
        if (drawable3 != null) {
            drawable3.draw(canvas);
        }
        if ((rect = this.getTargetCheckedState() ? this.mOnLayout : this.mOffLayout) != null) {
            int[] nArray = this.getDrawableState();
            if (this.mTextColors != null) {
                this.mTextPaint.setColor(this.mTextColors.getColorForState(nArray, 0));
            }
            this.mTextPaint.drawableState = nArray;
            if (drawable3 != null) {
                drawable3 = drawable3.getBounds();
                n2 = drawable3.left;
                n2 = drawable3.right + n2;
            } else {
                n2 = this.getWidth();
            }
            int n8 = rect.getWidth() / 2;
            n5 = (n3 + n5 + (n4 - n6)) / 2;
            n4 = rect.getHeight() / 2;
            canvas.translate((float)((n2 /= 2) - n8), (float)(n5 - n4));
            rect.draw(canvas);
        }
        canvas.restoreToCount(n7);
    }

    @TargetApi(value=14)
    public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        super.onInitializeAccessibilityEvent(accessibilityEvent);
        accessibilityEvent.setClassName((CharSequence)ACCESSIBILITY_EVENT_CLASS_NAME);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        if (Build.VERSION.SDK_INT < 14) return;
        super.onInitializeAccessibilityNodeInfo(accessibilityNodeInfo);
        accessibilityNodeInfo.setClassName((CharSequence)ACCESSIBILITY_EVENT_CLASS_NAME);
        CharSequence charSequence = this.isChecked() ? this.mTextOn : this.mTextOff;
        if (TextUtils.isEmpty((CharSequence)charSequence)) return;
        CharSequence charSequence2 = accessibilityNodeInfo.getText();
        if (TextUtils.isEmpty((CharSequence)charSequence2)) {
            accessibilityNodeInfo.setText(charSequence);
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(charSequence2).append(' ').append(charSequence);
        accessibilityNodeInfo.setText((CharSequence)stringBuilder);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void onLayout(boolean bl, int n2, int n3, int n4, int n5) {
        int n6 = 0;
        super.onLayout(bl, n2, n3, n4, n5);
        if (this.mThumbDrawable != null) {
            Rect rect = this.mTempRect;
            if (this.mTrackDrawable != null) {
                this.mTrackDrawable.getPadding(rect);
            } else {
                rect.setEmpty();
            }
            Rect rect2 = DrawableUtils.getOpticalBounds(this.mThumbDrawable);
            n2 = Math.max(0, rect2.left - rect.left);
            n3 = Math.max(0, rect2.right - rect.right);
        } else {
            n2 = 0;
            n3 = n6;
        }
        if (ViewUtils.isLayoutRtl((View)this)) {
            n4 = this.getPaddingLeft() + n2;
            n5 = this.mSwitchWidth + n4 - n2 - n3;
        } else {
            n5 = this.getWidth() - this.getPaddingRight() - n3;
            n4 = n3 + (n2 + (n5 - this.mSwitchWidth));
        }
        switch (this.getGravity() & 0x70) {
            default: {
                n3 = this.getPaddingTop();
                n2 = this.mSwitchHeight + n3;
                break;
            }
            case 16: {
                n3 = (this.getPaddingTop() + this.getHeight() - this.getPaddingBottom()) / 2 - this.mSwitchHeight / 2;
                n2 = this.mSwitchHeight + n3;
                break;
            }
            case 80: {
                n2 = this.getHeight() - this.getPaddingBottom();
                n3 = n2 - this.mSwitchHeight;
            }
        }
        this.mSwitchLeft = n4;
        this.mSwitchTop = n3;
        this.mSwitchBottom = n2;
        this.mSwitchRight = n5;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void onMeasure(int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7 = 0;
        if (this.mShowText) {
            if (this.mOnLayout == null) {
                this.mOnLayout = this.makeLayout(this.mTextOn);
            }
            if (this.mOffLayout == null) {
                this.mOffLayout = this.makeLayout(this.mTextOff);
            }
        }
        Rect rect = this.mTempRect;
        if (this.mThumbDrawable != null) {
            this.mThumbDrawable.getPadding(rect);
            n6 = this.mThumbDrawable.getIntrinsicWidth() - rect.left - rect.right;
            n5 = this.mThumbDrawable.getIntrinsicHeight();
        } else {
            n5 = 0;
            n6 = 0;
        }
        int n8 = this.mShowText ? Math.max(this.mOnLayout.getWidth(), this.mOffLayout.getWidth()) + this.mThumbTextPadding * 2 : 0;
        this.mThumbWidth = Math.max(n8, n6);
        if (this.mTrackDrawable != null) {
            this.mTrackDrawable.getPadding(rect);
            n6 = this.mTrackDrawable.getIntrinsicHeight();
        } else {
            rect.setEmpty();
            n6 = n7;
        }
        int n9 = rect.left;
        n7 = n4 = rect.right;
        n8 = n9;
        if (this.mThumbDrawable != null) {
            rect = DrawableUtils.getOpticalBounds(this.mThumbDrawable);
            n8 = Math.max(n9, rect.left);
            n7 = Math.max(n4, rect.right);
        }
        n8 = Math.max(this.mSwitchMinWidth, n7 + (n8 + this.mThumbWidth * 2));
        n5 = Math.max(n6, n5);
        this.mSwitchWidth = n8;
        this.mSwitchHeight = n5;
        super.onMeasure(n2, n3);
        if (this.getMeasuredHeight() < n5) {
            this.setMeasuredDimension(ViewCompat.getMeasuredWidthAndState((View)this), n5);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @TargetApi(value=14)
    public void onPopulateAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        super.onPopulateAccessibilityEvent(accessibilityEvent);
        CharSequence charSequence = this.isChecked() ? this.mTextOn : this.mTextOff;
        if (charSequence != null) {
            accessibilityEvent.getText().add(charSequence);
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean onTouchEvent(MotionEvent var1_1) {
        this.mVelocityTracker.addMovement(var1_1);
        switch (MotionEventCompat.getActionMasked((MotionEvent)var1_1)) lbl-1000:
        // 6 sources

        {
            default: lbl-1000:
            // 2 sources

            {
                while (true) {
                    var2_2 = super.onTouchEvent(var1_1);
lbl6:
                    // 4 sources

                    return var2_2;
                }
            }
            case 0: {
                var3_3 = var1_1.getX();
                var4_6 = var1_1.getY();
                if (!this.isEnabled() || !this.hitThumb(var3_3, var4_6)) ** GOTO lbl-1000
                this.mTouchMode = 1;
                this.mTouchX = var3_3;
                this.mTouchY = var4_6;
                ** GOTO lbl-1000
            }
            case 2: {
                switch (this.mTouchMode) {
                    case 0: {
                        ** GOTO lbl-1000
                    }
                    default: {
                        ** GOTO lbl-1000
                    }
                    case 1: {
                        var3_4 = var1_1.getX();
                        var4_7 = var1_1.getY();
                        if (!(Math.abs(var3_4 - this.mTouchX) > (float)this.mTouchSlop) && !(Math.abs(var4_7 - this.mTouchY) > (float)this.mTouchSlop)) ** GOTO lbl-1000
                        this.mTouchMode = 2;
                        this.getParent().requestDisallowInterceptTouchEvent(true);
                        this.mTouchX = var3_4;
                        this.mTouchY = var4_7;
                        var2_2 = true;
                        ** GOTO lbl6
                    }
                    case 2: 
                }
                var5_9 = var1_1.getX();
                var6_10 = this.getThumbScrollRange();
                var3_5 = var5_9 - this.mTouchX;
                if (var6_10 == 0) ** GOTO lbl47
                var3_5 /= (float)var6_10;
lbl38:
                // 3 sources

                while (true) {
                    var4_8 = var3_5;
                    if (ViewUtils.isLayoutRtl((View)this)) {
                        var4_8 = -var3_5;
                    }
                    if ((var3_5 = SwitchCompat.constrain(var4_8 + this.mThumbPosition, 0.0f, 1.0f)) != this.mThumbPosition) {
                        this.mTouchX = var5_9;
                        this.setThumbPosition(var3_5);
                    }
                    var2_2 = true;
                    ** GOTO lbl6
                    break;
                }
lbl47:
                // 1 sources

                if (!(var3_5 > 0.0f)) ** GOTO lbl50
                var3_5 = 1.0f;
                ** GOTO lbl38
lbl50:
                // 1 sources

                var3_5 = -1.0f;
                ** continue;
            }
            case 1: 
            case 3: 
        }
        if (this.mTouchMode == 2) {
            this.stopDrag(var1_1);
            super.onTouchEvent(var1_1);
            var2_2 = true;
            ** continue;
        }
        this.mTouchMode = 0;
        this.mVelocityTracker.clear();
        ** while (true)
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setChecked(boolean bl) {
        super.setChecked(bl);
        bl = this.isChecked();
        if (this.getWindowToken() != null && ViewCompat.isLaidOut((View)this) && this.isShown()) {
            this.animateThumbToCheckedState(bl);
            return;
        }
        this.cancelPositionAnimator();
        float f2 = bl ? 1.0f : 0.0f;
        this.setThumbPosition(f2);
    }

    public void setShowText(boolean bl) {
        if (this.mShowText != bl) {
            this.mShowText = bl;
            this.requestLayout();
        }
    }

    public void setSplitTrack(boolean bl) {
        this.mSplitTrack = bl;
        this.invalidate();
    }

    public void setSwitchMinWidth(int n2) {
        this.mSwitchMinWidth = n2;
        this.requestLayout();
    }

    public void setSwitchPadding(int n2) {
        this.mSwitchPadding = n2;
        this.requestLayout();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setSwitchTextAppearance(Context context, int n2) {
        TypedArray typedArray = context.obtainStyledAttributes(n2, R.styleable.TextAppearance);
        this.mTextColors = (context = typedArray.getColorStateList(R.styleable.TextAppearance_android_textColor)) != null ? context : this.getTextColors();
        n2 = typedArray.getDimensionPixelSize(R.styleable.TextAppearance_android_textSize, 0);
        if (n2 != 0 && (float)n2 != this.mTextPaint.getTextSize()) {
            this.mTextPaint.setTextSize((float)n2);
            this.requestLayout();
        }
        this.setSwitchTypefaceByIndex(typedArray.getInt(R.styleable.TextAppearance_android_typeface, -1), typedArray.getInt(R.styleable.TextAppearance_android_textStyle, -1));
        this.mSwitchTransformationMethod = typedArray.getBoolean(R.styleable.TextAppearance_textAllCaps, false) ? new AllCapsTransformationMethod(this.getContext()) : null;
        typedArray.recycle();
    }

    public void setSwitchTypeface(Typeface typeface) {
        if (this.mTextPaint.getTypeface() != typeface) {
            this.mTextPaint.setTypeface(typeface);
            this.requestLayout();
            this.invalidate();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setSwitchTypeface(Typeface typeface, int n2) {
        boolean bl = false;
        if (n2 <= 0) {
            this.mTextPaint.setFakeBoldText(false);
            this.mTextPaint.setTextSkewX(0.0f);
            this.setSwitchTypeface(typeface);
            return;
        }
        typeface = typeface == null ? Typeface.defaultFromStyle((int)n2) : Typeface.create((Typeface)typeface, (int)n2);
        this.setSwitchTypeface(typeface);
        int n3 = typeface != null ? typeface.getStyle() : 0;
        n2 = ~n3 & n2;
        typeface = this.mTextPaint;
        if ((n2 & 1) != 0) {
            bl = true;
        }
        typeface.setFakeBoldText(bl);
        typeface = this.mTextPaint;
        float f2 = (n2 & 2) != 0 ? -0.25f : 0.0f;
        typeface.setTextSkewX(f2);
    }

    public void setTextOff(CharSequence charSequence) {
        this.mTextOff = charSequence;
        this.requestLayout();
    }

    public void setTextOn(CharSequence charSequence) {
        this.mTextOn = charSequence;
        this.requestLayout();
    }

    public void setThumbDrawable(Drawable drawable2) {
        this.mThumbDrawable = drawable2;
        this.requestLayout();
    }

    public void setThumbResource(int n2) {
        this.setThumbDrawable(this.mDrawableManager.getDrawable(this.getContext(), n2));
    }

    public void setThumbTextPadding(int n2) {
        this.mThumbTextPadding = n2;
        this.requestLayout();
    }

    public void setTrackDrawable(Drawable drawable2) {
        this.mTrackDrawable = drawable2;
        this.requestLayout();
    }

    public void setTrackResource(int n2) {
        this.setTrackDrawable(this.mDrawableManager.getDrawable(this.getContext(), n2));
    }

    /*
     * Enabled aggressive block sorting
     */
    public void toggle() {
        boolean bl = !this.isChecked();
        this.setChecked(bl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean verifyDrawable(Drawable drawable2) {
        if (super.verifyDrawable(drawable2)) return true;
        if (drawable2 == this.mThumbDrawable) return true;
        if (drawable2 != this.mTrackDrawable) return false;
        return true;
    }

    private class ThumbAnimation
    extends Animation {
        final float mDiff;
        final float mEndPosition;
        final float mStartPosition;

        private ThumbAnimation(float f2, float f3) {
            this.mStartPosition = f2;
            this.mEndPosition = f3;
            this.mDiff = f3 - f2;
        }

        protected void applyTransformation(float f2, Transformation transformation) {
            SwitchCompat.this.setThumbPosition(this.mStartPosition + this.mDiff * f2);
        }
    }
}

