/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.widget;

import android.content.Context;
import android.content.ContextWrapper;
import android.content.res.Resources;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.v7.app.AppCompatDelegate;
import android.support.v7.widget.TintResources;
import android.support.v7.widget.VectorEnabledTintResources;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

public class TintContextWrapper
extends ContextWrapper {
    private static final ArrayList<WeakReference<TintContextWrapper>> sCache = new ArrayList();
    private Resources mResources;
    private final Resources.Theme mTheme;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private TintContextWrapper(@NonNull Context context) {
        super(context);
        if (VectorEnabledTintResources.shouldBeUsed()) {
            this.mTheme = this.getResources().newTheme();
            this.mTheme.setTo(context.getTheme());
            return;
        }
        this.mTheme = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean shouldWrap(@NonNull Context context) {
        boolean bl;
        boolean bl2 = bl = false;
        if (context instanceof TintContextWrapper) return bl2;
        bl2 = bl;
        if (context.getResources() instanceof TintResources) return bl2;
        if (context.getResources() instanceof VectorEnabledTintResources) {
            return bl;
        }
        if (!AppCompatDelegate.isCompatVectorFromResourcesEnabled()) return true;
        bl2 = bl;
        if (Build.VERSION.SDK_INT > 20) return bl2;
        return true;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static Context wrap(@NonNull Context context) {
        void var1_6;
        Context context2 = context;
        if (!TintContextWrapper.shouldWrap(context)) return var1_6;
        int n2 = sCache.size();
        int n3 = 0;
        while (true) {
            void var1_5;
            if (n3 >= n2) {
                TintContextWrapper tintContextWrapper = new TintContextWrapper(context);
                sCache.add(new WeakReference<TintContextWrapper>(tintContextWrapper));
                return var1_6;
            }
            WeakReference<TintContextWrapper> weakReference = sCache.get(n3);
            if (weakReference != null) {
                TintContextWrapper tintContextWrapper = (TintContextWrapper)((Object)weakReference.get());
            } else {
                Object var1_7 = null;
            }
            if (var1_5 != null && var1_5.getBaseContext() == context) {
                return var1_6;
            }
            ++n3;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public Resources getResources() {
        if (this.mResources == null) {
            TintResources tintResources = this.mTheme == null ? new TintResources((Context)this, super.getResources()) : new VectorEnabledTintResources((Context)this, super.getResources());
            this.mResources = tintResources;
        }
        return this.mResources;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Resources.Theme getTheme() {
        if (this.mTheme != null) return this.mTheme;
        return super.getTheme();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setTheme(int n2) {
        if (this.mTheme == null) {
            super.setTheme(n2);
            return;
        }
        this.mTheme.applyStyle(n2, true);
    }
}

