/*
 * Decompiled with CFR 0.152.
 */
package com.android.gmacs.dragback;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.support.v4.view.ViewCompat;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.android.gmacs.R;
import com.android.gmacs.activity.GmacsImageActivity;
import com.android.gmacs.dragback.ParallaxBackActivityHelper;
import com.android.gmacs.dragback.ViewDragHelper;

public class ParallaxBackLayout
extends FrameLayout {
    private static final int DEFAULT_SCRIM_COLOR = -1728053248;
    private static final float DEFAULT_SCROLL_THRESHOLD = 0.5f;
    private static final int EDGE_LEFT = 1;
    private static final int FULL_ALPHA = 255;
    private static final int OVERSCROLL_DISTANCE = 0;
    private int mContentLeft;
    private int mContentTop;
    private View mContentView;
    private ViewDragHelper mDragHelper = ViewDragHelper.create((ViewGroup)this, new ViewDragCallback());
    private boolean mEnable = true;
    private boolean mInLayout;
    private int mScrimColor = -1728053248;
    private float mScrimOpacity;
    private float mScrollPercent;
    private float mScrollThreshold = 0.5f;
    private Drawable mShadowLeft = this.getResources().getDrawable(R.drawable.gmacs_shadow_left);
    private ParallaxBackActivityHelper mSwipeHelper;
    private int mTrackingEdge;

    public ParallaxBackLayout(Context context) {
        this(context, null);
    }

    public ParallaxBackLayout(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public ParallaxBackLayout(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet);
    }

    static /* synthetic */ int access$202(ParallaxBackLayout parallaxBackLayout, int n2) {
        parallaxBackLayout.mTrackingEdge = n2;
        return n2;
    }

    static /* synthetic */ float access$302(ParallaxBackLayout parallaxBackLayout, float f2) {
        parallaxBackLayout.mScrollPercent = f2;
        return f2;
    }

    static /* synthetic */ int access$502(ParallaxBackLayout parallaxBackLayout, int n2) {
        parallaxBackLayout.mContentLeft = n2;
        return n2;
    }

    static /* synthetic */ int access$602(ParallaxBackLayout parallaxBackLayout, int n2) {
        parallaxBackLayout.mContentTop = n2;
        return n2;
    }

    private void drawScrim(Canvas canvas, View view) {
        int n2 = (int)((float)((this.mScrimColor & 0xFF000000) >>> 24) * this.mScrimOpacity);
        int n3 = this.mScrimColor;
        if ((this.mTrackingEdge & 1) != 0) {
            canvas.clipRect(0, 0, view.getLeft(), this.getHeight());
        }
        canvas.drawColor(n2 << 24 | n3 & 0xFFFFFF);
    }

    private void drawShadow(Canvas canvas, View view) {
        this.mShadowLeft.setBounds(view.getLeft() - this.mShadowLeft.getIntrinsicWidth(), view.getTop(), view.getLeft(), view.getBottom());
        this.mShadowLeft.setAlpha((int)(this.mScrimOpacity * 255.0f));
        this.mShadowLeft.draw(canvas);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void drawThumb(Canvas canvas, View view) {
        if (view.getLeft() == 0) {
            return;
        }
        int n2 = canvas.save();
        int n3 = (view.getLeft() - this.getWidth()) / 2;
        canvas.translate((float)n3, 0.0f);
        canvas.clipRect(n3, 0, (view.getLeft() + this.getWidth()) / 2, view.getBottom());
        view = this.mSwipeHelper.getSecondActivity();
        if (view != null) {
            view.drawThumb(canvas);
        }
        canvas.restoreToCount(n2);
    }

    private void setContentView(View view) {
        this.mContentView = view;
    }

    public void attachToActivity(ParallaxBackActivityHelper parallaxBackActivityHelper) {
        this.mSwipeHelper = parallaxBackActivityHelper;
        ViewGroup viewGroup = (ViewGroup)parallaxBackActivityHelper.getActivity().getWindow().getDecorView();
        parallaxBackActivityHelper = (ViewGroup)viewGroup.getChildAt(0);
        viewGroup.removeView((View)parallaxBackActivityHelper);
        this.addView((View)parallaxBackActivityHelper);
        this.setContentView((View)parallaxBackActivityHelper);
        viewGroup.addView((View)this);
    }

    public void computeScroll() {
        this.mScrimOpacity = 1.0f - this.mScrollPercent;
        if (this.mDragHelper.continueSettling(true)) {
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected boolean drawChild(Canvas canvas, View view, long l2) {
        boolean bl = view == this.mContentView;
        boolean bl2 = super.drawChild(canvas, view, l2);
        if (this.mEnable && this.mSwipeHelper.hasSecondActivity()) {
            this.drawThumb(canvas, view);
        }
        if (this.mScrimOpacity > 0.0f && bl && this.mDragHelper.getViewDragState() != 0) {
            this.drawShadow(canvas, view);
            this.drawScrim(canvas, view);
        }
        return bl2;
    }

    public View getContentView() {
        return this.mContentView;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        boolean bl = false;
        String string2 = this.mSwipeHelper.getActivity().getClass().getSimpleName();
        boolean bl2 = bl;
        if (!this.mEnable) return bl2;
        if (GmacsImageActivity.class.getSimpleName().equals(string2)) {
            return bl;
        }
        try {
            return this.mDragHelper.shouldInterceptTouchEvent(motionEvent);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return bl;
        }
    }

    protected void onLayout(boolean bl, int n2, int n3, int n4, int n5) {
        this.mInLayout = true;
        if (this.mContentView != null) {
            this.mContentView.layout(this.mContentLeft, this.mContentTop, this.mContentLeft + this.mContentView.getMeasuredWidth(), this.mContentTop + this.mContentView.getMeasuredHeight());
        }
        this.mInLayout = false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (!this.mEnable) {
            return false;
        }
        this.mDragHelper.processTouchEvent(motionEvent);
        return true;
    }

    public void requestLayout() {
        if (!this.mInLayout) {
            super.requestLayout();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void scrollToFinishActivity() {
        if (!this.mEnable) {
            this.mSwipeHelper.getActivity().finish();
            return;
        }
        int n2 = this.mContentView.getWidth();
        this.mTrackingEdge = 1;
        this.mDragHelper.smoothSlideViewTo(this.mContentView, n2, 0);
        this.invalidate();
    }

    public void setEnableGesture(boolean bl) {
        this.mEnable = bl;
    }

    public void setScrimColor(int n2) {
        this.mScrimColor = n2;
        this.invalidate();
    }

    public void setScrollThresHold(float f2) {
        if (f2 >= 1.0f || f2 <= 0.0f) {
            throw new IllegalArgumentException("Threshold value should be between 0 and 1.0");
        }
        this.mScrollThreshold = f2;
    }

    private class ViewDragCallback
    extends ViewDragHelper.Callback {
        private boolean mIsScrollOverValid;

        private ViewDragCallback() {
        }

        @Override
        public int clampViewPositionHorizontal(View view, int n2, int n3) {
            n3 = 0;
            if ((ParallaxBackLayout.this.mTrackingEdge & 1) != 0) {
                n3 = Math.min(view.getWidth(), Math.max(n2, 0));
            }
            return n3;
        }

        @Override
        public int clampViewPositionVertical(View view, int n2, int n3) {
            return 0;
        }

        @Override
        public int getViewHorizontalDragRange(View view) {
            return 1;
        }

        @Override
        public int getViewVerticalDragRange(View view) {
            return 0;
        }

        @Override
        public void onViewDragStateChanged(int n2) {
            super.onViewDragStateChanged(n2);
        }

        @Override
        public void onViewPositionChanged(View view, int n2, int n3, int n4, int n5) {
            super.onViewPositionChanged(view, n2, n3, n4, n5);
            if ((ParallaxBackLayout.this.mTrackingEdge & 1) != 0) {
                ParallaxBackLayout.access$302(ParallaxBackLayout.this, Math.abs((float)n2 / (float)ParallaxBackLayout.this.mContentView.getWidth()));
            }
            ParallaxBackLayout.access$502(ParallaxBackLayout.this, n2);
            ParallaxBackLayout.access$602(ParallaxBackLayout.this, n3);
            ParallaxBackLayout.this.invalidate();
            if (ParallaxBackLayout.this.mScrollPercent < ParallaxBackLayout.this.mScrollThreshold && !this.mIsScrollOverValid) {
                this.mIsScrollOverValid = true;
            }
            if (ParallaxBackLayout.this.mScrollPercent >= 1.0f && !ParallaxBackLayout.this.mSwipeHelper.getActivity().isFinishing()) {
                ParallaxBackLayout.this.mSwipeHelper.getActivity().finish();
                ParallaxBackLayout.this.mSwipeHelper.getActivity().overridePendingTransition(0, 0);
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void onViewReleased(View view, float f2, float f3) {
            int n2;
            int n3 = view.getWidth();
            if ((ParallaxBackLayout.this.mTrackingEdge & 1) != 0) {
                n2 = n3;
                if (!(f2 > 0.0f)) {
                    n2 = ParallaxBackLayout.this.mScrollPercent > ParallaxBackLayout.this.mScrollThreshold ? n3 : 0;
                }
            } else {
                n2 = 0;
            }
            ParallaxBackLayout.this.mDragHelper.settleCapturedViewAt(n2, 0);
            ParallaxBackLayout.this.invalidate();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean tryCaptureView(View view, int n2) {
            int n3 = 1;
            int n4 = ParallaxBackLayout.this.mDragHelper.isEdgeTouched(1, n2) ? 1 : 0;
            if (n4 != 0) {
                ParallaxBackLayout.access$202(ParallaxBackLayout.this, 1);
                this.mIsScrollOverValid = true;
            }
            if (!ParallaxBackLayout.this.mDragHelper.checkTouchSlop(2, n2)) {
                n2 = n3;
                return (n2 & n4) != 0;
            }
            n2 = 0;
            return (n2 & n4) != 0;
        }
    }
}

